/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.common;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.common.Monitor;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.engine.ContextGroup;

public class ContextGroupMonitor
extends Monitor {
    private WebContainerManager manager;
    private Hashtable contextGroups = null;
    private PrintStream systemOut;
    private PrintStream systemErr;

    public ContextGroupMonitor(WebContainerManager manager, Hashtable ctxGroups, PrintStream sysout, PrintStream syserr) {
        super("LogMonitor");
        this.manager = manager;
        this.systemOut = sysout;
        this.systemErr = syserr;
        this.contextGroups = ctxGroups;
    }

    protected void doJob() {
        this.manager.checkRedirectedStdLogFile();
        Enumeration ctxGroups = this.contextGroups.elements();
        boolean first = true;
        while (ctxGroups.hasMoreElements()) {
            ContextGroup ctxGroup = (ContextGroup)ctxGroups.nextElement();
            ctxGroup.checkFileCache();
            ctxGroup.checkSessionContainer(first);
            first = false;
        }
        if (this.systemErr != null) {
            this.systemErr.flush();
        }
        if (this.systemOut != null) {
            this.systemOut.flush();
        }
    }
}

