/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationListener;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.WebEngineMo;
import jeus.security.base.Policy;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.enginecontainer.StartThread;
import jeus.server.manager.JeusVersion;
import jeus.servlet.common.NamingServerBinder;
import jeus.servlet.common.ShutdownMonitor;
import jeus.servlet.common.WebContainerControl;
import jeus.servlet.common.WebContainerControlImpl;
import jeus.servlet.common.WebContainerMonitor;
import jeus.servlet.connection.Connector;
import jeus.servlet.deployment.ConfigUtil;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ContainerMonitorDescriptor;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.deployment.descriptor.bind.WebMainDescriptorJB;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.loader.ClassLoadManager;
import jeus.servlet.property.ContainerProperties;
import jeus.servlet.servlets.SuspendServlet;
import jeus.servlet.servlets.UnavailableServlet;
import jeus.servlet.util.URLResolver;
import jeus.sessionmanager.SessionMonitoring;
import jeus.util.CUtility;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.JeusRuntimeException;
import jeus.util.Runner;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.jeusDD.AccessLogType;
import jeus.xml.binding.jeusDD.LoggingType;
import jeus.xml.binding.jeusDD.UserLogType;

public class WebContainerManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.common");
    private SimpleDateFormat fn = new SimpleDateFormat("MMddyyyy");
    protected boolean configByXML;
    private File configFile;
    protected WebMainDescriptorJB webContainerDesc;
    private boolean redirectStdOut = false;
    private boolean redirectStdErr = false;
    protected Hashtable contextGroups;
    protected Vector ctxGroupNames;
    private GenericServlet suspendServlet;
    private GenericServlet unavailableServlet;
    private PrintStream systemOut;
    private PrintStream systemErr;
    private PrintStream savedSystemOut;
    private PrintStream savedSystemErr;
    private int redirectedSystemOutCreatedDay = -1;
    private int redirectedSystemErrCreatedDay = -1;
    private ContainerMonitorDescriptor monitorDesc;
    private WebContainerMonitor containerMonitor;
    private WebContainerControlImpl control = null;
    public static WebContainerControlImpl ENGINE_CONTROLLER = null;
    protected ClassLoadManager classLoadManager = null;
    public static int webContainerProcessId = CUtility.thisProcessPID;
    public String ENGINE_NAME = null;
    public static String _ENGINE_NAME = null;
    public String SHORT_ENGINE_NAME = null;
    public static String NODE_NAME = null;
    public String CONFIG_DIR = null;
    public static boolean STANDALONE_MODE = false;
    public boolean isSYSTEM_ENGINE = false;
    public boolean active = false;
    private WebEngineMo webEngineMo;
    private static String REDIRECT_DIR = JeusProperties.JEUS_LOG_HOME + File.separator + "JeusSystem" + File.separator + JeusManagerPropertyValues.containerName;
    private ContainerProperties containerProperties;
    private HashMap clientInfos = new HashMap();
    private int licensedClientNum = 0;

    public WebContainerManager() {
        this.contextGroups = new Hashtable();
    }

    public void initConstants(String engineName, boolean standalone, boolean isSystemEngine) throws StartingException {
        this.isSYSTEM_ENGINE = isSystemEngine;
        STANDALONE_MODE = standalone;
        this.ENGINE_NAME = engineName;
        int pos = isSystemEngine ? engineName.indexOf("_system_engine") : engineName.indexOf("_servlet_");
        if (pos < 0) {
            throw new StartingException(JeusMessage_WebContainer0._1120, new String[]{engineName});
        }
        NODE_NAME = engineName.substring(0, pos);
        this.SHORT_ENGINE_NAME = isSystemEngine ? "system_engine" : engineName.substring(pos + "_servlet_".length());
        String fs = System.getProperty("file.separator");
        this.CONFIG_DIR = JeusProperties.JEUS_CONFIG_HOME + fs + NODE_NAME + fs + this.ENGINE_NAME;
    }

    public void setWebContainerDescriptor(WebContainerDescriptor desc) {
        this.webContainerDesc = (WebMainDescriptorJB)desc;
        this.monitorDesc = desc.getContainerMonitorDescriptor();
        this.redirectStdOut = desc.isRedirectStdOut();
        this.redirectStdErr = desc.isRedirectStdErr();
    }

    public void setConfigByXML(boolean xml) {
        this.configByXML = xml;
    }

    public void setConfigFile(File file) {
        this.configFile = file;
    }

    public void setMonitoringPeriod(String intval, int monId) {
        switch (monId) {
            case 0: {
                this.monitorDesc.setThreadPoolCheckPeriod(intval);
                break;
            }
            case 2: {
                this.monitorDesc.setSessionCheckPeriod(intval);
                break;
            }
            case 3: {
                this.monitorDesc.setServletReloadCheckPeriod(intval);
                break;
            }
            default: {
                return;
            }
        }
        if (this.containerMonitor != null) {
            this.containerMonitor.startMonitor();
        }
    }

    public long getMonitoringPeriod(int monId) {
        switch (monId) {
            case 0: {
                return this.monitorDesc.getThreadPoolCheckPeriod();
            }
            case 2: {
                return this.monitorDesc.getSessionCheckPeriod();
            }
            case 3: {
                return this.monitorDesc.getServletReloadCheckPeriod();
            }
        }
        return -1L;
    }

    public void registerSessionManagerMBean(SessionMonitoring manager, String scope) {
        if (manager != null && this.webEngineMo != null) {
            if (scope == null) {
                scope = this.ENGINE_NAME;
            }
            manager.createMBean(this.webEngineMo.getObjectName(), scope + "-session");
        }
    }

    public boolean getConfigByXML() {
        return this.configByXML;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public ClassLoadManager getClassLoadManager() {
        return this.classLoadManager;
    }

    public ContextGroup getContextGroup(String name) {
        return (ContextGroup)this.contextGroups.get(name);
    }

    public Enumeration getContextGroups() {
        Vector<ContextGroup> tmpVec = new Vector<ContextGroup>();
        if (this.ctxGroupNames != null && this.contextGroups != null) {
            Enumeration enum1 = this.ctxGroupNames.elements();
            while (enum1.hasMoreElements()) {
                String ctxGroupName = (String)enum1.nextElement();
                ContextGroup ctxGroup = (ContextGroup)this.contextGroups.get(ctxGroupName);
                if (ctxGroup == null) continue;
                tmpVec.addElement(ctxGroup);
            }
        }
        return tmpVec.elements();
    }

    public Vector getContextGroupNames() {
        return this.ctxGroupNames;
    }

    public int getContextGroupNum() {
        return this.contextGroups.size();
    }

    public ContextGroupDescriptor getContextGroupDescriptor(String ctxGroupName) {
        return this.webContainerDesc.getContextGroupDescriptor(ctxGroupName);
    }

    public Servlet getSuspendServlet() {
        return this.suspendServlet;
    }

    public Servlet getUnavailableServlet() {
        return this.unavailableServlet;
    }

    public Vector getConnectorNames() {
        HashMap conns = this.getConnectors();
        Vector result = new Vector();
        Iterator it = conns.keySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public HashMap getConnectors() {
        HashMap result = new HashMap();
        Enumeration enum1 = this.contextGroups.elements();
        while (enum1.hasMoreElements()) {
            ContextGroup ctxGroup = (ContextGroup)enum1.nextElement();
            HashMap connectors = ctxGroup.getConnectors();
            if (connectors == null) continue;
            result.putAll(connectors);
        }
        return result;
    }

    public Connector getConnector(String id) {
        Enumeration enum1 = this.contextGroups.elements();
        while (enum1.hasMoreElements()) {
            ContextGroup ctxGroup = (ContextGroup)enum1.nextElement();
            HashMap connectors = ctxGroup.getConnectors();
            if (connectors == null) {
                return null;
            }
            Connector connector = (Connector)connectors.get(id);
            if (connector == null) continue;
            return connector;
        }
        return null;
    }

    public WebMainDescriptorJB getWebContainerDescriptor() {
        return this.webContainerDesc;
    }

    public int getCurruntThreadNum() {
        int currThreads = 0;
        Enumeration enum1 = this.contextGroups.elements();
        while (enum1.hasMoreElements()) {
            ContextGroup ctxGroup = (ContextGroup)enum1.nextElement();
            HashMap tpools = ctxGroup.getThreadPoolManagers();
            for (ThreadPoolManager[] tpoolManager : tpools.values()) {
                if (tpoolManager == null) continue;
                for (int i = 0; i < tpoolManager.length; ++i) {
                    currThreads += tpoolManager[i].getCurrentThreadNum();
                }
            }
        }
        return currThreads;
    }

    public WebContainerControl getController() {
        return this.control;
    }

    public void validateConfiguration() throws StartingException {
        Hashtable descs = this.webContainerDesc.getContextGroupDescriptor();
        Hashtable<String, ConnectionDescriptor> duptbl = new Hashtable<String, ConnectionDescriptor>();
        Enumeration enum1 = descs.elements();
        while (enum1.hasMoreElements()) {
            ContextGroupDescriptor grpdesc = (ContextGroupDescriptor)enum1.nextElement();
            Hashtable connDescs = grpdesc.getConnectionDescriptor();
            Enumeration enum2 = connDescs.elements();
            while (enum2.hasMoreElements()) {
                ConnectionDescriptor conndesc = (ConnectionDescriptor)enum2.nextElement();
                ConnectionDescriptor dup = duptbl.put(conndesc.getListenerId(), conndesc);
                if (dup == null) continue;
                throw new StartingException(JeusMessage_WebContainer0._1013, conndesc.getListenerId());
            }
        }
    }

    public void startContainer() throws StartingException {
        String fileName;
        File logFile;
        File logDir;
        String suffix;
        Calendar cal;
        int pid;
        block42: {
            ContextGroup contextGroup;
            block41: {
                block39: {
                    this.setLicensedClientNum();
                    this.savedSystemOut = System.out;
                    this.savedSystemErr = System.err;
                    try {
                        this.classLoadManager = STANDALONE_MODE ? new ClassLoadManager(this.getClass().getClassLoader(), URLResolver.resolve(JeusBootstrapProperties.JEUS_HOME), this.ENGINE_NAME, STANDALONE_MODE) : new ClassLoadManager(JeusRootClassLoader.loader, URLResolver.resolve(JeusBootstrapProperties.JEUS_HOME), this.ENGINE_NAME, STANDALONE_MODE);
                    }
                    catch (MalformedURLException mue) {
                        throw new StartingException(JeusMessage_WebContainer0._1014, JeusBootstrapProperties.JEUS_HOME, (Throwable)mue);
                    }
                    try {
                        this.suspendServlet = new SuspendServlet();
                        this.suspendServlet.init();
                    }
                    catch (ServletException se) {
                        if (!logger.isLoggable(JeusMessage_WebContainer0._1035_LEVEL)) break block39;
                        logger.log(JeusMessage_WebContainer0._1035_LEVEL, JeusMessage_WebContainer0._1035, (Throwable)se);
                    }
                }
                try {
                    this.unavailableServlet = new UnavailableServlet();
                    this.unavailableServlet.init();
                }
                catch (ServletException se) {
                    System.out.println(ErrorMsgManager.getLocalizedString((int)2035));
                    se.printStackTrace(System.out);
                }
                this.registerMBean();
                if (!this.isSYSTEM_ENGINE) {
                    LoggingType logging;
                    block40: {
                        logging = this.webContainerDesc.getLogging();
                        AccessLogType alog = logging == null ? null : logging.getAccessLog();
                        try {
                            ConfigUtil.configureAccessLog(alog, null);
                        }
                        catch (Throwable t) {
                            if (!logger.isLoggable(JeusMessage_WebContainer0._1351_LEVEL)) break block40;
                            logger.log(JeusMessage_WebContainer0._1351_LEVEL, JeusMessage_WebContainer0._1351, t);
                        }
                    }
                    UserLogType ulog = logging == null ? null : logging.getUserLog();
                    try {
                        ConfigUtil.configureUserLog(ulog, null);
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(JeusMessage_WebContainer0._1352_LEVEL)) break block41;
                        logger.log(JeusMessage_WebContainer0._1352_LEVEL, JeusMessage_WebContainer0._1352, t);
                    }
                }
            }
            if (this.getContainerProperties() == null) {
                this.containerProperties = new ContainerProperties();
                this.containerProperties.init(null);
            }
            Hashtable descs = this.webContainerDesc.getContextGroupDescriptor();
            this.ctxGroupNames = this.webContainerDesc.getContextGroupNames();
            Enumeration names = this.ctxGroupNames.elements();
            while (names.hasMoreElements()) {
                String groupName = (String)names.nextElement();
                ContextGroupDescriptor ctxGroupDesc = (ContextGroupDescriptor)descs.get(groupName);
                contextGroup = new ContextGroup(ctxGroupDesc, this);
                contextGroup.setConfigByXML(this.configByXML);
                contextGroup.initLogger();
                if (this.webEngineMo != null) {
                    contextGroup.registerMBean(this.webEngineMo.getObjectName());
                }
                this.contextGroups.put(groupName, contextGroup);
            }
            boolean isWebtFound = true;
            try {
                Class.forName("tmax.webt.util.WebtProperties");
            }
            catch (ClassNotFoundException e) {
                isWebtFound = false;
            }
            Enumeration ctxGroups = this.contextGroups.elements();
            while (ctxGroups.hasMoreElements()) {
                contextGroup = (ContextGroup)ctxGroups.nextElement();
                contextGroup.init();
            }
            System.setProperty("java.rmi.server.codebase", "http://localhost/");
            NamingServerBinder binder = new NamingServerBinder();
            try {
                this.control = new WebContainerControlImpl(this);
                String webcontainerEngineName = StartThread.webContainer;
                if (webcontainerEngineName != null && webcontainerEngineName.equals(this.ENGINE_NAME)) {
                    ENGINE_CONTROLLER = this.control;
                }
                binder.rebind(this.ENGINE_NAME, this.control);
                if (logger.isLoggable(JeusMessage_WebContainer0._1019_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1019_LEVEL, JeusMessage_WebContainer0._1019, (Object[])new String[]{this.ENGINE_NAME, "default"});
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (logger.isLoggable(JeusMessage_WebContainer0._1018_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1018_LEVEL, JeusMessage_WebContainer0._1018, (Object[])new String[]{"default"}, t);
                }
                throw new StartingException(JeusMessage_WebContainer0._1018, new String[]{"default"}, t);
            }
            if (this.isSYSTEM_ENGINE) {
                Enumeration enum1 = this.contextGroups.elements();
                while (enum1.hasMoreElements()) {
                    ContextGroup contextGroup2 = (ContextGroup)enum1.nextElement();
                    contextGroup2.startConnector();
                }
            }
            PrintStream errStream = System.err;
            System.setErr(System.out);
            System.setErr(errStream);
            pid = -1;
            try {
                pid = CUtility.thisProcessPID;
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_WebContainer0._1027_LEVEL)) {
                logger.log(JeusMessage_WebContainer0._1027_LEVEL, JeusMessage_WebContainer0._1027, (Object[])new String[]{JeusVersion.getVersion(), this.ENGINE_NAME});
            }
            if (this.redirectStdOut) {
                try {
                    cal = Calendar.getInstance();
                    suffix = this.fn.format(cal.getTime());
                    logDir = new File(REDIRECT_DIR);
                    logFile = null;
                    if (logDir.exists() || logDir.mkdirs()) {
                        fileName = "stdout_" + suffix + ".log";
                        logFile = new File(logDir, fileName);
                    }
                    this.systemOut = new PrintStream(new FileOutputStream(logFile.toString(), true), true);
                    System.setOut(this.systemOut);
                    this.redirectedSystemOutCreatedDay = cal.get(6);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer0._1037_LEVEL)) break block42;
                    logger.log(JeusMessage_WebContainer0._1037_LEVEL, JeusMessage_WebContainer0._1037, (Object)"stdout", (Throwable)e);
                }
            }
        }
        if (this.redirectStdErr) {
            try {
                cal = Calendar.getInstance();
                suffix = this.fn.format(cal.getTime());
                logDir = new File(REDIRECT_DIR);
                logFile = null;
                if (logDir.exists() || logDir.mkdirs()) {
                    fileName = "stderr_" + suffix + ".log";
                    logFile = new File(logDir, fileName);
                }
                this.systemErr = new PrintStream(new FileOutputStream(logFile.toString(), true), true);
                System.setErr(this.systemErr);
                this.redirectedSystemErrCreatedDay = cal.get(6);
            }
            catch (Exception e) {
                System.setErr(this.savedSystemOut);
                if (logger.isLoggable(JeusMessage_WebContainer0._1037_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1037_LEVEL, JeusMessage_WebContainer0._1037, (Object)"stderr", (Throwable)e);
                }
            }
        } else {
            System.setErr(this.savedSystemOut);
        }
        if (logger.isLoggable(JeusMessage_WebContainer0._1027_LEVEL)) {
            logger.log(JeusMessage_WebContainer0._1027_LEVEL, JeusMessage_WebContainer0._1027, new Object[]{JeusVersion.getVersion(), this.ENGINE_NAME, String.valueOf(pid)});
        }
        if (this.monitorDesc != null) {
            this.containerMonitor = new WebContainerMonitor(this, this.monitorDesc, this.contextGroups, this.classLoadManager, this.systemOut, this.systemErr, this.ENGINE_NAME);
            this.containerMonitor.startMonitor();
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRedirectedStdLogFile() {
        String fileName;
        File logFile;
        File logDir;
        PrintStream old;
        try {
            if (this.systemErr != null) {
                this.systemErr.flush();
            }
        }
        catch (Throwable t) {
            System.setErr(this.savedSystemOut);
            this.systemErr = null;
            this.redirectedSystemErrCreatedDay = -1;
            try {
                this.systemErr.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        try {
            if (this.systemOut != null) {
                this.systemOut.flush();
            }
        }
        catch (Throwable t) {
            System.setOut(this.savedSystemOut);
            this.systemOut = null;
            this.redirectedSystemOutCreatedDay = -1;
            try {
                this.systemOut.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        Calendar cal = Calendar.getInstance();
        int thisDay = cal.get(6);
        String suffix = this.fn.format(cal.getTime());
        if (this.redirectedSystemOutCreatedDay >= 0 && thisDay != this.redirectedSystemOutCreatedDay && this.systemOut != null) {
            old = this.systemOut;
            try {
                logDir = new File(REDIRECT_DIR);
                logFile = null;
                if (logDir.exists() || logDir.mkdirs()) {
                    fileName = "stdout_" + suffix + ".log";
                    logFile = new File(logDir, fileName);
                }
                this.systemOut = new PrintStream(new FileOutputStream(logFile.toString(), true), true);
                System.setOut(this.systemOut);
                this.redirectedSystemOutCreatedDay = thisDay;
            }
            catch (Exception e) {
                System.setOut(this.savedSystemOut);
                this.systemOut = null;
                this.redirectedSystemOutCreatedDay = -1;
                if (logger.isLoggable(JeusMessage_WebContainer0._1037_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1037_LEVEL, JeusMessage_WebContainer0._1037, (Object)"stdout", (Throwable)e);
                }
            }
            finally {
                try {
                    old.close();
                }
                catch (Throwable t) {}
            }
        }
        if (this.redirectedSystemErrCreatedDay >= 0 && thisDay != this.redirectedSystemErrCreatedDay && this.systemErr != null) {
            old = this.systemErr;
            try {
                logDir = new File(REDIRECT_DIR);
                logFile = null;
                if (logDir.exists() || logDir.mkdirs()) {
                    fileName = "stderr_" + suffix + ".log";
                    logFile = new File(logDir, fileName);
                }
                this.systemErr = new PrintStream(new FileOutputStream(logFile.toString(), true), true);
                System.setErr(this.systemErr);
                this.redirectedSystemErrCreatedDay = thisDay;
            }
            catch (Exception e) {
                System.setErr(this.savedSystemOut);
                this.systemErr = null;
                this.redirectedSystemErrCreatedDay = -1;
                if (logger.isLoggable(JeusMessage_WebContainer0._1037_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1037_LEVEL, JeusMessage_WebContainer0._1037, (Object)"stderr", (Throwable)e);
                }
            }
            finally {
                try {
                    old.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block25: {
            block23: {
                this.active = false;
                if (this.webEngineMo != null) {
                    try {
                        this.webEngineMo.destroyMBean();
                        _ENGINE_NAME = null;
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(JeusMessage_WebContainer0._1043_LEVEL)) break block23;
                        logger.log(JeusMessage_WebContainer0._1043_LEVEL, JeusMessage_WebContainer0._1043, (Throwable)e);
                    }
                }
            }
            try {
                PrintStream errStream = System.err;
                System.setErr(System.out);
                System.setErr(errStream);
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_WebContainer0._1030_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1030_LEVEL, JeusMessage_WebContainer0._1030, (Throwable)e);
                }
            }
            finally {
                if (this.savedSystemOut != null) {
                    System.setOut(this.savedSystemOut);
                }
                if (this.savedSystemErr != null) {
                    System.setErr(this.savedSystemErr);
                }
            }
            if (STANDALONE_MODE) {
                ShutdownMonitor shutdownMonitor = new ShutdownMonitor(10000L, this.ENGINE_NAME);
                shutdownMonitor.start();
            }
            try {
                if (this.containerMonitor != null) {
                    this.containerMonitor.stopMonitor();
                }
                Enumeration ctxGroups = this.getContextGroups();
                while (ctxGroups.hasMoreElements()) {
                    ContextGroup ctxGroup = (ContextGroup)ctxGroups.nextElement();
                    ctxGroup.shutdown();
                }
                if (this.systemErr != null) {
                    this.systemErr.close();
                }
                if (this.systemOut != null) {
                    this.systemOut.close();
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_WebContainer0._1038_LEVEL)) break block25;
                logger.log(JeusMessage_WebContainer0._1038_LEVEL, JeusMessage_WebContainer0._1038, t);
            }
        }
        if (!STANDALONE_MODE) {
            try {
                UnicastRemoteObject.unexportObject(this.control, true);
                NamingServerBinder binder = new NamingServerBinder();
                binder.unbind(this.ENGINE_NAME);
            }
            catch (NoSuchObjectException nsoe) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer0._1031_LEVEL)) {
            logger.log(JeusMessage_WebContainer0._1031_LEVEL, JeusMessage_WebContainer0._1031, (Object[])new String[]{JeusVersion.getVersion(), this.ENGINE_NAME});
        }
    }

    public TargetModuleID deployContext(String ctxGroupName, List virtualHostName, ContextDescriptor ctxDesc, Policy appPolicy, ClassLoader classloader, WebModule webModule) throws ServerException {
        ContextGroup contextGroup = this.getContextGroup(ctxGroupName);
        if (contextGroup == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        }
        return contextGroup.deployContext(virtualHostName, ctxDesc, appPolicy, classloader, webModule);
    }

    public boolean terminateCtxGroup(String ctxGroupName) {
        ContextGroup ctxGroup = (ContextGroup)this.contextGroups.get(ctxGroupName);
        if (ctxGroup.execTerminate()) {
            this.contextGroups.remove(ctxGroupName);
            return true;
        }
        return false;
    }

    public boolean reReadConfigIfModified() throws StartingException {
        WebContainerDescriptor desc = WebMainDescriptorJB.getWebMainDescriptor(this.ENGINE_NAME);
        this.setWebContainerDescriptor(desc);
        return true;
    }

    public boolean restartCtxGroup(String ctxGroupName) throws ServerException {
        try {
            this.reReadConfigIfModified();
            Hashtable descs = this.webContainerDesc.getContextGroupDescriptor();
            ContextGroupDescriptor ctxGroupDesc = (ContextGroupDescriptor)descs.get(ctxGroupName);
            ContextGroup contextGroup = new ContextGroup(ctxGroupDesc, this);
            contextGroup.setConfigByXML(this.configByXML);
            contextGroup.initLogger();
            contextGroup.registerMBean(this.webEngineMo.getObjectName());
            contextGroup.init();
            this.contextGroups.put(ctxGroupName, contextGroup);
            contextGroup.startConnector();
        }
        catch (StartingException se) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1026, (Object[])new String[]{ctxGroupName}), (Exception)((Object)se));
        }
        return true;
    }

    public boolean validContextGroupName(String ctxGroupName) {
        Hashtable descs = this.webContainerDesc.getContextGroupDescriptor();
        Object groupDesc = descs.get(ctxGroupName);
        return groupDesc != null;
    }

    public void restartEngine(String contextGroupName) {
        block8: {
            if (STANDALONE_MODE) {
                this.terminateCtxGroup(contextGroupName);
                try {
                    this.restartCtxGroup(contextGroupName);
                    if (logger.isLoggable(JeusMessage_WebContainer0._1032_LEVEL)) {
                        logger.log(JeusMessage_WebContainer0._1032_LEVEL, JeusMessage_WebContainer0._1032, (Object)contextGroupName);
                    }
                    break block8;
                }
                catch (ServerException se) {
                    if (logger.isLoggable(JeusMessage_WebContainer0._1026_LEVEL)) {
                        logger.log(JeusMessage_WebContainer0._1026_LEVEL, JeusMessage_WebContainer0._1026, (Object)contextGroupName, (Throwable)se);
                    }
                    break block8;
                }
            }
            CUtility.dumpThreadStack((int)EngineContainer.getPID());
            try {
                EngineContainer.restart(this.ENGINE_NAME);
                if (logger.isLoggable(JeusMessage_WebContainer0._1033_LEVEL)) {
                    logger.log(JeusMessage_WebContainer0._1033_LEVEL, JeusMessage_WebContainer0._1033, (Object)this.ENGINE_NAME);
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_WebContainer0._1034_LEVEL)) break block8;
                logger.log(JeusMessage_WebContainer0._1034_LEVEL, JeusMessage_WebContainer0._1034, (Object)this.ENGINE_NAME, (Throwable)ex);
            }
        }
    }

    private void registerMBean() {
        try {
            if (EngineContainer.serverMBean != null) {
                this.webEngineMo = (WebEngineMo)WebEngineMo.createMBean(this.ENGINE_NAME, EngineContainer.serverMBean.getObjectName(), this);
                this.webEngineMo.start();
                _ENGINE_NAME = this.ENGINE_NAME;
            }
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addContainerBootEndListener(NotificationListener listener) {
        EngineContainer.serverMBean.addNotificationListener(listener, null, null);
        EngineContainer.nodeListServiceMBean.addNotificationListener(listener, null, null);
    }

    public void removeContainerBootEndListener(NotificationListener listener) {
        try {
            EngineContainer.serverMBean.removeNotificationListener(listener);
            EngineContainer.nodeListServiceMBean.removeNotificationListener(listener);
        }
        catch (ListenerNotFoundException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setContainerProperties(ContainerProperties containerProperties) {
        this.containerProperties = containerProperties;
    }

    private void setLicensedClientNum() {
        int licType = Runner.getLicenseType();
        if (licType == Runner.LIC_TYPE_DEVELOPER || licType == Runner.LIC_TYPE_ACADEMIC) {
            this.licensedClientNum = Runner.getNumOfLicensedClient();
            if (this.licensedClientNum < 0) {
                throw new IllegalStateException("can not get the number of licensed client. please check the license");
            }
        }
    }

    public int getLicensedClientNum() {
        return this.licensedClientNum;
    }

    public boolean updateClientStats(HttpServletRequest request) {
        if (this.licensedClientNum == 0) {
            return true;
        }
        String clientAddr = request.getHeader("X-Forwarded-For");
        if (clientAddr == null) {
            clientAddr = request.getRemoteAddr();
        }
        return this.updateClientStats(clientAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateClientStats(String clientAddr) {
        if (this.licensedClientNum == 0) {
            return true;
        }
        HashMap hashMap = this.clientInfos;
        synchronized (hashMap) {
            int num = this.clientInfos.size();
            if (this.clientInfos.get(clientAddr) == null) {
                if (num == this.licensedClientNum) {
                    return false;
                }
                this.clientInfos.put(clientAddr, clientAddr);
            }
            return true;
        }
    }

    class ParsedResult {
        Object argumentObject;
        String remainingString;

        ParsedResult() {
        }
    }
}

