/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import jeus.management.j2ee.servlet.ContextGroupMo;
import jeus.management.j2ee.servlet.WebListenerMo;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.LoginService;
import jeus.servlet.connection.SSLSocketFactory;
import jeus.servlet.connection.SSLSocketFactory13;
import jeus.servlet.connection.SSLSocketFactory14;
import jeus.servlet.connection.SSLSocketFactory15;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.util.SimpleTimer;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.Logger;
import jeus.util.logging.JeusLogger;

public abstract class Connector
implements Runnable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connection");
    protected ConnectionDescriptor connDesc;
    protected String listenerId = null;
    protected String listenerType = null;
    protected int port = 8080;
    protected int backlog = 50;
    protected String webServerAddress = "127.0.0.1";
    protected ContextGroup contextGroup = null;
    protected WebListenerMo webListenerMo;
    protected SSLSocketFactory sslSocketFactory = null;

    Connector() {
    }

    Connector(ContextGroup ctxGroup, ConnectionDescriptor desc) {
        this.contextGroup = ctxGroup;
        this.initParameters(desc);
    }

    protected void initParameters(ConnectionDescriptor desc) {
        this.connDesc = desc;
        this.listenerId = this.connDesc.getListenerId();
        this.listenerType = this.connDesc.getListenerType();
        this.port = this.connDesc.getPort();
        this.backlog = this.connDesc.getBacklog();
        this.webServerAddress = this.connDesc.getWebServerAddress();
        if (this.sslSocketFactory == null && this.connDesc.isEnableSecure()) {
            float version = JeusBootstrapPropertyValues.JAVA_VERSION;
            this.sslSocketFactory = (double)version == 1.3 ? new SSLSocketFactory13(this.connDesc) : ((double)version == 1.4 ? new SSLSocketFactory14(this.connDesc) : ((double)version == 1.5 ? new SSLSocketFactory15(this.connDesc) : new SSLSocketFactory14(this.connDesc)));
        }
    }

    public String getListenerId() {
        return this.connDesc.getListenerId();
    }

    public String getListenerType() {
        return this.listenerType;
    }

    public String getWebServerAddress() {
        return this.webServerAddress;
    }

    public int getPort() {
        return this.port;
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connDesc;
    }

    public abstract ThreadPoolManager[] getThreadPoolManager();

    public abstract void init() throws StartingException;

    public abstract void startConnector() throws StartingException;

    public abstract void run();

    public abstract void destroy(SimpleTimer var1);

    protected abstract int[] getThreadInfo();

    public void registerMBean(ContextGroupMo contextGroupMo, String _type) {
        if (contextGroupMo == null) {
            return;
        }
        try {
            this.webListenerMo = (WebListenerMo)WebListenerMo.createMBean(this.listenerId, contextGroupMo.getObjectName(), this, _type);
            this.webListenerMo.start();
        }
        catch (Exception e) {
            Logger.directLog(e);
        }
        this.registerPoolManagerMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPoolManagerMBean() {
        try {
            LoginService.loginCodeSubject();
            ThreadPoolManager[] thPoolMgrs = this.getThreadPoolManager();
            if (thPoolMgrs == null) {
                return;
            }
            for (int i = 0; i < thPoolMgrs.length; ++i) {
                ThreadPoolManager thPoolMgr = thPoolMgrs[i];
                thPoolMgr.registerMBean(this.webListenerMo);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    public WebListenerMo getMBean() {
        return this.webListenerMo;
    }

    public void unregisterMBean() {
        if (this.webListenerMo != null) {
            this.webListenerMo.destroyMBean();
        }
    }
}

