/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import jeus.management.j2ee.servlet.ContextGroupMo;
import jeus.servlet.connection.Ajp13Connector;
import jeus.servlet.connection.Connector;
import jeus.servlet.connection.HttpConnector;
import jeus.servlet.connection.NIOHttpConnector;
import jeus.servlet.connection.NIOTCPConnector;
import jeus.servlet.connection.NIOTmaxConnector;
import jeus.servlet.connection.TCPConnector;
import jeus.servlet.connection.TmaxConnector;
import jeus.servlet.connection.WebtobConnector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.util.ErrorMsgManager;

public class ConnectorFactory {
    public static final String HTTP_CONNECTOR = "HttpListener";
    public static final String WEBTOB_CONNECTOR = "WebtobListener";
    public static final String TCP_CONNECTOR = "TCPListener";
    public static final String AJP13_CONNECTOR = "Ajp13Listener";
    public static final String TMAX_CONNECTOR = "TmaxListener";

    public static HashMap getConnectors(ContextGroup ctxGroup, ContextGroupDescriptor ctxgrpDesc, HashMap threadPools, ContextGroupMo contextGroupMo) throws StartingException {
        HashMap<String, Connector> connectors = new HashMap<String, Connector>();
        Enumeration enum1 = ctxgrpDesc.getConnectionDescriptor().elements();
        while (enum1.hasMoreElements()) {
            ConnectionDescriptor desc = (ConnectionDescriptor)enum1.nextElement();
            String id = desc.getListenerId();
            String type = desc.getListenerType();
            Connector conn = null;
            if (type.equals(HTTP_CONNECTOR)) {
                conn = desc.isUseNio() ? new NIOHttpConnector(ctxGroup, desc) : new HttpConnector(ctxGroup, desc);
                connectors.put(id, conn);
                threadPools.put(id, conn.getThreadPoolManager());
            } else if (type.equals(WEBTOB_CONNECTOR)) {
                conn = new WebtobConnector(ctxGroup, desc);
                connectors.put(id, conn);
                threadPools.put(id, conn.getThreadPoolManager());
            } else if (type.equals(TCP_CONNECTOR)) {
                conn = desc.isUseNio() ? new NIOTCPConnector(ctxGroup, desc) : new TCPConnector(ctxGroup, desc);
                connectors.put(id, conn);
                threadPools.put(id, conn.getThreadPoolManager());
            } else if (type.equals(AJP13_CONNECTOR)) {
                conn = new Ajp13Connector(ctxGroup, desc);
                connectors.put(id, conn);
                threadPools.put(id, conn.getThreadPoolManager());
            } else if (type.equals(TMAX_CONNECTOR)) {
                try {
                    conn = desc.isUseNio() ? new NIOTmaxConnector(ctxGroup, desc) : new TmaxConnector(ctxGroup, desc);
                }
                catch (IOException ioe) {
                    String msg = ErrorMsgManager.getLocalizedString((int)2059, (Object[])new String[]{String.valueOf(desc.getPort())});
                    throw new StartingException(msg, (Throwable)ioe);
                }
                connectors.put(id, conn);
                threadPools.put(id, conn.getThreadPoolManager());
            }
            if (conn == null) continue;
            conn.registerMBean(contextGroupMo, type);
        }
        for (Connector connector : connectors.values()) {
            connector.init();
        }
        return connectors;
    }
}

