/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import jeus.servlet.connection.SSLSocketFactory14;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;

public class SSLSocketFactory15
extends SSLSocketFactory14 {
    public SSLSocketFactory15(ConnectionDescriptor connDesc) {
        super(connDesc);
    }

    protected TrustManager[] getTrustManagers(String truststoreType, String algorithm, String path, String pass) throws Exception {
        String crlf = this.connDesc.getCrlFile();
        if (crlf == null) {
            return super.getTrustManagers(truststoreType, algorithm, path, pass);
        }
        TrustManager[] tms = null;
        KeyStore trustStore = this.getStore(truststoreType, path, pass);
        if (trustStore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
            CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
            tmf.init(mfp);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    private CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters params = null;
        if (!"PKIX".equalsIgnoreCase(algorithm)) {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        PKIXBuilderParameters xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        Collection crls = this.getCRLs(crlf);
        CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
        CertStore store = CertStore.getInstance("Collection", csp);
        xparams.addCertStore(store);
        xparams.setRevocationEnabled(true);
        params = xparams;
        return params;
    }

    private Collection getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlf);
            crls = cf.generateCRLs(is);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }
}

