/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import jeus.util.logging.JeusLogger;

public class SSLSupport {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connection");
    public static final String CIPHER_SUITE_KEY = "javax.servlet.request.cipher_suite";
    public static final String KEY_SIZE_KEY = "javax.servlet.request.key_size";
    public static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    public static final String SESSION_ID_KEY = "javax.servlet.request.ssl_session";
    public static final String JEUS_KEY_STORE = "jeus.ssl.keystore";
    public static final String JEUS_KEY_PASS = "jeus.ssl.keypass";
    public static final String JEUS_TRUST_STORE = "jeus.ssl.truststore";
    public static final String JEUS_TRUST_PASS = "jeus.ssl.trustpass";
    public static final String JAVAX_KEY_STORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEY_PASS = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String JAVAX_KEY_MANAGEMENT_ALGO = "ssl.KeyManagerFactory.algorithm";
    public static final String JAVAX_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_TRUST_PASS = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String JAVAX_TRUST_MANAGEMENT_ALGO = "ssl.TrustManagerFactory.algorithm";
    public static final String DEFAULT_KEY_STORE = "keystore";
    public static final String DEFAULT_KEY_PASS = "jeuskeypass";
    public static final String DEFAULT_KEY_STORE_TYPE = "JKS";
    public static final String DEFAULT_KEY_MANAGEMENT_ALGO = "SunX509";
    public static final String DEFAULT_TRUST_STORE = "truststore";
    public static final String DEFAULT_TRUST_PASS = "jeustrustpass";
    public static final String DEFAULT_TRUST_STORE_TYPE = "JKS";
    public static final String DEFAULT_TRUST_MANAGEMENT_ALGO = "SunX509";
    public static final int FLAG_KEY_STORE = 1;
    public static final int FLAG_KEY_PASS = 2;
    public static final int FLAG_KEY_STORE_TYPE = 3;
    public static final int FLAG_KEY_MANAGEMENT_ALGO = 4;
    public static final int FLAG_TRUST_STORE = 5;
    public static final int FLAG_TRUST_PASS = 6;
    public static final int FLAG_TRUST_STORE_TYPE = 7;
    public static final int FLAG_TRUST_MANAGEMENT_ALGO = 8;
    static final CipherData[] ciphers = new CipherData[]{new CipherData("_WITH_NULL_", 0), new CipherData("_WITH_IDEA_CBC_", 128), new CipherData("_WITH_RC2_CBC_40_", 40), new CipherData("_WITH_RC4_40_", 40), new CipherData("_WITH_RC4_128_", 128), new CipherData("_WITH_DES40_CBC_", 40), new CipherData("_WITH_DES_CBC_", 56), new CipherData("_WITH_3DES_EDE_CBC_", 168)};
    protected SSLSocket sslSocket;

    public SSLSupport(SSLSocket sslSocket) {
        this.sslSocket = sslSocket;
    }

    public String getCipherSuite() throws IOException {
        SSLSession session = this.sslSocket.getSession();
        if (session == null) {
            return null;
        }
        return session.getCipherSuite();
    }

    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        SSLSession session = this.sslSocket.getSession();
        if (session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
        }
        catch (Exception bex) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            session.invalidate();
            this.handShake();
            session = this.sslSocket.getSession();
        }
        return this.getX509Certificates(session);
    }

    protected void handShake() throws IOException {
        this.sslSocket.setNeedClientAuth(true);
        this.sslSocket.startHandshake();
    }

    protected X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        javax.security.cert.X509Certificate[] jsseCerts;
        block7: {
            jsseCerts = null;
            try {
                jsseCerts = session.getPeerCertificateChain();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) break block7;
                logger.log(Level.FINE, "error getting client certs", t);
            }
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        X509Certificate[] x509Certs = new X509Certificate[jsseCerts.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    public Integer getKeySize() {
        SSLSession session = this.sslSocket.getSession();
        if (session == null) {
            return null;
        }
        CipherData[] c_aux = ciphers;
        Integer keySize = (Integer)session.getValue(KEY_SIZE_KEY);
        if (keySize == null) {
            int size = 0;
            String cipherSuite = session.getCipherSuite();
            for (int i = 0; i < c_aux.length; ++i) {
                if (cipherSuite.indexOf(c_aux[i].phrase) < 0) continue;
                size = c_aux[i].keySize;
                break;
            }
            keySize = new Integer(size);
            session.putValue(KEY_SIZE_KEY, keySize);
        }
        return keySize;
    }

    public String getSessionId() throws IOException {
        SSLSession session = this.sslSocket.getSession();
        if (session == null) {
            return null;
        }
        byte[] ssl_session = session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        for (int x = 0; x < ssl_session.length; ++x) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }

    public static String getSSLConfigValue(String value, String jeusKey, String javaxKey, int flag) {
        if (value != null) {
            return value;
        }
        if (jeusKey != null) {
            value = System.getProperty(jeusKey);
            if (value == null) {
                value = System.getProperty(javaxKey);
            }
        } else {
            value = System.getProperty(javaxKey);
        }
        if (value == null) {
            return SSLSupport.getDefaultSSLConfigValue(flag);
        }
        return value;
    }

    private static String getDefaultSSLConfigValue(int flag) {
        switch (flag) {
            case 1: {
                return DEFAULT_KEY_STORE;
            }
            case 2: {
                return DEFAULT_KEY_PASS;
            }
            case 3: {
                return "JKS";
            }
            case 4: {
                return "SunX509";
            }
            case 5: {
                return DEFAULT_TRUST_STORE;
            }
            case 6: {
                return DEFAULT_TRUST_PASS;
            }
            case 7: {
                return "JKS";
            }
            case 8: {
                return "SunX509";
            }
        }
        return null;
    }

    public static boolean isSSLAttribute(String name) {
        return CERTIFICATE_KEY.equals(name) || CIPHER_SUITE_KEY.equals(name) || KEY_SIZE_KEY.equals(name) || SESSION_ID_KEY.equals(name);
    }

    static final class CipherData {
        public String phrase = null;
        public int keySize = 0;

        public CipherData(String phrase, int keySize) {
            this.phrase = phrase;
            this.keySize = keySize;
        }
    }
}

