/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.servlet.connection.Connector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.TmaxThreadPoolManager;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.engine.io.TmaxUtil;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.servlet.util.SimpleTimer;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRootClassLoader;
import jeus.util.message.JeusMessage_WebContainer4;

public class TmaxConnector
extends Connector {
    private static int RECONNECT_INTERVAL = 5000;
    private static String DEFAULT_RECONNECT_TIMEOUT = "120000";
    private TCPDispatcherConfig dispatcherConfig;
    private int spri;
    private int clhCount;
    private int cpcCount;
    private int[] clhPort;
    private int procType;
    private int clid;
    private int domainid;
    private XAResource xar;
    private TMMHandler tmmHandler;
    private TmaxThreadPoolManager[] poolManager;
    private Vector addedPools;
    private Object lock;
    private boolean running;
    private boolean reconnecting;
    private Thread thread;
    private ConnectionDescriptor backupDesc;
    private boolean isBackup;
    private boolean httpGW;

    public TmaxConnector(ContextGroup ctxGroup, ConnectionDescriptor desc) throws IOException {
        block2: {
            super(ctxGroup, desc);
            this.dispatcherConfig = null;
            this.addedPools = new Vector();
            this.lock = new Object();
            this.running = false;
            this.reconnecting = false;
            this.thread = null;
            this.isBackup = false;
            this.httpGW = false;
            this.clhCount = 0;
            this.cpcCount = 0;
            this.initBackup();
            this.initDispatcherConfig();
            this.tmmHandler = new TMMHandler();
            try {
                this.tmmHandler.connect(desc);
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(JeusMessage_WebContainer4._4050_LEVEL)) break block2;
                logger.log(JeusMessage_WebContainer4._4050_LEVEL, JeusMessage_WebContainer4._4050);
            }
        }
        this.createPoolManager();
    }

    private void initBackup() {
        Enumeration en;
        Vector backups = this.connDesc.getBackupServerDescriptor();
        if (backups != null && backups.size() > 0 && (en = backups.elements()).hasMoreElements()) {
            this.backupDesc = (ConnectionDescriptor)en.nextElement();
            try {
                this.backupDesc.setListenerId(this.connDesc.getListenerId());
            }
            catch (DescriptorException descriptorException) {
                // empty catch block
            }
            if (this.backupDesc.getThreadPoolDescriptor() == null) {
                this.backupDesc.setThreadPoolDescriptor(this.connDesc.getThreadPoolDescriptor());
            }
        }
    }

    private void initDispatcherConfig() throws StartingException {
        String dispatcherConfigClass = this.connDesc.getDispatcherConfigClass();
        if (dispatcherConfigClass == null) {
            throw new StartingException(ErrorMsgManager.getLocalizedString((int)2388));
        }
        try {
            Class<?> klass = JeusRootClassLoader.loader.loadClass(dispatcherConfigClass);
            this.dispatcherConfig = (TCPDispatcherConfig)klass.newInstance();
            this.dispatcherConfig.init();
        }
        catch (Exception e) {
            throw new StartingException("fail to instantiate dispatcher config class : " + dispatcherConfigClass, (Throwable)e);
        }
    }

    private void createPoolManager() {
        this.poolManager = new TmaxThreadPoolManager[this.clhCount];
        for (int i = 0; i < this.clhCount; ++i) {
            ConnectionDescriptor tmaxConnDesc = this.getCurrentConnectionDescriptor();
            this.poolManager[i] = new TmaxThreadPoolManager(this.contextGroup, this, tmaxConnDesc, i);
        }
    }

    public ThreadPoolManager[] getThreadPoolManager() {
        return this.poolManager;
    }

    public void init() throws StartingException {
    }

    public void startConnector() {
        this.running = true;
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(this);
            this.thread.setName(this.listenerId + "-acceptor");
            this.thread.start();
        }
        try {
            for (int i = 0; i < this.poolManager.length; ++i) {
                this.poolManager[i].createPool();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(ErrorMsgManager.getLocalizedString((int)2064, (Object[])new String[]{this.listenerType, String.valueOf(this.port)}));
    }

    public void run() {
        if (!this.tmmHandler.isConnected()) {
            this.reconnectTMM();
        }
        while (this.running) {
            try {
                int msgtype = this.tmmHandler.handleRequest();
                if (msgtype != 108 || !this.running) continue;
                this.reconnectTMM();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_WebContainer4._4051_LEVEL)) {
                    logger.log(JeusMessage_WebContainer4._4051_LEVEL, JeusMessage_WebContainer4._4051, (Object)Thread.currentThread().getName(), (Throwable)ioe);
                }
                if (!this.running) continue;
                this.reconnectTMM();
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_WebContainer4._4052_LEVEL)) {
                    logger.log(JeusMessage_WebContainer4._4052_LEVEL, JeusMessage_WebContainer4._4052, (Object)Thread.currentThread().getName(), t);
                }
                if (!this.running) continue;
                this.reconnectTMM();
            }
        }
    }

    public ConnectionDescriptor getCurrentConnectionDescriptor() {
        if (this.isBackup) {
            return this.backupDesc;
        }
        return this.connDesc;
    }

    private ConnectionDescriptor getAnotherConnectionDescriptor() {
        if (this.backupDesc != null) {
            this.isBackup = !this.isBackup;
        }
        return this.getCurrentConnectionDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectTMM() {
        if (logger.isLoggable(JeusMessage_WebContainer4._4053_LEVEL)) {
            logger.log(JeusMessage_WebContainer4._4053_LEVEL, JeusMessage_WebContainer4._4053);
        }
        this.tmmHandler.closeSocket();
        Object object = this.lock;
        synchronized (object) {
            ConnectionDescriptor desc;
            boolean success;
            this.reconnecting = true;
            if (logger.isLoggable(JeusMessage_WebContainer4._4054_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4054_LEVEL, JeusMessage_WebContainer4._4054, (Object)String.valueOf(this.running));
            }
            if (success = this.tmmHandler.reconnect(desc = this.getCurrentConnectionDescriptor())) {
                this.destroyThreadPoolManager(null);
                this.createPoolManager();
                this.startConnector();
                this.contextGroup.addThreadPoolManager(this.listenerId, this.poolManager);
                this.reconnecting = false;
                return;
            }
            if (this.backupDesc == null) {
                return;
            }
            while (this.running) {
                desc = this.getAnotherConnectionDescriptor();
                if (desc == null) {
                    this.running = false;
                    break;
                }
                this.destroyThreadPoolManager(null);
                boolean isZero = false;
                try {
                    if (desc.getReconnectTimeout() == 0L) {
                        desc.setReconnectTimeout(DEFAULT_RECONNECT_TIMEOUT);
                        isZero = true;
                    }
                    if (logger.isLoggable(JeusMessage_WebContainer4._4057_LEVEL)) {
                        logger.log(JeusMessage_WebContainer4._4057_LEVEL, JeusMessage_WebContainer4._4057);
                    }
                    if (!(success = this.tmmHandler.reconnect(desc))) continue;
                    this.createPoolManager();
                    this.startConnector();
                    this.contextGroup.addThreadPoolManager(this.listenerId, this.poolManager);
                    this.reconnecting = false;
                    break;
                }
                finally {
                    if (!isZero) continue;
                    desc.setReconnectTimeout("0");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(SimpleTimer timer) {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            if (this.reconnecting) {
                this.lock.notifyAll();
                return;
            }
            try {
                this.tmmHandler.requestShutdown();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_WebContainer4._4059_LEVEL)) {
                    logger.log(JeusMessage_WebContainer4._4059_LEVEL, JeusMessage_WebContainer4._4059);
                }
                return;
            }
            this.destroyThreadPoolManager(timer);
            this.lock.notifyAll();
            return;
        }
    }

    private void destroyThreadPoolManager(SimpleTimer timer) {
        if (logger.isLoggable(JeusMessage_WebContainer4._4060_LEVEL)) {
            logger.log(JeusMessage_WebContainer4._4060_LEVEL, JeusMessage_WebContainer4._4060);
        }
        if (this.poolManager != null) {
            for (int i = 0; i < this.poolManager.length; ++i) {
                this.poolManager[i].destroy();
                this.poolManager[i].waitWorkerDestroy(timer);
            }
            this.poolManager = null;
        }
        if (this.addedPools.size() > 0) {
            Enumeration en = this.addedPools.elements();
            while (en.hasMoreElements()) {
                ThreadPoolManager mngr = (ThreadPoolManager)en.nextElement();
                mngr.destroy();
                mngr.waitWorkerDestroy(timer);
            }
            this.addedPools.clear();
        }
    }

    public void checkAlivePrimary() {
        if (!this.isBackup) {
            return;
        }
    }

    public int[] getThreadInfo() {
        TmaxThreadPoolManager[] pm = null;
        pm = this.poolManager;
        int[] info = new int[3];
        info[0] = 0;
        for (int i = 0; i < pm.length; ++i) {
            info[0] = info[0] + pm[i].getCurrentThreadNum();
            info[1] = info[1] + pm[i].getWaitQueueCount();
            info[2] = info[2] + pm[i].getMaxThreadNum();
        }
        return info;
    }

    public String[] getConnectionInfo() {
        TmaxThreadPoolManager[] pm = null;
        pm = this.poolManager;
        String[] result = new String[pm.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = pm[i].getConnectionInfo();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClhCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.clhCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClhPort(int clhId) {
        Object object = this.lock;
        synchronized (object) {
            return this.clhPort[clhId];
        }
    }

    public int getCpcCount() {
        return this.cpcCount;
    }

    public int getSpri() {
        return this.spri;
    }

    public int getClid() {
        return this.clid;
    }

    public TCPDispatcherConfig getDispatcherConfig() {
        return this.dispatcherConfig;
    }

    public String getWebServerAddress() {
        if (this.isBackup) {
            return this.backupDesc.getWebServerAddress();
        }
        return this.connDesc.getWebServerAddress();
    }

    public TmaxHeader getTmaxHeader() {
        return this.tmmHandler.tmaxHeader;
    }

    public Vector getXidVector() {
        return this.tmmHandler.xidVector;
    }

    public boolean isRecover() {
        return this.tmmHandler.recover;
    }

    public XAResource getXar() {
        return this.xar;
    }

    public boolean isHttpGW() {
        return this.httpGW;
    }

    static /* synthetic */ int[] access$902(TmaxConnector x0, int[] x1) {
        x0.clhPort = x1;
        return x1;
    }

    private class TMMHandler {
        private boolean connected = false;
        private Socket socket;
        private InputStream in;
        private OutputStream out;
        private TmaxHeader tmaxHeader = null;
        private boolean recover;
        private Vector xidVector = new Vector();

        boolean isConnected() {
            return this.connected;
        }

        boolean reconnect(ConnectionDescriptor tmaxConnDesc) {
            long timeout = tmaxConnDesc.getReconnectTimeout();
            if (timeout == 0L) {
                return false;
            }
            boolean infinite = false;
            if (timeout < 0L) {
                infinite = true;
            }
            while (true) {
                try {
                    this.connect(tmaxConnDesc);
                    return true;
                }
                catch (Throwable t) {
                    if (Connector.logger.isLoggable(JeusMessage_WebContainer4._4058_LEVEL)) {
                        Connector.logger.log(JeusMessage_WebContainer4._4058_LEVEL, JeusMessage_WebContainer4._4058);
                    }
                    if (!infinite && timeout <= 0L) {
                        return false;
                    }
                    try {
                        Thread.sleep(RECONNECT_INTERVAL);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (infinite) continue;
                    timeout -= (long)RECONNECT_INTERVAL;
                    continue;
                }
                break;
            }
        }

        void connect(ConnectionDescriptor tmaxConnDesc) throws IOException {
            byte[] data;
            byte[] reply;
            String tmaxVer;
            String s1;
            if (tmaxConnDesc.getServerType() != null && tmaxConnDesc.getServerType().equalsIgnoreCase("httpGW")) {
                TmaxConnector.this.httpGW = true;
            }
            if ((s1 = tmaxConnDesc.getXAResourceClass()) != null && !s1.equals("")) {
                this.recover = true;
                try {
                    Class[] aclass = new Class[]{TmaxConnector.this.connDesc.getClass()};
                    Object[] aobj = new Object[]{TmaxConnector.this.connDesc};
                    Class<?> class1 = Thread.currentThread().getContextClassLoader().loadClass(s1);
                    Constructor<?> constructor = class1.getDeclaredConstructor(aclass);
                    TmaxConnector.this.xar = (XAResource)constructor.newInstance(aobj);
                }
                catch (Exception e) {
                    throw new StartingException("fail to instantiate XAResource class : " + s1, (Throwable)e);
                }
            }
            if ("40".equals(tmaxVer = tmaxConnDesc.getTmaxVersion())) {
                this.tmaxHeader = TmaxUtil.VER4_HEADER;
            } else if ("3X".equalsIgnoreCase(tmaxVer)) {
                this.tmaxHeader = TmaxUtil.VER3_HEADER;
            } else {
                throw new IOException("TMMHandler : Unrecognized value - tmax version : " + tmaxVer);
            }
            this.socket = new Socket(tmaxConnDesc.getWebServerAddress(), tmaxConnDesc.getPort());
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            byte[] header = TmaxUtil.makeHeader(this.tmaxHeader, 101);
            if (tmaxConnDesc.getServerType() != null && tmaxConnDesc.getServerType().equalsIgnoreCase("tms")) {
                TmaxUtil.writeInt(header, 26, this.tmaxHeader.TYPE_OFFSET());
            } else {
                TmaxUtil.writeInt(header, 25, this.tmaxHeader.TYPE_OFFSET());
            }
            TmaxUtil.writeString(this.tmaxHeader, header, tmaxConnDesc.getServerName(), this.tmaxHeader.SVCINAME_OFFSET());
            String svgname = tmaxConnDesc.getServerGroupName();
            if (svgname != null) {
                TmaxUtil.writeString(this.tmaxHeader, header, svgname, this.tmaxHeader.SUBTYPE_OFFSET());
                TmaxUtil.writeInt(header, 0, this.tmaxHeader.RCODE_OFFSET());
            } else {
                TmaxUtil.writeInt(header, -1, this.tmaxHeader.RCODE_OFFSET());
            }
            try {
                this.out.write(header);
                this.out.flush();
            }
            catch (IOException ioe) {
                this.closeSocket();
                throw ioe;
            }
            try {
                reply = TmaxUtil.recvHeader(this.tmaxHeader, this.in);
            }
            catch (IOException ioe) {
                this.closeSocket();
                throw ioe;
            }
            int msgtype = TmaxUtil.readInt(reply, this.tmaxHeader.MSGTYPE_OFFSET());
            if (msgtype != 1101) {
                this.closeSocket();
                throw new IOException("tmm_register : error replied : " + msgtype);
            }
            TmaxConnector.this.spri = TmaxUtil.readInt(reply, this.tmaxHeader.SVCICD_OFFSET());
            TmaxConnector.this.clhCount = TmaxUtil.readInt(reply, this.tmaxHeader.RCODE_OFFSET());
            TmaxConnector.this.cpcCount = TmaxUtil.readInt(reply, this.tmaxHeader.ETC_OFFSET());
            TmaxConnector.this.procType = TmaxUtil.readInt(reply, this.tmaxHeader.TYPE_OFFSET());
            TmaxConnector.this.clid = TmaxUtil.readInt(reply, this.tmaxHeader.CLID_OFFSET());
            TmaxConnector.this.domainid = TmaxUtil.readInt(reply, this.tmaxHeader.ETC2_OFFSET());
            int datalen = TmaxUtil.readInt(reply, this.tmaxHeader.SVCILEN_OFFSET());
            if (datalen < TmaxConnector.this.clhCount * 4) {
                this.closeSocket();
                throw new IOException("not enough data received. expected = " + TmaxConnector.this.clhCount * 4 + ", received = " + datalen);
            }
            try {
                data = TmaxUtil.recvData(this.in, datalen);
            }
            catch (IOException ioe) {
                this.closeSocket();
                throw ioe;
            }
            TmaxConnector.access$902(TmaxConnector.this, new int[TmaxConnector.this.clhCount]);
            for (int i = 0; i < TmaxConnector.this.clhCount; ++i) {
                ((TmaxConnector)TmaxConnector.this).clhPort[i] = TmaxUtil.readInt(data, i * 4);
            }
            this.connected = true;
            if (Connector.logger.isLoggable(JeusMessage_WebContainer4._4061_LEVEL)) {
                Connector.logger.log(JeusMessage_WebContainer4._4061_LEVEL, JeusMessage_WebContainer4._4061, new Object[]{new Integer(TmaxConnector.this.spri), new Integer(TmaxConnector.this.clhCount), new Integer(TmaxConnector.this.cpcCount), new Integer(TmaxConnector.this.procType)});
            }
            if (this.recover && TmaxConnector.this.xar != null) {
                Xid[] axid;
                block33: {
                    for (int l = 0; l < TmaxConnector.this.clhCount; ++l) {
                        this.xidVector.add(l, new Vector());
                    }
                    axid = null;
                    try {
                        axid = TmaxConnector.this.xar.recover(0x1800000);
                    }
                    catch (XAException xae) {
                        xae.printStackTrace();
                        if (!Connector.logger.isLoggable(JeusMessage_WebContainer4._4063_LEVEL)) break block33;
                        Connector.logger.log(JeusMessage_WebContainer4._4063_LEVEL, JeusMessage_WebContainer4._4063, (Object)TmaxConnector.this.xar, (Throwable)xae);
                    }
                }
                if (axid == null) {
                    this.recover = false;
                    if (Connector.logger.isLoggable(JeusMessage_WebContainer4._4064_LEVEL)) {
                        Connector.logger.log(JeusMessage_WebContainer4._4064_LEVEL, JeusMessage_WebContainer4._4064);
                    }
                } else {
                    if (Connector.logger.isLoggable(JeusMessage_WebContainer4._4065_LEVEL)) {
                        Connector.logger.log(JeusMessage_WebContainer4._4065_LEVEL, JeusMessage_WebContainer4._4065, (Object)new Integer(axid.length));
                    }
                    for (int i1 = 0; i1 < axid.length; ++i1) {
                        Xid xid = axid[i1];
                        byte[] gtxId = xid.getGlobalTransactionId();
                        int j1 = TmaxUtil.readInt(gtxId, 0);
                        if (TmaxConnector.this.domainid != j1 >> 22) continue;
                        int clhId = j1 << 24;
                        if (clhId < 0 || clhId >= TmaxConnector.this.clhCount) {
                            clhId = 0;
                        }
                        if (this.xidVector.elementAt(clhId) == null) {
                            Vector<Xid> vector = new Vector<Xid>();
                            vector.add(xid);
                            this.xidVector.add(clhId, vector);
                            continue;
                        }
                        Vector vector1 = (Vector)this.xidVector.get(clhId);
                        vector1.add(xid);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestShutdown() throws IOException {
            byte[] header = TmaxUtil.makeHeader(this.tmaxHeader, 48);
            TmaxUtil.writeString(this.tmaxHeader, header, TmaxConnector.this.connDesc.getServerName(), this.tmaxHeader.SVCINAME_OFFSET());
            Object object = TmaxConnector.this.lock;
            synchronized (object) {
                this.out.write(header);
                this.out.flush();
            }
            if (Connector.logger.isLoggable(JeusMessage_WebContainer4._4062_LEVEL)) {
                Connector.logger.log(JeusMessage_WebContainer4._4062_LEVEL, JeusMessage_WebContainer4._4062);
            }
        }

        void closeSocket() {
            this.connected = false;
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.in = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.out = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
        }

        public int handleRequest() throws IOException {
            byte[] header = TmaxUtil.recvHeader(this.tmaxHeader, this.in);
            int msgtype = TmaxUtil.readInt(header, this.tmaxHeader.MSGTYPE_OFFSET());
            switch (msgtype) {
                case 108: {
                    this.processDownRequest(header);
                    break;
                }
                case 203: {
                    this.processPingRequest(header);
                    break;
                }
                case 109: {
                    this.processCLHAddedRequest(header);
                    break;
                }
                default: {
                    this.processUnknownRequest(header, msgtype);
                }
            }
            return msgtype;
        }

        private void unregisterTMM() {
            try {
                TmaxUtil.unregisterConnection(this.tmaxHeader, this.out, this.in, true, TmaxConnector.this.procType);
                Connector.logger.log(JeusMessage_WebContainer4._4066_LEVEL, JeusMessage_WebContainer4._4066);
            }
            catch (IOException ioe) {
                Connector.logger.log(JeusMessage_WebContainer4._4067_LEVEL, JeusMessage_WebContainer4._4067, (Throwable)ioe);
            }
            this.closeSocket();
        }

        private void processDownRequest(byte[] header) {
            Connector.logger.log(JeusMessage_WebContainer4._4068_LEVEL, JeusMessage_WebContainer4._4068);
            TmaxConnector.this.destroyThreadPoolManager(null);
            this.unregisterTMM();
            TmaxConnector.this.contextGroup.removeThreadPoolManager(TmaxConnector.this.listenerId);
        }

        private void processPingRequest(byte[] header) throws IOException {
            Connector.logger.log(JeusMessage_WebContainer4._4069_LEVEL, JeusMessage_WebContainer4._4069);
            TmaxUtil.writeInt(header, 1203, this.tmaxHeader.MSGTYPE_OFFSET());
            this.out.write(header);
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCLHAddedRequest(byte[] header) throws IOException {
            int clhId = TmaxUtil.readInt(header, this.tmaxHeader.SVCICD_OFFSET());
            int cpc = TmaxUtil.readInt(header, this.tmaxHeader.ETC_OFFSET());
            int port = TmaxUtil.readInt(header, this.tmaxHeader.RCODE_OFFSET());
            Object object = TmaxConnector.this.lock;
            synchronized (object) {
                TmaxConnector.this.clhCount++;
                int[] tmp = new int[TmaxConnector.this.clhPort.length + 1];
                System.arraycopy(TmaxConnector.this.clhPort, 0, tmp, 0, TmaxConnector.this.clhPort.length);
                tmp[((TmaxConnector)TmaxConnector.this).clhPort.length] = port;
                TmaxConnector.access$902(TmaxConnector.this, tmp);
            }
            ConnectionDescriptor tmaxConnDesc = TmaxConnector.this.getCurrentConnectionDescriptor();
            TmaxThreadPoolManager pool = new TmaxThreadPoolManager(TmaxConnector.this.contextGroup, TmaxConnector.this, tmaxConnDesc, clhId);
            boolean success = false;
            try {
                pool.createPool();
                TmaxConnector.this.addedPools.add(pool);
                success = true;
            }
            catch (Exception e) {
                Connector.logger.log(JeusMessage_WebContainer4._4070_LEVEL, JeusMessage_WebContainer4._4070, (Throwable)e);
            }
            byte[] reply = null;
            reply = success ? TmaxUtil.makeHeader(this.tmaxHeader, 1109) : TmaxUtil.makeHeader(this.tmaxHeader, 2109);
            this.out.write(reply);
            this.out.flush();
        }

        private void processUnknownRequest(byte[] header, int msgtype) throws IOException {
            if (Connector.logger.isLoggable(JeusMessage_WebContainer4._4071_LEVEL)) {
                Connector.logger.log(JeusMessage_WebContainer4._4071_LEVEL, JeusMessage_WebContainer4._4071, new Object[]{new Integer(msgtype), new Integer(TmaxUtil.readInt(header, this.tmaxHeader.RCODE_OFFSET()))});
            }
            TmaxUtil.writeInt(header, msgtype + 2000, this.tmaxHeader.MSGTYPE_OFFSET());
            this.out.write(header);
            this.out.flush();
        }
    }
}

