/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import jeus.servlet.connector.Task;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.pipeline.Pipeline;

public abstract class AbstractTask
implements Task {
    protected WebConnector connector;
    private int type;
    private Pipeline pipeline;
    private long startTime;

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setConnector(WebConnector connector) {
        this.connector = connector;
    }

    public WebConnector getConnector() {
        return this.connector;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void execute() {
        if (this.pipeline != null) {
            this.startTime = System.currentTimeMillis();
            this.pipeline.addTask(this);
        } else {
            if (this.connector != null && this.connector.getProcessorPipeline() != null && this.connector.getProcessorPipeline().getPipelineStatistic() != null && this.startTime != 0L) {
                this.connector.getProcessorPipeline().getPipelineStatistic().gatherQueueWaitTime(System.currentTimeMillis() - this.startTime);
            }
            this.run();
        }
    }

    public void run() {
        try {
            this.doTask();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void cancelTask(Throwable t, String message) {
        this.sendError(t, message);
        this.finishConnection();
    }

    public Object call() throws Exception {
        return null;
    }

    public abstract void finishConnection();

    public abstract void sendError(Throwable var1, String var2);
}

