/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import jeus.io.Selector;
import jeus.io.SocketListener;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.handler.StreamHandler;
import jeus.io.helper.IOComponentCreator;
import jeus.io.impl.nio.ChannelConnector;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.net.JeusSSLConfiguration;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.WebContentHandlerCreator;
import jeus.servlet.connector.WebStreamContentReceiver;
import jeus.servlet.connector.protocol.tmax.TMAXWebConnector;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;
import jeus.util.properties.JeusNetProperties;

public class Connector
implements SocketListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    private WebContentHandlerCreator webContentHandlerCreator = null;
    private Selector jeusSelector;
    private boolean destroyed;
    private jeus.io.Connector jeusConnector = null;
    private static final int INVALID_PORT = -1;
    private WebConnector connector;
    private int connectionTimeout = JeusNetProperties.CONNECT_TIMEOUT;
    private int readTimeout = 20000;
    private SSLContext sslContext = null;
    private static final Map sslProperty = new HashMap();

    public Connector(WebConnector connector, Selector jeusSelector, boolean useSSL) {
        if (logger.isLoggable(JeusMessage_WebContainer10._10217_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10217_LEVEL, JeusMessage_WebContainer10._10217, new Object[]{connector, jeusSelector, String.valueOf(useSSL)});
        }
        this.destroyed = false;
        this.connector = connector;
        this.jeusSelector = jeusSelector;
        if (useSSL) {
            this.sslContext = JeusSSLConfiguration.sslContext;
        }
    }

    public void init(String name, int port, WebContentHandlerCreator webContentHandlerCreator) throws IOException {
        if (port <= 0 || port > 65535) {
            IOException ie = new IOException("accept port is not valid");
            if (logger.isLoggable(JeusMessage_WebContainer10._10207_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10207_LEVEL, JeusMessage_WebContainer10._10207, new Object[]{name, String.valueOf(port)});
            }
            throw ie;
        }
        if (webContentHandlerCreator == null) {
            IOException ie = new IOException("WebContentHandlerCreator must be initialized");
            if (logger.isLoggable(JeusMessage_WebContainer10._10207_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10207_LEVEL, JeusMessage_WebContainer10._10207, new Object[]{name, String.valueOf(port)});
            }
            throw ie;
        }
        this.webContentHandlerCreator = webContentHandlerCreator;
        if (logger.isLoggable(JeusMessage_WebContainer10._10208_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10208_LEVEL, JeusMessage_WebContainer10._10208, new Object[]{name, String.valueOf(port)});
        }
        if (this.jeusConnector == null) {
            this.jeusConnector = new ChannelConnector();
            this.jeusConnector.setTimeout(this.connectionTimeout);
        }
        if (this.connector instanceof TMAXWebConnector) {
            String host = this.connector.getConnectionDescriptor().getWebServerAddress();
            for (int i = 0; i < this.connector.getMinWorkerThreads(); ++i) {
                int clhPort = ((TMAXWebConnector)this.connector).getPort();
                Socket socket = this.connectOnly(host, clhPort, this.connectionTimeout, this.readTimeout);
                if (((TMAXWebConnector)this.connector).isOutChannel()) {
                    ((TMAXWebConnector)this.connector).registerCLH(i + this.connector.getMinWorkerThreads(), socket);
                } else {
                    ((TMAXWebConnector)this.connector).registerCLH(i, socket);
                }
                this.onSocket(socket);
            }
        }
    }

    public Socket connectOnly(String host, int port, int connectionTimeout, int readTimeout) {
        Socket socket = null;
        try {
            socket = this.jeusConnector.connect(host, port, null, connectionTimeout, readTimeout);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return socket;
    }

    public boolean connect(String host, int port, int connectionTimeout, int readTimeout) {
        Socket socket = null;
        try {
            socket = this.jeusConnector.connect(host, port, null, connectionTimeout, readTimeout);
            this.onSocket(socket);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public synchronized void onSocket(Socket socket) {
        block11: {
            if (this.destroyed) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10209_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10209_LEVEL, JeusMessage_WebContainer10._10209, (Object)socket);
                }
                return;
            }
            try {
                if (logger.isLoggable(JeusMessage_WebContainer10._10210_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10210_LEVEL, JeusMessage_WebContainer10._10210, (Object)socket);
                }
                socket.setSoLinger(false, 0);
                if (logger.isLoggable(JeusMessage_WebContainer10._10211_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10211_LEVEL, JeusMessage_WebContainer10._10211, (Object)socket);
                }
                WebStreamContentReceiver contentReceiver = new WebStreamContentReceiver(this.connector);
                if (this.sslContext != null) {
                    IOComponentCreator.setSSLInfo((SSLContext)this.sslContext, (Map)sslProperty, (StreamContentHandlerCreator)this.webContentHandlerCreator);
                }
                if (logger.isLoggable(JeusMessage_WebContainer10._10212_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10212_LEVEL, JeusMessage_WebContainer10._10212, (Object)socket);
                }
                if (this.webContentHandlerCreator == null) {
                    IOException ie = new IOException("content handler creator must be initialized.");
                    if (logger.isLoggable(JeusMessage_WebContainer10._10213_LEVEL)) {
                        logger.log(JeusMessage_WebContainer10._10213_LEVEL, JeusMessage_WebContainer10._10213, (Object)socket, (Throwable)ie);
                    }
                    throw ie;
                }
                NIOStreamHandlerImpl handler = new NIOStreamHandlerImpl((StreamContentReceiver)contentReceiver, (StreamContentHandlerCreator)this.webContentHandlerCreator, JeusNetProperties.WRITE_LIMIT, JeusNetProperties.WRITE_RESTART, JeusNetProperties.WRITE_REPEAT_COUNT);
                handler.setSocket(socket);
                if (logger.isLoggable(JeusMessage_WebContainer10._10214_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10214_LEVEL, JeusMessage_WebContainer10._10214, new Object[]{handler, this.jeusSelector});
                }
                this.jeusSelector.addSelectItem((StreamHandler)handler);
                this.connector.addHandlerList((StreamHandler)handler);
                this.connector.incrementTotalAcceptCount();
            }
            catch (IOException e) {
                if (!logger.isLoggable(JeusMessage_WebContainer10._10215_LEVEL)) break block11;
                logger.log(JeusMessage_WebContainer10._10215_LEVEL, JeusMessage_WebContainer10._10215, (Object)socket, (Throwable)e);
            }
        }
    }

    public synchronized void destroy() {
        if (logger.isLoggable(JeusMessage_WebContainer10._10216_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10216_LEVEL, JeusMessage_WebContainer10._10216, (Object)String.valueOf(this.getServerSocketPort()));
        }
        this.destroyed = true;
        this.connector = null;
        this.sslContext = null;
        this.jeusSelector = null;
        this.webContentHandlerCreator = null;
    }

    public int getServerSocketPort() {
        return -1;
    }

    static {
        sslProperty.put("useClientMode", Boolean.FALSE);
        sslProperty.put("needClientAuth", Boolean.TRUE);
    }
}

