/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import jeus.servlet.connector.pipeline.LinkedThreadPoolExecutorPipeline;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;

public final class Constants {
    public static final int INVALID_PORT = -1;
    public static final int PROCESSOR_TASK_NUM = 1;
    public static final int RELOAD_CHECK_SLEEP_TIME = 1000;
    public static final int DEFAULT_MAX_THREAD_NUM = 20;
    public static final int DEFAULT_MIN_THREAD_NUM = 10;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 4096;
    public static final int DEFAULT_THREAD_INCREMENT = 1;
    public static final int DEFAULT_LISTEN_PORT = 8080;
    public static final int DEFAULT_THREAD_PRIORITY = 5;
    public static final long DEFAULT_THREAD_TIMEOUT = 3000L;
    public static final String DEFAULT_PIPELINE_CLASS_NAME = LinkedThreadPoolExecutorPipeline.class.getName();
    public static final int REQUEST_STEP_NEW = 0;
    public static final int REQUEST_STEP_PARSE = 1;
    public static final int REQUEST_STEP_PREPARE = 2;
    public static final int REQUEST_STEP_FILTER_SOCKET = 3;
    public static final int REQUEST_STEP_CHECK_RELOAD = 4;
    public static final int REQUEST_STEP_GET_WRAPPER = 5;
    public static final int REQUEST_STEP_PREPARE_DATASOURCE_CONNECTIONS = 6;
    public static final int REQUEST_STEP_SERVICE = 7;
    public static final int REQUEST_STEP_UPDATE_STATISTIC = 8;
    public static final int REQUEST_STEP_POST_SESSION = 9;
    public static final int REQUEST_STEP_REQUEST_FINISH = 10;
    public static final int REQUEST_STEP_RESPONSE_FINISH = 11;
    public static final int REQUEST_STEP_WRITE_ACCESSLOG = 12;
    public static final int REQUEST_STEP_FINISH_CHECKING_RELOADING = 13;
    public static final int REQUEST_STEP_REQUEST_CLEARING = 14;
    public static final int REQUEST_STEP_RESPONSE_CLEARING = 15;
    public static final int REQUEST_STEP_ROLLBACK_TRANSACTION = 16;
    public static final int REQUEST_STEP_CLEANUP_DATASOURCE_CONNECTIONS = 17;
    public static final int REQUEST_STEP_CLEANUP_USERWORKAREA = 18;
    public static final int REQUEST_STEP_ENDED = 19;
    public static final int READ_MESSAGE_BLOCK_SIZE = 8192;
    public static final int FILE_SAVING_ADAPTOR_WRITE_BLOCK_SIZE;
    public static final int FILE_SAVING_ADAPTOR_WRITE_BLOCK_SIZE_DEFAULT = 65536;
    public static final String DEFAULT_FILE_PREFIX = "servletmsg";
    public static final String DEFAULT_FILE_SUFFIX = ".tmp";
    public static final int FILE_PERSISTENT_MESSAGE_LOWER_BOUND;
    public static final int FILE_PERSISTENT_MESSAGE_LOWER_BOUND_DEFAULT = 0x4000000;
    public static final String FILE_PERSISTENT_MESSAGE_TEMP_DIRECTORY;

    static int getByteSizePropertyValue(String value, int defaultValue) {
        if (value != null) {
            int temp;
            try {
                if (value.endsWith("m") || value.endsWith("M")) {
                    value = value.substring(0, value.length() - 1);
                    temp = Integer.parseInt(value) * 1024 * 1024;
                } else if (value.endsWith("k") || value.endsWith("K")) {
                    value = value.substring(0, value.length() - 1);
                    temp = Integer.parseInt(value) * 1024;
                } else {
                    temp = Integer.parseInt(value);
                }
            }
            catch (NumberFormatException nfe) {
                temp = defaultValue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                temp = defaultValue;
            }
            return temp;
        }
        return defaultValue;
    }

    static {
        WebProperties props = PropertyUtil.getContainerProperties();
        FILE_PERSISTENT_MESSAGE_LOWER_BOUND = Constants.getByteSizePropertyValue(props.FILE_PERSISTENT_MESSAGE_LOWER_BOUND.value, 0x4000000);
        FILE_PERSISTENT_MESSAGE_TEMP_DIRECTORY = props.FILE_PERSISTENT_MESSAGE_TEMP_DIRECTORY.value;
        int blockSize = Constants.getByteSizePropertyValue(props.FILE_SAVING_ADAPTOR_WRITE_BLOCK_SIZE.value, 65536);
        if (blockSize < 65536) {
            blockSize = 65536;
        }
        FILE_SAVING_ADAPTOR_WRITE_BLOCK_SIZE = blockSize;
    }
}

