/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import jeus.servlet.connector.PassiveWebConnector;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.WebConnectorException;
import jeus.servlet.connector.protocol.http.HTTPProcessorTask;
import jeus.servlet.connector.protocol.http.HTTPWebContentHandlerCreator;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.util.JeusRootClassLoader;
import jeus.util.message.JeusMessage_WebContainer10;

public class HTTPWebConnector
extends PassiveWebConnector {
    private ClassLoader classLoader = JeusRootClassLoader.loader;

    public HTTPWebConnector(ContextGroup contextGroup, ConnectionDescriptor connDesc) throws WebConnectorException {
        super(contextGroup, connDesc);
        String dispatcherConfigClass = connDesc.getDispatcherConfigClass();
        if (dispatcherConfigClass == null) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10200_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10200_LEVEL, JeusMessage_WebContainer10._10200, (Object)this.name);
            }
            return;
        }
    }

    public void initialize() throws StartingException {
        try {
            this.setPersistentConnection();
            this.webContentHandlerCreator = new HTTPWebContentHandlerCreator(this, null, null);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10202_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10202_LEVEL, JeusMessage_WebContainer10._10202, (Object)this.name, t);
            }
            throw new StartingException(t);
        }
    }

    public void destroy() {
        if (this.webContentHandlerCreator != null) {
            this.webContentHandlerCreator.destroy();
            this.webContentHandlerCreator = null;
        }
    }

    public ProcessorTask newProcessorTask() {
        return new HTTPProcessorTask();
    }
}

