/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.protocol.http.HTTPWebStreamContentReader;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.io.BufferedOutputAdaptor;
import jeus.util.message.JeusMessage_WebContainer2;

public class NIOBufferedOutputAdaptor
extends BufferedOutputAdaptor {
    public NIOBufferedOutputAdaptor(NIOWebServerOutputStream nioWebServerOutputStream, byte[] httpHeader, byte[] httpBody) {
        super(null, nioWebServerOutputStream, httpHeader, httpBody);
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        boolean flushed = false;
        HttpServletRequestImpl request = this.webServer.getRequest();
        if (request.isBlockingMode()) {
            while (!((HTTPWebStreamContentReader)this.streamHandler.getContentReader()).isBlockingEnabled()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                int contLen = this.bufferCount - this.webServerHeaderSize;
                if (!forced && !last && contLen < 0) {
                    return false;
                }
                if (!this.committed) {
                    this.writeHeader();
                    this.webServer.setWebServerHeader(last, contLen + this.headerCount, 0, this.httpHeader);
                    this.out.write(this.httpHeader, 0, this.headerCount);
                    if (contLen > 0) {
                        this.out.write(this.httpBody, this.webServerHeaderSize, contLen);
                    }
                    this.out.flush();
                    this.committed = true;
                    flushed = true;
                    if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                    }
                } else if (last || contLen >= 0) {
                    this.webServer.setWebServerHeader(last, this.bufferCount, 0, this.httpBody);
                    this.out.write(this.httpBody, 0, this.bufferCount);
                    this.out.flush();
                    flushed = true;
                }
                if (flushed) {
                    this.bufferCount = this.webServerHeaderSize;
                }
            }
            catch (IOException ioe) {
                this.committed = false;
                this.reset();
                throw ioe;
            }
            if (last) {
                try {
                    this.streamHandler.register();
                    HTTPWebStreamContentReader contentReader = (HTTPWebStreamContentReader)this.streamHandler.getContentReader();
                    contentReader.setBlockingEnabled(false);
                    contentReader.setProcessing(false);
                    this.streamHandler.close(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return flushed;
        }
        try {
            int contLen = this.bufferCount - this.webServerHeaderSize;
            if (!forced && !last && contLen <= 0) {
                return false;
            }
            int writeTotalSize = 0;
            ByteBuffer buffer = null;
            if (!this.committed) {
                this.writeHeader();
                this.webServer.setWebServerHeader(last, contLen + this.headerCount, 0, this.httpHeader);
                writeTotalSize = this.headerCount;
                if (contLen > 0) {
                    buffer = this.streamHandler.createByteBuffer(writeTotalSize += contLen);
                    buffer.put(this.httpHeader, 0, this.headerCount);
                    buffer.put(this.httpBody, this.webServerHeaderSize, contLen);
                } else {
                    buffer = this.streamHandler.createByteBuffer(writeTotalSize);
                    buffer.put(this.httpHeader, 0, this.headerCount);
                }
                this.streamHandler.write(buffer);
                this.committed = true;
                flushed = true;
            } else if (last || contLen > 0) {
                this.webServer.setWebServerHeader(last, this.bufferCount, 0, this.httpBody);
                writeTotalSize = this.bufferCount;
                buffer = this.streamHandler.createByteBuffer(writeTotalSize);
                buffer.put(this.httpBody, 0, this.bufferCount);
                this.streamHandler.write(buffer);
                flushed = true;
            }
            if (flushed) {
                this.bufferCount = this.webServerHeaderSize;
            }
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        if (last) {
            try {
                HTTPWebStreamContentReader contentReader = (HTTPWebStreamContentReader)this.streamHandler.getContentReader();
                contentReader.setProcessing(false);
                ((NIOStreamHandlerImpl)this.streamHandler).addEventOp(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flushed;
    }
}

