/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.OutputStream;
import jeus.servlet.connector.NIOFullBufferedOutputAdaptor;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.protocol.tmax.TMAXOutputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer4;

public class NIOTmaxOutputAdaptor
extends NIOFullBufferedOutputAdaptor {
    private TMAXOutputStream tmaxOutputStream;

    public NIOTmaxOutputAdaptor(OutputStream out, NIOWebServerOutputStream webServer, byte[] header, byte[] body) {
        super(webServer, header, body);
        this.tmaxOutputStream = (TMAXOutputStream)webServer;
        this.bufferCount = 0;
    }

    public void setBodyBuffer(byte[] body) {
        this.httpBody = body;
        this.bufferSize = body.length;
        this.headerCount = this.webServerHeaderSize = this.webServer.getWebServerHeaderSize();
        this.bufferCount = 0;
    }

    protected void writeHeader() {
        this.webServerHeaderSize = this.webServer.getWebServerHeaderSize();
        if (logger.isLoggable(JeusMessage_WebContainer4._4401_LEVEL)) {
            logger.log(JeusMessage_WebContainer4._4401_LEVEL, JeusMessage_WebContainer4._4401, (Object)String.valueOf(this.webServerHeaderSize));
        }
        if (this.headerCount > this.webServerHeaderSize) {
            return;
        }
        byte[] metadata = this.tmaxOutputStream.getWebServerSpecificBody();
        if (metadata != null) {
            if (logger.isLoggable(JeusMessage_WebContainer4._4402_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4402_LEVEL, JeusMessage_WebContainer4._4402, (Object)String.valueOf(metadata.length));
            }
            if (this.httpHeader.length - this.webServerHeaderSize < metadata.length) {
                this.httpHeader = this.webServer.resizeHttpHeader(1024 + metadata.length + this.httpHeader.length);
            }
            this.headerCount = this.webServerHeaderSize;
            System.arraycopy(metadata, 0, this.httpHeader, this.headerCount, metadata.length);
            this.headerCount += metadata.length;
            return;
        }
    }

    protected void writeContentLength() {
    }

    public void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)2452));
        }
        this.webServerHeaderSize = this.webServer.getWebServerHeaderSize();
        this.bufferCount = 0;
        this.headerCount = this.webServerHeaderSize;
    }
}

