/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.StreamHandlerImpl14;
import jeus.servlet.connector.NIOBufferedOutputAdaptor;
import jeus.servlet.connector.NIOChunkedOutputAdaptor;
import jeus.servlet.connector.NIOFullBufferedOutputAdaptor;
import jeus.servlet.connector.NIOHeadOutputAdaptor;
import jeus.servlet.connector.NIOHttp09OutputAdaptor;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public abstract class NIOWebServerOutputStream
extends WebServerOutputStream {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    protected StreamHandlerImpl14 streamHandler;

    protected NIOWebServerOutputStream(int bufsize) {
        super(null, bufsize);
        this.initializeAdaptor();
    }

    protected void initializeAdaptor() {
        this.chunkedAdaptor = new NIOChunkedOutputAdaptor(this, this.httpHeader, this.httpBody);
        this.bufferedAdaptor = new NIOBufferedOutputAdaptor(this, this.httpHeader, this.httpBody);
        this.fullBufferedAdaptor = new NIOFullBufferedOutputAdaptor(this, this.httpHeader, this.httpBody);
        this.headAdaptor = new NIOHeadOutputAdaptor(this, this.httpHeader, this.httpBody);
        this.http09Adaptor = new NIOHttp09OutputAdaptor(this, this.httpHeader, this.httpBody);
    }

    public void selectOutputAdaptor() throws IOException {
        super.selectOutputAdaptor();
        this.adaptor.setStreamHandlerImpl((StreamHandlerImpl)this.streamHandler);
    }

    public void setStreamHandler(StreamHandlerImpl streamHandler) {
        this.streamHandler = (StreamHandlerImpl14)streamHandler;
    }

    public StreamHandlerImpl getStreamHandler() {
        return this.streamHandler;
    }

    public void finish() {
        super.finish();
        this.streamHandler = null;
    }

    public void sendUrgentMessage() {
        block4: {
            if (this.urgentMessage == null || this.streamHandler == null) {
                return;
            }
            int msgLength = this.urgentMessage.length;
            if (msgLength > 0) {
                try {
                    ByteBuffer buffer = this.streamHandler.createByteBuffer(msgLength);
                    buffer.put(this.urgentMessage, 0, msgLength);
                    this.streamHandler.write(buffer);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_WebContainer10._10206_LEVEL)) break block4;
                    logger.log(JeusMessage_WebContainer10._10206_LEVEL, JeusMessage_WebContainer10._10206, (Object)this.streamHandler.toString(), t);
                }
            }
        }
        this.urgentMessage = null;
    }
}

