/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import jeus.servlet.connector.Acceptor;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.WebConnectorException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;

public abstract class PassiveWebConnector
extends WebConnector {
    protected Acceptor acceptor;

    public PassiveWebConnector(ContextGroup contextGroup, ConnectionDescriptor connDesc) throws WebConnectorException {
        this(contextGroup, connDesc, true);
    }

    public PassiveWebConnector(ContextGroup contextGroup, ConnectionDescriptor connDesc, boolean createAcceptor) throws WebConnectorException {
        super(contextGroup, connDesc);
        if (createAcceptor && this.acceptor == null) {
            this.acceptor = new Acceptor(this, this.jeusSelector, connDesc.isEnableSecure());
        }
    }

    protected void export() throws IOException {
        super.export();
        if (this.acceptor != null) {
            this.acceptor.init(this.name + "-Acceptor", this.port, this.webContentHandlerCreator, this.getConnectionDescriptor().getBacklog());
        }
    }

    protected void unexport() {
        if (this.acceptor != null) {
            this.acceptor.destroy();
            this.acceptor = null;
        }
        super.unexport();
    }

    public int getServerSocketPort() {
        if (this.acceptor != null) {
            return this.acceptor.getServerSocketPort();
        }
        return -1;
    }
}

