/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import jeus.io.Selector;
import jeus.io.handler.StreamHandler;
import jeus.io.helper.IOComponentCreator;
import jeus.servlet.connection.JSSEKeyManager;
import jeus.servlet.connector.CancelThreadException;
import jeus.servlet.connector.Constants;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.Task;
import jeus.servlet.connector.WebConnectionListener;
import jeus.servlet.connector.WebConnectorException;
import jeus.servlet.connector.WebContentHandlerCreator;
import jeus.servlet.connector.WebThreadPoolManager;
import jeus.servlet.connector.pipeline.LinkedThreadPoolExecutorPipeline;
import jeus.servlet.connector.pipeline.Pipeline;
import jeus.servlet.connector.pipeline.PipelineStatistic;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ThreadPoolDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.tcp.ConnectionHandshaker;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public abstract class WebConnector {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    private String pipelineClassName = Constants.DEFAULT_PIPELINE_CLASS_NAME;
    private int maxQueueSize = 4096;
    private int maxWorkerThreads = 20;
    private int minWorkerThreads = 10;
    private long threadsTimeout = 3000L;
    private int threadsIncrement = 1;
    private ConcurrentLinkedQueue processorTasks = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue activeProcessorTasks = new ConcurrentLinkedQueue();
    private boolean persistentConnection = true;
    protected String name;
    protected Selector jeusSelector;
    protected int port = -1;
    protected Pipeline processorPipeline;
    protected PipelineStatistic pipelineStat;
    protected WebContentHandlerCreator webContentHandlerCreator;
    protected ContextGroup contextGroup;
    private WebThreadPoolManager threadPoolManager;
    private ConnectionDescriptor connDesc;
    protected ConnectionHandshaker handshaker;
    protected WebConnectionListener connectionListener;
    protected Map connectionContextMap = new HashMap();
    private boolean initialized;
    private String[] enabledCiphers;
    private boolean clientAuth = false;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;
    private static String defaultKeystoreType = "JKS";
    protected static final String DEFAULT_PROTOCOL = "TLS";
    private SSLContext context;
    protected ArrayList handlerList = new ArrayList();

    public WebConnector() {
    }

    public WebConnector(ContextGroup contextGroup, ConnectionDescriptor connDesc) throws WebConnectorException {
        this(contextGroup, connDesc, "");
    }

    public WebConnector(ContextGroup contextGroup, ConnectionDescriptor connDesc, String postFix) throws WebConnectorException {
        String connListenerClassName;
        this.connDesc = connDesc;
        if (connDesc == null) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10220_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10220_LEVEL, JeusMessage_WebContainer10._10220);
            }
            return;
        }
        this.port = connDesc.getPort();
        this.name = connDesc.getListenerId() + "(" + this.port + ")";
        this.setPersistentConnection();
        ThreadPoolDescriptor poolDesc = connDesc.getThreadPoolDescriptor();
        if (poolDesc != null) {
            this.maxWorkerThreads = poolDesc.getMaxThreadNum();
            this.minWorkerThreads = poolDesc.getMinThreadNum();
            this.maxQueueSize = poolDesc.getMaxQueue();
            this.threadsIncrement = poolDesc.getChangingRate();
            this.threadsTimeout = poolDesc.getMaxIdleTime();
        }
        if (connDesc.isEnableSecure()) {
            try {
                String clientAuthStr = connDesc.getClientAuth();
                if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                    this.requireClientAuth = true;
                } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                    this.wantClientAuth = true;
                }
                String protocol = connDesc.getSslProtocol();
                if (protocol == null) {
                    protocol = DEFAULT_PROTOCOL;
                }
                this.context = SSLContext.getInstance(protocol);
                this.context.init(this.getKeyManagers(connDesc.getKeyStoreType(), connDesc.getKeyManagementAlgorithm(), connDesc.getKeyStoreFile(), connDesc.getKeyStorePass(), connDesc.getKeyAlias(), connDesc.getKeypassword()), this.getTrustManagers(connDesc.getTrustStoreType(), connDesc.getTrustManagementAlgorithm(), connDesc.getTrustStoreFile(), connDesc.getTrustStorePass()), new SecureRandom());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new WebConnectorException(e.getMessage());
            }
        }
        if ((connListenerClassName = connDesc.getConnectionListenerClass()) != null) {
            try {
                Class<?> klass = JeusRootClassLoader.loader.loadClass(connListenerClassName);
                this.connectionListener = (WebConnectionListener)klass.newInstance();
            }
            catch (Throwable t) {
                throw new WebConnectorException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10233, (Object[])new Object[]{this.name, connListenerClassName}), t);
            }
        }
        this.contextGroup = contextGroup;
        this.threadPoolManager = new WebThreadPoolManager(this, contextGroup, connDesc);
        this.pipelineStat = new PipelineStatistic(this.port, this.threadPoolManager.getThreadPoolId() + postFix);
        try {
            this.initPipeline();
        }
        catch (IOException ie) {
            throw new WebConnectorException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10221, (Object)(this.name + postFix)), ie);
        }
        int selectorNum = 1;
        String num = connDesc.getSelectorCount();
        if (num != null) {
            try {
                selectorNum = Integer.parseInt(num);
            }
            catch (Exception e) {
                selectorNum = 1;
            }
        }
        IOComponentCreator creator = new IOComponentCreator(1, this.name + postFix, 0);
        if (this.jeusSelector == null) {
            this.jeusSelector = creator.createSelector(this.name + postFix + "-Selector", selectorNum, false);
        }
        if (logger.isLoggable(JeusMessage_WebContainer10._10222_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10222_LEVEL, JeusMessage_WebContainer10._10222, (Object)this.name);
        }
    }

    public void init() throws StartingException {
        this.initialize();
        for (int i = 0; i < this.maxWorkerThreads; ++i) {
            ProcessorTask task = this.newProcessorTask();
            task.setConnector(this);
            task.init(this.contextGroup, this.threadPoolManager);
            task.setPipeline(this.processorPipeline);
            this.processorTasks.offer(task);
        }
        try {
            this.export();
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10223_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10223_LEVEL, JeusMessage_WebContainer10._10223, (Object)this.name, (Throwable)e);
            }
            throw new StartingException(e);
        }
    }

    protected void export() throws IOException {
        if (logger.isLoggable(JeusMessage_WebContainer10._10224_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10224_LEVEL, JeusMessage_WebContainer10._10224, new Object[]{this.name, String.valueOf(this.port)});
        }
        if (this.pipelineStat != null) {
            this.pipelineStat.start();
        }
        this.startPipelines();
    }

    protected void unexport() {
        if (logger.isLoggable(JeusMessage_WebContainer10._10225_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10225_LEVEL, JeusMessage_WebContainer10._10225, new Object[]{this.name, String.valueOf(this.port)});
        }
        this.stopPipelines();
        if (this.pipelineStat != null) {
            this.pipelineStat.stop();
        }
    }

    public void finish() {
        this.unexport();
        Iterator iter = this.processorTasks.iterator();
        while (iter.hasNext()) {
            ProcessorTask task = (ProcessorTask)iter.next();
            task.setPipeline(null);
            task.setConnector(null);
            task.finish();
            iter.remove();
        }
        this.processorTasks.clear();
        this.destroy();
        if (this.jeusSelector != null) {
            this.jeusSelector.destroySelector();
            this.jeusSelector = null;
        }
        this.finishPipelines();
        if (this.pipelineStat != null) {
            this.pipelineStat.finish();
            this.pipelineStat = null;
        }
        if (this.threadPoolManager != null) {
            this.threadPoolManager.destroy();
            this.threadPoolManager = null;
        }
        this.contextGroup = null;
        this.port = -1;
        this.name = "";
    }

    private void initPipeline() throws IOException {
        if (this.processorPipeline == null) {
            this.processorPipeline = this.newPipeline("JeusWebProcessor", this.port, 10, this.maxWorkerThreads, this.minWorkerThreads, this.maxQueueSize, this.threadsIncrement, this.threadsTimeout, this.threadPoolManager.getThreadPoolId(), this.pipelineStat);
        }
        this.processorPipeline.initPipeline();
    }

    private Pipeline newPipeline(String name, int port, int priority, int maxThreads, int minThreads, int maxQueueSize, int threadsIncrement, long threadsTimeout, String threadPrefix, PipelineStatistic pipelineStat) {
        Class<?> className = null;
        Pipeline pipeline = null;
        try {
            className = Class.forName(this.pipelineClassName);
            pipeline = (Pipeline)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10226_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10226_LEVEL, JeusMessage_WebContainer10._10226, new Object[]{name, this.pipelineClassName});
            }
            pipeline = new LinkedThreadPoolExecutorPipeline();
        }
        catch (InstantiationException ex) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10227_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10227_LEVEL, JeusMessage_WebContainer10._10227, new Object[]{name, this.pipelineClassName});
            }
            pipeline = new LinkedThreadPoolExecutorPipeline();
        }
        catch (IllegalAccessException ex) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10227_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10227_LEVEL, JeusMessage_WebContainer10._10227, new Object[]{name, this.pipelineClassName});
            }
            pipeline = new LinkedThreadPoolExecutorPipeline();
        }
        if (logger.isLoggable(JeusMessage_WebContainer10._10228_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10228_LEVEL, JeusMessage_WebContainer10._10228, new Object[]{name, String.valueOf(port), pipeline.getClass().getName()});
        }
        if (pipelineStat != null) {
            pipeline.setPipelineStatistic(pipelineStat);
            pipelineStat.setProcessorPipeline(pipeline);
        }
        pipeline.setMaxThreads(maxThreads);
        pipeline.setMinThreads(minThreads);
        pipeline.setName(name);
        pipeline.setPort(port);
        pipeline.setPriority(priority);
        pipeline.setMaxQueueSize(maxQueueSize);
        pipeline.setThreadsIncrement(threadsIncrement);
        pipeline.setThreadsTimeout(threadsTimeout);
        pipeline.setThreadPrefix(threadPrefix);
        return pipeline;
    }

    private void startPipelines() {
        if (this.processorPipeline != null) {
            this.processorPipeline.startPipeline();
        }
    }

    private void stopPipelines() {
        if (this.processorPipeline != null) {
            this.processorPipeline.stopPipeline();
        }
    }

    private void finishPipelines() {
        if (this.processorPipeline != null) {
            this.processorPipeline.finishPipeline();
            this.processorPipeline = null;
        }
    }

    public ProcessorTask getProcessorTask() {
        ProcessorTask task = null;
        task = (ProcessorTask)this.processorTasks.poll();
        if (task == null) {
            task = this.newProcessorTask();
            task.setConnector(this);
            task.init(this.contextGroup, this.threadPoolManager);
            task.setPipeline(this.processorPipeline);
        }
        this.activeProcessorTasks.offer(task);
        return task;
    }

    public void returnTask(Task task) {
        if (task == null) {
            return;
        }
        switch (task.getType()) {
            case 1: {
                ProcessorTask processor = (ProcessorTask)task;
                this.activeProcessorTasks.remove(processor);
                this.processorTasks.offer(processor);
                break;
            }
        }
    }

    public void incrementTotalAcceptCount() {
        if (this.pipelineStat != null) {
            this.pipelineStat.incrementTotalAcceptCount();
        }
    }

    public boolean cancelThreadExecution(long cancelThreadID) {
        if (this.activeProcessorTasks.size() == 0) {
            return false;
        }
        for (Object obj : this.activeProcessorTasks) {
            ProcessorTask processorTask;
            long threadID;
            if (!(obj instanceof ProcessorTask) || (threadID = (processorTask = (ProcessorTask)obj).getRequestStatistic().getWorkerThreadID()) != cancelThreadID) continue;
            String message = "Request cancelled";
            processorTask.cancelTask(new CancelThreadException(message), message);
            if (logger.isLoggable(JeusMessage_WebContainer10._10229_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10229_LEVEL, JeusMessage_WebContainer10._10229, (Object)String.valueOf(threadID));
            }
            return processorTask.getPipeline().interruptThread(threadID);
        }
        return false;
    }

    public boolean cancelThreadExecution(String cancelThreadID) {
        if (this.activeProcessorTasks.size() == 0 || cancelThreadID == null) {
            return false;
        }
        for (Object obj : this.activeProcessorTasks) {
            ProcessorTask processorTask;
            String threadID;
            if (!(obj instanceof ProcessorTask) || !cancelThreadID.equals(threadID = (processorTask = (ProcessorTask)obj).getRequestStatistic().getStringWorkerThreadID())) continue;
            String message = "Request cancelled";
            processorTask.cancelTask(new CancelThreadException(message), message);
            if (logger.isLoggable(JeusMessage_WebContainer10._10229_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10229_LEVEL, JeusMessage_WebContainer10._10229, (Object)threadID);
            }
            return processorTask.getPipeline().interruptThread(threadID);
        }
        return false;
    }

    public ConcurrentLinkedQueue getActiveProcessorTasks() {
        return this.activeProcessorTasks;
    }

    public Pipeline getProcessorPipeline() {
        return this.processorPipeline;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }

    public WebThreadPoolManager getThreadPoolManager() {
        return this.threadPoolManager;
    }

    protected void setPersistentConnection() {
        this.persistentConnection = true;
    }

    protected void unsetPersistentConnection() {
        this.persistentConnection = false;
    }

    public boolean isPersistentConnection() {
        return this.persistentConnection;
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connDesc;
    }

    protected TrustManager[] getTrustManagers(String truststoreType, String algorithm, String path, String pass) throws Exception {
        String crlf = this.connDesc.getCrlFile();
        TrustManager[] tms = null;
        if (crlf == null) {
            KeyStore trustStore = this.getStore(truststoreType, path, pass);
            if (trustStore != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            }
            return tms;
        }
        KeyStore trustStore = this.getStore(truststoreType, path, pass);
        if (trustStore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
            CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
            tmf.init(mfp);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    private KeyManager[] getKeyManagers(String keystoreType, String algorithm, String path, String pass, String keyAlias, String keypass) throws Exception {
        KeyManager[] kms = null;
        KeyStore ks = this.getStore(keystoreType, path, pass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException("key alias is no entry. alias=" + keyAlias);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keypass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if (defaultKeystoreType.equals(keystoreType)) {
                keyAlias = keyAlias.toLowerCase();
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    private CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters params = null;
        if (!"PKIX".equalsIgnoreCase(algorithm)) {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        PKIXBuilderParameters xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        Collection crls = this.getCRLs(crlf);
        CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
        CertStore store = CertStore.getInstance("Collection", csp);
        xparams.addCertStore(store);
        xparams.setRevocationEnabled(true);
        params = xparams;
        return params;
    }

    private Collection getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlf);
            crls = cf.generateCRLs(is);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }

    protected KeyStore getStore(String type, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = KeyStore.getInstance(type);
            if (!"PKCS11".equalsIgnoreCase(type)) {
                istream = new FileInputStream(path);
            }
            ks.load(istream, pass.toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException("Exception trying to load keystore " + path + ": " + ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    public abstract ProcessorTask newProcessorTask();

    public abstract void initialize() throws StartingException;

    public abstract void destroy();

    public void addHandlerList(StreamHandler handler) {
        this.handlerList.add(handler);
    }

    public ArrayList getHandlerList() {
        return this.handlerList;
    }

    public int getMinWorkerThreads() {
        return this.minWorkerThreads;
    }

    public ConnectionHandshaker getHandshaker() {
        return this.handshaker;
    }

    public WebConnectionListener getConnectionListener() {
        if (this.connectionListener != null) {
            return this.connectionListener;
        }
        return null;
    }

    public Object getConnectionContext(Object key) {
        return this.connectionContextMap.get(key);
    }

    public Selector getJeusSelector() {
        return this.jeusSelector;
    }

    public SSLContext getSSLContext() {
        return this.context;
    }

    public boolean getClientAuth() {
        return this.wantClientAuth;
    }
}

