/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.pipeline;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import jeus.servlet.connector.MaxConnectionReachedException;
import jeus.servlet.connector.Task;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.pipeline.Pipeline;
import jeus.servlet.connector.pipeline.PipelineStatistic;
import jeus.servlet.connector.pipeline.WorkerThread;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public class LinkedListPipeline
extends LinkedList
implements Pipeline {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    private int maxThreads = 20;
    private int minThreads = 10;
    private int port = 8080;
    private int priority = 5;
    private int maxQueueSize = 4096;
    private int threadsIncrement = 1;
    private boolean isStarted = false;
    private int threadCount = 0;
    private int waitingThreads = 0;
    private String name;
    private WorkerThread[] workerThreads;
    private PipelineStatistic pipelineStat;
    private String threadPrefix;

    public void initPipeline() {
        if (this.minThreads > this.maxThreads) {
            this.minThreads = this.maxThreads;
        }
        this.workerThreads = new WorkerThread[this.maxThreads];
        this.increaseWorkerThread(this.minThreads, false);
    }

    public void startPipeline() {
        if (!this.isStarted) {
            for (int i = 0; i < this.minThreads; ++i) {
                this.workerThreads[i].start();
            }
            this.isStarted = true;
        }
    }

    public void stopPipeline() {
        if (!this.isStarted) {
            return;
        }
        if (this.workerThreads != null) {
            for (int i = 0; i < this.threadCount; ++i) {
                this.workerThreads[i].terminate();
            }
            this.threadCount = 0;
        }
        this.isStarted = false;
    }

    public void finishPipeline() {
        if (!this.isStarted) {
            this.workerThreads = null;
            this.pipelineStat = null;
        }
    }

    private void increaseWorkerThread(int increment, boolean startThread) {
        int currentCount = this.threadCount;
        int increaseCount = this.threadCount + increment;
        for (int i = currentCount; i < increaseCount; ++i) {
            WorkerThread workerThread = new WorkerThread(this, this.threadPrefix + "(" + this.port + ")-w" + i);
            workerThread.setPriority(this.priority);
            if (startThread) {
                workerThread.start();
            }
            this.workerThreads[i] = workerThread;
            ++this.threadCount;
            if (this.threadCount <= Integer.MAX_VALUE) continue;
            this.threadCount = 0;
        }
    }

    public boolean interruptThread(long threadID) {
        return false;
    }

    public boolean interruptThread(String threadID) {
        if (threadID == null) {
            return false;
        }
        ThreadGroup threadGroup = this.workerThreads[0].getThreadGroup();
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threadID.equals(threads[i].getName())) continue;
            try {
                threads[i].interrupt();
                if (logger.isLoggable(JeusMessage_WebContainer10._10003_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10003_LEVEL, JeusMessage_WebContainer10._10003, (Object)threadID);
                }
                return true;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void addTask(Task task) {
        if (this.pipelineStat != null) {
            this.pipelineStat.gather(this.size());
        }
        if (this.maxQueueSize >= 0 && this.size() >= this.maxQueueSize) {
            if (this.pipelineStat != null) {
                this.pipelineStat.gatherOverflow();
            }
            String message = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10001, (Object[])new Object[]{this.name, String.valueOf(this.maxQueueSize), String.valueOf(this.size())});
            MaxConnectionReachedException mcre = new MaxConnectionReachedException(message);
            if (logger.isLoggable(JeusMessage_WebContainer10._10400_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10400_LEVEL, JeusMessage_WebContainer10._10400, (Object)message);
            }
            task.cancelTask(mcre, message);
            WebConnector connector = task.getConnector();
            if (connector != null) {
                connector.returnTask(task);
            }
            return;
        }
        this.addLast(task);
        this.notify();
        if (this.threadCount < this.maxThreads && this.waitingThreads < this.minThreads) {
            int left = this.maxThreads - this.threadCount;
            if (this.threadsIncrement > left) {
                this.threadsIncrement = left;
            }
            this.increaseWorkerThread(this.threadsIncrement, true);
        }
    }

    public synchronized Task getTask() {
        if (this.isEmpty()) {
            try {
                ++this.waitingThreads;
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            --this.waitingThreads;
        }
        try {
            return (Task)this.removeFirst();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public int getWaitingThread() {
        return this.waitingThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getCurrentThreadCount() {
        return this.threadCount;
    }

    public int getCurrentThreadsBusy() {
        return this.threadCount - this.waitingThreads;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name + this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public String toString() {
        return "[name=" + this.name + ", maxThreads=" + this.maxThreads + ", minThreads=" + this.minThreads + ", increment=" + this.threadsIncrement + ", maxQueue=" + this.maxQueueSize + "]";
    }

    public void setThreadsIncrement(int threadsIncrement) {
        this.threadsIncrement = threadsIncrement;
    }

    public void setThreadsTimeout(long threadsTimeout) {
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        if (this.pipelineStat != null) {
            this.pipelineStat.setQueueSize(maxQueueSize);
        }
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setPipelineStatistic(PipelineStatistic pipelineStatistic) {
        this.pipelineStat = pipelineStatistic;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }

    public void setThreadPrefix(String threadPrefix) {
        this.threadPrefix = threadPrefix;
    }

    public int getTaskQueuedCount() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.size() - this.waitingThreads <= 0;
    }
}

