/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.pipeline;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jeus.servlet.connector.pipeline.JeusWebThreadFactory;
import jeus.servlet.connector.pipeline.Pipeline;

public class PipelineStatistic {
    private int maxQueueSize = -1;
    private boolean started = false;
    private long totalCount;
    private long peakCount;
    private long overflowCount;
    private ScheduledThreadPoolExecutor countAverageExecutor;
    private Statistic lastMinuteStat = new Statistic(60);
    private Statistic lastFiveMinuteStat = new Statistic(300);
    private Statistic lastFifteenMinuteStat = new Statistic(900);
    private static final Integer SECONDS_1MINUTE = new Integer(60);
    private static final Integer SECONDS_5MINUTE = new Integer(300);
    private static final Integer SECONDS_15MINUTE = new Integer(900);
    private ConcurrentHashMap stats = new ConcurrentHashMap();
    private Pipeline processorPipeline;
    private Future[] futures = new Future[3];
    private long totalAcceptCount;
    private AtomicLong queueWaitTime = new AtomicLong();
    private AtomicLong queueWaitCount = new AtomicLong();

    public PipelineStatistic(int port, String threadPrefix) {
        this.countAverageExecutor = new ScheduledThreadPoolExecutor(3, new JeusWebThreadFactory("JeusWebPipelineStat", port, 5, threadPrefix));
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.futures[0] = this.countAverageExecutor.scheduleAtFixedRate(this.lastMinuteStat, 1L, this.lastMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.futures[1] = this.countAverageExecutor.scheduleAtFixedRate(this.lastFiveMinuteStat, 1L, this.lastFiveMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.futures[2] = this.countAverageExecutor.scheduleAtFixedRate(this.lastFifteenMinuteStat, 1L, this.lastFifteenMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.stats.put(this.lastMinuteStat.getSecondsInt(), this.lastMinuteStat);
        this.stats.put(this.lastFiveMinuteStat.getSecondsInt(), this.lastFiveMinuteStat);
        this.stats.put(this.lastFifteenMinuteStat.getSecondsInt(), this.lastFifteenMinuteStat);
        this.started = true;
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        for (int i = 0; i < this.futures.length; ++i) {
            this.futures[i].cancel(true);
        }
        this.stats.clear();
        this.started = false;
    }

    public boolean gather(int queueLength) {
        if (this.maxQueueSize >= 0 && queueLength >= this.maxQueueSize) {
            return false;
        }
        if (queueLength > 0) {
            if (this.totalCount >= Integer.MAX_VALUE) {
                this.totalCount = 0L;
            }
            ++this.totalCount;
        }
        if ((long)queueLength > this.peakCount) {
            this.peakCount = queueLength;
        }
        return true;
    }

    public void gatherQueueWaitTime(long time) {
        if (this.queueWaitTime.get() > Integer.MAX_VALUE || this.queueWaitCount.get() > Integer.MAX_VALUE) {
            this.queueWaitTime.set(0L);
            this.queueWaitCount.set(0L);
            return;
        }
        this.queueWaitTime.addAndGet(time);
        this.queueWaitCount.incrementAndGet();
    }

    public void gatherOverflow() {
        if (this.overflowCount >= Integer.MAX_VALUE) {
            this.overflowCount = 0L;
        }
        ++this.overflowCount;
    }

    public double getQueueWaitTimeAverage() {
        long waitCount = this.queueWaitCount.get();
        long waitTime = this.queueWaitTime.get();
        if (waitCount == 0L || waitTime == 0L) {
            return 0.0;
        }
        return waitTime / waitCount;
    }

    public long getCountOverflows() {
        return this.overflowCount;
    }

    public long getPeakQueued() {
        return this.peakCount;
    }

    public int getMaxQueue() {
        return this.maxQueueSize;
    }

    public long getCountTotalConnections() {
        return this.totalAcceptCount;
    }

    public void setQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public long getRemainQueue() {
        if (this.maxQueueSize >= 0) {
            return this.maxQueueSize - this.getCountQueued();
        }
        return -1L;
    }

    public long getCountTotalQueued() {
        return this.totalCount;
    }

    public int getCountQueued() {
        int size = 0;
        if (this.processorPipeline != null) {
            size += this.processorPipeline.size();
        }
        return size;
    }

    public long getCountQueued1MinuteAverage() {
        return this.getCountAverage(SECONDS_1MINUTE);
    }

    public long getCountQueued5MinuteAverage() {
        return this.getCountAverage(SECONDS_5MINUTE);
    }

    public long getCountQueued15MinuteAverage() {
        return this.getCountAverage(SECONDS_15MINUTE);
    }

    public void incrementTotalAcceptCount() {
        if (this.totalAcceptCount >= Integer.MAX_VALUE) {
            this.totalAcceptCount = 0L;
        }
        ++this.totalAcceptCount;
    }

    public void setProcessorPipeline(Pipeline processorPipeline) {
        this.processorPipeline = processorPipeline;
    }

    private long getCountAverage(Integer seconds) {
        Statistic stat = null;
        Object obj = this.stats.get(seconds);
        if (obj instanceof Statistic) {
            stat = (Statistic)obj;
        }
        return stat == null ? 0L : stat.average();
    }

    public void finish() {
        this.processorPipeline = null;
    }

    public void clearStatistics() {
        this.totalAcceptCount = 0L;
        this.totalCount = 0L;
        this.peakCount = 0L;
        this.overflowCount = 0L;
        this.queueWaitTime.set(0L);
        this.queueWaitCount.set(0L);
        this.lastMinuteStat.clear();
        this.lastFiveMinuteStat.clear();
        this.lastFifteenMinuteStat.clear();
    }

    public String toString() {
        return new String("[total connection=" + this.getCountTotalConnections() + ", max=" + this.getMaxQueue() + ", current=" + this.getCountQueued() + ", remain=" + this.getRemainQueue() + ", peak=" + this.getPeakQueued() + ", total=" + this.getCountTotalQueued() + ", difference(1min)=" + this.getCountQueued1MinuteAverage() + ", difference(5min)= " + this.getCountQueued5MinuteAverage() + ", difference(15min)=" + this.getCountQueued15MinuteAverage() + ", overflows=" + this.getCountOverflows() + ", waitAverage=" + this.getQueueWaitTimeAverage() + "]");
    }

    class Statistic
    implements Runnable {
        long lastCount = 0L;
        long average = 0L;
        int seconds;
        Integer secondsInt;

        public Statistic(int seconds) {
            this.seconds = seconds;
            this.secondsInt = new Integer(seconds);
        }

        public void run() {
            this.average = PipelineStatistic.this.totalCount - this.lastCount;
            this.lastCount = PipelineStatistic.this.totalCount;
        }

        public long average() {
            return this.average;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public Integer getSecondsInt() {
            if (this.secondsInt == null) {
                this.secondsInt = new Integer(this.seconds);
            }
            return this.secondsInt;
        }

        public void clear() {
            this.lastCount = 0L;
            this.average = 0L;
        }
    }
}

