/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.tcp;

import jeus.servlet.connector.PassiveWebConnector;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.TcpAcceptor;
import jeus.servlet.connector.WebConnectorException;
import jeus.servlet.connector.protocol.tcp.TCPProcessorTask;
import jeus.servlet.connector.protocol.tcp.TCPWebContentHandlerCreator;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.tcp.ConnectionHandshaker;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.util.JeusRootClassLoader;
import jeus.util.message.JeusMessage_WebContainer10;

public class TCPWebConnector
extends PassiveWebConnector {
    private TCPDispatcherConfig dispatcherConfig;

    public TCPWebConnector(ContextGroup contextGroup, ConnectionDescriptor connDesc) throws WebConnectorException {
        super(contextGroup, connDesc, false);
        this.acceptor = new TcpAcceptor(this, this.jeusSelector, connDesc.isEnableSecure());
        ClassLoader classLoader = JeusRootClassLoader.loader;
        String dispatcherConfigClass = connDesc.getDispatcherConfigClass();
        if (dispatcherConfigClass == null) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10200_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10200_LEVEL, JeusMessage_WebContainer10._10200, (Object)this.name);
            }
            return;
        }
        try {
            Class<?> klass = classLoader.loadClass(dispatcherConfigClass);
            this.dispatcherConfig = (TCPDispatcherConfig)klass.newInstance();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10201_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10201_LEVEL, JeusMessage_WebContainer10._10201, new Object[]{this.name, dispatcherConfigClass}, t);
            }
            return;
        }
        String handshakerClass = connDesc.getConnectionHandshakerClass();
        if (handshakerClass != null) {
            try {
                Class<?> klass = classLoader.loadClass(handshakerClass);
                this.handshaker = (ConnectionHandshaker)klass.newInstance();
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10230_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10230_LEVEL, JeusMessage_WebContainer10._10230, new Object[]{this.name, dispatcherConfigClass}, t);
                }
                return;
            }
        }
    }

    public void initialize() throws StartingException {
        if (this.dispatcherConfig == null) {
            StartingException se = new StartingException("tcp dispatcher config class must be initialized");
            if (logger.isLoggable(JeusMessage_WebContainer10._10202_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10202_LEVEL, JeusMessage_WebContainer10._10202, (Object)this.name, (Throwable)((Object)se));
            }
            throw se;
        }
        try {
            this.dispatcherConfig.init();
            if (this.dispatcherConfig.isPersistentConnection()) {
                this.setPersistentConnection();
            } else {
                this.unsetPersistentConnection();
            }
            this.webContentHandlerCreator = new TCPWebContentHandlerCreator(null, this.dispatcherConfig);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10202_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10202_LEVEL, JeusMessage_WebContainer10._10202, (Object)this.name, t);
            }
            throw new StartingException(t);
        }
    }

    public void destroy() {
        if (this.webContentHandlerCreator != null) {
            this.webContentHandlerCreator.destroy();
            this.webContentHandlerCreator = null;
        }
        this.dispatcherConfig = null;
    }

    public ProcessorTask newProcessorTask() {
        return new TCPProcessorTask();
    }
}

