/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.tmax;

import java.io.IOException;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.protocol.tmax.TMAXMessage;
import jeus.servlet.connector.protocol.tmax.TMAXOutputStream;
import jeus.servlet.connector.protocol.tmax.TMAXServletRequestImpl;
import jeus.servlet.connector.protocol.tmax.TMAXServletResponseImpl;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.engine.io.TmaxHeaderVer4;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer10;

public class TMAXProcessorTask
extends ProcessorTask {
    TmaxHeader tmaxHeader = new TmaxHeaderVer4();

    protected HttpServletRequestImpl createRequest(ContextGroup contextGroup) {
        return new TMAXServletRequestImpl(contextGroup, null);
    }

    protected HttpServletResponseImpl createResponse(ContextGroup contextGroup, NIOWebServerOutputStream outputStream) {
        return new TMAXServletResponseImpl(contextGroup, outputStream);
    }

    protected NIOWebServerOutputStream createOutputStream(int bufferSize) {
        return new TMAXOutputStream(bufferSize);
    }

    protected void destroy() {
        ((TMAXServletRequestImpl)this.request).setWebConnector(null);
        ((TMAXServletResponseImpl)this.response).setWebConnector(null);
    }

    protected void initialize() {
        super.initialize();
        ((TMAXServletRequestImpl)this.request).setWebConnector(this.connector);
        ((TMAXServletResponseImpl)this.response).setWebConnector(this.connector);
    }

    protected void readRequest(Object message) throws IOException, InterruptedException {
        if (message == null || !(message instanceof TMAXMessage)) {
            IOException ie = new IOException("message type is not instance of TMAXMessage");
            if (logger.isLoggable(JeusMessage_WebContainer10._10122_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10122_LEVEL, JeusMessage_WebContainer10._10122, (Object)this.requestStatistic.getStringWorkerThreadID(), (Throwable)ie);
            }
            throw ie;
        }
        if (!(this.request instanceof TMAXServletRequestImpl)) {
            IOException ie = new IOException("request type is not instance of TMAXServletRequestImpl");
            if (logger.isLoggable(JeusMessage_WebContainer10._10122_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10122_LEVEL, JeusMessage_WebContainer10._10122, (Object)this.requestStatistic.getStringWorkerThreadID(), (Throwable)ie);
            }
            throw ie;
        }
        TMAXServletRequestImpl tmaxRequest = (TMAXServletRequestImpl)this.request;
        TMAXMessage tmaxMsg = (TMAXMessage)message;
        tmaxRequest.setHeaderLength(tmaxMsg.getHeaderLength());
        tmaxRequest.setHeader(tmaxMsg.getHeader());
        tmaxRequest.setBody(tmaxMsg.getBody());
        tmaxRequest.setContentLength(tmaxMsg.getContentLength());
        tmaxRequest.setContextPath(tmaxMsg.getContextPath());
        String servletPath = tmaxMsg.getServletPath();
        if (servletPath != null && !servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
        tmaxRequest.setServletPath(servletPath);
        String requestURI = tmaxMsg.getContextPath();
        if (servletPath != null && !servletPath.equals("/")) {
            requestURI = requestURI + servletPath;
        }
        if (tmaxMsg.getPathInfo() != null) {
            requestURI = requestURI + servletPath;
        }
        tmaxRequest.setPathInfo(tmaxMsg.getPathInfo());
        tmaxRequest.processCommonRequest(requestURI, null, null);
        if (logger.isLoggable(JeusMessage_WebContainer10._10401_LEVEL)) {
            StringBuffer buf = new StringBuffer();
            buf.append("\tcontext-path : " + tmaxRequest.getContextPath() + StringUtil.lineSeparator);
            buf.append("\tservlet-path : " + tmaxRequest.getServletPath() + StringUtil.lineSeparator);
            buf.append("\tpath-info    : " + tmaxRequest.getPathInfo() + StringUtil.lineSeparator);
            buf.append("\trequest-uri  : " + tmaxRequest.getRequestURI() + StringUtil.lineSeparator);
            buf.append("\tcontent-len  : " + tmaxRequest.getContentLength() + StringUtil.lineSeparator);
            logger.log(JeusMessage_WebContainer10._10401_LEVEL, JeusMessage_WebContainer10._10401, (Object)buf.toString());
        }
        tmaxRequest.readRequest0(this.getStreamHandlerImpl());
    }
}

