/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.tmax;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Vector;
import javax.transaction.xa.XAResource;
import jeus.io.impl.StreamHandlerImpl14;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.servlet.connector.ActiveWebConnector;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.WebConnectorException;
import jeus.servlet.connector.protocol.tmax.TMAXProcessorTask;
import jeus.servlet.connector.protocol.tmax.TMAXWebConnectorManager;
import jeus.servlet.connector.protocol.tmax.TMAXWebContentHandlerCreator;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.TmaxThreadPoolManager;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.engine.io.TmaxHeaderVer4;
import jeus.servlet.engine.io.TmaxUtil;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.util.message.JeusMessage_WebContainer10;
import jeus.util.message.JeusMessage_WebContainer2;

public class TMAXWebConnector
extends ActiveWebConnector {
    private TCPDispatcherConfig dispatcherConfig;
    protected static int RECONNECT_INTERVAL = 5000;
    private static String DEFAULT_RECONNECT_TIMEOUT = "120000";
    TMAXWebConnector pair;
    private int spri;
    private int clhCount;
    private int cpcCount;
    private int clhPort;
    private int procType;
    private int clid;
    private int domainid;
    private XAResource xar;
    private TmaxThreadPoolManager[] poolManager;
    private Vector addedPools = new Vector();
    private Object lock = new Object();
    private boolean running = false;
    private boolean reconnecting = false;
    private Thread thread = null;
    private ConnectionDescriptor backupDesc;
    private ConnectionDescriptor connDesc;
    private boolean isBackup = false;
    private boolean httpGW = false;
    private String recoverConnector = null;
    private TMAXWebConnectorManager connectorManager;
    private boolean processingCreatePool = false;
    private boolean tms;
    private String serverGroupName;
    private boolean outChannel = false;

    public TMAXWebConnector(ContextGroup contextGroup, TMAXWebConnectorManager connectorManager, ConnectionDescriptor desc, int clhId, String postFix) throws WebConnectorException {
        super(contextGroup, desc, postFix);
        this.connectorManager = connectorManager;
        this.clhPort = connectorManager.getClhPort(clhId);
        this.port = connectorManager.getClhPort(clhId);
        this.dispatcherConfig = connectorManager.getDispatcherConfig();
        this.tms = false;
        this.serverGroupName = null;
        if (desc.getServerType() != null && desc.getServerType().equalsIgnoreCase("tms")) {
            this.tms = true;
        }
        this.serverGroupName = desc.getServerGroupName();
    }

    public void initialize() throws StartingException {
        if (this.dispatcherConfig == null) {
            StartingException se = new StartingException("tmax dispatcher config class must be initialized");
            if (logger.isLoggable(JeusMessage_WebContainer10._10202_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10202_LEVEL, JeusMessage_WebContainer10._10202, (Object)this.name, (Throwable)((Object)se));
            }
            throw se;
        }
        try {
            this.dispatcherConfig.init();
            if (this.dispatcherConfig.isPersistentConnection()) {
                this.setPersistentConnection();
            } else {
                this.unsetPersistentConnection();
            }
            this.webContentHandlerCreator = new TMAXWebContentHandlerCreator(null, this.dispatcherConfig);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10202_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10202_LEVEL, JeusMessage_WebContainer10._10202, (Object)this.name, t);
            }
            throw new StartingException(t);
        }
    }

    public void destroy() {
        if (this.webContentHandlerCreator != null) {
            this.webContentHandlerCreator.destroy();
            this.webContentHandlerCreator = null;
        }
        this.dispatcherConfig = null;
    }

    public ProcessorTask newProcessorTask() {
        return new TMAXProcessorTask();
    }

    public ConnectionDescriptor getCurrentConnectionDescriptor() {
        if (this.isBackup) {
            return this.backupDesc;
        }
        return this.connDesc;
    }

    public void setPairConnector(TMAXWebConnector connector2) {
        this.pair = connector2;
    }

    public StreamHandlerImpl14 getPairStreamHandler() {
        int i = 0;
        ArrayList pairHandlerList = this.pair.getHandlerList();
        if (i < pairHandlerList.size()) {
            NIOStreamHandlerImpl streamHandler = (NIOStreamHandlerImpl)pairHandlerList.get(i);
            return streamHandler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket registerCLH(int cpcId, Socket socket) throws IOException {
        int msgtype;
        TmaxHeader tmaxHeader = TmaxHeaderVer4.getInstnace();
        SocketChannel channel = socket.getChannel();
        boolean isBlocking = channel.isBlocking();
        if (!isBlocking) {
            channel.configureBlocking(true);
        }
        byte[] header = TmaxUtil.makeHeader(tmaxHeader, 101);
        if (this.isTms()) {
            TmaxUtil.writeInt(header, 26, tmaxHeader.TYPE_OFFSET());
        } else {
            TmaxUtil.writeInt(header, 25, tmaxHeader.TYPE_OFFSET());
        }
        int spri = this.getSpri();
        TmaxUtil.writeInt(header, spri, tmaxHeader.SVCICD_OFFSET());
        TmaxUtil.writeInt(header, cpcId, tmaxHeader.ETC_OFFSET());
        String svgname = this.getServerGroupName();
        if (svgname != null) {
            TmaxUtil.writeString(tmaxHeader, header, svgname, tmaxHeader.SUBTYPE_OFFSET());
        }
        ByteBuffer headerByteBuffer = null;
        try {
            headerByteBuffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)header.length, (boolean)true);
            headerByteBuffer.put(header);
            headerByteBuffer.flip();
            channel.write(headerByteBuffer);
        }
        finally {
            if (headerByteBuffer != null) {
                ByteBufferCreator.freeByteBuffer((ByteBuffer)headerByteBuffer);
            }
        }
        byte[] reply = TmaxUtil.recvHeader(tmaxHeader, channel);
        if (!isBlocking) {
            channel.configureBlocking(false);
        }
        if ((msgtype = TmaxUtil.readInt(reply, tmaxHeader.MSGTYPE_OFFSET())) != 1101) {
            throw new IOException("clh_register : error replied : " + msgtype);
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3902_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3902_LEVEL, JeusMessage_WebContainer2._3902, (Object[])new String[]{this.name, String.valueOf(this.clhPort), String.valueOf(socket.getLocalPort())});
        }
        return socket;
    }

    public int getCpcCount() {
        return this.cpcCount;
    }

    public int getSpri() {
        return this.connectorManager.getSpri();
    }

    public int getClid() {
        return this.connectorManager.getClid();
    }

    public boolean isTms() {
        return this.tms;
    }

    public boolean isHttpGw() {
        return this.httpGW;
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isOutChannel() {
        return this.outChannel;
    }

    public void setOutChannel(boolean outChannel) {
        this.outChannel = outChannel;
    }

    public TMAXWebConnectorManager getConnectorManager() {
        return this.connectorManager;
    }
}

