/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import jeus.descriptor.tool.AuthConstraint;
import jeus.descriptor.tool.EJBReference;
import jeus.descriptor.tool.EnvironEntry;
import jeus.descriptor.tool.FormLoginConfig;
import jeus.descriptor.tool.LoginConfig;
import jeus.descriptor.tool.MessageDestinationReference;
import jeus.descriptor.tool.ResourceEnvironReference;
import jeus.descriptor.tool.ResourceReference;
import jeus.descriptor.tool.SecurityConstraint;
import jeus.descriptor.tool.SecurityRole;
import jeus.descriptor.tool.UserDataConstraint;
import jeus.descriptor.tool.WEBResource;
import jeus.servlet.deployment.ConfigConstants2;
import jeus.servlet.deployment.descriptor.WebCommonDescriptor;
import jeus.xml.binding.j2ee.AuthConstraintType;
import jeus.xml.binding.j2ee.AuthMethodType;
import jeus.xml.binding.j2ee.DescriptionType;
import jeus.xml.binding.j2ee.EjbLinkType;
import jeus.xml.binding.j2ee.EjbLocalRefType;
import jeus.xml.binding.j2ee.EjbRefNameType;
import jeus.xml.binding.j2ee.EjbRefType;
import jeus.xml.binding.j2ee.EjbRefTypeType;
import jeus.xml.binding.j2ee.EnvEntryType;
import jeus.xml.binding.j2ee.EnvEntryTypeValuesType;
import jeus.xml.binding.j2ee.ErrorCodeType;
import jeus.xml.binding.j2ee.ErrorPageType;
import jeus.xml.binding.j2ee.FormLoginConfigType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.HomeType;
import jeus.xml.binding.j2ee.JndiNameType;
import jeus.xml.binding.j2ee.LifecycleCallbackType;
import jeus.xml.binding.j2ee.LocalHomeType;
import jeus.xml.binding.j2ee.LocalType;
import jeus.xml.binding.j2ee.LoginConfigType;
import jeus.xml.binding.j2ee.MessageDestinationLinkType;
import jeus.xml.binding.j2ee.MessageDestinationRefType;
import jeus.xml.binding.j2ee.MessageDestinationTypeType;
import jeus.xml.binding.j2ee.MessageDestinationUsageType;
import jeus.xml.binding.j2ee.MimeMappingType;
import jeus.xml.binding.j2ee.MimeTypeType;
import jeus.xml.binding.j2ee.PathType;
import jeus.xml.binding.j2ee.PersistenceContextRefType;
import jeus.xml.binding.j2ee.PersistenceUnitRefType;
import jeus.xml.binding.j2ee.RemoteType;
import jeus.xml.binding.j2ee.ResAuthType;
import jeus.xml.binding.j2ee.ResSharingScopeType;
import jeus.xml.binding.j2ee.ResourceEnvRefType;
import jeus.xml.binding.j2ee.ResourceRefType;
import jeus.xml.binding.j2ee.RoleNameType;
import jeus.xml.binding.j2ee.SecurityConstraintType;
import jeus.xml.binding.j2ee.SecurityRoleType;
import jeus.xml.binding.j2ee.ServiceRefType;
import jeus.xml.binding.j2ee.SessionConfigType;
import jeus.xml.binding.j2ee.TaglibType;
import jeus.xml.binding.j2ee.TransportGuaranteeType;
import jeus.xml.binding.j2ee.UrlPatternType;
import jeus.xml.binding.j2ee.UserDataConstraintType;
import jeus.xml.binding.j2ee.WarPathType;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.j2ee.WebResourceCollectionType;
import jeus.xml.binding.j2ee.WelcomeFileListType;
import jeus.xml.binding.j2ee.XsdIntegerType;
import jeus.xml.binding.j2ee.XsdStringType;

public class WebCommonConfiguration
implements ConfigConstants2 {
    public static WebCommonDescriptor configWebCommon(WebAppType webApp) {
        WebCommonDescriptor webcommon = new WebCommonDescriptor();
        List descriptionAndDisplayNameAndIcon = webApp.getDescriptionAndDisplayNameAndIcon();
        ArrayList<SecurityRole> roles = new ArrayList<SecurityRole>();
        ArrayList<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
        ArrayList<EnvironEntry> envs = new ArrayList<EnvironEntry>();
        ArrayList<EJBReference> ejbEnvs = new ArrayList<EJBReference>();
        ArrayList<EJBReference> ejbLocalEnvs = new ArrayList<EJBReference>();
        ArrayList<ResourceReference> resRefs = new ArrayList<ResourceReference>();
        ArrayList<ResourceEnvironReference> resEnvRefs = new ArrayList<ResourceEnvironReference>();
        ArrayList<MessageDestinationReference> messageDestRefs = new ArrayList<MessageDestinationReference>();
        ArrayList<EnvEntryType> envEntryTypes = new ArrayList<EnvEntryType>();
        ArrayList<EjbRefType> ejbRefTypes = new ArrayList<EjbRefType>();
        ArrayList<EjbLocalRefType> ejbLocalRefTypes = new ArrayList<EjbLocalRefType>();
        ArrayList<ServiceRefType> serviceRefTypes = new ArrayList<ServiceRefType>();
        ArrayList<ResourceRefType> resourceRefTypes = new ArrayList<ResourceRefType>();
        ArrayList<ResourceEnvRefType> resourceEnvRefTypes = new ArrayList<ResourceEnvRefType>();
        ArrayList<MessageDestinationRefType> messageDestinationRefTypes = new ArrayList<MessageDestinationRefType>();
        ArrayList<PersistenceContextRefType> persistenceContextRefTypes = new ArrayList<PersistenceContextRefType>();
        ArrayList<PersistenceUnitRefType> persistenceUnitRefTypes = new ArrayList<PersistenceUnitRefType>();
        ArrayList<LifecycleCallbackType> postConstructTypes = new ArrayList<LifecycleCallbackType>();
        ArrayList<LifecycleCallbackType> preDestroyTypes = new ArrayList<LifecycleCallbackType>();
        for (JAXBElement element : descriptionAndDisplayNameAndIcon) {
            QName qname;
            Object o = element.getValue();
            if (o instanceof SessionConfigType) {
                WebCommonConfiguration.processSessionTimeOut((SessionConfigType)o, webcommon);
                continue;
            }
            if (o instanceof MimeMappingType) {
                WebCommonConfiguration.processMimeMappings((MimeMappingType)o, webcommon);
                continue;
            }
            if (o instanceof WelcomeFileListType) {
                WebCommonConfiguration.processWelcomeFiles((WelcomeFileListType)o, webcommon);
                continue;
            }
            if (o instanceof ErrorPageType) {
                WebCommonConfiguration.processErrorPages((ErrorPageType)o, webcommon);
                continue;
            }
            if (o instanceof TaglibType) {
                WebCommonConfiguration.processTagLibConfigs((TaglibType)o, webcommon);
                continue;
            }
            if (o instanceof SecurityRoleType) {
                roles.add(WebCommonConfiguration.processSecurityRoles((SecurityRoleType)o));
                continue;
            }
            if (o instanceof SecurityConstraintType) {
                constraints.add(WebCommonConfiguration.processSecurityConstraints((SecurityConstraintType)o));
                continue;
            }
            if (o instanceof LoginConfigType) {
                WebCommonConfiguration.processLoginConfig((LoginConfigType)o, webcommon);
                continue;
            }
            if (o instanceof EnvEntryType) {
                envs.add(WebCommonConfiguration.processEnvironEntry((EnvEntryType)o));
                envEntryTypes.add((EnvEntryType)o);
                continue;
            }
            if (o instanceof EjbRefType) {
                ejbEnvs.add(WebCommonConfiguration.processEJBReference((EjbRefType)o));
                ejbRefTypes.add((EjbRefType)o);
                continue;
            }
            if (o instanceof EjbLocalRefType) {
                ejbLocalEnvs.add(WebCommonConfiguration.processEJBLocalReference((EjbLocalRefType)o));
                ejbLocalRefTypes.add((EjbLocalRefType)o);
                continue;
            }
            if (o instanceof ResourceRefType) {
                resRefs.add(WebCommonConfiguration.processResourceReference((ResourceRefType)o));
                resourceRefTypes.add((ResourceRefType)o);
                continue;
            }
            if (o instanceof ResourceEnvRefType) {
                resEnvRefs.add(WebCommonConfiguration.processResourceEnvironReference((ResourceEnvRefType)o));
                resourceEnvRefTypes.add((ResourceEnvRefType)o);
                continue;
            }
            if (o instanceof MessageDestinationRefType) {
                messageDestRefs.add(WebCommonConfiguration.processMessageDestinationReference((MessageDestinationRefType)o));
                messageDestinationRefTypes.add((MessageDestinationRefType)o);
                continue;
            }
            if (o instanceof ServiceRefType) {
                serviceRefTypes.add((ServiceRefType)o);
                continue;
            }
            if (o instanceof PersistenceContextRefType) {
                persistenceContextRefTypes.add((PersistenceContextRefType)o);
                continue;
            }
            if (o instanceof PersistenceUnitRefType) {
                persistenceUnitRefTypes.add((PersistenceUnitRefType)o);
                continue;
            }
            if (!(o instanceof LifecycleCallbackType) || (qname = element.getName()) == null) continue;
            if ("post-construct".equals(qname.getLocalPart())) {
                postConstructTypes.add((LifecycleCallbackType)o);
                continue;
            }
            if ("pre-destroy".equals(qname.getLocalPart())) {
                preDestroyTypes.add((LifecycleCallbackType)o);
                continue;
            }
            System.out.println("### invalid QName : " + qname);
        }
        webcommon.setSecurityRoles(roles.toArray(new SecurityRole[roles.size()]));
        webcommon.setSecurityConstraints(constraints.toArray(new SecurityConstraint[constraints.size()]));
        webcommon.setEnvironEntries(envs.toArray(new EnvironEntry[envs.size()]));
        webcommon.setEJBRefs(ejbEnvs.toArray(new EJBReference[ejbEnvs.size()]));
        webcommon.setEJBLocalRefs(ejbLocalEnvs.toArray(new EJBReference[ejbLocalEnvs.size()]));
        webcommon.setResourceRefs(resRefs.toArray(new ResourceReference[resRefs.size()]));
        webcommon.setResourceEnvRefs(resEnvRefs.toArray(new ResourceEnvironReference[resEnvRefs.size()]));
        webcommon.setMessageDestRefs(messageDestRefs.toArray(new MessageDestinationReference[messageDestRefs.size()]));
        webcommon.setEnvEntryTypes(envEntryTypes);
        webcommon.setEjbRefTypes(ejbRefTypes);
        webcommon.setEjbLocalRefTypes(ejbLocalRefTypes);
        webcommon.setServiceRefTypes(serviceRefTypes);
        webcommon.setResourceRefTypes(resourceRefTypes);
        webcommon.setResourceEnvRefTypes(resourceEnvRefTypes);
        webcommon.setMessageDestinationRefTypes(messageDestinationRefTypes);
        webcommon.setPersistenceContextRefTypes(persistenceContextRefTypes);
        webcommon.setPersistenceUnitRefTypes(persistenceUnitRefTypes);
        webcommon.setPostConstructTypes(postConstructTypes);
        webcommon.setPreDestroyTypes(preDestroyTypes);
        return webcommon;
    }

    private static void processSessionTimeOut(SessionConfigType config, WebCommonDescriptor webcommon) {
        XsdIntegerType tmpTree = config.getSessionTimeout();
        if (tmpTree != null) {
            String sessionTimeOut = tmpTree.getValue().toString();
            webcommon.setSessionTimeout(sessionTimeOut);
        }
    }

    private static SecurityRole processSecurityRoles(SecurityRoleType config) {
        RoleNameType roleNameElement = config.getRoleName();
        String roleName = null;
        if (roleNameElement != null) {
            roleName = roleNameElement.getValue();
        }
        List descriptionElement = config.getDescription();
        String description = null;
        if (descriptionElement.size() > 0) {
            description = ((DescriptionType)descriptionElement.get(0)).getValue();
        }
        return new SecurityRole(description, roleName);
    }

    private static SecurityConstraint processSecurityConstraints(SecurityConstraintType config) {
        WEBResource[] webRes = null;
        List v2 = config.getWebResourceCollection();
        int size2 = v2.size();
        if (size2 > 0) {
            webRes = new WEBResource[size2];
            for (int j = 0; j < size2; ++j) {
                WebResourceCollectionType next2 = (WebResourceCollectionType)v2.get(j);
                jeus.xml.binding.j2ee.String resNameTree = next2.getWebResourceName();
                String resName = null;
                if (resNameTree != null) {
                    resName = resNameTree.getValue();
                }
                List v3 = next2.getUrlPattern();
                int size3 = v3.size();
                String[] urlPatterns = null;
                if (size3 > 0) {
                    urlPatterns = new String[size3];
                    for (int k = 0; k < size3; ++k) {
                        UrlPatternType next3 = (UrlPatternType)v3.get(k);
                        if (next3 == null) continue;
                        urlPatterns[k] = next3.getValue();
                    }
                }
                List v4 = next2.getHttpMethod();
                size3 = v4.size();
                String[] httpMethods = null;
                if (size3 > 0) {
                    httpMethods = new String[size3];
                    for (int k = 0; k < size3; ++k) {
                        String next3 = (String)v4.get(k);
                        if (next3 == null) continue;
                        httpMethods[k] = next3;
                    }
                }
                webRes[j] = new WEBResource();
                webRes[j].setResourceName(resName);
                webRes[j].setURLPatterns(urlPatterns);
                webRes[j].setHttpMethods(httpMethods);
            }
        }
        AuthConstraint authConstraint = null;
        AuthConstraintType authConstTree = config.getAuthConstraint();
        if (authConstTree != null) {
            String[] roleNames = null;
            v2 = authConstTree.getRoleName();
            size2 = v2.size();
            if (size2 > 0) {
                roleNames = new String[size2];
                for (int j = 0; j < size2; ++j) {
                    RoleNameType roleNameTree = (RoleNameType)v2.get(j);
                    if (roleNameTree == null) continue;
                    roleNames[j] = roleNameTree.getValue();
                }
            }
            String acDescription = null;
            List acDescriptionTree = authConstTree.getDescription();
            if (acDescriptionTree.size() > 0) {
                acDescription = ((DescriptionType)acDescriptionTree.get(0)).getValue();
            }
            authConstraint = new AuthConstraint();
            authConstraint.setRoleNames(roleNames);
            authConstraint.setDescription(acDescription);
        }
        UserDataConstraint userDataConstraint = null;
        UserDataConstraintType userDataConstTree = config.getUserDataConstraint();
        if (userDataConstTree != null) {
            String transpotGuarantee = null;
            TransportGuaranteeType transpotGuaranteeTree = userDataConstTree.getTransportGuarantee();
            if (transpotGuaranteeTree != null) {
                transpotGuarantee = transpotGuaranteeTree.getValue();
            }
            String udcDescription = null;
            List udcDescriptionTree = userDataConstTree.getDescription();
            if (udcDescriptionTree.size() > 0) {
                udcDescription = ((DescriptionType)udcDescriptionTree.get(0)).getValue();
            }
            userDataConstraint = new UserDataConstraint();
            userDataConstraint.setTransGuarantee(transpotGuarantee);
            userDataConstraint.setDescription(udcDescription);
        }
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setWEBResourceCollection(webRes);
        constraint.setAuthConstraint(authConstraint);
        constraint.setUserDataConstraint(userDataConstraint);
        return constraint;
    }

    private static void processLoginConfig(LoginConfigType config, WebCommonDescriptor webcommon) {
        FormLoginConfigType formLoginConfigTree;
        jeus.xml.binding.j2ee.String realmNameTree;
        LoginConfig loginConfig = new LoginConfig();
        AuthMethodType authMethodTree = config.getAuthMethod();
        if (authMethodTree != null) {
            loginConfig.setAuthMethod(authMethodTree.getValue());
        }
        if ((realmNameTree = config.getRealmName()) != null) {
            loginConfig.setRealmName(realmNameTree.getValue());
        }
        if ((formLoginConfigTree = config.getFormLoginConfig()) != null) {
            WarPathType formErrorPageTree;
            FormLoginConfig formLoginConfig = new FormLoginConfig();
            WarPathType formLoginPageTree = formLoginConfigTree.getFormLoginPage();
            if (formLoginPageTree != null) {
                formLoginConfig.setLoginPage(formLoginPageTree.getValue());
            }
            if ((formErrorPageTree = formLoginConfigTree.getFormErrorPage()) != null) {
                formLoginConfig.setErrorPage(formErrorPageTree.getValue());
            }
            loginConfig.setFormLoginConfig(formLoginConfig);
        }
        webcommon.setLoginConfig(loginConfig);
    }

    private static void processMimeMappings(MimeMappingType config, WebCommonDescriptor webcommon) {
        MimeTypeType mimeType;
        jeus.xml.binding.j2ee.String mimeExtension = config.getExtension();
        String extension = null;
        String type = null;
        if (mimeExtension != null) {
            extension = mimeExtension.getValue();
        }
        if ((mimeType = config.getMimeType()) != null) {
            type = mimeType.getValue();
        }
        if (extension != null && type != null) {
            webcommon.setMimeMappings(extension, type);
        }
    }

    private static void processWelcomeFiles(WelcomeFileListType config, WebCommonDescriptor webcommon) {
        List welcomeFiles = config.getWelcomeFile();
        if (welcomeFiles.size() == 0) {
            return;
        }
        for (int i = 0; i < welcomeFiles.size(); ++i) {
            String welcomeFile = (String)welcomeFiles.get(i);
            webcommon.addWelcomeFileList(welcomeFile);
        }
    }

    private static void processErrorPages(ErrorPageType config, WebCommonDescriptor webcommon) {
        String error = null;
        String location = null;
        ErrorCodeType errorCode = config.getErrorCode();
        if (errorCode != null) {
            error = errorCode.getValue().toString();
        } else {
            FullyQualifiedClassType exceptionType = config.getExceptionType();
            if (exceptionType != null) {
                error = exceptionType.getValue();
            }
        }
        WarPathType locationNode = config.getLocation();
        if (locationNode != null) {
            location = locationNode.getValue();
        }
        if (error != null && location != null) {
            webcommon.addErrorPage(error, location);
        }
    }

    private static void processTagLibConfigs(TaglibType config, WebCommonDescriptor webcommon) {
        PathType locationNode;
        String uri = null;
        String location = null;
        jeus.xml.binding.j2ee.String uriNode = config.getTaglibUri();
        if (uriNode != null) {
            uri = uriNode.getValue();
        }
        if ((locationNode = config.getTaglibLocation()) != null) {
            location = locationNode.getValue();
        }
        webcommon.addTaglib(uri, location);
    }

    private static EnvironEntry processEnvironEntry(EnvEntryType config) {
        EnvEntryTypeValuesType typeNode;
        XsdStringType valueNode;
        JndiNameType nameNode;
        String description = null;
        String name = null;
        String value = null;
        String type = null;
        List descriptionNode = config.getDescription();
        if (descriptionNode.size() > 0) {
            description = ((DescriptionType)descriptionNode.get(0)).getValue();
        }
        if ((nameNode = config.getEnvEntryName()) != null) {
            name = nameNode.getValue();
        }
        if ((valueNode = config.getEnvEntryValue()) != null) {
            value = valueNode.getValue().trim();
        }
        if ((typeNode = config.getEnvEntryType()) != null) {
            type = typeNode.getValue();
        }
        return new EnvironEntry(name, type, value, description);
    }

    private static EJBReference processEJBReference(EjbRefType config) {
        EjbLinkType nodeLink;
        RemoteType nodeRemote;
        HomeType nodeHome;
        EjbRefTypeType nodeType;
        EjbRefNameType nodeName;
        String description = null;
        String name = null;
        String type = null;
        String home = null;
        String remote = null;
        String link = null;
        List descriptionNode = config.getDescription();
        if (descriptionNode.size() > 0) {
            description = ((DescriptionType)descriptionNode.get(0)).getValue();
        }
        if ((nodeName = config.getEjbRefName()) != null) {
            name = nodeName.getValue();
        }
        if ((nodeType = config.getEjbRefType()) != null) {
            type = nodeType.getValue();
        }
        if ((nodeHome = config.getHome()) != null) {
            home = nodeHome.getValue();
        }
        if ((nodeRemote = config.getRemote()) != null) {
            remote = nodeRemote.getValue();
        }
        if ((nodeLink = config.getEjbLink()) != null) {
            link = nodeLink.getValue();
        }
        return new EJBReference(description, name, type, home, remote, link);
    }

    private static EJBReference processEJBLocalReference(EjbLocalRefType config) {
        EjbLinkType nodeLink;
        LocalType nodeRemote;
        LocalHomeType nodeHome;
        EjbRefTypeType nodeType;
        EjbRefNameType nodeName;
        String description = null;
        String name = null;
        String type = null;
        String home = null;
        String remote = null;
        String link = null;
        List descriptionNode = config.getDescription();
        if (descriptionNode.size() > 0) {
            description = ((DescriptionType)descriptionNode.get(0)).getValue();
        }
        if ((nodeName = config.getEjbRefName()) != null) {
            name = nodeName.getValue();
        }
        if ((nodeType = config.getEjbRefType()) != null) {
            type = nodeType.getValue();
        }
        if ((nodeHome = config.getLocalHome()) != null) {
            home = nodeHome.getValue();
        }
        if ((nodeRemote = config.getLocal()) != null) {
            remote = nodeRemote.getValue();
        }
        if ((nodeLink = config.getEjbLink()) != null) {
            link = nodeLink.getValue();
        }
        return new EJBReference(description, name, type, home, remote, link);
    }

    private static ResourceReference processResourceReference(ResourceRefType config) {
        ResSharingScopeType nodeScope;
        ResAuthType nodeAuth;
        FullyQualifiedClassType nodeType;
        JndiNameType nodeName;
        String description = null;
        String name = null;
        String type = null;
        String auth = null;
        String scope = null;
        List descriptionNode = config.getDescription();
        if (descriptionNode.size() > 0) {
            description = ((DescriptionType)descriptionNode.get(0)).getValue();
        }
        if ((nodeName = config.getResRefName()) != null) {
            name = nodeName.getValue();
        }
        if ((nodeType = config.getResType()) != null) {
            type = nodeType.getValue();
        }
        if ((nodeAuth = config.getResAuth()) != null) {
            auth = nodeAuth.getValue();
        }
        if ((nodeScope = config.getResSharingScope()) != null) {
            scope = nodeScope.getValue();
        }
        return new ResourceReference(name, description, type, auth);
    }

    private static ResourceEnvironReference processResourceEnvironReference(ResourceEnvRefType config) {
        FullyQualifiedClassType nodeType;
        JndiNameType nodeName;
        String description = null;
        String name = null;
        String type = null;
        List descriptionNode = config.getDescription();
        if (descriptionNode.size() > 0) {
            description = ((DescriptionType)descriptionNode.get(0)).getValue();
        }
        if ((nodeName = config.getResourceEnvRefName()) != null) {
            name = nodeName.getValue();
        }
        if ((nodeType = config.getResourceEnvRefType()) != null) {
            type = nodeType.getValue();
        }
        ResourceEnvironReference env = new ResourceEnvironReference();
        env.setName(name);
        env.setType(type);
        env.setDescription(description);
        return env;
    }

    private static MessageDestinationReference processMessageDestinationReference(MessageDestinationRefType config) {
        MessageDestinationLinkType nodeLink;
        MessageDestinationUsageType nodeUsage;
        MessageDestinationTypeType nodeType;
        JndiNameType nodeName;
        String description = null;
        String name = null;
        String type = null;
        String usage = null;
        String link = null;
        List descriptionNode = config.getDescription();
        if (descriptionNode.size() > 0) {
            description = ((DescriptionType)descriptionNode.get(0)).getValue();
        }
        if ((nodeName = config.getMessageDestinationRefName()) != null) {
            name = nodeName.getValue();
        }
        if ((nodeType = config.getMessageDestinationType()) != null) {
            type = nodeType.getValue();
        }
        if ((nodeUsage = config.getMessageDestinationUsage()) != null) {
            usage = nodeUsage.getValue();
        }
        if ((nodeLink = config.getMessageDestinationLink()) != null) {
            link = nodeLink.getValue();
        }
        return new MessageDestinationReference(description, name, type, usage, link);
    }
}

