/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import jeus.descriptor.tool.SecurityRoleReference;
import jeus.servlet.deployment.ConfigConstants2;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.WebCommonConfiguration;
import jeus.servlet.deployment.descriptor.ListenerDescriptor;
import jeus.servlet.deployment.descriptor.ServletDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.deployment.descriptor.WebCommonDescriptor;
import jeus.servlet.filter.FilterDef;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.xml.binding.BindingHelper;
import jeus.xml.binding.j2ee.DescriptionType;
import jeus.xml.binding.j2ee.DisplayNameType;
import jeus.xml.binding.j2ee.FilterMappingType;
import jeus.xml.binding.j2ee.FilterNameType;
import jeus.xml.binding.j2ee.FilterType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.JspConfigType;
import jeus.xml.binding.j2ee.JspFileType;
import jeus.xml.binding.j2ee.ListenerType;
import jeus.xml.binding.j2ee.LoginConfigType;
import jeus.xml.binding.j2ee.ParamValueType;
import jeus.xml.binding.j2ee.RoleNameType;
import jeus.xml.binding.j2ee.RunAsType;
import jeus.xml.binding.j2ee.SecurityRoleRefType;
import jeus.xml.binding.j2ee.ServletMappingType;
import jeus.xml.binding.j2ee.ServletNameType;
import jeus.xml.binding.j2ee.ServletType;
import jeus.xml.binding.j2ee.SessionConfigType;
import jeus.xml.binding.j2ee.String;
import jeus.xml.binding.j2ee.UrlPatternType;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.j2ee.XsdStringType;

public class WebConfiguration
implements ConfigConstants2 {
    public static WebAppDescriptor configureWeb(WebAppType webApp) throws StartingException {
        WebAppDescriptor webAppDesc = new WebAppDescriptor();
        return WebConfiguration.configureWeb(webApp, webAppDesc);
    }

    public static WebAppDescriptor configureWeb(WebAppType webApp, WebAppDescriptor webAppDesc) throws StartingException {
        java.lang.String version = webApp.getVersion();
        if ("2.3".equals(version)) {
            webAppDesc.setWebApp_2_3(true);
            webAppDesc.setMetadataComplete(true);
        } else if ("2.4".equals(version)) {
            webAppDesc.setWebApp_2_4(true);
            webAppDesc.setMetadataComplete(true);
        } else if ("2.5".equals(version)) {
            webAppDesc.setWebApp_2_5(true);
            if (webApp.isSetMetadataComplete() && webApp.isMetadataComplete()) {
                webAppDesc.setMetadataComplete(true);
            } else {
                webAppDesc.setMetadataComplete(false);
            }
        } else {
            webAppDesc.setWebApp_2_5(true);
            webAppDesc.setMetadataComplete(false);
        }
        List displayNameList = webApp.getDescriptionAndDisplayNameAndIcon();
        for (int i = 0; i < displayNameList.size(); ++i) {
            JAXBElement jaxbElement = (JAXBElement)displayNameList.get(i);
            Object o = jaxbElement.getValue();
            if (!(o instanceof DisplayNameType)) continue;
            DisplayNameType name = (DisplayNameType)o;
            webAppDesc.setServletContextName(name.getValue());
            break;
        }
        List list = webApp.getDescriptionAndDisplayNameAndIcon();
        for (int i = 0; i < list.size(); ++i) {
            JAXBElement jaxbElement = (JAXBElement)list.get(i);
            Object o = jaxbElement.getValue();
            if (o instanceof ParamValueType) {
                WebConfiguration.processContextParameters((ParamValueType)o, webAppDesc);
                continue;
            }
            if (o instanceof ServletType) {
                WebConfiguration.processServlets((ServletType)o, webAppDesc);
                continue;
            }
            if (o instanceof ServletMappingType) {
                WebConfiguration.processServletMappings((ServletMappingType)o, webAppDesc);
                continue;
            }
            if (o instanceof FilterType) {
                WebConfiguration.processFilters((FilterType)o, webAppDesc);
                continue;
            }
            if (o instanceof FilterMappingType) {
                WebConfiguration.processFilterMappings((FilterMappingType)o, webAppDesc);
                continue;
            }
            if (!(o instanceof ListenerType)) continue;
            WebConfiguration.processListeners((ListenerType)o, webAppDesc);
        }
        WebCommonDescriptor webCommonDesc = WebCommonConfiguration.configWebCommon(webApp);
        webAppDesc.setWebCommonDescriptor(webCommonDesc);
        WebConfiguration.setWebApp(webApp, webAppDesc);
        return webAppDesc;
    }

    private static void setWebApp(WebAppType webApp, WebAppDescriptor webDesc) throws StartingException {
        webDesc.setWebApp(webApp);
        WebConfiguration.setServletContextName24(webApp, webDesc);
        WebConfiguration.validate(webApp, webDesc);
    }

    private static void setServletContextName24(WebAppType webApp, WebAppDescriptor webDesc) {
        if (webApp == null) {
            return;
        }
        try {
            Object _obj = BindingHelper.getSubFirstElement(webApp.getDescriptionAndDisplayNameAndIcon(), DisplayNameType.class);
            if (_obj != null) {
                DisplayNameType _display = (DisplayNameType)_obj;
                webDesc.setServletContextName(_display.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void validate(WebAppType _webApp, WebAppDescriptor _webDesc) throws StartingException {
        if (_webApp == null) {
            return;
        }
        List<LoginConfigType> _loginConfig = BindingHelper.getSubList(_webApp.getDescriptionAndDisplayNameAndIcon(), LoginConfigType.class);
        if (_loginConfig != null && _loginConfig.size() > 1) {
            throw new StartingException(JeusMessage_WebContainer2._3703);
        }
        List<SessionConfigType> _sessConfig = BindingHelper.getSubList(_webApp.getDescriptionAndDisplayNameAndIcon(), SessionConfigType.class);
        if (_sessConfig != null && _sessConfig.size() > 1) {
            throw new StartingException(JeusMessage_WebContainer2._3708);
        }
        List<JspConfigType> _jspConfig = BindingHelper.getSubList(_webApp.getDescriptionAndDisplayNameAndIcon(), JspConfigType.class);
        if (_jspConfig != null && _jspConfig.size() > 1) {
            throw new StartingException(JeusMessage_WebContainer2._3715);
        }
        if (_webDesc == null) {
            return;
        }
        Hashtable servletMap = _webDesc.getServletMappings();
        if (servletMap != null && servletMap.size() > 0) {
            Collection col = servletMap.values();
            for (Vector _urlPatterns : col) {
                Enumeration enumeration = _urlPatterns.elements();
                while (enumeration.hasMoreElements()) {
                    java.lang.String _url = (java.lang.String)enumeration.nextElement();
                    if (_url == null || _url.indexOf("\n") < 0) continue;
                    throw new StartingException(JeusMessage_WebContainer2._3709);
                }
            }
        }
    }

    private static void processContextParameters(ParamValueType contextParam, WebAppDescriptor webAppDesc) {
        XsdStringType paramValue;
        java.lang.String name = null;
        java.lang.String value = null;
        String paramName = contextParam.getParamName();
        if (paramName != null) {
            name = paramName.getValue();
        }
        if ((paramValue = contextParam.getParamValue()) != null) {
            value = paramValue.getValue();
        }
        webAppDesc.addContextParam(name, value, null);
    }

    private static void processServletMappings(ServletMappingType config, WebAppDescriptor webAppDesc) {
        java.lang.String servletName = null;
        java.lang.String urlPattern = null;
        ServletNameType servletNameNode = config.getServletName();
        if (servletNameNode != null) {
            servletName = servletNameNode.getValue();
        }
        List urlPatternList = config.getUrlPattern();
        Iterator iter2 = urlPatternList.iterator();
        UrlPatternType urlPatternType = null;
        while (iter2.hasNext()) {
            Object item2 = iter2.next();
            urlPatternType = (UrlPatternType)item2;
            urlPattern = urlPatternType.getValue();
            webAppDesc.addServletMapping(servletName, urlPattern);
        }
    }

    private static void processServlets(ServletType servlet, WebAppDescriptor webAppDesc) {
        List v;
        int size;
        FullyQualifiedClassType servletClassType;
        ServletDescriptor servletDesc = new ServletDescriptor();
        java.lang.String servletName = null;
        ServletNameType servletNameType = servlet.getServletName();
        if (servletNameType != null) {
            servletName = servletNameType.getValue();
            servletDesc.setServletName(servletName);
        }
        if ((servletClassType = servlet.getServletClass()) != null) {
            servletDesc.setServletClass(servletClassType.getValue());
        } else {
            JspFileType jspFileType = servlet.getJspFile();
            if (jspFileType != null) {
                servletDesc.setJSPFile(jspFileType.getValue());
            } else {
                System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1208, (Object)servletDesc.getServletName()));
                return;
            }
        }
        java.lang.String loadOnStartup = servlet.getLoadOnStartup();
        if (loadOnStartup != null) {
            if (loadOnStartup instanceof BigInteger) {
                servletDesc.setLoadOnStartUp(loadOnStartup.toString());
            } else if (loadOnStartup instanceof java.lang.String) {
                servletDesc.setLoadOnStartUp(loadOnStartup);
            }
        }
        List initParams = servlet.getInitParam();
        for (int i = 0; i < initParams.size(); ++i) {
            java.lang.String[] nameValue = WebConfiguration.getParamNameAndValue((ParamValueType)initParams.get(i));
            servletDesc.addInitParam(nameValue[0], nameValue[1].trim(), null);
        }
        RunAsType _runAsnode = servlet.getRunAs();
        if (_runAsnode != null) {
            RoleNameType _role_name = _runAsnode.getRoleName();
            java.lang.String _runAs = _role_name.getValue();
            servletDesc.setRunAs(_runAs);
        }
        if ((size = (v = servlet.getSecurityRoleRef()).size()) > 0) {
            SecurityRoleReference[] roleRefs = new SecurityRoleReference[size];
            for (int i = 0; i < size; ++i) {
                SecurityRoleRefType roleRefTree = (SecurityRoleRefType)v.get(i);
                java.lang.String roleName = null;
                RoleNameType element = roleRefTree.getRoleName();
                if (element != null) {
                    roleName = element.getValue();
                }
                java.lang.String roleLink = null;
                element = roleRefTree.getRoleLink();
                if (element != null) {
                    roleLink = element.getValue();
                }
                java.lang.String roleDescription = null;
                List descs = roleRefTree.getDescription();
                if (descs.size() > 0) {
                    roleDescription = ((DescriptionType)descs.get(0)).getValue();
                }
                roleRefs[i] = new SecurityRoleReference();
                roleRefs[i].setRoleName(roleName);
                roleRefs[i].setRoleLink(roleLink);
                roleRefs[i].setDescription(roleDescription);
            }
            servletDesc.setSecurityRoleRefs(roleRefs);
        }
        webAppDesc.addServletDescriptor(servletName, servletDesc);
    }

    private static java.lang.String[] getParamNameAndValue(ParamValueType paramValueType) {
        XsdStringType valueNode;
        java.lang.String paramName = null;
        java.lang.String paramValue = null;
        String nameNode = paramValueType.getParamName();
        if (nameNode != null) {
            paramName = nameNode.getValue();
        }
        if ((valueNode = paramValueType.getParamValue()) != null) {
            paramValue = valueNode.getValue();
        }
        return new java.lang.String[]{paramName, paramValue.trim()};
    }

    private static void processFilters(FilterType config, WebAppDescriptor webAppDesc) {
        FullyQualifiedClassType classType;
        FilterDef filterDef = new FilterDef();
        java.lang.String filterName = null;
        FilterNameType filterNameType = config.getFilterName();
        if (filterNameType != null) {
            filterName = filterNameType.getValue();
            filterDef.setFilterName(filterName);
        }
        if ((classType = config.getFilterClass()) == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1209, (Object)filterDef.getFilterName()));
            return;
        }
        filterDef.setFilterClass(classType.getValue());
        List initParams = config.getInitParam();
        for (int i = 0; i < initParams.size(); ++i) {
            java.lang.String[] nameValue = WebConfiguration.getParamNameAndValue((ParamValueType)initParams.get(i));
            filterDef.addInitParameter(nameValue[0], nameValue[1]);
        }
        webAppDesc.addFilterDef(filterName, filterDef);
    }

    private static void processFilterMappings(FilterMappingType config, WebAppDescriptor webAppDesc) {
        java.lang.String filterName = null;
        java.lang.String mappingName = null;
        boolean isUrl = false;
        FilterNameType filterNameNode = config.getFilterName();
        if (filterNameNode != null) {
            filterName = filterNameNode.getValue();
        }
        List dispatchers = config.getDispatcher();
        ServletNameType servletNameType = null;
        UrlPatternType urlPatternType = null;
        List urlPatternOrServletName = config.getUrlPatternOrServletName();
        for (Object item2 : urlPatternOrServletName) {
            if (item2 instanceof ServletNameType) {
                isUrl = false;
                servletNameType = (ServletNameType)item2;
                mappingName = servletNameType.getValue();
                webAppDesc.addFilterMapping(filterName, mappingName, isUrl, dispatchers);
            }
            if (!(item2 instanceof UrlPatternType)) continue;
            isUrl = true;
            urlPatternType = (UrlPatternType)item2;
            mappingName = urlPatternType.getValue();
            webAppDesc.addFilterMapping(filterName, mappingName, isUrl, dispatchers);
        }
    }

    private static void processListeners(ListenerType config, WebAppDescriptor webAppDesc) {
        ListenerDescriptor listenerDesc = new ListenerDescriptor();
        FullyQualifiedClassType node = config.getListenerClass();
        if (node != null) {
            java.lang.String listenerClass = node.getValue();
            listenerDesc.setListenerClass(listenerClass);
            webAppDesc.addListenerDescriptor(listenerDesc);
        }
    }
}

