/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;

public class LoggerDescriptor
implements Serializable {
    private int errorLogLevel = 1;
    private String errorLogTarget = "file";
    private String errorLogFile = null;
    private int errorLogBufferSize = 512;
    private int errorLogValidDays = -1;
    private int errorLogsPerDay = 1;
    private String userLogTarget = "file";
    private String userLogFile = null;
    private int userLogBufferSize = 512;
    private int userLogValidDays = -1;
    private int userLogsPerDay = 1;
    private boolean enableAccessLog = false;
    private String accessLogTarget = "file";
    private String accessLogFile = null;
    private int accessLogBufferSize = 1024;
    private int accessLogValidDays = -1;
    private int accessLogsPerDay = 1;
    private String accessLogFormat = "default";

    public void setErrorLogTarget(String log) {
        this.errorLogTarget = log != null ? log : "file";
    }

    public void setErrorLogLevel(String level) {
        if (level != null) {
            try {
                this.errorLogLevel = Integer.parseInt(level);
            }
            catch (NumberFormatException nfe) {
                this.errorLogLevel = level.equalsIgnoreCase("debug") ? 3 : (level.equalsIgnoreCase("information") || level.equalsIgnoreCase("info") ? 2 : (level.equalsIgnoreCase("error") ? 1 : (level.equalsIgnoreCase("notice") ? 1 : (level.equalsIgnoreCase("fatal") ? 0 : (level.equalsIgnoreCase("test") ? 100 : 0)))));
            }
        }
    }

    public void setErrorLogBufferSize(String size) {
        if (size != null) {
            try {
                this.errorLogBufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setErrorLogFile(String filename) {
        this.errorLogFile = filename;
    }

    public void setErrorLogValidDays(String days) {
        if (days != null) {
            try {
                this.errorLogValidDays = Integer.parseInt(days);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setErrorLogsPerDay(String value) {
        if (value == null) {
            this.errorLogsPerDay = 1;
        } else {
            try {
                this.errorLogsPerDay = LoggerDescriptor.validateLogsPerDay(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setUserLogTarget(String log) {
        this.userLogTarget = log != null ? log : "file";
    }

    public void setUserLogFile(String filename) {
        this.userLogFile = filename;
    }

    public void setUserLogBufferSize(String size) {
        if (size != null) {
            try {
                this.userLogBufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setUserLogValidDays(String days) {
        if (days != null) {
            try {
                this.userLogValidDays = Integer.parseInt(days);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setUserLogsPerDay(String value) {
        if (value == null) {
            this.userLogsPerDay = 1;
        } else {
            try {
                this.userLogsPerDay = LoggerDescriptor.validateLogsPerDay(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setAccessLogTarget(String log) {
        if (log != null) {
            this.accessLogTarget = log;
            this.enableAccessLog = true;
        } else {
            this.accessLogFile = "file";
        }
    }

    public void setAccessLogFile(String filename) {
        this.accessLogFile = filename;
    }

    public void setAccessLogBufferSize(String size) {
        if (size != null) {
            try {
                this.accessLogBufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setAccessLogValidDays(String days) {
        if (days != null) {
            try {
                this.accessLogValidDays = Integer.parseInt(days);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setAccessLogsPerDay(String value) {
        if (value == null) {
            this.accessLogsPerDay = 1;
        } else {
            try {
                this.accessLogsPerDay = LoggerDescriptor.validateLogsPerDay(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setAccessLogFormat(String format) {
        if (format != null) {
            this.accessLogFormat = format;
        }
    }

    public String getErrorLogTarget() {
        return this.errorLogTarget;
    }

    public int getErrorLogLevel() {
        return this.errorLogLevel;
    }

    public String getErrorLogFile() {
        return this.errorLogFile;
    }

    public int getErrorLogBufferSize() {
        return this.errorLogBufferSize;
    }

    public int getErrorLogValidDays() {
        return this.errorLogValidDays;
    }

    public int getErrorLogsPerDay() {
        return this.errorLogsPerDay;
    }

    public String getUserLogTarget() {
        return this.userLogTarget;
    }

    public String getUserLogFile() {
        return this.userLogFile;
    }

    public int getUserLogBufferSize() {
        return this.userLogBufferSize;
    }

    public int getUserLogValidDays() {
        return this.userLogValidDays;
    }

    public int getUserLogsPerDay() {
        return this.userLogsPerDay;
    }

    public boolean enableAccessLog() {
        return this.enableAccessLog;
    }

    public String getAccessLogTarget() {
        return this.accessLogTarget;
    }

    public String getAccessLogFile() {
        return this.accessLogFile;
    }

    public int getAccessLogBufferSize() {
        return this.accessLogBufferSize;
    }

    public int getAccessLogValidDays() {
        return this.accessLogValidDays;
    }

    public int getAccessLogsPerDay() {
        return this.accessLogsPerDay;
    }

    public String getAccessLogFormat() {
        return this.accessLogFormat;
    }

    public static int validateLogsPerDay(int logsPerDay) {
        if (logsPerDay <= 0) {
            return 1;
        }
        if (logsPerDay >= 24) {
            return 24;
        }
        while (24 % logsPerDay != 0) {
            ++logsPerDay;
        }
        return logsPerDay;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("<<< Logger >>>");
        out.println("  ++ Error Log ++");
        out.println("  - log target      : " + this.errorLogTarget);
        out.println("  - log file        : " + this.errorLogFile);
        out.println("  - log level       : " + this.errorLogLevel);
        out.println("  - log buffer size : " + this.errorLogBufferSize);
        out.println("  - log expire days : " + this.errorLogValidDays);
        out.println("  - logs per day    : " + this.errorLogsPerDay);
        out.println("  ++ User Log ++");
        out.println("  - log target      : " + this.userLogTarget);
        out.println("  - log file        : " + this.userLogFile);
        out.println("  - log buffer size : " + this.userLogBufferSize);
        out.println("  - log expire days : " + this.userLogValidDays);
        out.println("  - logs per day    : " + this.userLogsPerDay);
        out.println("  ++ Access Log ++");
        out.println("  - log target      : " + this.accessLogTarget);
        out.println("  - log file        : " + this.accessLogFile);
        out.println("  - log buffer size : " + this.accessLogBufferSize);
        out.println("  - log expire days : " + this.accessLogValidDays);
        out.println("  - logs per day    : " + this.accessLogsPerDay);
    }
}

