/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jeus.descriptor.tool.Descriptor;
import jeus.descriptor.tool.SecurityRoleReference;

public class ServletDescriptor
extends Descriptor
implements Serializable {
    private String servletName = null;
    private String servletClass = null;
    private String jspFile = null;
    private Hashtable initParamValues = null;
    private Hashtable initParamDescs = null;
    private int loadOnStartUp = -1;
    private SecurityRoleReference[] securityRoleRefs = null;
    private String runAs = null;

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    public ServletDescriptor() {
    }

    public ServletDescriptor(String paramServletName) {
        this.setServletName(paramServletName);
    }

    public ServletDescriptor(String servletName, String servletClass, String loadOnStartup) {
        this.servletName = servletName;
        this.servletClass = servletClass;
        if (loadOnStartup != null) {
            try {
                this.loadOnStartUp = Integer.parseInt(loadOnStartup);
            }
            catch (NumberFormatException nfe) {
                this.loadOnStartUp = -1;
            }
        }
    }

    public ServletDescriptor(String servletName, String servletClass) {
        this.servletName = servletName;
        this.servletClass = servletClass;
    }

    public void setServletName(String paramServletName) {
        this.servletName = paramServletName;
    }

    public void setServletClass(String paramServletClass) {
        this.servletClass = paramServletClass;
    }

    public void setJSPFile(String paramJSPFile) {
        if (paramJSPFile != null && paramJSPFile.length() > 0 && !paramJSPFile.startsWith("/")) {
            paramJSPFile = "/" + paramJSPFile;
        }
        this.jspFile = paramJSPFile;
    }

    public void addInitParam(String name, String value, String desc) {
        if (name != null && value != null) {
            if (this.initParamValues == null) {
                this.initParamValues = new Hashtable();
                this.initParamDescs = new Hashtable();
            }
            this.initParamValues.put(name, value);
            if (desc != null) {
                this.initParamDescs.put(name, desc);
            }
        }
    }

    public void setLoadOnStartUp(String paramLoadOnStartUp) {
        if (paramLoadOnStartUp != null) {
            try {
                this.loadOnStartUp = Integer.parseInt(paramLoadOnStartUp);
            }
            catch (NumberFormatException nfe) {
                this.loadOnStartUp = -1;
            }
        }
    }

    public void setSecurityRoleRefs(SecurityRoleReference[] paramReferences) {
        this.securityRoleRefs = paramReferences;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public String getJSPFile() {
        return this.jspFile;
    }

    public Hashtable getInitParamValues() {
        return this.initParamValues;
    }

    public String getInitParamValue(String key) {
        if (this.initParamValues != null) {
            return (String)this.initParamValues.get(key);
        }
        return null;
    }

    public Hashtable getInitParamDescs() {
        return this.initParamDescs;
    }

    public String getInitParamDesc(String key) {
        if (this.initParamDescs != null) {
            return (String)this.initParamDescs.get(key);
        }
        return null;
    }

    public int getLoadOnStartUp() {
        return this.loadOnStartUp;
    }

    public SecurityRoleReference[] getSecurityRoleRefs() {
        return this.securityRoleRefs;
    }

    public String toString() {
        return this.getServletName();
    }

    public void printDescriptor(PrintWriter out) {
        if (this.servletClass != null) {
            out.println("  - servlet-name=" + this.servletName + ", servlet-class=" + this.servletClass + ", load-on-startup=" + this.loadOnStartUp);
        } else {
            out.println("  - servlet-name=" + this.servletName + ", jsp-file=" + this.jspFile + ", load-on-startup=" + this.loadOnStartUp);
        }
        if (this.initParamValues != null) {
            Enumeration enum1 = this.initParamValues.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                String value = (String)this.initParamValues.get(name);
                out.println("    - init-param : name = " + name + ", value = " + value);
            }
        }
    }

    public void print() {
        int i;
        System.out.println("  servletName = " + this.servletName);
        System.out.println("  servletClass = " + this.servletClass);
        System.out.println("  jspFile = " + this.jspFile);
        if (this.initParamValues != null) {
            i = 0;
            Enumeration enum1 = this.initParamValues.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                String value = (String)this.initParamValues.get(name);
                String desc = (String)this.initParamDescs.get(name);
                System.out.println("InitParam[" + i++ + "]");
                System.out.println("  paramName = " + name);
                System.out.println("  paramValue = " + value);
                System.out.println("  description = " + desc);
            }
        }
        System.out.println("  loadOnStartup = " + this.loadOnStartUp);
        if (this.securityRoleRefs != null) {
            for (i = 0; i < this.securityRoleRefs.length; ++i) {
                System.out.println("SecurityRoleReference[" + i + "]");
                this.securityRoleRefs[i].print();
            }
        }
    }
}

