/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import jeus.xml.binding.jeusDD.ThreadStateNotifyType;

public class ThreadStateNotifyDescriptor
implements Serializable {
    private long maxThreadActiveTime = -1L;
    private String notifyThreshold = null;
    private String restartThreshold = null;
    private String notifySubject = "[WARNING] threads are hanged up";
    private String restartSubject = "[WARNING] Jeus WebContainerType is now restarted";
    private double notifyThresholdValue = -1.0;
    private double restartThresholdValue = -1.0;
    private ThreadStateNotifyType threadThreadNotifyType;

    public ThreadStateNotifyType getThreadThreadNotifyType() {
        return this.threadThreadNotifyType;
    }

    public void setThreadThreadNotifyType(ThreadStateNotifyType threadThreadNotifyType) {
        this.threadThreadNotifyType = threadThreadNotifyType;
    }

    public void setMaxThreadActiveTime(String time) {
        if (time != null) {
            try {
                this.maxThreadActiveTime = Long.parseLong(time);
            }
            catch (NumberFormatException nfe) {
                this.maxThreadActiveTime = -1L;
            }
            if (this.maxThreadActiveTime <= 0L) {
                time = null;
            }
        }
        if (time == null) {
            this.maxThreadActiveTime = -1L;
        }
        if (this.threadThreadNotifyType != null) {
            this.threadThreadNotifyType.setMaxThreadActiveTime(Long.valueOf(this.maxThreadActiveTime));
        }
    }

    public void setNotifyThreshold(String threshold) {
        if (threshold != null) {
            try {
                this.notifyThresholdValue = Double.parseDouble(threshold);
                this.notifyThreshold = threshold;
            }
            catch (Exception e) {
                this.notifyThreshold = "-1";
                this.notifyThresholdValue = -1.0;
            }
            if (this.notifyThresholdValue <= 0.0) {
                threshold = null;
            }
        }
        if (threshold == null) {
            this.notifyThreshold = "-1";
            this.notifyThresholdValue = -1.0;
        }
        if (this.threadThreadNotifyType != null) {
            this.threadThreadNotifyType.setNotifyThresholdRatio(Double.valueOf(this.notifyThresholdValue));
        }
    }

    public void setRestartThreshold(String threshold) {
        if (threshold != null) {
            try {
                this.restartThresholdValue = Double.parseDouble(threshold);
                this.restartThreshold = threshold;
            }
            catch (Exception e) {
                this.restartThreshold = "-1";
                this.restartThresholdValue = -1.0;
            }
            if (this.restartThresholdValue <= 0.0) {
                threshold = null;
            }
        }
        if (threshold == null) {
            this.restartThreshold = "-1";
            this.restartThresholdValue = -1.0;
        }
        if (this.threadThreadNotifyType != null) {
            this.threadThreadNotifyType.setRestartThresholdRatio(Double.valueOf(this.restartThresholdValue));
        }
    }

    public void setNotifySubject(String subject) {
        if (subject != null) {
            this.notifySubject = subject;
        }
    }

    public void setRestartSubject(String subject) {
        if (subject != null) {
            this.restartSubject = subject;
        }
    }

    public long getMaxThreadActiveTime() {
        return this.maxThreadActiveTime;
    }

    public String getNotifyThreshold() {
        return this.notifyThreshold;
    }

    public String getRestartThreshold() {
        return this.restartThreshold;
    }

    public boolean needNotify(int blockedThreads, int maxThreadNum) {
        if (this.notifyThresholdValue <= 0.0) {
            return false;
        }
        return (double)blockedThreads >= (double)maxThreadNum * this.notifyThresholdValue;
    }

    public boolean needRestart(int blockedThreads, int maxThreadNum) {
        if (this.restartThresholdValue <= 0.0) {
            return false;
        }
        return (double)blockedThreads >= (double)maxThreadNum * this.restartThresholdValue;
    }

    public String getNotifySubject() {
        return this.notifySubject;
    }

    public String getRestartSubject() {
        return this.restartSubject;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("  ++ Thread State Notification ++");
        out.println("    - max active time (tmtat) : " + this.maxThreadActiveTime);
        out.println("    - notify threshold rate(tnt)  : " + this.notifyThreshold);
        out.println("    - restart threshold rate(trt) : " + this.restartThreshold);
        out.println("    - notify subject          : " + this.notifySubject);
        out.println("    - restart subject         : " + this.restartSubject);
    }

    public void printDescriptor2(PrintWriter out) {
        out.println("    ++ Thread State Notification ++");
        out.println("      - max active time (tmtat) : " + this.maxThreadActiveTime);
        out.println("      - notify threshold rate(tnt)  : " + this.notifyThreshold);
        out.println("      - restart threshold rate(trt) : " + this.restartThreshold);
        out.println("      - notify subject          : " + this.notifySubject);
        out.println("      - restart subject         : " + this.restartSubject);
    }
}

