/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.PropertiesType;

public class VirtualHostDescriptor
implements Serializable {
    private boolean isDefault = false;
    private String virtualHostName;
    private Vector hostList = new Vector();
    private Hashtable contextList = new Hashtable();
    private Vector ctxList = new Vector();
    private PropertiesType properties;

    public void setDefaultVirtualHost(boolean value) {
        this.isDefault = value;
        this.virtualHostName = "__DEFAULT_HOST__";
    }

    public void setVirtualHostName(String name) throws DescriptorException {
        if (name == null || name.trim().equals("")) {
            throw new DescriptorException(JeusMessage_WebContainer0._1340, name);
        }
        this.virtualHostName = name.trim();
        if (this.virtualHostName.length() == 0) {
            throw new DescriptorException(JeusMessage_WebContainer0._1340, name);
        }
    }

    public void addHostName(String name) {
        if (name != null && !name.trim().equals("")) {
            this.hostList.add(name.trim());
        }
    }

    public void setHostNames(Vector val) {
        this.hostList = val;
    }

    public String toString() {
        return this.virtualHostName;
    }

    public void addContextDescriptor(ContextDescriptor desc) throws DescriptorException {
        if (desc != null) {
            String ctxName = desc.getContextName();
            Object dup = this.contextList.get(ctxName);
            if (dup != null) {
                throw new DescriptorException(JeusMessage_WebContainer0._1341, ctxName);
            }
            this.contextList.put(ctxName, desc);
        }
    }

    public boolean isDefaultVirtualHost() {
        return this.isDefault;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public Vector getHostNames() {
        return this.hostList;
    }

    public ContextDescriptor getContextDescriptor(String ctxName) {
        if (ctxName == null) {
            return null;
        }
        return (ContextDescriptor)this.contextList.get(ctxName);
    }

    public ContextDescriptor removeContextDescriptor(String ctxName) {
        if (ctxName == null) {
            return null;
        }
        return (ContextDescriptor)this.contextList.remove(ctxName);
    }

    public Hashtable getContextDescriptors() {
        return this.contextList;
    }

    public PropertiesType getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesType properties) {
        this.properties = properties;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("<<< VirtualHost [" + this.virtualHostName + "] Information >>>");
        out.println("- host list    :");
        Enumeration<Object> enum1 = this.hostList.elements();
        while (enum1.hasMoreElements()) {
            String name = (String)enum1.nextElement();
            out.println("    + " + name);
        }
        out.println("- context list :");
        enum1 = this.contextList.elements();
        while (enum1.hasMoreElements()) {
            ContextDescriptor desc = (ContextDescriptor)enum1.nextElement();
            out.println("    + " + desc.getContextName());
        }
        out.println();
    }
}

