/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.Ajp13RequestProcessor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class Ajp13ThreadPoolManager
extends ThreadPoolManager {
    private Object poolSync = new Object();
    private Vector activePool;
    private Vector idlePool;

    public Ajp13ThreadPoolManager(ContextGroup ctxgrp, ConnectionDescriptor desc) {
        super(ctxgrp, desc);
        this.threadPoolId = desc.getListenerId();
        this.activePool = new Vector();
        this.idlePool = this.threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPool() throws StartingException {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isDestroyed) {
                return;
            }
            int minThreadNum = this.tpoolDesc.getMinThreadNum();
            try {
                for (int i = 0; i < minThreadNum; ++i) {
                    Ajp13RequestProcessor worker = new Ajp13RequestProcessor(this, this.contextGroup);
                    this.addIdleWorker(worker);
                    worker.start();
                }
                if (logger.isLoggable(JeusMessage_WebContainer2._3250_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3250_LEVEL, JeusMessage_WebContainer2._3250, (Object)this.threadPoolId);
                }
                if (logger.isLoggable(JeusMessage_WebContainer2._3251_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3251_LEVEL, JeusMessage_WebContainer2._3251, (Object[])new String[]{String.valueOf(this.tpoolDesc.getMinThreadNum()), String.valueOf(this.tpoolDesc.getMaxThreadNum()), String.valueOf(this.tpoolDesc.getChangingRate()), String.valueOf(this.tpoolDesc.getMaxIdleTime())});
                }
            }
            catch (Exception e) {
                throw new StartingException(JeusMessage_WebContainer2._3404, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ajp13RequestProcessor getProcessor() {
        Object object = this.poolSync;
        synchronized (object) {
            int size = this.idlePool.size();
            if (size > 0) {
                Ajp13RequestProcessor proc = (Ajp13RequestProcessor)this.idlePool.remove(size - 1);
                this.activePool.add(proc);
                return proc;
            }
            this.createThreads();
            while (this.idlePool.size() <= 0) {
                try {
                    this.poolSync.wait();
                    if (this.idlePool.size() > 0) break;
                    this.createThreads();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            Ajp13RequestProcessor proc = (Ajp13RequestProcessor)this.idlePool.remove(this.idlePool.size() - 1);
            this.activePool.add(proc);
            return proc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdle(Ajp13RequestProcessor proc) {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.activePool.remove(proc)) {
                this.addIdleWorker(proc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdleWorker(Ajp13RequestProcessor worker) {
        Object object = this.poolSync;
        synchronized (object) {
            this.idlePool.addElement(worker);
            this.poolSync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads() {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isDestroyed) {
                return 0;
            }
            int diff = this.tpoolDesc.getMaxThreadNum() - (this.idlePool.size() + this.activePool.size());
            int changingRate = this.tpoolDesc.getChangingRate();
            if (diff > 0) {
                if (diff >= changingRate) {
                    diff = changingRate;
                }
                for (int i = 0; i < diff; ++i) {
                    Ajp13RequestProcessor worker = new Ajp13RequestProcessor(this, this.contextGroup);
                    this.addIdleWorker(worker);
                    worker.start();
                }
            }
            return diff;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createThreads(int numCount) {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isDestroyed) {
                return 0;
            }
            int diff = this.tpoolDesc.getMaxThreadNum() - (this.idlePool.size() + this.activePool.size());
            if (diff > numCount) {
                diff = numCount;
            }
            if (diff > 0) {
                for (int i = 0; i < diff; ++i) {
                    Ajp13RequestProcessor worker = new Ajp13RequestProcessor(this, this.contextGroup);
                    this.addIdleWorker(worker);
                    worker.start();
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3252_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3252_LEVEL, JeusMessage_WebContainer2._3252, (Object[])new String[]{this.threadPoolId, worker.getThreadId(), String.valueOf(this.activePool.size()), String.valueOf(this.idlePool.size()), String.valueOf(this.blockedThreadPool.size())});
                }
            }
            return diff;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllThreads() {
        int deletedSize = 0;
        Object object = this.poolSync;
        synchronized (object) {
            int i;
            int size = this.idlePool.size();
            for (i = size - 1; i >= 0; --i) {
                Ajp13RequestProcessor proc = (Ajp13RequestProcessor)this.idlePool.remove(i);
                proc.destroy();
            }
            deletedSize += size;
            size = this.activePool.size();
            for (i = size - 1; i >= 0; --i) {
                Ajp13RequestProcessor worker = (Ajp13RequestProcessor)this.activePool.elementAt(i);
                this.activePool.removeElementAt(i);
                worker.blocked = true;
                this.blockedThreadPool.insertElementAt(worker, 0);
                worker.interrupt();
            }
            int numBlocked = this.blockedThreadPool.size();
            if (numBlocked > 0) {
                for (int i2 = numBlocked - 1; i2 >= 0; --i2) {
                    RequestProcessor worker = (RequestProcessor)this.blockedThreadPool.elementAt(i2);
                    String state = worker.checkBlockedThreadState();
                    if (state != null) {
                        if (!logger.isLoggable(JeusMessage_WebContainer2._3253_LEVEL)) continue;
                        logger.log(JeusMessage_WebContainer2._3253_LEVEL, JeusMessage_WebContainer2._3253, (Object[])new String[]{this.threadPoolId, worker.getThreadId(), worker.getRequestURI(), String.valueOf(this.activePool.size()), String.valueOf(this.idlePool.size()), String.valueOf(this.blockedThreadPool.size())});
                        continue;
                    }
                    worker.blocked = false;
                    this.blockedThreadPool.removeElement(worker);
                }
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3254_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3254_LEVEL, JeusMessage_WebContainer2._3254, (Object[])new String[]{this.threadPoolId, String.valueOf(deletedSize), String.valueOf(this.blockedThreadPool.size())});
        }
        this.createThreads(this.tpoolDesc.getMinThreadNum());
        if (logger.isLoggable(JeusMessage_WebContainer2._3255_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3255_LEVEL, JeusMessage_WebContainer2._3255, (Object[])new String[]{this.threadPoolId, String.valueOf(this.activePool.size()), String.valueOf(this.idlePool.size()), String.valueOf(this.blockedThreadPool.size())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkActivePool() {
        long maxThreadActiveTime;
        int deleted = 0;
        long l = maxThreadActiveTime = this.tsnDesc == null ? 0L : this.tsnDesc.getMaxThreadActiveTime();
        if (maxThreadActiveTime <= 0L) {
            return 0;
        }
        Object object = this.poolSync;
        synchronized (object) {
            int size = this.activePool.size();
            if (size > 0) {
                try {
                    for (int i = 0; i < size; ++i) {
                        long activeTime;
                        RequestProcessor worker = (RequestProcessor)this.activePool.get(i);
                        if (!worker.active || (activeTime = worker.checkIdleTime(maxThreadActiveTime)) <= 0L) continue;
                        this.activePool.remove(worker);
                        worker.blocked = true;
                        this.blockedThreadPool.insertElementAt(worker, 0);
                        ++deleted;
                        if (logger.isLoggable(JeusMessage_WebContainer2._3256_LEVEL)) {
                            logger.log(JeusMessage_WebContainer2._3256_LEVEL, JeusMessage_WebContainer2._3256, (Object[])new String[]{this.threadPoolId, worker.getThreadId(), String.valueOf(activeTime), worker.getRequestURI(), String.valueOf(this.activePool.size()), String.valueOf(this.idlePool.size()), String.valueOf(this.blockedThreadPool.size())});
                        }
                        worker.interrupt();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkIdlePool() {
        long maxIdleTime = this.tpoolDesc.getMaxIdleTime();
        if (maxIdleTime <= 0L) {
            return 0;
        }
        int minThreadNum = this.tpoolDesc.getMinThreadNum();
        int deleteCount = this.tpoolDesc.getChangingRate();
        int activeSize = this.activePool.size();
        int idleSize = this.idlePool.size();
        int deleted = 0;
        if (activeSize + idleSize > minThreadNum) {
            Object object = this.poolSync;
            synchronized (object) {
                Iterator it = this.idlePool.iterator();
                while (it.hasNext() && (activeSize = this.activePool.size()) + (idleSize = this.idlePool.size()) > minThreadNum) {
                    Ajp13RequestProcessor worker = (Ajp13RequestProcessor)it.next();
                    long idleTime = worker.checkIdleTime(maxIdleTime);
                    if (idleTime <= 0L) continue;
                    it.remove();
                    worker.interrupt();
                    ++deleted;
                    if (logger.isLoggable(JeusMessage_WebContainer2._3257_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3257_LEVEL, JeusMessage_WebContainer2._3257, (Object[])new String[]{this.threadPoolId, worker.getThreadId(), String.valueOf(idleTime), String.valueOf(this.activePool.size()), String.valueOf(this.idlePool.size()), String.valueOf(this.blockedThreadPool.size())});
                    }
                    if (--deleteCount != 0) continue;
                    break;
                }
            }
        }
        return deleted;
    }

    private int checkBlockedPool(StringBuffer sb) {
        int blockedThreads = 0;
        Iterator it = this.blockedThreadPool.iterator();
        try {
            while (it.hasNext()) {
                RequestProcessor worker = (RequestProcessor)it.next();
                String state = worker.checkBlockedThreadState();
                if (state != null) {
                    sb.append(state + "\n");
                    ++blockedThreads;
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3253_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3253_LEVEL, JeusMessage_WebContainer2._3253, (Object[])new String[]{this.threadPoolId, worker.getThreadId(), worker.getRequestURI(), String.valueOf(this.activePool.size()), String.valueOf(this.idlePool.size()), String.valueOf(this.blockedThreadPool.size())});
                    continue;
                }
                worker.blocked = false;
                it.remove();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return blockedThreads;
    }

    public void checkThreadPool() {
        int diff;
        if (this.isDestroyed) {
            return;
        }
        int minThreadNum = this.tpoolDesc.getMinThreadNum();
        int maxThreadNum = this.tpoolDesc.getMaxThreadNum();
        int numActiveDeleted = 0;
        int numIdleDeleted = 0;
        int numCreated = 0;
        if (this.tsnDesc != null) {
            String engineName;
            WebContainerManager manager;
            numActiveDeleted = this.checkActivePool();
            numIdleDeleted = this.checkIdlePool();
            StringBuffer msg = new StringBuffer();
            int blockedThreads = this.checkBlockedPool(msg);
            if (this.tsnDesc != null && this.tsnDesc.needNotify(blockedThreads, maxThreadNum)) {
                manager = this.contextGroup.getContainerManager();
                engineName = manager.ENGINE_NAME;
                if (logger.isLoggable(JeusMessage_WebContainer2._3319_LEVEL)) {
                    logger.sendEmailNotification(JeusMessage_WebContainer2._3319_LEVEL, this.tsnDesc.getNotifySubject(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3319, (Object[])new String[]{engineName, this.threadPoolId, msg.toString()}));
                }
            }
            if (this.tsnDesc != null && this.tsnDesc.needRestart(blockedThreads, maxThreadNum)) {
                manager = this.contextGroup.getContainerManager();
                engineName = manager.ENGINE_NAME;
                String restartMsg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3320, (Object[])new String[]{engineName, this.threadPoolId, msg.toString()});
                logger.log(JeusMessage_WebContainer2._3320_LEVEL, restartMsg);
                if (logger.isLoggable(JeusMessage_WebContainer2._3320_LEVEL)) {
                    logger.sendEmailNotification(JeusMessage_WebContainer2._3320_LEVEL, this.tsnDesc.getRestartSubject(), restartMsg);
                }
                manager.restartEngine(this.contextGroup.getGroupName());
            }
        } else {
            numIdleDeleted = this.checkIdlePool();
        }
        int activeSize = this.activePool.size();
        int idleSize = this.idlePool.size();
        int size = activeSize + idleSize;
        if (size < minThreadNum && (diff = minThreadNum - size) > 0) {
            numCreated = this.createThreads(diff);
        }
        if (numActiveDeleted > 0) {
            this.createThreads(numActiveDeleted);
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3258_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3258_LEVEL, JeusMessage_WebContainer2._3258, (Object[])new String[]{this.threadPoolId, String.valueOf(numActiveDeleted), String.valueOf(numIdleDeleted), String.valueOf(numCreated), String.valueOf(this.activePool.size()), String.valueOf(this.idlePool.size()), String.valueOf(this.blockedThreadPool.size())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.poolSync;
        synchronized (object) {
            this.isDestroyed = true;
            this.terminateProcessors(this.activePool);
            this.terminateProcessors(this.idlePool);
        }
    }

    private void terminateProcessors(Vector processors) {
        if (processors == null) {
            return;
        }
        Enumeration e = processors.elements();
        while (e.hasMoreElements()) {
            RequestProcessor worker = (RequestProcessor)e.nextElement();
            worker.terminate();
        }
    }

    public Vector getThreadState(int mode) {
        Vector allWorkersCopy = new Vector();
        allWorkersCopy.addAll(this.activePool);
        allWorkersCopy.addAll(this.idlePool);
        allWorkersCopy.addAll(this.blockedThreadPool);
        return this.getThreadState(allWorkersCopy, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessorInActivePool(Ajp13RequestProcessor processor) {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isDestroyed) {
                return;
            }
            int size = this.activePool.size();
            if (size > 0) {
                try {
                    for (int i = 0; i < size; ++i) {
                        RequestProcessor worker = (RequestProcessor)this.activePool.get(i);
                        if (worker != processor) continue;
                        this.activePool.remove(worker);
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

