/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletException;
import javax.xml.bind.JAXBException;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentDescriptorProcessor;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;
import jeus.container.namingenv.JndiEnvironmentRefsGroup;
import jeus.container.namingenv.NamingEnvManager;
import jeus.container.namingenv.NamingEnvironment;
import jeus.deploy.InvalidDescriptorException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.descriptor.sessionmanager.CentralSessionManagerDescriptor;
import jeus.descriptor.sessionmanager.DistributedSessionManagerDescriptor;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.security.base.Domain;
import jeus.security.base.Policy;
import jeus.security.container.web.ServletSecurity;
import jeus.servlet.deployment.ConfigUtil;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextParamDescriptor;
import jeus.servlet.deployment.descriptor.ServletDescriptor;
import jeus.servlet.deployment.descriptor.SessionCookieDescriptor;
import jeus.servlet.deployment.descriptor.SessionDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.deployment.descriptor.WebCommonDescriptor;
import jeus.servlet.deployment.descriptor.bind.ContextDescriptorJB;
import jeus.servlet.engine.ContextEnvironment;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.RequestDispatcherImpl;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.engine.ServletConfigImpl;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.engine.ServletMapper;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.engine.VirtualHost;
import jeus.servlet.jsp.JspConfig;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.compiler.JavaCompiler;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.servlet.jsp.compiler.batch.CompileContext;
import jeus.servlet.jsp.resource.JspResourceProvider;
import jeus.servlet.jsp2.EmbeddedServletOptions;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.JspCompilationContext;
import jeus.servlet.jsp2.compiler.Compiler;
import jeus.servlet.jsp2.compiler.JspRuntimeContext;
import jeus.servlet.jsp2.runtime.JspApplicationContextImpl;
import jeus.servlet.listener.ListenerManager;
import jeus.servlet.loader.ClassLoadManager;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.JspReloader;
import jeus.servlet.loader.ResourceCache;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.ContextProperties;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.FileUtil;
import jeus.servlet.util.MimeMap;
import jeus.servlet.util.URLResolver;
import jeus.sessionmanager.JkRouter;
import jeus.sessionmanager.LifeCycle;
import jeus.sessionmanager.SessionManager;
import jeus.sessionmanager.SessionManagerFactory;
import jeus.sessionmanager.WebSessionConfigImpl;
import jeus.sessionmanager.central.CentralSessionManager;
import jeus.sessionmanager.central.CentralWebSessionFactory;
import jeus.sessionmanager.distributed.DistributableWebSessionFactory;
import jeus.sessionmanager.distributed.DistributedJkRouter;
import jeus.sessionmanager.distributed.DistributedSessionManager;
import jeus.sessionmanager.util.SecureSessionIdGenerator;
import jeus.sessionmanager.util.SerializedObjectTable;
import jeus.util.ErrorMsgManager;
import jeus.util.ExecutionContext;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.Runner;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.webservices.spi.EWSProvider;
import jeus.xml.binding.BindingHelper;
import jeus.xml.binding.j2ee.LocaleEncodingMappingListType;
import jeus.xml.binding.j2ee.LocaleEncodingMappingType;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.SessionConfigType;
import jeus.xml.binding.jeusDD.UserLogType;
import jeus.xml.binding.jeusDD.WebComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements ServletContext {
    public static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    public static final Enumeration EMPTY_VECTOR_ENUMERATION = Collections.enumeration(Collections.EMPTY_LIST);
    public static final String WAR_JSPWORK = ".warjspwork";
    public static final String TMP_DIR = "javax.servlet.context.tempdir";
    public static final long WRITE_LOCK_TIMEOUT = 30000L;
    private static final String SERVLET_ENGINE_INFO = "Jeus Web Container";
    private static final int SERVLET_MAJOR_VERSION = 2;
    private static final int SERVLET_MINOR_VERSION = 5;
    private static final String DEFAULT_SESSION_MANAGER_SCOPE = "servlet-" + SecureSessionIdGenerator.generateId();
    private boolean isWebAdmin = false;
    public int currentRequestNum = 0;
    public long processingTime = 0L;
    private ServletManager servletManager;
    private ListenerManager listenerManager;
    private SessionManager sessionManager;
    private NamingEnvManager namingEnvManager;
    private ContextDescriptor contextDesc;
    private ContextType webDD;
    private WebAppDescriptor webAppDesc;
    private WebAppDescriptor preConfiguredWebDesc;
    private SessionDescriptor sessionDesc;
    private NamingEnvironment namingEnvironment;
    private EnvironmentContext envContext;
    private ContextEnvironment environment;
    private final ReentrantReadWriteLock rRWlock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rRWlock.readLock();
    private final Lock writeLock = this.rRWlock.writeLock();
    private boolean shutdown;
    private WebModule webModule;
    private ClassLoader parentClassLoader;
    private ContextLoader contextLoader;
    private Policy thisPolicy;
    private Aliasing aliasing;
    private JspResourceProvider resourceProvider;
    private ContextProperties contextProperties;
    private JeusLogger userLogger = null;
    private VirtualHost virtualHost = null;
    private URL ctxDocBase = null;
    private MimeMap mimeMap = new MimeMap();
    private Hashtable contextParams = null;
    private Hashtable tagLibs = null;
    private Hashtable errorPages = null;
    private Hashtable jspConfigParams = null;
    private Hashtable attributes = new Hashtable();
    private HashMap localeEncodingMapCache;
    private HashMap execContextParamMap = new HashMap();
    private Map serviceEndpointInterfaceMap;
    private Vector welcomeFiles = null;
    private Vector addedClassPath = null;
    private Vector<String> libraries = null;
    private SerializedObjectTable serAttributes;
    private String sessionManagerLifeCycle = DEFAULT_SESSION_MANAGER_SCOPE;
    private String servletContextName = null;
    private String bindingName;
    private String policyID;
    private String contextName;
    private String contextPath;
    private String docBase;
    private int age = 0;
    private boolean isFastDeploy = false;
    private boolean isJsfApplication = false;

    public Context(VirtualHost virtualHost, ContextDescriptor desc) throws StartingException {
        this.contextDesc = desc;
        this.virtualHost = virtualHost;
        if (virtualHost.getVirtualHostProperties() != null) {
            this.contextProperties = new ContextProperties(virtualHost.getVirtualHostProperties().properties);
            this.contextProperties.init(this.contextDesc.getProperties());
        }
        this.isWebAdmin = false;
        this.initParameters(this.isWebAdmin);
    }

    protected Context(VirtualHost virtualHost, ContextDescriptor desc, boolean isWebAdmin) throws StartingException {
        this.contextDesc = desc;
        this.virtualHost = virtualHost;
        if (virtualHost.getVirtualHostProperties() != null) {
            this.contextProperties = new ContextProperties(virtualHost.getVirtualHostProperties().properties);
            this.contextProperties.init(this.contextDesc.getProperties());
        }
        this.isWebAdmin = isWebAdmin;
        this.initParameters(isWebAdmin);
    }

    private void initParameters(boolean isWebAdmin) throws StartingException {
        if (this.contextDesc == null) {
            throw new StartingException(JeusMessage_WebContainer2._3390);
        }
        this.serAttributes = this.contextProperties.PERSISTENT_CONTEXT_ATTRIBUTE.value ? SerializedObjectTable.getSerializedObjectTable(true) : null;
        this.contextName = this.contextDesc.getContextName();
        this.contextPath = this.contextDesc.getContextPath();
        if (this.contextPath != null && this.contextPath.length() > 1 && this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath.substring(0, this.contextPath.length() - 1);
        }
        this.docBase = this.contextDesc.getDocBase();
        if (this.docBase == null || this.docBase.equals("")) {
            new StartingException("Docbase must be set with a absolute path:" + this.docBase);
        }
        if (this.docBase != null && this.docBase.length() > 1 && this.docBase.endsWith(File.separator)) {
            this.docBase = this.docBase.substring(0, this.docBase.length() - 1);
        }
        this.addedClassPath = this.contextDesc.getAddedClassPath();
        this.libraries = this.contextDesc.getLibraries();
        this.jspConfigParams = (Hashtable)this.virtualHost.getJSPConfig().clone();
        this.bindingName = "_" + this.virtualHost.getContextGroup().getGroupName() + "/" + this.contextName;
        this.shutdown = false;
    }

    private void initJspConfigParameter(boolean isWebAdmin) {
        Hashtable localJspConf = this.contextDesc.getJspConfig();
        String jspWorkDirOfWebDd = null;
        String compileOutputDirOfWebDd = null;
        if (localJspConf != null) {
            Enumeration enum1 = localJspConf.keys();
            while (enum1.hasMoreElements()) {
                String attr = (String)enum1.nextElement();
                String value = (String)localJspConf.get(attr);
                if (!value.equals("") && (attr.equals("JspWorkDir") || attr.equals("CompileOutputDir"))) {
                    if (!value.endsWith(File.separator)) {
                        value = value + File.separator;
                    }
                    value = FileUtil.isAbsolutePath(value) ? value + this.getJspWorkDir() : this.docBase + File.separator + value + this.getJspWorkDir();
                    this.jspConfigParams.put(attr, value);
                    if (attr.equals("JspWorkDir")) {
                        jspWorkDirOfWebDd = value;
                        continue;
                    }
                    compileOutputDirOfWebDd = value;
                    continue;
                }
                this.jspConfigParams.put(attr, value);
            }
            if (jspWorkDirOfWebDd != null && compileOutputDirOfWebDd != null) {
                return;
            }
        }
        String jspWorkDirOfContextGroup = null;
        String defaultJspWorkDir = null;
        if (jspWorkDirOfWebDd == null) {
            jspWorkDirOfContextGroup = this.getJspDirParamFromContextGroup("JspWorkDir");
            if (jspWorkDirOfContextGroup == null) {
                defaultJspWorkDir = this.getDefaultJspDirParam("JspWorkDir", isWebAdmin);
                this.jspConfigParams.put("JspWorkDir", defaultJspWorkDir);
            } else {
                this.jspConfigParams.put("JspWorkDir", jspWorkDirOfContextGroup);
            }
        }
        String compileOutputDirOfContextGroup = null;
        if (compileOutputDirOfWebDd == null) {
            if (jspWorkDirOfWebDd != null) {
                this.jspConfigParams.put("CompileOutputDir", jspWorkDirOfWebDd);
            } else {
                compileOutputDirOfContextGroup = this.getJspDirParamFromContextGroup("CompileOutputDir");
                if (compileOutputDirOfContextGroup != null) {
                    this.jspConfigParams.put("CompileOutputDir", compileOutputDirOfContextGroup);
                    this.jspConfigParams.put("useContextGroupDir", new Boolean(true));
                } else if (jspWorkDirOfContextGroup != null) {
                    this.jspConfigParams.put("CompileOutputDir", jspWorkDirOfContextGroup);
                    this.jspConfigParams.put("useContextGroupDir", new Boolean(true));
                } else {
                    this.jspConfigParams.put("CompileOutputDir", defaultJspWorkDir);
                }
            }
        }
    }

    private String getJspDirParamFromContextGroup(String key) {
        String value;
        Hashtable jspConfigOfWebMain = this.virtualHost.getContextGroup().getContextGroupDescriptor().getJspConfig();
        if (jspConfigOfWebMain != null && (value = (String)jspConfigOfWebMain.get(key)) != null) {
            if (!value.endsWith(File.separator)) {
                value = value + File.separator;
            }
            value = value + this.getJspWorkDir();
            return value;
        }
        return null;
    }

    private String getDefaultJspDirParam(String key, boolean isWebAdmin) {
        if (this.contextDesc.isWarDeploy()) {
            return this.getDefaultJspWorkDir();
        }
        Hashtable jspConfigOfVirutualHost = this.virtualHost.getJSPConfig();
        String value = (String)jspConfigOfVirutualHost.get(key);
        if (value != null) {
            String base = ContextGroup.convertSpecialCharacter(this.contextName);
            base = base + File.separator;
            if ((this.contextPath.equals("") || this.contextPath.equals("/")) && isWebAdmin) {
                base = "";
            }
            value = value + base;
            return value;
        }
        return value;
    }

    private void initLogger() {
        block3: {
            if (this instanceof CompileContext) {
                return;
            }
            UserLogType ulog = this.contextDesc.getLogging();
            try {
                this.userLogger = ConfigUtil.configureWebDDUserLog(ulog, this.virtualHost.getContextGroup().getGroupName(), this.contextName);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3853_LEVEL)) break block3;
                logger.log(JeusMessage_WebContainer2._3853_LEVEL, JeusMessage_WebContainer2._3853, (Object)this.contextName, t);
            }
        }
    }

    private void initSessionDescriptor() {
        ContextGroup contextGroup = this.virtualHost.getContextGroup();
        SessionConfigType ctxSessionDescType = null;
        if (this.contextDesc instanceof ContextDescriptorJB) {
            ctxSessionDescType = ((ContextDescriptorJB)this.contextDesc).getSessionDescType();
        }
        SessionConfigType ctxGroupSessionDescType = contextGroup.getContextGroupDescriptor().getSessionDescType();
        SessionConfigType webContainerSessionDescType = contextGroup.getContainerManager().getWebContainerDescriptor().getSessionDescType();
        this.sessionDesc = SessionDescriptor.getSessionDescriptor(ctxSessionDescType, ctxGroupSessionDescType, webContainerSessionDescType);
        if (logger.isLoggable(JeusMessage_WebContainer2._3857_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3857_LEVEL, JeusMessage_WebContainer2._3857, (Object[])new String[]{this.contextName, this.sessionDesc.toString()});
        }
    }

    public void init(boolean configByXML, WebAppDescriptor webDesc, Policy appPolicy, ClassLoader classloader, WebModule webModule) throws StartingException {
        this.thisPolicy = appPolicy;
        this.webModule = webModule;
        this.initJspConfigParameter(this.isWebAdmin);
        this.initLogger();
        this.initSessionDescriptor();
        if (webModule != null) {
            this.webModule.setContext(this);
        }
        this.parentClassLoader = classloader;
        this.preConfiguredWebDesc = webDesc;
        try {
            this.ctxDocBase = URLResolver.resolve(this.docBase);
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3391_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3391_LEVEL, JeusMessage_WebContainer2._3391, (Object[])new String[]{this.contextName, this.docBase}, (Throwable)ex);
            }
            throw new StartingException(JeusMessage_WebContainer2._3391, new String[]{this.contextName, this.docBase});
        }
        this.init0();
        if (logger.isLoggable(JeusMessage_WebContainer2._3406_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3406_LEVEL, JeusMessage_WebContainer2._3406, (Object)this.contextName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init0() throws StartingException {
        EWSProvider provider;
        File warjspworkDir;
        this.execContextParamMap.put("jeus.app.name", this.contextName);
        this.execContextParamMap.put("jeus.jndi.enc.prefix", this.bindingName);
        AbstractArchive archive = null;
        try {
            archive = FileArchiveFactory.openArchiveStatic((String)this.docBase);
            if (archive instanceof FileArchive && this.webModule != null) {
                this.webModule.setRootArchive((FileArchive)archive);
            }
        }
        catch (IOException ex) {
            throw new StartingException(ex);
        }
        File tmpDir = new File(this.docBase + File.separator + "WEB-INF" + File.separator + "tempdir");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        Hashtable hashtable = this.attributes;
        synchronized (hashtable) {
            this.attributes.put(TMP_DIR, tmpDir);
        }
        File classesDir = new File(this.docBase + File.separator + "WEB-INF" + File.separator + "classes");
        if (!classesDir.exists()) {
            classesDir.mkdirs();
        }
        if ((warjspworkDir = new File(this.docBase + File.separator + "WEB-INF" + File.separator + WAR_JSPWORK)).exists()) {
            File workDir = new File((String)this.jspConfigParams.get("JspWorkDir"));
            File outputDir = new File((String)this.jspConfigParams.get("CompileOutputDir"));
            if (!workDir.exists()) {
                workDir.mkdirs();
            }
            try {
                FileUtils.copyDirectoryWithExtension((File)warjspworkDir, (File)workDir, (String)".java");
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            try {
                FileUtils.copyDirectoryWithExtension((File)warjspworkDir, (File)outputDir, (String)".class");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        ClassLoadManager loadManager = this.virtualHost.getContextGroup().getContainerManager().getClassLoadManager();
        this.contextLoader = this.parentClassLoader == null ? loadManager.createContextLoader(this.ctxDocBase, this) : loadManager.createContextLoader(this.ctxDocBase, this, this.parentClassLoader);
        if (this.preConfiguredWebDesc != null) {
            this.webAppDesc = this.preConfiguredWebDesc;
        } else {
            try {
                this.webAppDesc = this.readWebConfigByXML();
            }
            catch (Exception e) {
                if (e instanceof StartingException) {
                    throw (StartingException)((Object)e);
                }
                throw new StartingException(e);
            }
        }
        Hashtable table = this.webAppDesc.getServletDescriptors();
        if (table != null) {
            for (ServletDescriptor servletDesc : table.values()) {
                String servletClass = servletDesc.getServletClass();
                if (!"javax.faces.webapp.FacesServlet".equals(servletClass)) continue;
                this.isJsfApplication = true;
                break;
            }
        }
        this.contextDesc = this.getBindedDescriptor(this.contextDesc);
        this.aliasing = new Aliasing(this.contextDesc);
        if (this.webModule != null && this.webModule.isFastDeploy()) {
            this.isFastDeploy = true;
        } else if (this.webDD != null && this.webDD.isSetFastDeploy()) {
            this.isFastDeploy = this.webDD.isFastDeploy();
        } else if (this.contextDesc.isFastDeploy() != null) {
            this.isFastDeploy = this.contextDesc.isFastDeploy();
        }
        boolean isKeepGenerated = false;
        if (this.webModule != null && this.webModule.isKeepGenerated()) {
            isKeepGenerated = true;
        } else if (this.webDD != null && this.webDD.isSetKeepGenerated()) {
            isKeepGenerated = this.webDD.isKeepGenerated();
        } else if (this.contextDesc.isKeepGenerated() != null) {
            isKeepGenerated = this.contextDesc.isKeepGenerated();
        }
        if (this.contextDesc.getJspResource() != null && this.contextDesc.getJspResource().isSetProviderClass()) {
            String providerClassName = this.contextDesc.getJspResource().getProviderClass();
            try {
                if (this.contextLoader != null) {
                    Class providerClass = this.contextLoader.loadClass(providerClassName);
                    this.resourceProvider = (JspResourceProvider)providerClass.newInstance();
                    this.resourceProvider.addJspResourceListener(this.servletManager);
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5693_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5693_LEVEL, JeusMessage_WebContainer5_4._5693, (Object)providerClassName);
                    }
                }
            }
            catch (Exception e) {
                this.resourceProvider = null;
                if (logger.isLoggable(JeusMessage_WebContainer5_4._5694_LEVEL)) {
                    logger.log(JeusMessage_WebContainer5_4._5694_LEVEL, JeusMessage_WebContainer5_4._5694, (Object)providerClassName, (Throwable)e);
                }
                throw new StartingException(JeusMessage_WebContainer5_4._5694, (Throwable)e);
            }
        }
        this.initLocaleEncoding();
        if (this.webModule != null) {
            try {
                this.webModule.initPersistenceUnits();
            }
            catch (Exception ex) {
                throw new StartingException("Exception occurred during initializing persistence units", (Throwable)ex);
            }
        }
        try {
            provider = EWSProvider.getProvider();
            if (provider != null) {
                provider.preDeploy(this.webModule, this, this.isFastDeploy, isKeepGenerated);
            }
        }
        catch (Exception e) {
            throw new StartingException(e.getMessage(), (Throwable)e);
        }
        WebAppContextSwitch.preContextSwitch(this.contextLoader);
        try {
            this.initNamingEnvManager();
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
        this.environment = new ContextEnvironment(this.webAppDesc, this);
        if (JeusPropertyValues.JEUS_CATEGORY == 1 || JeusPropertyValues.JEUS_CATEGORY == 2) {
            this.initSecurityEnvironment(this.thisPolicy);
        }
        try {
            provider = EWSProvider.getProvider();
            if (provider != null) {
                provider.processServiceRefs(this.webModule, this.isFastDeploy, isKeepGenerated, this.webDD, this);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new StartingException("cannot deploy service-refs in context '" + this.servletContextName + "'");
        }
        try {
            if (archive != null) {
                archive.close();
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private WebAppDescriptor readWebConfigByXML() throws Exception {
        String configPath;
        boolean isSystemConfig = false;
        String myConfigPath = this.docBase;
        String systemConfigPath = this.virtualHost.getContextGroup().getContainerManager().CONFIG_DIR;
        if (myConfigPath != null && !myConfigPath.endsWith(File.separator)) {
            myConfigPath = myConfigPath + File.separator;
        }
        if (systemConfigPath != null && !systemConfigPath.endsWith(File.separator)) {
            systemConfigPath = systemConfigPath + File.separator;
        }
        if (myConfigPath != null && myConfigPath.startsWith("file:")) {
            myConfigPath = myConfigPath.substring(5);
        }
        if (systemConfigPath != null && systemConfigPath.startsWith("file:")) {
            systemConfigPath = systemConfigPath.substring(5);
        }
        File myConfigFile = new File(myConfigPath + "WEB-INF" + File.separator + "web.xml");
        File systemConfigFile = new File(systemConfigPath + "web.xml");
        if (myConfigFile.exists()) {
            configPath = myConfigPath;
            File configFile = myConfigFile;
            isSystemConfig = false;
        } else {
            configPath = systemConfigPath;
            File configFile = systemConfigFile;
            isSystemConfig = true;
            if (!configFile.exists()) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3467_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3467_LEVEL, JeusMessage_WebContainer2._3467, (Object)this.contextName);
                }
                return new WebAppDescriptor();
            }
        }
        WebAppDescriptor desc = ConfigUtil.readWebAppDescriptor(configPath, isSystemConfig);
        if (logger.isLoggable(JeusMessage_WebContainer2._3392_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3392_LEVEL, JeusMessage_WebContainer2._3392, (Object[])new String[]{this.contextName, configPath});
        }
        return desc;
    }

    private ContextDescriptor getBindedDescriptor(ContextDescriptor _contextDesc) {
        WebRuntimeDDFile webDDFile;
        AbstractArchive docArchive;
        if (_contextDesc instanceof ContextDescriptorJB) {
            this.webDD = ((ContextDescriptorJB)_contextDesc).getElement();
            return _contextDesc;
        }
        try {
            docArchive = FileArchiveFactory.openArchiveStatic((String)this.docBase);
            webDDFile = new WebRuntimeDDFile(this.contextName);
            if (webDDFile.existsDescriptorFile(docArchive)) {
                this.webDD = (ContextType)webDDFile.getDeploymentDescriptor(docArchive);
            }
        }
        catch (IOException e) {
        }
        catch (JAXBException e) {
            // empty catch block
        }
        if (this.webDD == null) {
            try {
                docArchive = FileArchiveFactory.openArchiveStatic((String)this.docBase);
                webDDFile = new WebRuntimeDDFile(this.contextName);
                if (webDDFile.existsDescriptorFile(docArchive)) {
                    this.webDD = (ContextType)webDDFile.getDeploymentDescriptor(docArchive);
                }
            }
            catch (IOException e1) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3700_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3700_LEVEL, JeusMessage_WebContainer2._3700, (Throwable)e1);
                }
                return _contextDesc;
            }
            catch (JAXBException e) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3700_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3700_LEVEL, JeusMessage_WebContainer2._3700, (Throwable)e);
                }
                return _contextDesc;
            }
            if (this.webDD == null) {
                return _contextDesc;
            }
        }
        try {
            ContextDescriptorJB contextDescJB = new ContextDescriptorJB();
            contextDescJB.setDescritpor(_contextDesc);
            contextDescJB.setElement(this.webDD);
            return contextDescJB;
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3700_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3700_LEVEL, JeusMessage_WebContainer2._3700, (Throwable)e);
            }
            e.printStackTrace();
            return _contextDesc;
        }
    }

    private void initLocaleEncoding() {
        WebAppType _webApp;
        if (this.localeEncodingMapCache == null) {
            this.localeEncodingMapCache = new HashMap();
        }
        if ((_webApp = this.webAppDesc.getWebApp()) == null) {
            return;
        }
        Object _obj = BindingHelper.getSubFirstElement(_webApp.getDescriptionAndDisplayNameAndIcon(), LocaleEncodingMappingListType.class);
        if (_obj == null) {
            return;
        }
        LocaleEncodingMappingListType leMapList = (LocaleEncodingMappingListType)_obj;
        List _localList = leMapList.getLocaleEncodingMapping();
        if (_localList == null) {
            return;
        }
        for (Object item : _localList) {
            LocaleEncodingMappingType _locale = (LocaleEncodingMappingType)item;
            if (_locale == null) continue;
            this.localeEncodingMapCache.put(_locale.getLocale(), _locale.getEncoding());
        }
    }

    private void initNamingEnvManager() {
        NamingEnvManager namingEnvManager = new NamingEnvManager();
        namingEnvManager.setEnvRoot(ExecutionContext.getExecutionContext().getENCJndiPrefix());
        NamingEnvironment namingEnvironment = new NamingEnvironment();
        namingEnvManager.setNamingEnvironment(namingEnvironment);
        this.namingEnvManager = namingEnvManager;
        this.namingEnvironment = namingEnvironment;
    }

    private void initSecurityEnvironment(Policy appPolicy) {
        block8: {
            String _policy = this.bindingName;
            try {
                WebAppType webApp = this.webAppDesc.getWebApp();
                if (webApp != null && this.webDD != null) {
                    this.policyID = this.contextName;
                    if (appPolicy != null) {
                        ServletSecurity.addServletPolicyToApp(this.policyID, webApp, this.webDD, appPolicy, this.webModule.getDomainName());
                    } else {
                        ServletSecurity.addServletPolicy(this.policyID, webApp, this.webDD, Domain.DEFAULT_APPLICATION_DOMAIN_NAME);
                    }
                } else if (logger.isLoggable(JeusMessage_WebContainer2._3713_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3713_LEVEL, JeusMessage_WebContainer2._3713, (Object)_policy);
                }
                if (this.environment != null) {
                    this.environment.initSecurityEnvironment();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!logger.isLoggable(JeusMessage_WebContainer2._3712_LEVEL)) break block8;
                logger.log(JeusMessage_WebContainer2._3712_LEVEL, JeusMessage_WebContainer2._3712, (Object)_policy);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execStart() throws StartingException {
        try {
            if (!this.writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) throw new StartingException("failed to execStart() because of timeout");
            try {
                boolean bl = !this.shutdown && this.doStart();
                return bl;
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3481_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3481_LEVEL, JeusMessage_WebContainer2._3481, (Object)this.contextName, t);
                }
                if (!(t instanceof StartingException)) throw new StartingException(t.getMessage(), t);
                throw (StartingException)((Object)t);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new StartingException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execResume() {
        if (!this.writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) return false;
        try {
            boolean bl = !this.shutdown && this.contextLoader.resumeServlets();
            this.writeLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.writeLock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execSuspend() {
        if (!this.writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) return false;
        try {
            boolean bl = !this.shutdown && this.contextLoader.suspendServlets();
            this.writeLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.writeLock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean execReload() {
        try {
            this.doReload();
        }
        catch (StartingException e) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3483_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3483_LEVEL, JeusMessage_WebContainer2._3483, (Object)this.contextName, (Throwable)((Object)e));
            }
            return false;
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3482_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3482_LEVEL, JeusMessage_WebContainer2._3482, (Object)this.contextName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execTerminate() {
        block16: {
            long shutdownTimeout = this.virtualHost.getContextGroup().getContainerManager().getWebContainerDescriptor().getShutdownTimeout();
            if (shutdownTimeout < 0L) {
                shutdownTimeout = 30000L;
            }
            try {
                if (!this.writeLock.tryLock(shutdownTimeout, TimeUnit.MILLISECONDS)) break block16;
                try {
                    block17: {
                        if (this.shutdown) {
                            return;
                        }
                        this.shutdown = true;
                        this.doStop(false);
                        if (this.policyID != null && this.thisPolicy == null) {
                            try {
                                ServletSecurity.removeServletPolicy(this.policyID, Domain.DEFAULT_APPLICATION_DOMAIN_NAME);
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggable(JeusMessage_WebContainer2._3714_LEVEL)) break block17;
                                logger.log(JeusMessage_WebContainer2._3714_LEVEL, JeusMessage_WebContainer2._3714, (Object)this.policyID, (Throwable)ex);
                            }
                        }
                    }
                    this.virtualHost.removeContext(this.contextPath);
                    if (this.userLogger != null) {
                        this.userLogger.close();
                    }
                    if (this.webModule != null) {
                        block18: {
                            try {
                                this.webModule.destroyMBean();
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(JeusMessage_WebContainer2._3704_LEVEL)) break block18;
                                logger.log(JeusMessage_WebContainer2._3704_LEVEL, JeusMessage_WebContainer2._3704, (Throwable)e);
                            }
                        }
                        this.webModule = null;
                    }
                    if (logger.isLoggable(JeusMessage_WebContainer2._3402_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3402_LEVEL, JeusMessage_WebContainer2._3402, (Object)this.contextName);
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStart() throws StartingException {
        boolean batch = this instanceof CompileContext;
        WebAppContextSwitch.preContextSwitch(this.contextLoader);
        try {
            WebComponentType webComponentType;
            Object componentType2;
            this.listenerManager = new ListenerManager(this, this.contextLoader);
            this.servletManager = new ServletManager(this, this.contextLoader);
            this.servletManager.init();
            this.configureWebCommon(this.virtualHost.getContextGroup().getWebCommonDescriptor());
            this.configureWebCommon(this.webAppDesc.getWebCommonDescriptor());
            this.configureWebApp(this.webModule);
            if (this.webModule != null && (componentType2 = this.webModule.getComponentType()) instanceof WebComponentType && (webComponentType = (WebComponentType)componentType2).isSetSessionTimeout() && this.sessionDesc != null) {
                this.sessionDesc.setTimeout(webComponentType.getSessionTimeout());
            }
            if (batch) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3480_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3480_LEVEL, JeusMessage_WebContainer2._3480, (Object)this.contextName);
                }
                boolean componentType2 = true;
                return componentType2;
            }
            if (!this.webAppDesc.isSystemApp()) {
                this.initJndiEnvRefsGroup();
                this.initEnvironmentContext();
            }
            this.bindAllEntries();
            this.listenerManager.start();
            this.servletManager.filterStart();
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
        try {
            if (this.sessionManager == null) {
                this.sessionManager = this.createSessionManager();
            }
            this.setSessionManagerTimeout(this.sessionManager);
            ((LifeCycle)((Object)this.sessionManager)).start();
        }
        catch (Throwable t) {
            throw new StartingException(t);
        }
        this.preloadServlets();
        if (logger.isLoggable(JeusMessage_WebContainer2._3480_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3480_LEVEL, JeusMessage_WebContainer2._3480, (Object)this.contextName);
        }
        return true;
    }

    private SessionManager createSessionManager() throws StartingException {
        boolean lightVersion = false;
        int edition = Runner.getLicenseEdition();
        if (edition != Runner.LIC_EDITION_BASEPLUS && edition != Runner.LIC_EDITION_ENTERPRISE) {
            lightVersion = true;
        }
        SessionManager manager = null;
        ContextGroup contextGroup = this.virtualHost.getContextGroup();
        if (lightVersion) {
            manager = this.getDistributedSessionManager(contextGroup, true, true);
        } else if (!this.isSessionDistributable()) {
            manager = this.getDistributedSessionManager(contextGroup, true, false);
        } else {
            manager = this.getCentralSessionManager(contextGroup);
            if (manager == null) {
                manager = this.getDistributedSessionManager(contextGroup, false, false);
            }
            if (manager == null) {
                manager = this.getDistributedSessionManager(contextGroup, true, false);
            }
        }
        if (manager != null) {
            return manager;
        }
        throw new StartingException("failed to create a session manager in " + this.contextName);
    }

    private SessionManager getCentralSessionManager(ContextGroup contextGroup) {
        if (contextGroup == null) {
            return null;
        }
        CentralSessionManagerDescriptor managerConfig = CentralSessionManagerDescriptor.getJeusManagerConfig(contextGroup.getContainerManager().getWebContainerDescriptor());
        if (managerConfig == null) {
            managerConfig = CentralSessionManagerDescriptor.getJeusManagerConfig();
        }
        if (managerConfig == null) {
            return null;
        }
        this.sessionManagerLifeCycle = DEFAULT_SESSION_MANAGER_SCOPE;
        managerConfig.printDescriptor();
        boolean stickySession = PropertyUtil.getContainerProperties().STICKY_SESSION_IN_CENTRAL_SESSION_MANAGER.value;
        WebSessionConfigImpl sessionConfig = stickySession ? new WebSessionConfigImpl(new JkRouter(contextGroup.getSessionRoutingEngineName())) : new WebSessionConfigImpl();
        CentralSessionManager manager = (CentralSessionManager)SessionManagerFactory.createSessionManager(this.sessionManagerLifeCycle, new CentralWebSessionFactory(), sessionConfig, managerConfig, 2);
        contextGroup.getContainerManager().registerSessionManagerMBean(manager, this.sessionManagerLifeCycle);
        return manager;
    }

    private SessionManager getDistributedSessionManager(ContextGroup contextGroup, boolean isDefault, boolean lightVersion) {
        if (contextGroup == null) {
            return null;
        }
        DistributedSessionManagerDescriptor managerConfig = null;
        String engineName = contextGroup.getContainerManager().ENGINE_NAME;
        try {
            managerConfig = isDefault ? DistributedSessionManagerDescriptor.getJeusDefaultManagerConfig(engineName, false) : DistributedSessionManagerDescriptor.getJeusManagerConfig(engineName);
        }
        catch (IOException e) {
            e.printStackTrace();
            managerConfig = null;
        }
        if (managerConfig == null) {
            return null;
        }
        if (managerConfig.isDefaultConfiguration()) {
            this.sessionManagerLifeCycle = this.isSessionShared() ? this.webModule.getApplicationName() : this.contextName + "_" + this.contextPath;
            managerConfig.setServerName(engineName + '-' + DistributedSessionManagerDescriptor.normalizeSessionName(this.sessionManagerLifeCycle), null);
        } else {
            this.sessionManagerLifeCycle = DEFAULT_SESSION_MANAGER_SCOPE;
        }
        managerConfig.printDescriptor();
        DistributedSessionManager manager = (DistributedSessionManager)SessionManagerFactory.createSessionManager(this.sessionManagerLifeCycle, new DistributableWebSessionFactory(), new WebSessionConfigImpl(new DistributedJkRouter()), managerConfig, lightVersion ? 4 : 3);
        contextGroup.setSessionRoutingEngineName(manager.getLocalId().getSessionRoutingId());
        if (managerConfig.isDefaultConfiguration()) {
            contextGroup.registerSessionManagerMBean(manager, this.sessionManagerLifeCycle);
        } else {
            contextGroup.getContainerManager().registerSessionManagerMBean(manager, this.sessionManagerLifeCycle);
        }
        return manager;
    }

    private void configureWebCommon(WebCommonDescriptor webCommonDesc) {
        if (webCommonDesc != null) {
            Hashtable tmpTagLibs;
            Vector tmpWelcomeFiles;
            Hashtable mimeMappings;
            int tmpSessionTimeout = webCommonDesc.getSessionTimeout();
            if (tmpSessionTimeout != Integer.MIN_VALUE && this.sessionDesc != null) {
                this.sessionDesc.setTimeout(tmpSessionTimeout);
            }
            if ((mimeMappings = webCommonDesc.getMimeMappings()) != null) {
                Enumeration enum1 = mimeMappings.keys();
                while (enum1.hasMoreElements()) {
                    String extension = (String)enum1.nextElement();
                    String mimeType = (String)mimeMappings.get(extension);
                    this.mimeMap.addContentType(extension, mimeType);
                }
            }
            if ((tmpWelcomeFiles = webCommonDesc.getWelcomeFileList()) != null) {
                this.welcomeFiles = tmpWelcomeFiles;
            }
            this.servletManager.setWelcomeFiles(this.welcomeFiles);
            Hashtable tmpErrorPages = webCommonDesc.getErrorPages();
            if (tmpErrorPages != null) {
                this.errorPages = tmpErrorPages;
            }
            if ((tmpTagLibs = webCommonDesc.getTagLibs()) != null) {
                this.tagLibs = tmpTagLibs;
            }
        }
    }

    private void configureWebApp(WebModule webModule) {
        WebAppDescriptor commonWebAppDesc;
        this.servletContextName = this.webAppDesc.getServletContextName();
        Vector params = this.webAppDesc.getContextParams();
        if (params != null) {
            if (this.contextParams == null) {
                this.contextParams = new Hashtable();
            }
            for (int i = 0; i < params.size(); ++i) {
                ContextParamDescriptor paramDesc = (ContextParamDescriptor)params.elementAt(i);
                String name = paramDesc.getParamName();
                String value = paramDesc.getParamValue();
                this.contextParams.put(name, value);
            }
        }
        this.listenerManager.addListeners((commonWebAppDesc = this.virtualHost.getContextGroup().getCommonWebAppDescriptor()) == null ? null : commonWebAppDesc.getListenerDescriptors());
        ArrayList listenerDescs = this.webAppDesc.getListenerDescriptors();
        this.listenerManager.addListeners(listenerDescs);
        this.listenerManager.checkJsfListeners();
        HashMap filterDefs = this.webAppDesc.getFilterDefs();
        ArrayList filterMaps = this.webAppDesc.getFilterMappings();
        this.servletManager.initFilters(commonWebAppDesc == null ? null : commonWebAppDesc.getFilterDefs(), commonWebAppDesc == null ? null : commonWebAppDesc.getFilterMappings(), filterDefs, filterMaps, this.environment.getLoginFilterDef(), this.environment.getLoginFilterMaps());
        this.servletManager.initServlets(commonWebAppDesc == null ? null : commonWebAppDesc.getServletDescriptors(), commonWebAppDesc == null ? null : commonWebAppDesc.getServletMappings(), this.webAppDesc.getServletDescriptors(), this.webAppDesc.getServletMappings(), webModule);
        this.servletManager.addJspMappings();
    }

    private void initJndiEnvRefsGroup() throws StartingException {
        WebAppDescriptor webAppDesc = this.getWebAppDesc();
        JndiEnvironmentRefsGroup envRefs = new JndiEnvironmentRefsGroup();
        envRefs.simpleEnvEntryList = webAppDesc.getEnvEntryTypes();
        envRefs.ejbRefList = webAppDesc.getEjbRefTypes();
        envRefs.ejbLocalRefList = webAppDesc.getEjbLocalRefTypes();
        boolean isJaxWsServiceRef = webAppDesc.isWebApp_2_5();
        if (isJaxWsServiceRef) {
            envRefs.serviceRefList = webAppDesc.getServiceRefTypes();
        }
        envRefs.resourceRefList = webAppDesc.getResourceRefTypes();
        envRefs.resourceEnvRefList = webAppDesc.getResourceEnvRefTypes();
        envRefs.messageDestinationRefList = webAppDesc.getMessageDestinationRefTypes();
        envRefs.persistenceContextRefList = webAppDesc.getPersistenceContextRefTypes();
        envRefs.persistenceUnitRefList = webAppDesc.getPersistenceUnitRefTypes();
        envRefs.postConstructList = webAppDesc.getPostConstructTypes();
        envRefs.preDestroyList = webAppDesc.getPreDestoryTypes();
        EnvironmentDescriptorProcessor envDescProcessor = new EnvironmentDescriptorProcessor(this.namingEnvironment, this.contextLoader);
        try {
            envDescProcessor.process(envRefs);
        }
        catch (InvalidDescriptorException e) {
            throw new StartingException("Exception occurred during initializing JndiEnvRefsGroup", (Throwable)e);
        }
    }

    private void initEnvironmentContext() {
        JndiEnvironmentMappingGroup mapping = new JndiEnvironmentMappingGroup();
        mapping.setSimpleEnvMapping(this.contextDesc.getEnvType());
        mapping.setEjbRefMapping(this.contextDesc.getEjbRefType());
        mapping.setResRefMapping(this.contextDesc.getResRefType());
        mapping.setResEnvMapping(this.contextDesc.getResEnvRefType());
        mapping.setMessageDistinationMapping(this.contextDesc.getMessageDestRefType());
        boolean isJaxWsServiceRef = this.webAppDesc.isWebApp_2_5();
        if (isJaxWsServiceRef) {
            mapping.setServiceRefMapping(this.contextDesc.getServiceRefType());
        }
        this.envContext = new EnvironmentContext(this.webModule, mapping);
    }

    private void bindAllEntries() {
        if (this.namingEnvManager == null) {
            return;
        }
        try {
            this.namingEnvManager.bindAllEntries(this.envContext);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (EnvironmentException e) {
            e.printStackTrace();
        }
    }

    private void setSessionManagerTimeout(SessionManager manager) {
        if (manager == null) {
            return;
        }
        int contextTimeoutSec = this.getSessionTimeoutMin() * 60;
        int managerTimeoutSec = manager.getMaxInactiveInterval();
        if (managerTimeoutSec != Integer.MAX_VALUE && this.isSessionShared()) {
            if (managerTimeoutSec > 0 && (contextTimeoutSec <= 0 || managerTimeoutSec < contextTimeoutSec)) {
                manager.setMaxInactiveInterval(contextTimeoutSec);
            }
        } else {
            manager.setMaxInactiveInterval(contextTimeoutSec);
        }
    }

    private void preloadServlets() {
        if (this.sessionManager != null) {
            this.servletManager.preloadServlets();
        }
    }

    private void parseAndCompile(String uriRoot) throws IOException, Jsp2EngineException {
        block9: {
            JspEngine jspEngine = this.servletManager.getJspEngine();
            JspConfig jspConfig = jspEngine.getJspConfig();
            String outputDir = jspConfig.getCompileOutputDir();
            String jspWorkDir = jspConfig.getJspWorkDir().getCanonicalPath();
            String argfile = outputDir + File.separator + "__argfile__";
            int parsedJspCount = 0;
            Collection jspFiles = this.scanFiles(uriRoot);
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5697_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5697_LEVEL, JeusMessage_WebContainer5_4._5697, (Object)String.valueOf(jspFiles.size()));
            }
            ServletConfigImpl servletConfig = new ServletConfigImpl(this);
            EmbeddedServletOptions options = new EmbeddedServletOptions(servletConfig, servletConfig.getServletContext());
            JspRuntimeContext runtimeContext = new JspRuntimeContext(servletConfig.getServletContext(), options);
            JspCompilationContext compCtx = new JspCompilationContext("", false, options, this, null, runtimeContext);
            Compiler jspCompiler = null;
            Iterator iter = jspFiles.iterator();
            StringBuffer listBuffer = new StringBuffer();
            while (iter.hasNext()) {
                String jspUri = ((String)iter.next()).replace('\\', '/');
                String className = JspReloader.generateClassName(this, jspUri, false);
                String javaFileName = jspWorkDir + File.separatorChar + className.replace('.', File.separatorChar) + ".java";
                new File(javaFileName).getParentFile().mkdirs();
                servletConfig.setServletName(jspUri);
                servletConfig.setServletClassName(className);
                compCtx.resetJspUri(jspUri);
                try {
                    compCtx.setClassLoader(this.contextLoader);
                    compCtx.setClassPath(this.contextLoader.getClassPath());
                    compCtx.setJspConfig(jspConfig);
                    int index = className.lastIndexOf(46);
                    compCtx.setServletClassName(className.substring(index + 1));
                    compCtx.setServletJavaFileName(javaFileName);
                    compCtx.setServletPackageName(className.substring(0, index));
                    compCtx.disableDerivedPackageName();
                    jspCompiler = compCtx.createCompiler();
                    if (!jspCompiler.isOutDated(true)) continue;
                    jspCompiler.compile(false, true);
                    listBuffer.append(javaFileName);
                    listBuffer.append('\n');
                    ++parsedJspCount;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer5_4._5702_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer5_4._5702_LEVEL, JeusMessage_WebContainer5_4._5702, (Object)jspUri, (Throwable)e);
                }
            }
            if (parsedJspCount > 0) {
                if (logger.isLoggable(JeusMessage_WebContainer5_4._5698_LEVEL)) {
                    logger.log(JeusMessage_WebContainer5_4._5698_LEVEL, JeusMessage_WebContainer5_4._5698, (Object)String.valueOf(parsedJspCount));
                }
                FileWriter writer = new FileWriter(argfile);
                writer.write(listBuffer.toString());
                ((Writer)writer).close();
                jspCompiler.initJavaCompiler(false);
                JavaCompiler javaCompiler = jspCompiler.getCompiler(this.getCompileClassPath(this.contextLoader.getClassPath()), "UTF8", outputDir, jspConfig.getCompileOption(), "@" + argfile);
                try {
                    javaCompiler.compile();
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5696_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5696_LEVEL, JeusMessage_WebContainer5_4._5696, (Object)String.valueOf(parsedJspCount));
                    }
                }
                catch (JspCompileException e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer5_4._5699_LEVEL)) break block9;
                    logger.log(JeusMessage_WebContainer5_4._5699_LEVEL, JeusMessage_WebContainer5_4._5699, (Throwable)((Object)e));
                }
            }
        }
    }

    private Collection scanFiles(String uriRoot) {
        File base = new File(uriRoot);
        Vector<String> pages = new Vector<String>();
        Vector<String> extensions = new Vector<String>();
        extensions.addElement("jsp");
        extensions.addElement("jspx");
        Stack<Object> dirs = new Stack<Object>();
        dirs.push(base);
        while (!dirs.isEmpty()) {
            String s = dirs.pop().toString();
            File f = new File(s);
            if (!f.exists() || !f.isDirectory()) continue;
            String[] files = f.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f2 = new File(s, files[i]);
                if (f2.isDirectory()) {
                    dirs.push(f2.getPath());
                    continue;
                }
                String path = f2.getPath();
                String uri = path.substring(uriRoot.length());
                String ext = files[i].substring(files[i].lastIndexOf(46) + 1);
                if (!extensions.contains(ext)) continue;
                pages.addElement(uri);
            }
        }
        return pages;
    }

    private String getCompileClassPath(String classpath) {
        String systemClassPath = null;
        try {
            systemClassPath = JeusRootClassLoader.getRootClassPaths(this.contextLoader.getParentClassLoader());
        }
        catch (Exception e) {
            systemClassPath = JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "javaee.jar";
            systemClassPath = systemClassPath + File.pathSeparator + JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "jeus.jar";
        }
        return systemClassPath + System.getProperty("path.separator") + classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReload() throws StartingException {
        block9: {
            try {
                int selfAge = this.age;
                if (this.writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) {
                    try {
                        if (this.shutdown || selfAge != this.age) {
                            return;
                        }
                        this.reload();
                        ++this.age;
                        if (this.age >= Integer.MAX_VALUE) {
                            this.age = 0;
                        }
                        break block9;
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
                throw new StartingException("failed to doReload() because of timeout");
            }
            catch (InterruptedException e) {
                throw new StartingException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void reload() throws StartingException {
        try {
            this.backupAttributesOnReload();
            if (this.sessionManager != null) {
                if (this.isSessionReloadPersistent()) {
                    this.sessionManager.backupLocalSessions(false);
                } else {
                    this.sessionManager.backupLocalSessions(true);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.doStop(true);
        this.init0();
        this.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupAttributesOnReload() {
        block8: {
            block7: {
                List notSerialized;
                if (this.serAttributes == null) break block7;
                Hashtable hashtable = this.attributes;
                synchronized (hashtable) {
                    notSerialized = this.serAttributes.serialize(this.attributes);
                }
                if (notSerialized == null) break block8;
                for (String name : notSerialized) {
                    Object value = this.attributes.remove(name);
                    if (value == null) continue;
                    ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, value);
                    if (this.listenerManager == null) continue;
                    this.listenerManager.fireContextAttributeRemovedEvent(event);
                }
                break block8;
            }
            Object file = this.attributes.get(TMP_DIR);
            this.removeAttributes(false);
            Hashtable hashtable = this.attributes;
            synchronized (hashtable) {
                this.attributes.put(TMP_DIR, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop(boolean reload) {
        if (this.resourceProvider != null && this.servletManager != null) {
            this.resourceProvider.removeJspResourceListener(this.servletManager);
            this.resourceProvider = null;
        }
        JspApplicationContextImpl.removeApplicationContext(this);
        if (this.namingEnvManager != null) {
            try {
                this.namingEnvManager.unbindAllEntries();
                this.namingEnvManager = null;
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        this.envContext = null;
        this.namingEnvironment = null;
        if (this.environment != null) {
            this.environment.destroySecurityEnvironment();
            this.environment = null;
        }
        WebAppContextSwitch.preContextSwitch(this.contextLoader);
        try {
            if (!reload && this.sessionManager != null) {
                SessionManagerFactory.destroySessionManager(this.sessionManagerLifeCycle);
                this.sessionManager = null;
            }
            if (this.servletManager != null) {
                this.servletManager.destroy();
                this.servletManager.filterStop();
                this.servletManager = null;
            }
            this.removeAttributes(reload);
            if (this.listenerManager != null) {
                this.listenerManager.stop();
                this.listenerManager = null;
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitchAndClear();
        }
        if (this.contextLoader != null) {
            this.virtualHost.getContextGroup().getContainerManager().getClassLoadManager().destroyContextLoader(this.contextLoader);
            this.contextLoader = null;
        }
        this.execContextParamMap.clear();
        this.aliasing = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAttributes(boolean reload) {
        Hashtable hashtable = this.attributes;
        synchronized (hashtable) {
            for (String name : this.attributes.keySet()) {
                Object value = this.attributes.get(name);
                if (value == null) continue;
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, value);
                if (this.listenerManager == null) continue;
                this.listenerManager.fireContextAttributeRemovedEvent(event);
            }
            this.attributes.clear();
            if (reload) {
                return;
            }
            if (this.serAttributes != null) {
                Enumeration enum1 = this.serAttributes.keys();
                while (enum1.hasMoreElements()) {
                    String name = (String)enum1.nextElement();
                    Object value = this.serAttributes.deserialize(name);
                    if (value == null) continue;
                    ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, value);
                    if (this.listenerManager == null) continue;
                    this.listenerManager.fireContextAttributeRemovedEvent(event);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean restartServlet(String servName) throws ServerException {
        try {
            if (!this.writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) throw new ServerException("failed to restartServlet() because of timeout");
            try {
                if (this.shutdown) {
                    boolean bl = false;
                    return bl;
                }
                ServletDescriptor servletDesc = this.webAppDesc.getServletDescriptor(servName);
                if (this.servletManager == null) {
                    throw new ServerException("the servlet manager must be initialized");
                }
                if (servletDesc == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3395, (Object)this.contextName));
                this.servletManager.initServlet(servletDesc, this.webAppDesc.getServletMappings(), this.webModule);
                return true;
            }
            catch (Exception se) {
                String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3396, (Object[])new String[]{this.contextName, servName});
                logger.log(JeusMessage_WebContainer2._3396_LEVEL, msg, (Throwable)se);
                if (!(se instanceof ServerException)) throw new ServerException(msg, se);
                throw (ServerException)se;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new ServerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean terminateServlet(String servName) {
        if (!this.writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) return false;
        try {
            boolean bl = !this.shutdown && this.servletManager != null && this.servletManager.terminateServlet(servName);
            this.writeLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.writeLock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public String getContextPath() {
        if (this.contextPath == null || this.contextPath.equals("/")) {
            return "";
        }
        return this.contextPath;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public Set getResourcePaths(String path) {
        URL url;
        if (path == null) {
            return null;
        }
        try {
            url = this.getResource(path);
            if (url == null) {
                return null;
            }
        }
        catch (MalformedURLException mue) {
            return null;
        }
        String realpath = url.getFile();
        if (!new File(realpath).isDirectory()) {
            HashSet<String> set = new HashSet<String>();
            set.add(path);
            return set;
        }
        if (!realpath.endsWith("/") && !realpath.endsWith("\\")) {
            realpath = realpath + File.separator;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList list = new ArrayList();
        FileUtil.listFiles(realpath, list);
        TreeSet<String> set = new TreeSet<String>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String item = (String)list.get(i);
            item = item.substring(realpath.length());
            set.add(path + item.replace(File.separatorChar, '/'));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        if (this.serAttributes != null) {
            Object obj = this.attributes.get(name);
            if (obj != null) {
                return obj;
            }
            Hashtable hashtable = this.attributes;
            synchronized (hashtable) {
                obj = this.attributes.get(name);
                if (obj != null) {
                    return obj;
                }
                obj = this.serAttributes.deserialize(name);
                if (obj != null) {
                    this.attributes.put(name, obj);
                }
                return obj;
            }
        }
        return this.attributes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (this.serAttributes != null) {
            Hashtable hashtable = this.attributes;
            synchronized (hashtable) {
                this.serAttributes.deserialize(this.attributes);
                return new Hashtable(this.attributes).keys();
            }
        }
        return new Hashtable(this.attributes).keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object object) {
        ServletContextAttributeEvent e;
        Object prev;
        if (name == null) {
            return;
        }
        if (object == null) {
            this.removeAttribute(name);
            return;
        }
        Hashtable hashtable = this.attributes;
        synchronized (hashtable) {
            prev = this.attributes.put(name, object);
            if (this.serAttributes != null && prev == null) {
                prev = this.serAttributes.deserialize(name);
            }
        }
        if (prev == null) {
            e = new ServletContextAttributeEvent((ServletContext)this, name, object);
            if (this.listenerManager != null) {
                this.listenerManager.fireContextAttributeAddedEvent(e);
            }
        } else {
            e = new ServletContextAttributeEvent((ServletContext)this, name, prev);
            if (this.listenerManager != null) {
                this.listenerManager.fireContextAttributeReplacedEvent(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object o;
        if (name == null) {
            return;
        }
        Hashtable hashtable = this.attributes;
        synchronized (hashtable) {
            o = this.attributes.remove(name);
            if (this.serAttributes != null && o == null) {
                o = this.serAttributes.deserialize(name);
            }
        }
        if (o != null) {
            ServletContextAttributeEvent e = new ServletContextAttributeEvent((ServletContext)this, name, o);
            if (this.listenerManager != null) {
                this.listenerManager.fireContextAttributeRemovedEvent(e);
            }
        }
    }

    public ServletContext getContext(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3397, (Object)path));
        }
        if (this.contextPath.equals(path)) {
            return this;
        }
        if (WebProperties.J2EE_COMPATIBLE.value) {
            return null;
        }
        return this.virtualHost.getContextByPathFromVirtualHost(path);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String filename) {
        return this.mimeMap.getContentTypeFor(filename);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRealPath(String path) {
        String realPath = null;
        if (path == null) {
            return null;
        }
        URL url = this.getAliasedPath(path = Context.normPath(path));
        if (url == null || !new File(url.getFile()).exists()) {
            try {
                url = new URL(this.ctxDocBase.getProtocol(), this.ctxDocBase.getHost(), this.ctxDocBase.getPort(), this.ctxDocBase.getFile() + path);
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        try {
            if (url == null) return realPath;
            if (url.getProtocol().equalsIgnoreCase("file")) {
                return FileUtil.patch(url.getFile());
            }
            if (!url.getProtocol().equalsIgnoreCase("http")) return realPath;
        }
        catch (Exception e) {
            // empty catch block
        }
        return realPath;
    }

    public InputStream getResourceAsStream(String path) {
        InputStream is = null;
        if (path == null) {
            return null;
        }
        try {
            URL url = this.getResource(path);
            if (url == null) {
                return null;
            }
            URLConnection con = url.openConnection();
            con.connect();
            is = con.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public URL getResource(String path) throws MalformedURLException {
        File file;
        if (path == null) {
            return null;
        }
        if (WebProperties.J2EE_COMPATIBLE.value && !path.startsWith("/")) {
            throw new MalformedURLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3711));
        }
        URL url = this.getAliasedPath(path = Context.normPath(path));
        if (url != null && new File(url.getFile()).exists()) {
            return url;
        }
        String urlpath = this.ctxDocBase.getFile() + path;
        if (!urlpath.startsWith("/")) {
            urlpath = "/" + urlpath;
        }
        if ((file = new File((url = new URL(this.ctxDocBase.getProtocol(), this.ctxDocBase.getHost(), this.ctxDocBase.getPort(), urlpath)).getFile())).exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    private URL getAliasedPath(String pathInfo) {
        if (this.aliasing != null) {
            return this.aliasing.getRealPath(pathInfo);
        }
        return null;
    }

    public static String normPath(String path) {
        if (path.indexOf(92) >= 0) {
            path = path.replace('\\', '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        RequestDispatcherImpl rd = new RequestDispatcherImpl(this);
        rd.setPath(path);
        return rd;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        ServletWrapper wrapper = null;
        if (this.servletManager != null) {
            wrapper = this.servletManager.getServletByName(name);
        }
        if (wrapper == null) {
            return null;
        }
        RequestDispatcherImpl rd = new RequestDispatcherImpl(this);
        rd.setName(name);
        return rd;
    }

    public String getServerInfo() {
        return SERVLET_ENGINE_INFO;
    }

    public void log(String msg) {
        String tid = "unknown";
        Thread t = Thread.currentThread();
        if (t instanceof RequestProcessor) {
            RequestProcessor rp = (RequestProcessor)t;
            tid = rp.getThreadId();
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3000_LEVEL) && this.userLogger != null) {
            this.userLogger.log(JeusMessage_WebContainer2._3000_LEVEL, JeusMessage_WebContainer2._3000, new Object[]{tid, msg});
        }
    }

    public String getInitParameter(String name) {
        if (this.contextParams != null) {
            return (String)this.contextParams.get(name);
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        if (this.contextParams != null) {
            return this.contextParams.keys();
        }
        return new Hashtable().keys();
    }

    public void log(String msg, Throwable t) {
        String tid = "unknown";
        Thread th = Thread.currentThread();
        if (th instanceof RequestProcessor) {
            RequestProcessor rp = (RequestProcessor)th;
            tid = rp.getThreadId();
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3000_LEVEL) && this.userLogger != null) {
            this.userLogger.log(JeusMessage_WebContainer2._3000_LEVEL, JeusMessage_WebContainer2._3000, new Object[]{tid, msg}, t);
        }
    }

    public void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        return EMPTY_VECTOR_ENUMERATION;
    }

    public Enumeration getServletNames() {
        return EMPTY_VECTOR_ENUMERATION;
    }

    public String getForcedRequestEncoding() {
        return this.contextDesc.getForcedRequestEncoding();
    }

    public String getDefaultRequestEncoding() {
        return this.contextDesc.getDefaultRequestEncoding();
    }

    public String getForcedResponseEncoding() {
        return this.contextDesc.getForcedResponseEncoding();
    }

    public String getDefaultResponseEncoding() {
        return this.contextDesc.getDefaultResponseEncoding();
    }

    public void increaseExecutionThread() {
        this.readLock.lock();
    }

    public void decreaseExecutionThread() {
        this.readLock.unlock();
    }

    public ContextDescriptor getContextDescriptor() {
        return this.contextDesc;
    }

    public VirtualHost getVirtualHost() {
        return this.virtualHost;
    }

    public String getContextName() {
        return this.contextName;
    }

    public final String getBindingName() {
        return this.bindingName;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public URL getCtxDocBase() {
        return this.ctxDocBase;
    }

    public ContextLoader getContextLoader() {
        return this.contextLoader;
    }

    public boolean isIsolatedStandalone() {
        return this.webModule != null && this.webModule.isIsolatedStandalone();
    }

    public String getWebServiceURL() {
        return this.contextDesc.getWebServiceURL();
    }

    public ContextEnvironment getContextEnvironment() {
        return this.environment;
    }

    public Set getResourcePathsAll(String path) {
        URL url;
        if (path == null) {
            return null;
        }
        try {
            url = this.getResource(path);
            if (url == null) {
                return null;
            }
        }
        catch (MalformedURLException mue) {
            return null;
        }
        String realpath = url.getFile();
        if (!new File(realpath).isDirectory()) {
            HashSet<String> set = new HashSet<String>();
            set.add(path);
            return set;
        }
        if (!realpath.endsWith("/") && !realpath.endsWith("\\")) {
            realpath = realpath + File.separator;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList list = new ArrayList();
        FileUtil.listFilesRecursively(realpath, list);
        list.remove(realpath);
        TreeSet<String> set = new TreeSet<String>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String item = (String)list.get(i);
            item = item.substring(realpath.length());
            set.add(path + item.replace(File.separatorChar, '/'));
        }
        return set;
    }

    public final String getErrorPage(String errorCode, Throwable t) {
        Throwable t2;
        String page;
        if (this.errorPages == null) {
            return null;
        }
        if (errorCode != null && (page = (String)this.errorPages.get(errorCode)) != null) {
            return page;
        }
        if (t == null) {
            return null;
        }
        Class<?> klass = t.getClass();
        String exceptionClassName = klass.getName();
        page = (String)this.errorPages.get(exceptionClassName);
        if (page != null) {
            return page;
        }
        if (exceptionClassName.equals("java.lang.Throwable")) {
            return null;
        }
        while ((klass = klass.getSuperclass()) != null && !(exceptionClassName = klass.getName()).equals("java.lang.Object")) {
            page = (String)this.errorPages.get(exceptionClassName);
            if (page == null) continue;
            return page;
        }
        if (t instanceof ServletException && (t2 = ((ServletException)t).getRootCause()) != null) {
            return this.getErrorPage(null, t2);
        }
        return null;
    }

    public Vector getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public boolean enableJSP() {
        return this.contextDesc.isJspEnable();
    }

    public Hashtable getJSPConfig() {
        return this.jspConfigParams;
    }

    public Hashtable getTaglibConfigs() {
        return this.tagLibs;
    }

    public Vector getAddedClassPath() {
        return this.addedClassPath;
    }

    public Vector<String> getLibraries() {
        return this.libraries;
    }

    public ResourceCache getResourceCache() {
        return null;
    }

    public int getMaxInstancePoolSize() {
        return this.contextDesc.getMaxInstancePoolSize();
    }

    public boolean isEarDeploy() {
        return this.contextDesc.isEarDeploy();
    }

    public boolean isWarDeploy() {
        return this.contextDesc.isWarDeploy();
    }

    public WebModule getMBean() {
        return this.webModule;
    }

    public WebAppDescriptor getWebAppDesc() {
        return this.webAppDesc;
    }

    public ServletInfo[] getAllServletInfo() {
        if (this.servletManager != null) {
            return this.servletManager.getAllServletInfo();
        }
        return new ServletInfo[0];
    }

    public ServletMapper getServletByPath(String path) {
        if (this.servletManager != null) {
            return this.servletManager.lookupServlet(path);
        }
        return null;
    }

    public ExecutionWrapper getServletByPath(HttpServletRequestImpl request) throws ServletException, FileNotFoundException {
        ExecutionWrapper wrapper = null;
        if (this.servletManager != null) {
            wrapper = this.servletManager.lookupServlet(request);
        }
        if (wrapper == null) {
            throw new FileNotFoundException("File Not Found: " + request.getRequestURI());
        }
        if (!wrapper.isResourceServlet()) {
            ++this.currentRequestNum;
        }
        return wrapper;
    }

    public ServletWrapper getServletByName(String name) {
        if (this.servletManager != null) {
            return this.servletManager.getServletByName(name);
        }
        return null;
    }

    public void clearStatistic() {
        this.currentRequestNum = 0;
        this.processingTime = 0L;
    }

    public final String getEncoding(String _languageName, String _localeFullName) {
        Object _found = this.localeEncodingMapCache.get(_languageName);
        if (_found != null) {
            return (String)_found;
        }
        _found = this.localeEncodingMapCache.get(_localeFullName);
        if (_found != null) {
            return (String)_found;
        }
        return null;
    }

    public boolean isWebApp_2_3() {
        return this.webAppDesc.isWebApp_2_3();
    }

    public String getAppPolicyID() {
        return this.policyID;
    }

    public Policy getApplicationPolicy() {
        return this.thisPolicy;
    }

    public String getDomainName() {
        if (this.thisPolicy != null && this.webModule != null) {
            return this.webModule.getDomainName();
        }
        return null;
    }

    public JspResourceProvider getJspResourceProvider() {
        return this.resourceProvider;
    }

    public boolean isJsfApplication() {
        return this.isJsfApplication;
    }

    public ContextProperties getContextProperties() {
        return this.contextProperties;
    }

    public Map getExecutionContextMap() {
        return this.execContextParamMap;
    }

    public EnvironmentContext getEnvContext() {
        return this.envContext;
    }

    public boolean isMetadataComplete() {
        return this.webAppDesc.isMetadataComplete();
    }

    public Map getServiceEndpointInterfaceMap() {
        if (this.serviceEndpointInterfaceMap == null) {
            this.serviceEndpointInterfaceMap = new HashMap();
        }
        return this.serviceEndpointInterfaceMap;
    }

    public NamingEnvManager getNamingEnvManager() {
        return this.namingEnvManager;
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void scavengeSessions(long timeStamp) {
        if (this.sessionManager != null) {
            this.sessionManager.scavenge(timeStamp);
        }
    }

    private boolean isSessionDistributable() {
        if (this.sessionDesc != null) {
            return this.sessionDesc.isDistributable();
        }
        return false;
    }

    public boolean isSessionShared() {
        if (this.sessionDesc != null) {
            return this.sessionDesc.isShared();
        }
        return false;
    }

    public int getSessionTimeoutMin() {
        if (this.sessionDesc != null) {
            return this.sessionDesc.getTimeout();
        }
        return 30;
    }

    private boolean isSessionReloadPersistent() {
        if (this.sessionDesc != null) {
            return this.sessionDesc.isReloadPersistent();
        }
        return false;
    }

    public boolean isSessionUrlRewriting() {
        if (this.sessionDesc != null) {
            return this.sessionDesc.isUrlRewriting();
        }
        return false;
    }

    public SessionCookieDescriptor getSessionCookieDescriptor() {
        if (this.sessionDesc != null) {
            return this.sessionDesc.getSessionCookie();
        }
        return null;
    }

    public String toString() {
        return super.toString() + " Context(name=" + this.contextName + ", path = " + this.contextPath + ")";
    }

    public boolean isAttachStacktrace() {
        return this.contextDesc.isAttachStacktrace();
    }

    private String getJspWorkDir() {
        return JeusManagerPropertyValues.containerName + File.separator + this.contextPath.substring(1) + File.separator;
    }

    private String getDefaultJspWorkDir() {
        if (this.webModule == null) {
            return null;
        }
        return this.webModule.getModuleGenerationDirectory().getAbsolutePath() + File.separator;
    }

    private final class Aliasing {
        private String docBasePath;
        private String[] aliasNames;
        private String[] realPaths;

        Aliasing(ContextDescriptor contextDesc) {
            Hashtable aliasList = contextDesc.getAliasing();
            if (aliasList != null && !aliasList.isEmpty()) {
                int size = aliasList.size();
                int i = 0;
                this.aliasNames = new String[size];
                this.realPaths = new String[size];
                this.docBasePath = (String)aliasList.get("//");
                Enumeration e = aliasList.keys();
                while (e.hasMoreElements()) {
                    this.aliasNames[i] = (String)e.nextElement();
                    this.realPaths[i] = (String)aliasList.get(this.aliasNames[i]);
                    ++i;
                }
            }
        }

        URL getRealPath(String pathInfo) {
            if (pathInfo == null) {
                return null;
            }
            if (this.aliasNames == null) {
                return null;
            }
            URL url = null;
            if (this.docBasePath != null) {
                try {
                    String remainPath = pathInfo.substring(1);
                    url = URLResolver.resolve(this.docBasePath + remainPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                for (int i = 0; i < this.aliasNames.length; ++i) {
                    if (!pathInfo.startsWith(this.aliasNames[i])) continue;
                    String remainPath = pathInfo.substring(this.aliasNames[i].length());
                    try {
                        url = URLResolver.resolve(this.realPaths[i] + remainPath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            return url;
        }
    }
}

