/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.ServerException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.servlet.http.HttpSession;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.ContextGroupMo;
import jeus.management.j2ee.servlet.WebModuleDeployInfo;
import jeus.security.base.Policy;
import jeus.security.util.LoginUtil;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.service.NodeListServiceMBean;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.common.WebContainerControlException;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.connection.Connector;
import jeus.servlet.connection.ConnectorFactory;
import jeus.servlet.connection.TmaxConnector;
import jeus.servlet.deployment.ConfigUtil;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.WebConfiguration;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.ResponseHeaderDescriptor;
import jeus.servlet.deployment.descriptor.VirtualHostDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.deployment.descriptor.WebCommonDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.VirtualHost;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.jsp.compiler.batch.CompileContextGroup;
import jeus.servlet.jsp.compiler.batch.CompileManager;
import jeus.servlet.loader.ResourceCache;
import jeus.servlet.property.ContextGroupProperties;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.util.SimpleTimer;
import jeus.sessionmanager.SessionMonitoring;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.logging.AccessLogger;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.jeusDD.AccessLogType;
import jeus.xml.binding.jeusDD.LoggingType;
import jeus.xml.binding.jeusDD.SessionConfigType;
import jeus.xml.binding.jeusDD.UserLogType;

public class ContextGroup
implements Serializable,
NotificationListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    private JeusLogger userLogger = null;
    private AccessLogger accessLogger = null;
    protected String sessionRoutingEngineName;
    protected ContextGroupDescriptor contextGroupDesc;
    protected String groupName;
    private String forcedRequestUrlEncoding = null;
    private String forcedRequestEncoding = null;
    private String forcedResponseEncoding = null;
    private String defaultRequestUrlEncoding = null;
    private String defaultRequestEncoding = null;
    private String defaultResponseEncoding = null;
    private boolean strictPostDataEncoding = false;
    private Hashtable jspConfig = null;
    protected boolean configByXML = true;
    private WebAppDescriptor commonWebAppDesc;
    private HashMap connectors;
    private HashMap threadPools;
    protected VirtualHost defaultHost = null;
    protected HashMap virtualHosts = new HashMap();
    protected Hashtable contextNames = new Hashtable();
    private transient WebContainerManager containerManager = null;
    private String logDir = null;
    private boolean securityOn;
    String customHeader;
    Vector customHeaderVector;
    public ContextGroupMo contextGroupMo;
    private boolean isBackupNode;
    private boolean isEnginePostBootSuccess = false;
    private int maxJspLoaderCount = 0;
    private Vector contextServlets = new Vector();
    private boolean checkJspWrapper = false;
    private int currentUsedFlag = 1;
    private ContextGroupProperties contextGroupProperties;

    public int getCurrentUsedFlag() {
        return this.currentUsedFlag;
    }

    public void addContextServlets(Hashtable servlets) {
        this.contextServlets.add(servlets);
    }

    public boolean getCheckJspWrapper() {
        return this.checkJspWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkJspWrapperCount() {
        int totalCount = 0;
        if (!this.checkJspWrapper) {
            for (int i = 0; i < this.contextServlets.size(); ++i) {
                Hashtable servlets = (Hashtable)this.contextServlets.elementAt(i);
                Enumeration wrappers = servlets.elements();
                for (int j = 0; j < servlets.size(); ++j) {
                    ServletWrapper wrapper = (ServletWrapper)wrappers.nextElement();
                    if (!(wrapper instanceof JspServletWrapper)) continue;
                    ++totalCount;
                }
            }
            if (totalCount > this.maxJspLoaderCount) {
                this.checkJspWrapper = true;
            }
            if (logger.isLoggable(JeusMessage_WebContainer2._3418_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3418_LEVEL, JeusMessage_WebContainer2._3418, (Object)new Integer(totalCount).toString());
            }
        } else {
            for (int i = 0; i < this.contextServlets.size(); ++i) {
                Hashtable servlets;
                Vector removeList = new Vector();
                Hashtable hashtable = servlets = (Hashtable)this.contextServlets.elementAt(i);
                synchronized (hashtable) {
                    Enumeration wrappers = servlets.keys();
                    while (wrappers.hasMoreElements()) {
                        Object key = wrappers.nextElement();
                        ServletWrapper wrapper = (ServletWrapper)servlets.get(key);
                        if (!(wrapper instanceof JspServletWrapper) || ((JspServletWrapper)wrapper).getUsedFlag() == this.currentUsedFlag) continue;
                        if (logger.isLoggable(JeusMessage_WebContainer2._3417_LEVEL)) {
                            logger.log(JeusMessage_WebContainer2._3417_LEVEL, JeusMessage_WebContainer2._3417, key);
                        }
                        removeList.add(key);
                    }
                    for (int k = 0; k < removeList.size(); ++k) {
                        Object removeKey = removeList.elementAt(k);
                        ServletWrapper wrapper = (ServletWrapper)servlets.remove(removeKey);
                        wrapper.getServletManager().removeServlet(wrapper);
                        wrapper.destroyServlet();
                    }
                    if (logger.isLoggable(JeusMessage_WebContainer2._3419_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3419_LEVEL, JeusMessage_WebContainer2._3419, (Object)new Integer(removeList.size()).toString());
                    }
                    continue;
                }
            }
            this.currentUsedFlag = this.currentUsedFlag == 0 ? 1 : 0;
            this.checkJspWrapper = false;
            System.gc();
            System.runFinalization();
        }
    }

    public ContextGroup(ContextGroupDescriptor desc, WebContainerManager containerManager) {
        this.containerManager = containerManager;
        this.sessionRoutingEngineName = PropertyUtil.getContainerProperties().STICKY_SESSION_ROUTE_NAME_IN_CENTRAL_SESSION_MANAGER.value;
        if (this.sessionRoutingEngineName == null || this.sessionRoutingEngineName.trim().length() == 0) {
            this.sessionRoutingEngineName = containerManager.ENGINE_NAME;
        }
        this.contextGroupDesc = desc;
        this.initParameters();
        this.logDir = JeusProperties.JEUS_LOG_HOME + File.separator + containerManager.ENGINE_NAME + File.separator + this.groupName;
        this.securityOn = containerManager.getWebContainerDescriptor().getSecuritySwitch();
        if (!containerManager.isSYSTEM_ENGINE && !(this instanceof CompileContextGroup)) {
            this.isBackupNode = EngineContainer.nodeListServiceMBean.isBackupNode();
            containerManager.addContainerBootEndListener(this);
        }
        if (containerManager.getContainerProperties() != null) {
            this.contextGroupProperties = new ContextGroupProperties(containerManager.getContainerProperties().properties);
            this.contextGroupProperties.init(this.contextGroupDesc.getProperties());
        } else {
            this.contextGroupProperties = new ContextGroupProperties(PropertyUtil.getContainerProperties().properties);
            this.contextGroupProperties.init(this.contextGroupDesc.getProperties());
        }
        this.maxJspLoaderCount = this.contextGroupProperties.MAX_JSPCOUNT.value;
    }

    private void initParameters() {
        this.groupName = this.contextGroupDesc.getGroupName();
        this.forcedRequestUrlEncoding = this.contextGroupDesc.getForcedRequestUrlEncoding();
        this.forcedRequestEncoding = this.contextGroupDesc.getForcedRequestEncoding();
        this.forcedResponseEncoding = this.contextGroupDesc.getForcedResponseEncoding();
        this.defaultRequestUrlEncoding = this.contextGroupDesc.getDefaultRequestUrlEncoding();
        this.defaultRequestEncoding = this.contextGroupDesc.getDefaultRequestEncoding();
        this.defaultResponseEncoding = this.contextGroupDesc.getDefaultResponseEncoding();
        this.strictPostDataEncoding = this.contextGroupDesc.getStrictPostDataEncoding();
        this.initCustomHeader();
    }

    private void initCustomHeader() {
        this.customHeader = null;
        ResponseHeaderDescriptor rhDesc = this.contextGroupDesc.getResponseHeaderDescriptor();
        this.customHeader = null;
        Vector v = rhDesc.getCustomHeader();
        if (v.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration enum1 = v.elements();
            while (enum1.hasMoreElements()) {
                String field = (String)enum1.nextElement();
                sb.append(field);
            }
            String hdrs = sb.toString();
            if (hdrs != null && hdrs.length() > 0) {
                this.customHeader = hdrs;
            }
        }
        this.customHeaderVector = v;
    }

    protected void initJSP() throws StartingException {
        Hashtable jspconf = this.contextGroupDesc.getJspConfig();
        jspconf = jspconf == null ? new Hashtable() : (Hashtable)jspconf.clone();
        String jspwork = (String)jspconf.get("JspWorkDir");
        String outdir = (String)jspconf.get("CompileOutputDir");
        Object webadminPrecompile = jspconf.get("jeus.servlet.jsp.precompile.webadmin");
        String base = ContextGroup.convertSpecialCharacter(this.groupName);
        base = base + File.separator;
        String jeusHome = JeusProperties.JEUS_HOME;
        if (!jeusHome.endsWith(File.separator)) {
            jeusHome = jeusHome + File.separator;
        }
        String rootdir = jeusHome + "webhome" + File.separator + JeusManagerPropertyValues.containerName + File.separator + "__jspwork" + File.separator + this.containerManager.ENGINE_NAME + File.separator;
        if (jspwork == null) {
            jspwork = rootdir + base;
        } else {
            if (!jspwork.endsWith(File.separator)) {
                jspwork = jspwork + File.separator;
            }
            if (webadminPrecompile == null) {
                jspwork = jspwork + this.containerManager.ENGINE_NAME + File.separator + base;
            }
        }
        if (outdir != null) {
            if (!outdir.endsWith(File.separator)) {
                outdir = outdir + File.separator;
            }
            if (webadminPrecompile == null) {
                outdir = outdir + this.containerManager.ENGINE_NAME + File.separator + base;
            }
        }
        jspconf.put("JspWorkDir", jspwork);
        if (outdir == null) {
            jspconf.put("CompileOutputDir", jspwork);
        } else {
            jspconf.put("CompileOutputDir", outdir);
        }
        String encoding = this.contextGroupDesc.getDefaultResponseEncoding();
        if (encoding != null) {
            jspconf.put("DefaultPageEncoding", encoding);
        }
        if ((encoding = this.contextGroupDesc.getForcedResponseEncoding()) != null) {
            jspconf.put("ForcedPageEncoding", encoding);
        }
        this.jspConfig = jspconf;
    }

    public static String convertSpecialCharacter(String input) {
        if (input == null || input.equals("")) {
            return input;
        }
        int len = input.length();
        StringBuffer output = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (!(ch >= '0' && ch <= '9' || ch == '_' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                char t = ch;
                String tt = Integer.toHexString(t);
                output.append("+").append(tt);
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public void init() throws StartingException {
        this.initJSP();
        this.readWebCommonByXML();
        new VirtualHost(this, this.contextGroupDesc.getDefaultVirtualHostDescriptor()).init(this.configByXML, !this.contextGroupDesc.isDisableDefaultContext(), this.contextGroupMo);
        Enumeration vhostDescs = this.contextGroupDesc.getVirtualHostDescriptors().elements();
        while (vhostDescs.hasMoreElements()) {
            VirtualHostDescriptor vhostDesc = (VirtualHostDescriptor)vhostDescs.nextElement();
            new VirtualHost(this, vhostDesc).init(this.configByXML, !this.contextGroupDesc.isDisableDefaultContext(), this.contextGroupMo);
        }
        this.threadPools = new HashMap();
        if (logger.isLoggable(JeusMessage_WebContainer2._3415_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3415_LEVEL, JeusMessage_WebContainer2._3415, (Object)this.groupName);
        }
    }

    final void registerContextName(String name, Context ctx) throws StartingException {
        Object dup = this.contextNames.get(name);
        if (dup != null) {
            throw new StartingException(JeusMessage_WebContainer0._1344, name);
        }
        this.contextNames.put(name, ctx);
    }

    public Context unregisterContextName(String name) {
        if (name == null || this.contextNames == null) {
            return null;
        }
        return (Context)this.contextNames.remove(name);
    }

    final void mapVirtualHost(Vector hostnames, VirtualHost vhost) throws StartingException {
        if (vhost.isDefaultVirtualHost()) {
            this.defaultHost = vhost;
            return;
        }
        Enumeration enum1 = hostnames.elements();
        while (enum1.hasMoreElements()) {
            String hostname = (String)enum1.nextElement();
            Object dup = this.virtualHosts.get(hostname);
            if (dup != null) {
                throw new StartingException(JeusMessage_WebContainer0._1345, hostname);
            }
            this.virtualHosts.put(hostname, vhost);
        }
    }

    public void initLogger() throws StartingException {
        block7: {
            LoggingType logging;
            block6: {
                if (this.containerManager.isSYSTEM_ENGINE) {
                    return;
                }
                if (this.containerManager instanceof CompileManager) {
                    return;
                }
                logging = this.contextGroupDesc.getLogging();
                AccessLogType alog = logging == null ? null : logging.getAccessLog();
                try {
                    this.accessLogger = ConfigUtil.configureAccessLog(alog, this.groupName);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3851_LEVEL)) break block6;
                    logger.log(JeusMessage_WebContainer2._3851_LEVEL, JeusMessage_WebContainer2._3851, (Object)this.groupName, t);
                }
            }
            UserLogType ulog = logging == null ? null : logging.getUserLog();
            try {
                this.userLogger = ConfigUtil.configureUserLog(ulog, this.groupName);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3852_LEVEL)) break block7;
                logger.log(JeusMessage_WebContainer2._3852_LEVEL, JeusMessage_WebContainer2._3852, (Object)this.groupName, t);
            }
        }
    }

    public void startConnector() throws StartingException {
        if (this.connectors == null) {
            this.connectors = ConnectorFactory.getConnectors(this, this.contextGroupDesc, this.threadPools, this.contextGroupMo);
        }
        Iterator iterator = this.connectors.values().iterator();
        Vector<Connector> vector = new Vector<Connector>();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            String s = connector.getListenerId();
            if (connector instanceof TmaxConnector) {
                boolean flag = false;
                for (int j = 0; j < vector.size(); ++j) {
                    TmaxConnector tmaxconnector = (TmaxConnector)vector.elementAt(j);
                    String s3 = tmaxconnector.getListenerId();
                    if (s.compareTo(s3) >= 0) continue;
                    vector.add(j, connector);
                    flag = true;
                    break;
                }
                if (flag) continue;
                vector.add(connector);
                continue;
            }
            connector.startConnector();
        }
        for (int i = 0; i < vector.size(); ++i) {
            Connector connector1 = (Connector)vector.elementAt(i);
            connector1.startConnector();
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3413_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3413_LEVEL, JeusMessage_WebContainer2._3413, (Object)this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnector(SimpleTimer timer) {
        ContextGroup contextGroup = this;
        synchronized (contextGroup) {
            if (this.connectors == null) {
                return;
            }
            for (Connector connector : this.connectors.values()) {
                connector.destroy(timer);
                connector.unregisterMBean();
            }
            this.connectors = null;
        }
    }

    protected void readWebCommonByXML() throws StartingException {
        WebAppType webApp;
        String configPath = this.containerManager.CONFIG_DIR;
        if (configPath.lastIndexOf("system_engine") != -1) {
            return;
        }
        WebDeploymentDescriptorFile file = new WebDeploymentDescriptorFile();
        String webCommonPath = configPath + File.separator + "webcommon.xml";
        try {
            webApp = (WebAppType)file.getDeploymentDescriptor(new FileInputStream(webCommonPath));
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "fail to read webcommon.xml from the path " + webCommonPath, (Throwable)e);
            } else if (logger.isLoggable(JeusMessage_WebContainer2._3967_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3967_LEVEL, JeusMessage_WebContainer2._3967, (Object)webCommonPath);
            }
            return;
        }
        this.commonWebAppDesc = WebConfiguration.configureWeb(webApp);
    }

    protected void readWebCommonBySer() {
        try {
            String configPath = this.containerManager.CONFIG_DIR;
            FileInputStream fin = new FileInputStream(new File(configPath, "webcommon.conf"));
            ObjectInputStream oin = new ObjectInputStream(fin);
            this.commonWebAppDesc = (WebAppDescriptor)oin.readObject();
            oin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getLogFile(String logTarget, String logFileName, String defaultLogFile) {
        File logFile = null;
        if (logTarget != null && logTarget.equals("file")) {
            if (logFileName != null) {
                logFileName = logFileName.trim();
            }
            if (logFileName == null || logFileName.equals("") || logFileName.equalsIgnoreCase("default")) {
                File logDirPath = new File(this.logDir);
                if (logDirPath.exists() || logDirPath.mkdirs()) {
                    logFile = new File(logDirPath, defaultLogFile);
                }
            } else if (new File(logFileName).isAbsolute()) {
                int pos;
                logFile = new File(logFileName);
                if (!logFile.exists() && (pos = logFileName.lastIndexOf(File.separator)) > 0) {
                    String dirName = logFileName.substring(0, pos);
                    new File(dirName).mkdirs();
                }
            } else {
                File logDirPath = new File(this.logDir);
                if (logDirPath.exists() || logDirPath.mkdirs()) {
                    logFile = new File(logDirPath, logFileName);
                }
            }
        }
        return logFile;
    }

    public void setContextGroupDescriptor(ContextGroupDescriptor desc) {
        this.contextGroupDesc = desc;
        this.initParameters();
    }

    public void setConfigByXML(boolean xml) {
        this.configByXML = xml;
    }

    public void setSessionTimeout(String timeout) throws WebContainerControlException {
        SessionConfigType sessionDescType = this.contextGroupDesc.getSessionDescType();
        if (sessionDescType != null) {
            try {
                sessionDescType.setTimeout(Integer.valueOf(Integer.parseInt(timeout)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean isSecurityOn() {
        return this.securityOn;
    }

    public final String getCustomHeader() {
        return this.customHeader;
    }

    public final Vector getCustomHeaderVector() {
        return this.customHeaderVector;
    }

    public WebContainerManager getContainerManager() {
        return this.containerManager;
    }

    public HashMap getConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolManager[] getThreadPoolManager(String port) {
        HashMap hashMap = this.threadPools;
        synchronized (hashMap) {
            return (ThreadPoolManager[])this.threadPools.get(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThreadPoolManager(String id) {
        HashMap hashMap = this.threadPools;
        synchronized (hashMap) {
            this.threadPools.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThreadPoolManager(String id, ThreadPoolManager[] pool) {
        HashMap hashMap = this.threadPools;
        synchronized (hashMap) {
            this.threadPools.put(id, pool);
        }
    }

    public HashMap getThreadPoolManagers() {
        return this.threadPools;
    }

    public String getSessionRoutingEngineName() {
        return this.sessionRoutingEngineName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Context getContextByName(String name) {
        return (Context)this.contextNames.get(name);
    }

    public Enumeration getContexts() {
        return this.contextNames.elements();
    }

    public int getContextNum() {
        return this.contextNames.size();
    }

    public int getConnectorNum() {
        if (this.connectors == null) {
            return 0;
        }
        return this.connectors.size();
    }

    public void setSessionRoutingEngineName(String routerInfo) {
        this.sessionRoutingEngineName = routerInfo;
    }

    public AccessLogger getAccessLogger() {
        return this.accessLogger;
    }

    public ContextGroupDescriptor getContextGroupDescriptor() {
        return this.contextGroupDesc;
    }

    public WebAppDescriptor getCommonWebAppDescriptor() {
        return this.commonWebAppDesc;
    }

    public WebCommonDescriptor getWebCommonDescriptor() {
        if (this.commonWebAppDesc == null) {
            return null;
        }
        return this.commonWebAppDesc.getWebCommonDescriptor();
    }

    public boolean getConfigByXML() {
        return this.configByXML;
    }

    public Hashtable getJSPConfig() {
        return this.jspConfig;
    }

    public String getForcedRequestUrlEncoding() {
        return this.forcedRequestUrlEncoding;
    }

    public String getForcedRequestEncoding() {
        return this.forcedRequestEncoding;
    }

    public String getForcedResponseEncoding() {
        return this.forcedResponseEncoding;
    }

    public String getDefaultRequestUrlEncoding() {
        return this.forcedRequestUrlEncoding;
    }

    public String getDefaultRequestEncoding() {
        return this.defaultRequestEncoding;
    }

    public String getDefaultResponseEncoding() {
        return this.defaultResponseEncoding;
    }

    public boolean getStrictPostDataEncoding() {
        return this.strictPostDataEncoding;
    }

    public boolean isAttachStacktraceOnError() {
        return this.contextGroupDesc.isAttachStacktraceOnError();
    }

    public Enumeration getSessionIds() {
        return Context.EMPTY_VECTOR_ENUMERATION;
    }

    public final Context getContextByPath(String hostname, String path) {
        VirtualHost vhost;
        if (hostname == null) {
            hostname = "";
        }
        if ((vhost = (VirtualHost)this.virtualHosts.get(hostname)) == null) {
            vhost = this.defaultHost;
            return vhost.getContextByPath(path);
        }
        Context ctx = vhost.getContextByPath(path);
        if (ctx != null) {
            return ctx;
        }
        return this.defaultHost.getContextByPath(path);
    }

    public final Context getContextByPathFromVirtualHost(VirtualHost vhost, String path) {
        Context ctx = vhost.getContextByPath(path);
        if (ctx != null) {
            return ctx;
        }
        return this.defaultHost.getContextByPath(path);
    }

    public void checkThreadPools() {
        for (ThreadPoolManager[] poolManager : this.threadPools.values()) {
            if (poolManager == null) continue;
            for (int i = 0; i < poolManager.length; ++i) {
                poolManager[i].checkThreadPool();
                if (!logger.isLoggable(Level.FINE)) continue;
                String threadPoolId = poolManager[i].getThreadPoolId();
                Vector threadStates = poolManager[i].getThreadState(ThreadStateInfo.GET_ALL_INFO);
                this.userLogger.directLog("[" + threadPoolId + "] " + threadStates);
            }
        }
    }

    public void checkFileCache() {
        Enumeration ctxs = this.contextNames.elements();
        while (ctxs.hasMoreElements()) {
            Context ctx = (Context)ctxs.nextElement();
            ResourceCache rc = ctx.getResourceCache();
            if (rc == null) continue;
            rc.checkIdleResources();
        }
    }

    public void checkSessionContainer(boolean first) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execSuspend() {
        ContextGroup contextGroup = this;
        synchronized (contextGroup) {
            if (this.contextGroupMo != null) {
                try {
                    this.contextGroupMo.stop();
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_WebContainer2._3856_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3856_LEVEL, JeusMessage_WebContainer2._3856, (Object)this.groupName, (Throwable)e);
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execResume() {
        ContextGroup contextGroup = this;
        synchronized (contextGroup) {
            if (this.contextGroupMo != null) {
                try {
                    this.start();
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_WebContainer2._3855_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3855_LEVEL, JeusMessage_WebContainer2._3855, (Object)this.groupName, (Throwable)e);
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execReload() throws StartingException {
        ContextGroup contextGroup = this;
        synchronized (contextGroup) {
            boolean result = true;
            Enumeration ctxs = this.contextNames.elements();
            while (ctxs.hasMoreElements()) {
                Context ctx = (Context)ctxs.nextElement();
                result &= ctx.execReload();
            }
            return result;
        }
    }

    public boolean terminateContext(String ctxName) {
        Context context = this.unregisterContextName(ctxName);
        if (context == null) {
            return false;
        }
        if (context.isWarDeploy()) {
            return false;
        }
        VirtualHost vh = context.getVirtualHost();
        VirtualHostDescriptor vdesc = vh.getDescriptor();
        context.execTerminate();
        vh.removeContext(context.getContextPath());
        vdesc.removeContextDescriptor(ctxName);
        if (this.contextGroupMo != null) {
            this.contextGroupMo.removeWebModule(ctxName);
            WebModuleDeployInfo obj = this.contextGroupMo.getDeployObject(context.getContextName());
            obj.setTerminated(true);
            this.contextGroupMo.updateWebModuleDeployInfo(context.getContextName(), obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execTerminate() {
        ContextGroup contextGroup = this;
        synchronized (contextGroup) {
            if (this.contextGroupMo != null && this.contextGroupMo.isExistRuntimeDeplyModule()) {
                return false;
            }
            this.stopConnector(null);
            Enumeration ctxs = this.contextNames.elements();
            while (ctxs.hasMoreElements()) {
                Context context = (Context)ctxs.nextElement();
                WebModuleDeployInfo obj = this.contextGroupMo.getDeployObject(context.getContextName());
                if (obj != null) {
                    obj.setTerminated(true);
                    this.contextGroupMo.updateWebModuleDeployInfo(context.getContextName(), obj);
                }
                context.execTerminate();
            }
            this.contextNames.clear();
            if (this.contextGroupMo != null) {
                this.contextGroupMo.clearDeployTable();
            }
            if (this.accessLogger != null) {
                this.accessLogger.close();
            }
            if (this.userLogger != null) {
                this.userLogger.close();
            }
            if (logger != null) {
                logger.close();
            }
            Iterator it = this.virtualHosts.values().iterator();
            while (it.hasNext()) {
                VirtualHost vh = (VirtualHost)it.next();
                vh.destroy();
                it.remove();
            }
        }
        return true;
    }

    public void start() throws Exception {
        this.contextGroupMo.startRecursive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ContextGroup contextGroup = this;
        synchronized (contextGroup) {
            this.stopConnectorWithTimer();
            Enumeration ctxs = this.contextNames.elements();
            while (ctxs.hasMoreElements()) {
                Context context = (Context)ctxs.nextElement();
                context.execTerminate();
            }
            this.contextNames.clear();
            if (this.accessLogger != null) {
                this.accessLogger.close();
            }
            if (this.userLogger != null) {
                this.userLogger.close();
            }
            if (logger != null) {
                logger.close();
            }
            if (this.contextGroupMo != null) {
                this.contextGroupMo.clearDeployTable();
            }
            Iterator it = this.virtualHosts.values().iterator();
            while (it.hasNext()) {
                VirtualHost vh = (VirtualHost)it.next();
                vh.destroy();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartContext(String contextName) throws ServerException {
        ContextGroup contextGroup = this;
        synchronized (contextGroup) {
            ClassLoader parent = null;
            Policy ctxPolicy = null;
            Context ctx = this.unregisterContextName(contextName);
            if (ctx != null) {
                parent = ctx.getContextLoader().getParentClassLoader();
                ctxPolicy = ctx.getApplicationPolicy();
            }
            try {
                boolean modified = this.containerManager.reReadConfigIfModified();
                if (modified) {
                    this.contextGroupDesc = this.containerManager.getContextGroupDescriptor(this.groupName);
                }
                ContextDescriptor ctxDesc = null;
                boolean found = false;
                VirtualHostDescriptor vhDesc = this.contextGroupDesc.getDefaultVirtualHostDescriptor();
                Enumeration enum1 = vhDesc.getContextDescriptors().elements();
                while (enum1.hasMoreElements()) {
                    ctxDesc = (ContextDescriptor)enum1.nextElement();
                    if (!ctxDesc.getContextName().equals(contextName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    enum1 = this.contextGroupDesc.getVirtualHostDescriptors().elements();
                    while (enum1.hasMoreElements()) {
                        vhDesc = (VirtualHostDescriptor)enum1.nextElement();
                        Enumeration enum2 = vhDesc.getContextDescriptors().elements();
                        while (enum2.hasMoreElements()) {
                            ctxDesc = (ContextDescriptor)enum2.nextElement();
                            if (!ctxDesc.getContextName().equals(contextName)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                }
                if (vhDesc == null) {
                    return false;
                }
                VirtualHost vhost = vhDesc.isDefaultVirtualHost() ? this.defaultHost : (VirtualHost)this.virtualHosts.get(vhDesc.getHostNames().firstElement());
                vhost.addContext(this.configByXML, this.contextGroupMo, ctxDesc, ctxPolicy, parent, null);
                ctxDesc.printDescriptor(new PrintWriter(System.out, true));
            }
            catch (StartingException se) {
                String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3410, (Object[])new String[]{this.groupName, contextName});
                logger.log(JeusMessage_WebContainer2._3410_LEVEL, msg, (Throwable)((Object)se));
                throw new ServerException(msg, (Exception)((Object)se));
            }
            catch (Exception e) {
                String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3410, (Object[])new String[]{this.groupName, contextName});
                logger.log(JeusMessage_WebContainer2._3410_LEVEL, msg, (Throwable)e);
                throw new ServerException(msg, e);
            }
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    public TargetModuleID deployContext(List vhostNameList, ContextDescriptor ctxDesc, Policy appPolicy, ClassLoader classloader, WebModule webModule) throws ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ObjectName undeployContext(String ctxName) {
        Context context = this.unregisterContextName(ctxName);
        ObjectName oname = null;
        if (context != null) {
            WebModule webModule = context.getMBean();
            oname = webModule == null ? null : webModule.getObjectName();
            VirtualHost vh = context.getVirtualHost();
            VirtualHostDescriptor vdesc = vh.getDescriptor();
            context.execTerminate();
            vh.removeContext(context.getContextPath());
            vdesc.removeContextDescriptor(ctxName);
            if (this.contextGroupMo != null) {
                this.contextGroupMo.removeWebModule(ctxName);
                this.contextGroupMo.removeWebModuleDeployInfo(ctxName);
            }
        }
        return oname;
    }

    public HttpSession findSession(Context ctx, String id) {
        return null;
    }

    public void removeSession(Context ctx, String id) {
    }

    public void checkSessions(boolean first) {
        long timeStamp = System.currentTimeMillis();
        CopyOnWriteArrayList sessionList = new CopyOnWriteArrayList(this.contextNames.values());
        Iterator i = sessionList.iterator();
        while (i.hasNext()) {
            ((Context)i.next()).scavengeSessions(timeStamp);
        }
    }

    public int getAllSessionsSize(Context ctx) {
        SessionMonitoring manager = (SessionMonitoring)((Object)ctx.getSessionManager());
        if (manager != null) {
            return manager.getAllSessionsSize();
        }
        return 0;
    }

    public int getActiveSessionsSize(Context ctx) {
        SessionMonitoring manager = (SessionMonitoring)((Object)ctx.getSessionManager());
        if (manager != null) {
            return manager.getActiveSessionsSize();
        }
        return 0;
    }

    public int getPassivateSessionsSize(Context ctx) {
        SessionMonitoring manager = (SessionMonitoring)((Object)ctx.getSessionManager());
        if (manager != null) {
            return manager.getPassivateSessionsSize();
        }
        return 0;
    }

    public int getLocalSessionsSize(Context ctx) {
        SessionMonitoring manager = (SessionMonitoring)((Object)ctx.getSessionManager());
        if (manager != null) {
            return manager.getLocalSessionsSize();
        }
        return 0;
    }

    public void registerMBean(ObjectName parent) {
        block2: {
            try {
                this.contextGroupMo = (ContextGroupMo)ContextGroupMo.createMBean(this.groupName, parent, this);
                this.contextGroupMo.start();
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3854_LEVEL)) break block2;
                logger.log(JeusMessage_WebContainer2._3854_LEVEL, JeusMessage_WebContainer2._3854, (Object)this.groupName, (Throwable)e);
            }
        }
    }

    public void handleNotification(Notification arg0, Object arg1) {
        try {
            LoginUtil.loginCodeSubjectWithRuntimeException();
            String type = arg0.getType();
            if (type.equals("jeus.enginecontainer.prestop")) {
                this.stopConnectorWithTimer();
                this.containerManager.removeContainerBootEndListener(this);
            } else if (type.equals("jeus.enginecontainer.engine.prestop")) {
                String engineType = StringUtil.getEngineTypeFromEngineName((String)((String)arg0.getUserData()));
                if (engineType.equals("servlet")) {
                    this.stopConnectorWithTimer();
                    this.containerManager.removeContainerBootEndListener(this);
                }
            } else if (type.equals("jeus.enginecontainer.poststart")) {
                if (!this.isBackupNode && this.isEnginePostBootSuccess) {
                    this.startConnector();
                }
            } else if (type.equals("jeus.engine.postboot.success")) {
                String engineType = StringUtil.getEngineTypeFromEngineName((String)((String)arg0.getUserData()));
                if (engineType.equals("servlet")) {
                    this.isEnginePostBootSuccess = true;
                }
            } else if (type.equals("jeus.engine.postboot.fail")) {
                Object[] userData = (Object[])arg0.getUserData();
                String engineType = StringUtil.getEngineTypeFromEngineName((String)((String)userData[0]));
                if (engineType.equals("servlet")) {
                    this.isEnginePostBootSuccess = false;
                }
            } else if (type.equals("jeus.enginecontainer.engine.poststart")) {
                String engineType;
                if (!this.isBackupNode && (engineType = StringUtil.getEngineTypeFromEngineName((String)((String)arg0.getUserData()))).equals("servlet")) {
                    this.startConnector();
                }
            } else if (type.equals(NodeListServiceMBean.JEUSMANAGER_BACKUP_CLUSTER_FAILED)) {
                if (this.isBackupNode) {
                    this.startConnector();
                }
            } else if (type.equals(NodeListServiceMBean.JEUSMANAGER_BACKUP_CLUSTER_RESURRECTED) && this.isBackupNode && JeusManagerProperties.DOWN_FOR_PRIMARY_BOOT) {
                this.stopConnectorWithTimer();
            }
        }
        catch (Exception e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    private void stopConnectorWithTimer() {
        try {
            this.stopConnector(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ContextGroupMo getContextGroupMBean() {
        return this.contextGroupMo;
    }

    public ContextGroupProperties getContextGroupProperties() {
        return this.contextGroupProperties;
    }

    public void registerSessionManagerMBean(SessionMonitoring manager, String scope) {
        if (manager != null && this.contextGroupMo != null) {
            if (scope == null) {
                scope = this.groupName;
            }
            manager.createMBean(this.contextGroupMo.getObjectName(), scope + "-session");
        }
    }
}

