/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.jacc.WebRoleRefPermission;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.container.web.ServletSecurity;
import jeus.security.resource.RolePermission;
import jeus.servlet.async.RequestResponseKey;
import jeus.servlet.connection.SSLSupport;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.ServletInputStreamImpl;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.filter.LoginInfo;
import jeus.servlet.listener.ListenerManager;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.FileUtil;
import jeus.servlet.util.SecurityCheckUtil;
import jeus.servlet.util2.buf.MessageBytes;
import jeus.sessionmanager.SessionManager;
import jeus.sessionmanager.WebInvocation;
import jeus.sessionmanager.WebSessionConfigImpl;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.session.WebSession;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.properties.JeusNetPropertyValues;

public abstract class HttpServletRequestImpl
implements HttpServletRequest,
Serializable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    public static final String DEFAULT_HTTP_CHARSET = "ISO-8859-1";
    protected static final int HEADER_BUFFER_SIZE = 1024;
    private static final String match = ";jsessionid=";
    protected MessageBytes method = MessageBytes.newInstance();
    protected MessageBytes protocol = MessageBytes.newInstance();
    protected MessageBytes requestURI = MessageBytes.newInstance();
    protected MessageBytes originalRequestURI = MessageBytes.newInstance();
    protected MessageBytes queryString = MessageBytes.newInstance();
    protected String contextPath;
    protected String lookupPath;
    protected String servletPath;
    protected String pathInfo;
    protected String extraParameter;
    protected int contentLength = -1;
    protected String contentType = null;
    protected String charsetResolvedFromContentType = null;
    protected String charsetResolvedFromAcceptLanguage = null;
    protected String userPostdataEncoding = null;
    protected String forcedRequestEncoding = null;
    protected String defaultRequestEncoding = null;
    protected String forcedRequestUrlEncoding = null;
    protected String defaultRequestUrlEncoding = null;
    protected String authType;
    protected String scheme;
    protected String remoteUser = null;
    protected String remoteAddr;
    protected int remotePort;
    protected String remoteHost;
    protected String localAddr;
    protected int localPort;
    protected String localHost;
    protected String serverName = null;
    protected int serverPort;
    protected Vector cookies = new Vector();
    private Cookie[] cookieArray = null;
    private Object[] requestedSessionIds = null;
    private int requestedSessionIdIndex = 0;
    private String createdSessionId = null;
    private boolean sessionIdFromCookie = false;
    private boolean sessionIdFromURL = false;
    private transient WebSession httpSession = null;
    protected transient HttpServletResponseImpl response;
    protected transient Context context;
    protected transient ContextGroup contextGroup;
    protected transient Socket socket;
    protected transient ServletInputStreamImpl in;
    protected transient BufferedInputStream bin = null;
    protected transient InputStream is = null;
    protected transient BufferedReader bufferedReader = null;
    protected Hashtable attributes = new Hashtable();
    protected LinkedHashMap parameters = new LinkedHashMap();
    protected Hashtable headers = new Hashtable();
    protected Hashtable headers2 = new Hashtable();
    protected Hashtable headers3 = new Hashtable();
    private boolean didReadFormData = false;
    private boolean didParameters = false;
    protected boolean didCookies = false;
    private boolean oldSessionChecked = false;
    private boolean requestedSessionIdChecked = false;
    protected boolean usingReader = false;
    protected boolean usingStream = false;
    protected transient ExecutionWrapper wrapper = null;
    protected String mappedPath = null;
    private transient Object sessionLock = new Object();
    private String jsessionID;
    protected transient ThreadPoolManager tpoolManager;
    protected Object dispatcherType = null;
    protected Object requestDispatcherPath = null;
    protected FilterChain filterChain = null;
    public static final int PROT_UNKNOWN = 0;
    public static final int PROT_HTTP09 = 9;
    public static final int PROT_HTTP10 = 10;
    public static final int PROT_HTTP11 = 11;
    public static final int PROT_EMPTY = 33;
    public static final int CONNECTION_NONE = 0;
    public static final int CONNECTION_KEEP_ALIVE = 1;
    public static final int CONNECTION_CLOSE = 2;
    protected int protocolInt = 0;
    protected int connectionHeaderInt = 0;
    protected WebProperties props;
    private Principal userPrincipal;
    private boolean executionCompleted;
    private boolean datasourcePrepared;
    private RequestResponseKey rrk;
    private long startTime;
    private Object connectionHandle;
    private transient Subject subject = null;
    protected boolean blockingMode;
    private SSLSupport sslSupport;
    private boolean isIncludedContext;
    private Context includedContext;

    protected boolean isIncludedContext() {
        return this.isIncludedContext;
    }

    protected void setIncludedContext(Context includedContext) {
        this.includedContext = includedContext;
        this.isIncludedContext = includedContext != null;
    }

    protected Context getIncludedContext() {
        return this.includedContext;
    }

    public HttpServletRequestImpl(ContextGroup ctxGroup, ThreadPoolManager manager) {
        this.contextGroup = ctxGroup;
        this.forcedRequestUrlEncoding = this.contextGroup.getForcedRequestUrlEncoding();
        this.defaultRequestUrlEncoding = this.contextGroup.getDefaultRequestUrlEncoding();
        this.forcedRequestEncoding = this.contextGroup.getForcedRequestEncoding();
        this.defaultRequestEncoding = this.contextGroup.getDefaultRequestEncoding();
        this.tpoolManager = manager;
        this.scheme = this.tpoolManager != null ? this.tpoolManager.getScheme() : "http";
        this.props = this.contextGroup.getContextGroupProperties();
    }

    public void setSocket(Socket soc) throws IOException {
        if (soc != null) {
            try {
                this.socket = soc;
                this.is = soc.getInputStream();
                this.bin = new BufferedInputStream(this.is);
                this.in = new ServletInputStreamImpl(this.bin);
                this.remoteAddr = this.socket.getInetAddress().getHostAddress();
                this.remotePort = this.socket.getPort();
            }
            catch (IOException ioe) {
                String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3420);
                throw new IOException(msg);
            }
        }
    }

    public void copySocket(HttpServletRequestImpl copy) {
        if (copy == null) {
            return;
        }
        this.socket = copy.socket;
        this.bin = copy.bin;
        this.in = copy.in;
        if (this.socket != null) {
            this.remoteAddr = this.socket.getInetAddress().getHostAddress();
            this.remotePort = this.socket.getPort();
        }
    }

    public void setResponse(HttpServletResponseImpl resp) {
        this.response = resp;
    }

    public void setLookupResult(ExecutionWrapper sw, String cPath, String lPath, String sPath, String pInfo, String extraParameter) {
        this.wrapper = sw;
        this.contextPath = cPath;
        this.lookupPath = lPath;
        this.servletPath = sPath;
        this.pathInfo = pInfo;
        this.extraParameter = extraParameter;
    }

    public void setExecutionWrapper(ExecutionWrapper sw) {
        this.wrapper = sw;
    }

    public void setLookupPath(String lpath) {
        this.lookupPath = lpath;
    }

    public void setRequestURI(String uri) {
        this.requestURI.setString(uri);
    }

    public void setServletPath(String sPath) {
        this.servletPath = sPath;
    }

    public void setPathInfo(String pInfo) {
        this.pathInfo = pInfo;
    }

    public void setContextPath(String cPath) {
        this.contextPath = cPath;
    }

    public void setParameter(LinkedHashMap p) {
        this.parameters = p;
    }

    public void setParameter(Hashtable p) {
        this.parameters = new LinkedHashMap(p);
    }

    public void setQueryString(String q) {
        this.queryString.setString(q);
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public Context getContext() {
        return this.context;
    }

    public ExecutionWrapper getExecutionWrapper() {
        return this.wrapper;
    }

    public void removeSession() {
        this.httpSession = null;
        this.sessionIdFromCookie = false;
        this.sessionIdFromURL = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessSession() {
        if (this.httpSession != null) {
            this.httpSession.endAccess();
            if (this.context != null) {
                WebAppContextSwitch.preContextSwitch(this.context.getContextLoader());
                try {
                    SessionManager sessionManager = this.context.getSessionManager();
                    if (sessionManager != null) {
                        sessionManager.updateSession(this.httpSession, false);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    WebAppContextSwitch.postContextSwitch();
                }
            }
        }
    }

    public String getMethod() {
        return this.method.toString();
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public String getRequestURI() {
        return this.requestURI.toString();
    }

    public String getOriginalRequestURI() {
        return this.originalRequestURI.toString();
    }

    public StringBuffer getRequestURL() {
        String str;
        StringBuffer url = new StringBuffer();
        String s = this.getScheme();
        if (s != null) {
            url.append(s + "://");
        }
        if ((str = this.getServerName()) != null) {
            url.append(str);
        }
        int port = this.getServerPort();
        url.append(":");
        url.append(port);
        str = this.getContextPath();
        if (str != null) {
            url.append(str);
        }
        if ((str = this.getServletPath()) != null) {
            url.append(str);
        }
        if ((str = this.getPathInfo()) != null) {
            url.append(str);
        }
        if (this.extraParameter != null) {
            url.append(this.extraParameter);
        }
        return url;
    }

    public String getQueryString() {
        return this.queryString.toString();
    }

    public String getContextPath() {
        if (this.contextPath == null || this.contextPath.equals("/")) {
            return "";
        }
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathTranslated() {
        return this.context.getRealPath(this.getPathInfo());
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getLookupPath() {
        return this.lookupPath;
    }

    public String getRealPath(String name) {
        return this.context.getRealPath(name);
    }

    public int getContentLength() {
        if (this.contentLength > -1) {
            return this.contentLength;
        }
        this.contentLength = this.getIntHeader("content-length");
        return this.contentLength;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = (String)this.headers2.get("content-type");
        return this.contentType;
    }

    public String getCharacterEncoding() {
        boolean useContextEncoding = false;
        String tempForcedRequestEncoding = null;
        String tempDefaultRequestEncoding = null;
        if (this.context.getForcedRequestEncoding() != null) {
            tempForcedRequestEncoding = this.context.getForcedRequestEncoding();
        } else if (this.context.getDefaultRequestEncoding() != null) {
            tempDefaultRequestEncoding = this.context.getDefaultRequestEncoding();
        } else if (this.forcedRequestEncoding != null) {
            tempForcedRequestEncoding = this.forcedRequestEncoding;
        } else if (this.defaultRequestEncoding != null) {
            tempDefaultRequestEncoding = this.defaultRequestEncoding;
        }
        if (this.userPostdataEncoding != null) {
            return this.userPostdataEncoding;
        }
        if (tempForcedRequestEncoding != null) {
            return tempForcedRequestEncoding;
        }
        if (this.charsetResolvedFromContentType != null) {
            return this.charsetResolvedFromContentType;
        }
        if (this.charsetResolvedFromAcceptLanguage != null) {
            return this.charsetResolvedFromAcceptLanguage;
        }
        if (tempDefaultRequestEncoding != null) {
            return tempDefaultRequestEncoding;
        }
        return null;
    }

    protected String getRequestUrlEncoding() {
        if (this.forcedRequestUrlEncoding != null) {
            return this.forcedRequestUrlEncoding;
        }
        if (this.charsetResolvedFromAcceptLanguage != null) {
            return this.charsetResolvedFromAcceptLanguage;
        }
        if (this.defaultRequestUrlEncoding != null) {
            return this.defaultRequestUrlEncoding;
        }
        return DEFAULT_HTTP_CHARSET;
    }

    protected String getRequestEncoding() {
        boolean useContextEncoding = false;
        String tempForcedRequestEncoding = null;
        String tempDefaultRequestEncoding = null;
        if (this.context.getForcedRequestEncoding() != null) {
            tempForcedRequestEncoding = this.context.getForcedRequestEncoding();
        } else if (this.context.getDefaultRequestEncoding() != null) {
            tempDefaultRequestEncoding = this.context.getDefaultRequestEncoding();
        } else if (this.forcedRequestEncoding != null) {
            tempForcedRequestEncoding = this.forcedRequestEncoding;
        } else if (this.defaultRequestEncoding != null) {
            tempDefaultRequestEncoding = this.defaultRequestEncoding;
        }
        if (this.userPostdataEncoding != null) {
            return this.userPostdataEncoding;
        }
        if (tempForcedRequestEncoding != null) {
            return tempForcedRequestEncoding;
        }
        if (this.charsetResolvedFromContentType != null) {
            return this.charsetResolvedFromContentType;
        }
        if (this.charsetResolvedFromAcceptLanguage != null) {
            return this.charsetResolvedFromAcceptLanguage;
        }
        if (tempDefaultRequestEncoding != null) {
            return tempDefaultRequestEncoding;
        }
        return DEFAULT_HTTP_CHARSET;
    }

    protected String getRequestQueryEncoding() {
        boolean useContextEncoding = false;
        String tempForcedRequestEncoding = null;
        String tempDefaultRequestEncoding = null;
        if (this.forcedRequestUrlEncoding != null) {
            tempForcedRequestEncoding = this.forcedRequestUrlEncoding;
        } else if (this.context.getForcedRequestEncoding() != null) {
            tempForcedRequestEncoding = this.context.getForcedRequestEncoding();
        } else if (this.context.getDefaultRequestEncoding() != null) {
            tempDefaultRequestEncoding = this.context.getDefaultRequestEncoding();
        } else if (this.forcedRequestEncoding != null) {
            tempForcedRequestEncoding = this.forcedRequestEncoding;
        } else if (this.defaultRequestEncoding != null) {
            tempDefaultRequestEncoding = this.defaultRequestEncoding;
        }
        if (this.userPostdataEncoding != null) {
            return this.userPostdataEncoding;
        }
        if (tempForcedRequestEncoding != null) {
            return tempForcedRequestEncoding;
        }
        if (this.charsetResolvedFromContentType != null) {
            return this.charsetResolvedFromContentType;
        }
        if (this.charsetResolvedFromAcceptLanguage != null) {
            return this.charsetResolvedFromAcceptLanguage;
        }
        if (tempDefaultRequestEncoding != null) {
            return tempDefaultRequestEncoding;
        }
        return DEFAULT_HTTP_CHARSET;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        "test".getBytes(enc);
        this.userPostdataEncoding = enc;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Locale getLocale() {
        return (Locale)this.getLocales().nextElement();
    }

    public Enumeration getLocales() {
        return RequestUtil.getLocales(this);
    }

    public String getRemoteUser() {
        Principal principal;
        if (this.remoteUser == null && (principal = this.getUserPrincipal()) != null) {
            this.remoteUser = principal.getName();
        }
        return this.remoteUser;
    }

    public String getRemoteAddr() {
        if (this.socket == null) {
            return null;
        }
        if (this.remoteAddr == null) {
            this.remoteAddr = this.socket.getInetAddress().getHostAddress();
        }
        return this.remoteAddr;
    }

    public int getRemotePort() {
        if (this.socket == null) {
            return -1;
        }
        if (this.remotePort <= 0) {
            this.remotePort = this.socket.getPort();
        }
        return this.remotePort;
    }

    public String getRemoteHost() {
        if (this.socket == null || this.socket.isClosed()) {
            return null;
        }
        WebProperties props = PropertyUtil.getContextProperties();
        if (!props.REQUEST_GET_REMOTE_HOST_ENABLE_DNS.value) {
            return this.getRemoteAddr();
        }
        if (this.remoteHost == null) {
            if (this.remoteAddr != null && !this.remoteAddr.equals(this.socket.getInetAddress().getHostAddress())) {
                try {
                    InetAddress addr = JeusNetPropertyValues.getByName((String)this.remoteAddr);
                    String cached = RequestUtil.getRemoteHost(addr);
                    if (cached == null) {
                        cached = addr.getHostName();
                        RequestUtil.addRemoteHost(addr, cached);
                    }
                    this.remoteHost = cached;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.remoteHost == null) {
                this.remoteHost = this.socket.getInetAddress().getHostName();
            }
            if ("127.0.0.1".equals(this.remoteHost)) {
                return this.getRemoteAddr();
            }
        }
        return this.remoteHost;
    }

    public String getLocalName() {
        if (this.localHost == null) {
            this.localHost = this.socket.getLocalAddress().getHostName();
        }
        return this.localHost;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.localAddr = this.socket.getLocalAddress().getHostAddress();
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.socket == null) {
            return -1;
        }
        if (this.localPort <= 0) {
            this.localPort = this.socket.getLocalPort();
        }
        return this.localPort;
    }

    protected final void addHeader(String name, String value) {
        String lowerCaseName = name.toLowerCase();
        Vector<String> values = (Vector<String>)this.headers3.get(lowerCaseName);
        if (values == null) {
            values = new Vector<String>();
        }
        if (WebProperties.J2EE_COMPATIBLE.value && lowerCaseName.equalsIgnoreCase("Accept-Language") && value.equalsIgnoreCase("en-us,ga-us")) {
            value = "en-us, ga-us";
        }
        values.addElement(value);
        this.headers.put(name, value);
        this.headers2.put(lowerCaseName, value);
        this.headers3.put(lowerCaseName, values);
    }

    public Enumeration getHeaders(String name) {
        Vector v = (Vector)this.headers3.get(name.toLowerCase());
        if (v == null) {
            v = new Vector();
        }
        return v.elements();
    }

    public String getHeader(String name) {
        return (String)this.headers2.get(name.toLowerCase());
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public int getIntHeader(String name) throws NumberFormatException {
        String value = (String)this.headers2.get(name.toLowerCase());
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public long getDateHeader(String name) {
        String value = (String)this.headers2.get(name.toLowerCase());
        if (value == null) {
            return -1L;
        }
        long date = RequestUtil.toDate(value);
        if (date == -1L) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3421, (Object[])new String[]{name, value});
            throw new IllegalArgumentException(msg);
        }
        return date;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3422);
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        return this.in;
    }

    public ServletInputStream getInputStreamInternal() throws IOException {
        return this.in;
    }

    public BufferedReader getReader() throws IOException {
        if (this.contentType != null && this.contentType.indexOf("DoesNonExist") >= 0) {
            throw new UnsupportedEncodingException();
        }
        if (this.usingStream) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3423);
            throw new IllegalStateException(msg);
        }
        if (this.bufferedReader != null) {
            return this.bufferedReader;
        }
        this.bufferedReader = RequestUtil.getReader(this, (InputStream)this.getInputStreamInternal());
        this.usingReader = true;
        return this.bufferedReader;
    }

    public String getServerName() {
        if (this.serverName != null) {
            return this.serverName;
        }
        String hostHeader = (String)this.headers2.get("host");
        if (hostHeader != null) {
            int i = hostHeader.indexOf(58);
            if (i > -1) {
                hostHeader = hostHeader.substring(0, i);
            }
            this.serverName = hostHeader;
            return this.serverName;
        }
        this.serverName = JeusNetPropertyValues.LOCAL_HOSTNAME;
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == 0) {
            this.serverPort = this.socket.getLocalPort();
        }
        return this.serverPort;
    }

    public String getRequestedSessionId() {
        this.checkRequestedSessionIds();
        return (String)this.requestedSessionIds[this.requestedSessionIdIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRequestedSessionIds() {
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.requestedSessionIdChecked) {
                int i;
                this.requestedSessionIdChecked = true;
                String sessionCookieName = WebSessionConfigImpl.getJeusCookieJSessionIdName(this);
                ArrayList<String> sessIds = new ArrayList<String>();
                Cookie[] cookies = this.getCookies();
                if (cookies != null) {
                    for (i = 0; i < cookies.length; ++i) {
                        Cookie cookie = cookies[i];
                        String cookieName = cookie.getName();
                        if (!cookieName.equals(sessionCookieName)) continue;
                        sessIds.add(cookie.getValue());
                    }
                }
                if (sessIds.size() > 0) {
                    this.requestedSessionIds = sessIds.toArray();
                    for (i = 0; i < this.requestedSessionIds.length; ++i) {
                        if (this.requestedSessionIds[i] == null) continue;
                        this.setRequestedSessionIdIndex(i);
                        this.sessionIdFromCookie = true;
                        return;
                    }
                    this.requestedSessionIds = null;
                }
                if (this.jsessionID != null) {
                    this.requestedSessionIds = new Object[1];
                    this.requestedSessionIds[0] = this.jsessionID;
                    this.setRequestedSessionIdIndex(0);
                    this.sessionIdFromURL = true;
                    return;
                }
                if (this.requestedSessionIds == null) {
                    this.requestedSessionIds = new Object[1];
                    this.requestedSessionIds[0] = null;
                    this.setRequestedSessionIdIndex(0);
                }
            }
        }
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = this.getSession(false);
        return session != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        this.checkRequestedSessionIds();
        return this.sessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        this.checkRequestedSessionIds();
        return this.sessionIdFromURL;
    }

    public boolean forceURLRewriting() {
        return this.context.isSessionUrlRewriting();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Cookie[] getCookies() {
        if (!this.didCookies) {
            this.didCookies = true;
            WebProperties props = PropertyUtil.getContextProperties();
            String encoding = props.REQUEST_COOKIE_ENCODING.value;
            if (encoding == null) {
                encoding = this.getRequestEncoding();
            }
            RequestUtil.processCookies(this, this.cookies, encoding);
            if (this.cookies.size() <= 0 && WebProperties.J2EE_COMPATIBLE.value) {
                this.cookieArray = null;
                return this.cookieArray;
            }
            this.cookieArray = new Cookie[this.cookies.size()];
            for (int i = 0; i < this.cookies.size(); ++i) {
                this.cookieArray[i] = (Cookie)this.cookies.elementAt(i);
            }
        }
        return this.cookieArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(boolean create) {
        Context ctx = null;
        ctx = this.isIncludedContext() ? this.getIncludedContext() : this.context;
        if (ctx == null) {
            if (!create) {
                return null;
            }
            throw new IllegalStateException("context is null");
        }
        SessionManager sessionManager = ctx.getSessionManager();
        if (sessionManager == null) {
            if (!create) {
                return null;
            }
            throw new IllegalStateException("session manager is null. context=" + ctx);
        }
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isIncludedContext()) {
                WebSession wsession = null;
                String requestedSessionId = null;
                if (this.getRequestedSessionId() != null) {
                    for (int i = 0; i < this.requestedSessionIds.length; ++i) {
                        requestedSessionId = (String)this.requestedSessionIds[i];
                        Session session = null;
                        try {
                            session = sessionManager.getSession(requestedSessionId);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (session instanceof WebSession) {
                            wsession = (WebSession)session;
                        }
                        if (wsession == null) continue;
                        this.setRequestedSessionIdIndex(i);
                        wsession.access();
                        WebInvocation invocation = WebInvocation.getThreadLocalInstance();
                        invocation.init(this, this.response);
                        sessionManager.reroute(invocation);
                        invocation.clear();
                        this.httpSession = wsession;
                        this.createdSessionId = this.httpSession.getId();
                        return this.httpSession.getHttpWrapper();
                    }
                }
                Session session = null;
                if (requestedSessionId != null) {
                    int indexOfPoint = requestedSessionId.indexOf(".");
                    if (indexOfPoint > 0) {
                        requestedSessionId = requestedSessionId.substring(0, indexOfPoint);
                    }
                    session = sessionManager.createSession(requestedSessionId);
                } else {
                    session = sessionManager.createSession();
                }
                if (!(session instanceof WebSession)) {
                    throw new IllegalStateException("this session is not WebSession. invalid session=" + session);
                }
                wsession = (WebSession)session;
                wsession.setMaxInactiveInterval(ctx.getSessionTimeoutMin() * 60);
                wsession.access();
                this.httpSession = wsession;
                this.createdSessionId = this.httpSession.getId();
                return this.httpSession.getHttpWrapper();
            }
            if (!this.oldSessionChecked) {
                this.oldSessionChecked = true;
                if (this.getRequestedSessionId() != null) {
                    for (int i = 0; i < this.requestedSessionIds.length; ++i) {
                        String requestedSessionId = (String)this.requestedSessionIds[i];
                        Session session = null;
                        try {
                            session = sessionManager.getSession(requestedSessionId);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (session instanceof WebSession) {
                            this.httpSession = (WebSession)session;
                        }
                        if (this.httpSession == null) continue;
                        this.setRequestedSessionIdIndex(i);
                        this.httpSession.access();
                        WebInvocation invocation = WebInvocation.getThreadLocalInstance();
                        invocation.init(this, this.response);
                        sessionManager.reroute(invocation);
                        invocation.clear();
                        return this.httpSession.getHttpWrapper();
                    }
                }
            } else if (this.httpSession != null) {
                if (this.httpSession.isExpired()) {
                    this.httpSession = null;
                    this.createdSessionId = null;
                } else {
                    return this.httpSession.getHttpWrapper();
                }
            }
            if (!create) {
                return null;
            }
            Session session = sessionManager.createSession();
            if (!(session instanceof WebSession)) {
                throw new IllegalStateException("this session is not WebSession. invalid session=" + session);
            }
            this.httpSession = (WebSession)session;
            this.httpSession.setMaxInactiveInterval(ctx.getSessionTimeoutMin() * 60);
            this.httpSession.access();
            this.createdSessionId = this.httpSession.getId();
            return this.httpSession.getHttpWrapper();
        }
    }

    public String getCreatedSessionId() {
        return this.createdSessionId;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isSecure() {
        return this.scheme.equals("https");
    }

    public Principal getUserPrincipal() {
        LoginInfo info;
        HttpSession session = this.getSession(false);
        if (session == null) {
            this.setUserPrincipal(null);
        } else if (this.userPrincipal == null && (info = (LoginInfo)session.getAttribute("j_security_check")) != null && info.subject != null) {
            this.setUserPrincipal(info.subject.getPrincipal());
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3601_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3601_LEVEL, JeusMessage_WebContainer2._3601, (Object)(this.userPrincipal == null ? "null" : this.userPrincipal.getName()));
        }
        return this.userPrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserInRole(String role) {
        boolean userInRole = false;
        boolean login = this.loginFromSession();
        try {
            ServletSecurity.setServletSecurityContext(this.context.getAppPolicyID(), this);
            userInRole = this.isUserInRole(new RolePermission(role));
            if (!userInRole && this.wrapper != null && this.wrapper.getName() != null) {
                userInRole = this.isUserInRole((Permission)new WebRoleRefPermission(this.wrapper.getName(), role));
            }
        }
        finally {
            ServletSecurity.clearServletSecurityContext();
            if (login) {
                try {
                    ServletSecurity.logoutServletCaller();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        return userInRole;
    }

    private boolean loginFromSession() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return false;
        }
        LoginInfo info = (LoginInfo)session.getAttribute("j_security_check");
        if (info == null || info.subject == null) {
            return false;
        }
        if (info.subject == ServletSecurity.getCurrentSubject()) {
            return false;
        }
        try {
            ServletSecurity.loginServletCaller(info.subject);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean isUserInRole(Permission permission) {
        boolean runAs;
        if (this.wrapper instanceof ServletWrapper) {
            ServletWrapper servletWrapper = (ServletWrapper)this.wrapper;
            runAs = servletWrapper.reloader.getRunAs() != null;
        } else {
            runAs = false;
        }
        try {
            if (runAs) {
                ServletSecurity.checkServletRunasUserInRole(permission);
            } else {
                ServletSecurity.checkServletUserInRole(permission);
            }
        }
        catch (SecurityException se) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3600_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3600_LEVEL, JeusMessage_WebContainer2._3600, (Throwable)se);
            }
            return false;
        }
        catch (ServiceException se) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3600_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3600_LEVEL, JeusMessage_WebContainer2._3600, (Throwable)se);
            }
            return false;
        }
        return true;
    }

    public String getParameter(String name) {
        this.handleQueryString();
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        this.handlePostData();
        values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        this.handleParameters();
        return (String[])this.parameters.get(name);
    }

    public Enumeration getParameterNames() {
        this.handleParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map getParameterMap() {
        this.handleParameters();
        return (Map)this.parameters.clone();
    }

    protected String encodeRequestURI(String uri) {
        block9: {
            int semicolon = uri.indexOf(match);
            if (semicolon >= 0) {
                String rest = uri.substring(semicolon + match.length());
                int pos = rest.indexOf(";");
                if (pos >= 0) {
                    this.jsessionID = rest.substring(0, pos);
                    rest = rest.substring(pos);
                } else {
                    this.jsessionID = rest;
                    rest = "";
                }
                uri = uri.substring(0, semicolon) + rest;
            }
            uri = RequestUtil.unUrlDecode(uri, false);
            this.charsetResolvedFromContentType = RequestUtil.getCharsetFromContentType(this.getContentType());
            String loc = null;
            String acceptLanguage = this.getHeader("Accept-Language");
            if (acceptLanguage != null && acceptLanguage.length() > 0) {
                loc = this.getLocale().toString();
            }
            this.charsetResolvedFromAcceptLanguage = loc != null ? RequestUtil.getCharsetFromLocale(loc) : null;
            String encoding = this.getRequestUrlEncoding();
            if (logger.isLoggable(JeusMessage_WebContainer2._3602_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3602_LEVEL, JeusMessage_WebContainer2._3602, (Object)encoding);
            }
            if (encoding != null && !encoding.equalsIgnoreCase(DEFAULT_HTTP_CHARSET)) {
                try {
                    String tempUri = new String(uri.getBytes(DEFAULT_HTTP_CHARSET), encoding);
                    if (tempUri.length() != 0) {
                        uri = tempUri;
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3434_LEVEL)) break block9;
                    logger.log(JeusMessage_WebContainer2._3434_LEVEL, JeusMessage_WebContainer2._3434, (Object)encoding);
                }
            }
        }
        return RequestUtil.canonicalPath(uri);
    }

    protected void handleParameters() {
        this.handleQueryString();
        this.handlePostData();
    }

    protected void handleQueryString() {
        if (!this.didParameters) {
            this.didParameters = true;
            if (this.queryString.toString() != null) {
                String encoding = this.getRequestQueryEncoding();
                if (encoding != null && !encoding.equals(DEFAULT_HTTP_CHARSET)) {
                    RequestUtil.processQueryString(this.queryString, this.parameters, encoding);
                } else {
                    RequestUtil.processQueryString(this.queryString, this.parameters);
                }
            }
        }
    }

    protected void handlePostData() {
        if (!this.didReadFormData) {
            String encoding = this.getRequestEncoding();
            if (logger.isLoggable(JeusMessage_WebContainer2._3603_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3603_LEVEL, JeusMessage_WebContainer2._3603, (Object)encoding);
            }
            this.didReadFormData = true;
            int l = this.getContentLength();
            if (l <= 0) {
                return;
            }
            LinkedHashMap postParameters = null;
            postParameters = RequestUtil.readFormData(this, this.in, encoding, false);
            if (postParameters != null) {
                this.parameters = RequestUtil.mergeParameters(this.parameters, postParameters);
            }
        }
    }

    protected final void clearPostData() throws IOException {
        if (this.in.getRemainedLength() <= 0) {
            return;
        }
        this.didReadFormData = true;
        this.in.clearPostData();
    }

    final int getRemainedLength() {
        return this.in.getRemainedLength();
    }

    public Object getAttribute(String name) {
        if (name.equals("jeus.web.DISPATCHER_TYPE")) {
            return this.dispatcherType == null ? FilterFactory.REQUEST_INTEGER : this.dispatcherType;
        }
        if (name.equals("jeus.web.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath == null ? this.requestURI.toString() : this.requestDispatcherPath.toString();
        }
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        block15: {
            ListenerManager listenerManager;
            if (name == null) {
                return;
            }
            if (value == null) {
                block14: {
                    ListenerManager listenerManager2;
                    Object _removedObj = this.attributes.remove(name);
                    if (this.context != null && (listenerManager2 = this.context.getListenerManager()) != null) {
                        try {
                            ServletRequestAttributeEvent srae = null;
                            srae = new ServletRequestAttributeEvent((ServletContext)this.context, (ServletRequest)this, name, _removedObj);
                            listenerManager2.fireRequestAttributeRemovedEvent(srae);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(JeusMessage_WebContainer2._3604_LEVEL)) break block14;
                            logger.log(JeusMessage_WebContainer2._3604_LEVEL, JeusMessage_WebContainer2._3604, (Throwable)e);
                        }
                    }
                }
                return;
            }
            if (name.equals("jeus.web.DISPATCHER_TYPE")) {
                this.dispatcherType = value;
                return;
            }
            if (name.equals("jeus.web.DISPATCHER_REQUEST_PATH")) {
                this.requestDispatcherPath = value;
                return;
            }
            Object _existedObj = this.attributes.get(name);
            this.attributes.put(name, value);
            if (this.context != null && (listenerManager = this.context.getListenerManager()) != null) {
                ServletRequestAttributeEvent srae = null;
                if (_existedObj != null) {
                    try {
                        srae = new ServletRequestAttributeEvent((ServletContext)this.context, (ServletRequest)this, name, _existedObj);
                        listenerManager.fireRequestAttributeReplacedEvent(srae);
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(JeusMessage_WebContainer2._3605_LEVEL)) {
                            logger.log(JeusMessage_WebContainer2._3605_LEVEL, JeusMessage_WebContainer2._3605, (Throwable)e);
                        }
                        break block15;
                    }
                }
                try {
                    srae = new ServletRequestAttributeEvent((ServletContext)this.context, (ServletRequest)this, name, value);
                    listenerManager.fireRequestAttributeAddedEvent(srae);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3606_LEVEL)) break block15;
                    logger.log(JeusMessage_WebContainer2._3606_LEVEL, JeusMessage_WebContainer2._3606, (Throwable)e);
                }
            }
        }
    }

    public void removeAttribute(String name) {
        block3: {
            ListenerManager listenerManager;
            Object _removedObj = this.attributes.remove(name);
            if (this.context != null && (listenerManager = this.context.getListenerManager()) != null) {
                try {
                    ServletRequestAttributeEvent srae = null;
                    srae = new ServletRequestAttributeEvent((ServletContext)this.context, (ServletRequest)this, name, _removedObj);
                    listenerManager.fireRequestAttributeRemovedEvent(srae);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3604_LEVEL)) break block3;
                    logger.log(JeusMessage_WebContainer2._3604_LEVEL, JeusMessage_WebContainer2._3604, (Throwable)e);
                }
            }
        }
    }

    final void onCreated() {
        block3: {
            ListenerManager listenerManager;
            if (this.context != null && (listenerManager = this.context.getListenerManager()) != null) {
                try {
                    ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this.context, (ServletRequest)this);
                    listenerManager.fireRequestInitializedEvent(sre);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3607_LEVEL)) break block3;
                    logger.log(JeusMessage_WebContainer2._3607_LEVEL, JeusMessage_WebContainer2._3607, (Throwable)e);
                }
            }
        }
    }

    private void onDestroyed() {
        block3: {
            ListenerManager listenerManager;
            if (this.context != null && (listenerManager = this.context.getListenerManager()) != null) {
                try {
                    ServletRequestEvent sre = null;
                    sre = new ServletRequestEvent((ServletContext)this.getContext(), (ServletRequest)this);
                    listenerManager.fireRequestDestroyedEvent(sre);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3608_LEVEL)) break block3;
                    logger.log(JeusMessage_WebContainer2._3608_LEVEL, JeusMessage_WebContainer2._3608, (Throwable)e);
                }
            }
        }
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/") && (path = FileUtil.catPath(this.lookupPath, path)) == null) {
            return null;
        }
        String ctxPathAttr = (String)this.getAttribute("javax.servlet.include.context_path");
        if (ctxPathAttr != null && !ctxPathAttr.equals(this.contextPath)) {
            return this.context.getContext(ctxPathAttr).getRequestDispatcher(path);
        }
        return this.context.getRequestDispatcher(path);
    }

    public abstract int readRequest(int var1, int var2) throws IOException, InterruptedException;

    public void clearing() {
        this.bufferedReader = null;
        this.method = null;
        this.protocol = null;
        this.requestURI = null;
        this.queryString = null;
        this.jsessionID = null;
        this.contextPath = null;
        this.lookupPath = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.mappedPath = null;
        this.extraParameter = null;
        this.contentLength = -1;
        this.contentType = null;
        this.userPostdataEncoding = null;
        this.charsetResolvedFromContentType = null;
        this.charsetResolvedFromAcceptLanguage = null;
        this.authType = null;
        this.sslSupport = null;
        this.scheme = this.tpoolManager != null ? this.tpoolManager.getScheme() : "http";
        this.remoteUser = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.serverName = null;
        this.serverPort = 0;
        this.cookies.removeAllElements();
        this.setRequestedSessionIdIndex(0);
        this.requestedSessionIds = null;
        this.createdSessionId = null;
        this.sessionIdFromCookie = false;
        this.sessionIdFromURL = false;
        this.httpSession = null;
        this.onDestroyed();
        this.context = null;
        this.attributes.clear();
        this.parameters.clear();
        this.headers.clear();
        this.headers2.clear();
        this.headers3.clear();
        this.didReadFormData = false;
        this.didParameters = false;
        this.didCookies = false;
        this.requestedSessionIdChecked = false;
        this.oldSessionChecked = false;
        this.cookieArray = null;
        this.usingReader = false;
        this.usingStream = false;
        this.wrapper = null;
        this.dispatcherType = null;
        this.requestDispatcherPath = null;
        this.filterChain = null;
        this.protocolInt = 0;
        this.connectionHeaderInt = 0;
        this.userPrincipal = null;
        this.subject = null;
    }

    public void finish() throws IOException {
        try {
            this.clearPostData();
        }
        catch (SocketException se) {
            throw se;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.in.setLimit(-1);
        }
    }

    final String getEngineName() {
        return this.contextGroup.getContainerManager().ENGINE_NAME;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this.handlePostData();
        s.defaultWriteObject();
    }

    public void processCommonRequest(String requestURI, String contextPath, String contextName) throws InterruptedException {
        if (requestURI == null) {
            return;
        }
        if (SecurityCheckUtil.isUnEncodeUriWithLastSpecialChar(requestURI)) {
            return;
        }
        requestURI = this.encodeRequestURI(requestURI);
        this.requestURI.setString(requestURI);
        if (contextPath != null && contextPath.length() > 0) {
            this.context = this.contextGroup.getContextByPath(this.getServerName(), contextPath);
        }
        this.context = contextName != null && !contextName.equalsIgnoreCase("jeus_dependent") ? this.contextGroup.getContextByName(contextName) : this.contextGroup.getContextByPath(this.getServerName(), requestURI);
        if (this.context != null) {
            this.contextPath = this.context.getContextPath();
            this.onCreated();
            return;
        }
    }

    public void processCommonRequest(MessageBytes requestURI, String contextPath, String contextName) throws InterruptedException {
        if (requestURI == null) {
            return;
        }
        this.originalRequestURI = MessageBytes.newInstance();
        try {
            this.originalRequestURI.duplicate(requestURI);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String encodedURI = this.encodeRequestURI(requestURI.toString());
        if (encodedURI == null) {
            return;
        }
        requestURI.setString(encodedURI);
        this.requestURI = requestURI;
        if (contextPath != null && contextPath.length() > 0) {
            this.context = this.contextGroup.getContextByPath(this.getServerName(), contextPath);
        }
        this.context = contextName != null && !contextName.equalsIgnoreCase("jeus_dependent") ? this.contextGroup.getContextByName(contextName) : this.contextGroup.getContextByPath(this.getServerName(), requestURI.toString());
        if (this.context != null) {
            this.contextPath = this.context.getContextPath();
            this.onCreated();
            return;
        }
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    public int getProtocolInt() {
        return this.protocolInt;
    }

    public void setProtocolInt(int protocolInt) {
        this.protocolInt = protocolInt;
    }

    public int getConnectionHeaderInt() {
        return this.connectionHeaderInt;
    }

    public void setConnectionHeader(int connectionHeaderInt) {
        this.connectionHeaderInt = connectionHeaderInt;
    }

    public void setMethod(String method) {
        this.method.setString(method);
    }

    public void setProtocol(String protocol) {
        this.protocol.setString(protocol);
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setSocketInfo(Socket socket) throws IOException {
        if (socket != null) {
            if (socket.isConnected()) {
                this.socket = socket;
                this.remoteAddr = socket.getInetAddress().getHostAddress();
                this.remotePort = socket.getPort();
            } else {
                throw new IOException("Socket " + socket + " is not connected. The client may disconnect the socket or the socket is closed.");
            }
        }
    }

    public HttpServletResponseImpl getResponse() {
        return this.response;
    }

    public String getRequestInfo() {
        String servletName = "unknown";
        if (this.wrapper != null) {
            servletName = this.wrapper.getClassName();
        }
        return "request from " + this.getRemoteAddr() + ":" + this.getRemotePort() + ". servlet = " + servletName + ", contentlen = " + this.contentLength;
    }

    private void setRequestedSessionIdIndex(int requestedSessionIdIndex) {
        if (this.requestedSessionIds == null) {
            this.requestedSessionIdIndex = 0;
            return;
        }
        if (this.requestedSessionIds.length <= requestedSessionIdIndex) {
            this.requestedSessionIdIndex = 0;
            return;
        }
        this.requestedSessionIdIndex = requestedSessionIdIndex;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        if (System.getSecurityManager() != null) {
            if (userPrincipal == null) {
                if (this.userPrincipal != null && this.subject != null && this.subject.getPrincipals().contains(this.userPrincipal)) {
                    this.subject.getPrincipals().remove(this.userPrincipal);
                }
            } else {
                HttpSession session = this.getSession(false);
                if (this.subject != null && !this.subject.getPrincipals().contains(userPrincipal)) {
                    this.subject.getPrincipals().add(userPrincipal);
                } else if (session != null && session.getAttribute("javax.security.auth.subject") == null) {
                    this.subject = new Subject();
                    this.subject.getPrincipals().add(userPrincipal);
                }
                if (session != null) {
                    session.setAttribute("javax.security.auth.subject", (Object)this.subject);
                }
            }
        }
        this.userPrincipal = userPrincipal;
    }

    public ContextGroup getContextGroup() {
        return this.contextGroup;
    }

    public void setExecutionCompleted(boolean b) {
        this.executionCompleted = b;
    }

    public boolean isExecutionCompleted() {
        return this.executionCompleted;
    }

    public void setDatasourcePrepared(boolean b) {
        this.datasourcePrepared = b;
    }

    public boolean getDatasourcePrepared() {
        return this.datasourcePrepared;
    }

    public RequestResponseKey getRequestResponseKey() {
        return this.rrk;
    }

    public void setRrk(RequestResponseKey rrk) {
        this.rrk = rrk;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Object getConnectionContext() {
        return null;
    }

    public void setConnectionHandle(Object handle) {
        this.connectionHandle = handle;
    }

    public Object getConnectionHandle() {
        return this.connectionHandle;
    }

    public void setBlockingMode(boolean blockingMode) {
        this.blockingMode = blockingMode;
    }

    public boolean isBlockingMode() {
        return this.blockingMode;
    }

    public SSLSupport getSslSupport() {
        return this.sslSupport;
    }

    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }
}

