/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.IncludedResponse;
import jeus.servlet.engine.RequestDispatcherImpl;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.io.ResponseHeaderInfo;
import jeus.servlet.engine.io.ServletOutputStreamWriter;
import jeus.servlet.engine.io.ServletPrintWriter;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.CharsetMap;
import jeus.servlet.util.JeusPrintWriter;
import jeus.sessionmanager.WebSessionConfigImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;

public class HttpServletResponseImpl
implements HttpServletResponse,
Serializable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    public static final String DEFAULT_HTTP_CHARSET = "ISO-8859-1";
    public static final String LOCALE_DEFAULT = "en";
    public static final byte[] CRLF = new byte[]{13, 10};
    private transient ContextGroup contextGroup;
    protected HttpServletRequestImpl request;
    private HashMap headers = new HashMap();
    private Vector userCookies = new Vector();
    private String contentType = null;
    private String forcedResponseEncoding;
    private String defaultResponseEncoding;
    private String characterEncoding;
    private int contentLength = -1;
    protected int status = 200;
    protected int accessLogStatus = -1;
    private String statusMessage = null;
    private Locale locale;
    protected transient WebServerOutputStream out;
    protected transient ServletOutputStreamWriter swriter;
    private transient ServletPrintWriter writer;
    private boolean usingStream = false;
    private boolean usingWriter = false;
    protected boolean errorSent = false;
    protected boolean isErrorPage = false;
    protected boolean sendRedirected = false;
    protected IncludedResponse included = null;
    private boolean contentTypeSetFlag = false;
    private boolean setCharacterEncodingFlag = false;
    private boolean flushedBuffer = false;
    private boolean setEncodingFlag = false;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public HttpServletResponseImpl(ContextGroup ctxGroup, WebServerOutputStream out) {
        this.contextGroup = ctxGroup;
        this.out = out;
        this.swriter = new ServletOutputStreamWriter(out);
        this.forcedResponseEncoding = ctxGroup.getForcedResponseEncoding();
        this.defaultResponseEncoding = ctxGroup.getDefaultResponseEncoding();
        if (this.defaultResponseEncoding == null) {
            this.defaultResponseEncoding = DEFAULT_HTTP_CHARSET;
        }
        this.characterEncoding = this.forcedResponseEncoding != null ? this.forcedResponseEncoding : this.defaultResponseEncoding;
        this.contentType = null;
        this.locale = HttpServletResponseImpl.getDefaultLocale();
    }

    public void setSocket(Socket soc) throws IOException {
        try {
            OutputStream os = soc.getOutputStream();
            this.out.setOutputStream(os);
        }
        catch (IOException ioe) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3424);
            throw new IOException(msg);
        }
    }

    public void setRequest(HttpServletRequestImpl request) {
        this.request = request;
    }

    HttpServletRequestImpl getRequest() {
        return this.request;
    }

    public int getStatus() {
        return this.status;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    IncludedResponse getIncludedResponse() {
        return this.included;
    }

    void setIncludedResponse(IncludedResponse value) {
        this.included = value;
    }

    void setJspErrorPageForwarded() {
        this.accessLogStatus = 500;
    }

    public int getAccessLogStatus() {
        return this.accessLogStatus > 0 ? this.accessLogStatus : this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            this.headers.put(name, values);
            if (name.equalsIgnoreCase("content-length")) {
                try {
                    this.contentLength = Integer.valueOf(value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void setDateHeader(String name, long date) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        this.setHeader(name, sdf.format(new Date(date)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
            if (values != null) {
                values.add(value);
                this.headers.put(name, values);
            } else {
                values = new ArrayList<String>();
                values.add(value);
                this.headers.put(name, values);
            }
            if (name.equalsIgnoreCase("content-length")) {
                try {
                    this.contentLength = Integer.valueOf(value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concatHeaderValue(String name, String value) {
        if (this.isContentLengthReached()) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                values.add(value);
                this.headers.put(name, values);
            } else {
                String oldValue = null;
                if (values.size() > 0) {
                    oldValue = (String)values.get(0);
                }
                values = new ArrayList();
                if (oldValue != null) {
                    String newValue = oldValue + ", " + value;
                    values.add(newValue);
                    this.headers.put(name, values);
                } else {
                    values.add(value);
                    this.headers.put(name, values);
                }
            }
        }
    }

    public void addDateHeader(String name, long date) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        String dateValue = sdf.format(new Date(date));
        this.addHeader(name, dateValue);
    }

    public void setIntHeader(String name, int value) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void addIntHeader(String name, int value) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        Enumeration enum1 = new Hashtable(this.headers).keys();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if (!key.toLowerCase().equals(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    void removeHeader(String name) {
        if (this.isContentLengthReached()) {
            return;
        }
        this.headers.remove(name);
    }

    public void setStatus(int status) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        this.status = status;
        this.statusMessage = null;
    }

    public void setStatus(int sc, String msg) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        this.status = sc;
        this.statusMessage = msg;
    }

    public void addCookie(Cookie cookie) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        this.userCookies.addElement(cookie);
    }

    public String encodeURL(String url) {
        if (this.isEncodeable(this.makeAbsolute(url))) {
            HttpSession session = this.request.getSession(false);
            String appended = ";jsessionid=" + session.getId();
            int question = url.indexOf("?");
            String path = url;
            String query = "";
            if (question >= 0) {
                path = url.substring(0, question);
                query = url.substring(question);
            }
            StringBuffer sb = new StringBuffer(path);
            sb.append(appended);
            sb.append(query);
            return sb.toString();
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String location) {
        return this.encodeRedirectURL(location);
    }

    public String getCharacterEncoding() {
        if (!this.setEncodingFlag) {
            this.setEncoding();
        }
        return this.characterEncoding;
    }

    public String getContentType() {
        String ret = this.contentType;
        if (!this.setEncodingFlag) {
            this.setEncoding();
        }
        if (ret != null && this.characterEncoding != null && ret.indexOf("charset=") == -1) {
            ret = ret + ";charset=" + this.characterEncoding;
        }
        return ret;
    }

    public void setCharacterEncoding(String charset) {
        if (this.usingWriter || this.flushedBuffer) {
            return;
        }
        this.setEncodingInternal(charset, true);
        if (this.contentType != null) {
            String _previous = this.contentType;
            int _pos = this.contentType.indexOf(";charset=");
            if (_pos >= 0) {
                this.contentType = this.contentType.substring(0, _pos) + ";charset=" + charset;
                if (!_previous.equalsIgnoreCase(this.contentType)) {
                    this.setHeader("Content-Type", this.contentType);
                }
            } else {
                this.setHeader("Content-Type", this.getContentType());
            }
        } else {
            WebProperties props = this.getContextProperties();
            if (!WebProperties.J2EE_COMPATIBLE.value) {
                this.contentType = props.DEFAULT_CONTENT_TYPE + ";charset=" + charset;
                this.setHeader("Content-Type", this.contentType);
            }
        }
        this.setCharacterEncodingFlag = true;
    }

    public void setContentType(String contentType) {
        this.setContentType(contentType, false);
    }

    private void setEncoding() {
        Context context = null;
        if (this.request != null && (context = this.request.getContext()) != null) {
            if (context.getForcedResponseEncoding() != null) {
                this.forcedResponseEncoding = context.getForcedResponseEncoding();
            }
            if (context.getDefaultResponseEncoding() != null) {
                this.defaultResponseEncoding = context.getDefaultResponseEncoding();
            }
            if (!this.setCharacterEncodingFlag) {
                this.characterEncoding = this.forcedResponseEncoding != null ? this.forcedResponseEncoding : this.defaultResponseEncoding;
            }
            this.setEncodingFlag = true;
        }
    }

    private void setContentType(String contentType, boolean _internal) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        if (!this.setEncodingFlag) {
            this.setEncoding();
        }
        this.contentType = this.usingWriter ? RequestUtil.getContentTypeWithoutCharset(contentType) : contentType;
        String encoding = null;
        if (!this.usingWriter) {
            encoding = RequestUtil.getCharsetFromContentType(contentType);
        }
        if (encoding != null && this.forcedResponseEncoding == null) {
            if (_internal) {
                this.setEncodingInternal(encoding, false);
            } else {
                String _beforeCharEncoding = this.characterEncoding;
                this.setEncodingInternal(encoding, true);
                if (_beforeCharEncoding != null && !_beforeCharEncoding.equalsIgnoreCase(this.characterEncoding) || _beforeCharEncoding == null && this.characterEncoding != null) {
                    this.contentTypeSetFlag = true;
                }
            }
        }
        this.setHeader("Content-Type", this.getContentType());
    }

    private void setEncodingInternal(String encoding, boolean _enforce) {
        if (this.flushedBuffer) {
            return;
        }
        if (!_enforce && this.setCharacterEncodingFlag) {
            return;
        }
        try {
            this.swriter.setEncoding(encoding);
            this.characterEncoding = encoding;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setContentLength(int contentLength) {
        if (contentLength < 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, JeusMessage_WebContainer2._3610, (Object)new Integer(contentLength), (Throwable)new IllegalArgumentException("Invalid argument value in ServletResponse.setContentLength()"));
            } else if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, JeusMessage_WebContainer2._3610, (Object)new Integer(contentLength));
            }
            return;
        }
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        this.contentLength = contentLength;
        this.setHeader("Content-Length", new Integer(contentLength).toString());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale loc) {
        if (this.included != null || this.sendRedirected) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.contextGroup.getForcedResponseEncoding() != null) {
            return;
        }
        if (loc == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.isContentLengthReached()) {
            return;
        }
        this.locale = loc;
        if (this.usingWriter) {
            return;
        }
        String contentLanguage = loc.getLanguage() + "-" + loc.getCountry();
        if (!this.contentTypeSetFlag) {
            String newType = this.getLocalizedContentType(this.contentType, loc);
            this.setContentType(newType, true);
            this.setLocaleEncoding(loc);
        }
        this.concatHeaderValue("Content-Language", contentLanguage);
    }

    private boolean isContentLengthReached() {
        if (!WebProperties.J2EE_COMPATIBLE.value) {
            return false;
        }
        if (this.contentLength < 0) {
            return false;
        }
        int count = 0;
        if (this.writer != null) {
            count = this.writer.getCharCount();
        }
        return (count += this.out.getContentCount()) >= this.contentLength;
    }

    private void setLocaleEncoding(Locale loc) {
        Context context = this.request.getContext();
        if (context == null) {
            return;
        }
        String _encoding = context.getEncoding(loc.getLanguage(), loc.toString());
        if (_encoding == null) {
            return;
        }
        this.setEncodingInternal(_encoding, false);
    }

    private String getLocalizedContentType(String type, Locale loc) {
        String charset;
        int semi;
        if (type == null) {
            WebProperties props = this.getContextProperties();
            type = props.DEFAULT_CONTENT_TYPE.value;
        }
        if ((semi = type.indexOf(";")) != -1) {
            type = type.substring(0, semi);
        }
        if ((charset = CharsetMap.getCharset(loc)) != null) {
            type = type + "; charset=" + charset;
        }
        return type;
    }

    public int getBufferSize() {
        return this.out.getBufferSize();
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (this.included != null) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3472));
        }
        this.out.setBufferSize(size);
    }

    public void flushBuffer() throws IOException {
        if (this.sendRedirected) {
            return;
        }
        this.swriter.flushBuffer();
        this.out.forceFlush();
        this.flushedBuffer = true;
    }

    final void beginForwardFlush() {
        this.out.beginForwardFlush();
    }

    final void endForwardFlush() {
        this.out.endForwardFlush();
    }

    public boolean isCommitted() {
        return this.out.isCommitted();
    }

    public void reset() throws IllegalStateException {
        if (this.included != null) {
            return;
        }
        this.userCookies.removeAllElements();
        this.contentType = null;
        this.locale = HttpServletResponseImpl.getDefaultLocale();
        this.characterEncoding = this.forcedResponseEncoding != null ? this.forcedResponseEncoding : this.defaultResponseEncoding;
        this.contentLength = -1;
        this.status = 200;
        this.statusMessage = null;
        this.headers.clear();
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3473));
        }
        this.out.reset();
        try {
            this.swriter.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        try {
            this.swriter.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.resetContent();
    }

    private ServletOutputStream getUnderlyingStream() {
        return this.out;
    }

    public ServletOutputStream getOutputStream() {
        if (WebProperties.J2EE_COMPATIBLE.value && this.usingWriter) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3426));
        }
        this.usingStream = true;
        return this.getUnderlyingStream();
    }

    private PrintWriter getUnderlyingWriter() throws IOException {
        String encoding = this.getCharacterEncoding();
        this.writer = new ServletPrintWriter(this.swriter);
        if (logger.isLoggable(JeusMessage_WebContainer2._3609_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3609_LEVEL, JeusMessage_WebContainer2._3609, (Object)encoding);
        }
        if (encoding == null || "Default".equals(encoding)) {
            this.swriter.setEncoding(null);
        } else {
            try {
                this.swriter.setEncoding(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                if (encoding.equals("8859_1") || encoding.equals(DEFAULT_HTTP_CHARSET)) {
                    this.swriter.setEncoding(null);
                } else {
                    try {
                        this.swriter.setEncoding(DEFAULT_HTTP_CHARSET);
                    }
                    catch (UnsupportedEncodingException ex2) {
                        this.swriter.setEncoding(null);
                    }
                }
                System.out.println("Unsupported encoding: " + encoding);
            }
        }
        this.out.setUsingWriter(this.swriter);
        return this.writer;
    }

    public void setUsingWriter(boolean usingWriter) {
        this.usingWriter = usingWriter;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (WebProperties.J2EE_COMPATIBLE.value && this.usingStream) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3427));
        }
        this.usingWriter = true;
        return this.getUnderlyingWriter();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.included != null) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3470));
        }
        if (this.included != null) {
            throw new IOException(msg);
        }
        this.accessLogStatus = sc;
        this.errorSent = true;
        this.status = sc;
        Context context = this.request.getContext();
        if (context == null) {
            this.printErrorToBrowser(sc, msg, true);
            this.flushBuffer();
            this.close();
            return;
        }
        String path = null;
        if (!this.isErrorPage) {
            path = context.getErrorPage(String.valueOf(sc), null);
        }
        if (path != null) {
            this.isErrorPage = true;
            RequestDispatcher rd = context.getRequestDispatcher(path);
            this.request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.ERROR_INTEGER);
            this.request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", ((RequestDispatcherImpl)rd).getPath());
            this.request.setAttribute("javax.servlet.error.status_code", new Integer(sc));
            this.request.setAttribute("javax.servlet.error.message", msg);
            this.request.setAttribute("javax.servlet.error.request_uri", this.request.getRequestURI());
            String servletName = null;
            ExecutionWrapper wrapper = this.request.getExecutionWrapper();
            if (wrapper != null) {
                servletName = wrapper.getName();
            }
            if (servletName != null) {
                this.request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            try {
                this.reset();
                this.status = sc;
                rd.forward((ServletRequest)this.request, (ServletResponse)this);
            }
            catch (IllegalStateException ise) {
                try {
                    rd.include((ServletRequest)this.request, (ServletResponse)this);
                }
                catch (ServletException se) {
                    this.printErrorToBrowser(sc, msg, true);
                }
            }
            catch (ServletException se) {
                this.printErrorToBrowser(sc, msg, true);
            }
        } else {
            this.printErrorToBrowser(sc, msg, true);
        }
        this.flushBuffer();
        this.close();
    }

    public void sendError(int sc, String msg, Throwable t) throws IOException {
        if (this.included != null) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3470));
        }
        if (this.included != null) {
            throw new IOException(msg);
        }
        this.accessLogStatus = sc;
        this.errorSent = true;
        this.status = sc;
        Context context = this.request.getContext();
        if (context == null) {
            this.printErrorToBrowser(sc, msg, t);
            this.flushBuffer();
            this.close();
            return;
        }
        String path = null;
        if (!this.isErrorPage) {
            path = context.getErrorPage(String.valueOf(sc), t);
        }
        if (path != null) {
            this.isErrorPage = true;
            RequestDispatcher rd = context.getRequestDispatcher(path);
            this.request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.INCLUDE_INTEGER);
            this.request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", ((RequestDispatcherImpl)rd).getPath());
            this.request.setAttribute("javax.servlet.error.status_code", new Integer(sc));
            if (t != null) {
                if (t instanceof ServletException) {
                    Throwable t2 = ((ServletException)t).getRootCause();
                    if (t2 != null) {
                        this.request.setAttribute("javax.servlet.error.exception_type", t2.getClass());
                        this.request.setAttribute("javax.servlet.error.exception", t2);
                        this.request.setAttribute("javax.servlet.error.message", t2.getMessage());
                    } else {
                        this.request.setAttribute("javax.servlet.error.exception_type", t.getClass());
                        this.request.setAttribute("javax.servlet.error.exception", t);
                        this.request.setAttribute("javax.servlet.error.message", msg);
                    }
                } else {
                    this.request.setAttribute("javax.servlet.error.exception_type", t.getClass());
                    this.request.setAttribute("javax.servlet.error.exception", t);
                    this.request.setAttribute("javax.servlet.error.message", msg);
                }
            }
            this.request.setAttribute("javax.servlet.error.request_uri", this.request.getRequestURI());
            String servletName = null;
            ExecutionWrapper wrapper = this.request.getExecutionWrapper();
            if (wrapper != null) {
                servletName = wrapper.getName();
            }
            if (servletName != null) {
                this.request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            try {
                this.reset();
                this.status = sc;
                rd.forward((ServletRequest)this.request, (ServletResponse)this);
            }
            catch (IllegalStateException ise) {
                try {
                    rd.include((ServletRequest)this.request, (ServletResponse)this);
                }
                catch (ServletException se) {
                    this.printErrorToBrowser(sc, msg, t);
                }
            }
            catch (ServletException se) {
                this.printErrorToBrowser(sc, msg, t);
            }
        } else {
            this.printErrorToBrowser(sc, msg, t);
        }
        this.flushBuffer();
        this.close();
    }

    protected void printErrorToBrowser(int sc, String msg, boolean showMessage) throws IOException {
        this.resetBuffer();
        this.setContentType("text/html;charset=" + this.getCharacterEncoding());
        StringBuffer buf = new StringBuffer();
        String statusStr = RequestUtil.getStatusString(sc);
        String title = sc + " " + statusStr;
        boolean attachStacktraceOnError = this.contextGroup.isAttachStacktraceOnError();
        if (!attachStacktraceOnError && this.request.getContext() != null) {
            attachStacktraceOnError = this.request.getContext().isAttachStacktrace();
        }
        if (attachStacktraceOnError) {
            buf.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n");
            buf.append("<HTML>\r\n\t<HEAD>\r\n\t\t<TITLE>" + title + "</TITLE>\r\n");
            buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
            buf.append("\t</HEAD>\r\n");
            buf.append("\t<BODY>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n\t\t\t<TR>\r\n\t\t\t\t<TD bgColor=\"#b2b2b2\">\r\n");
            buf.append("\t\t\t\t\t<STRONG><FONT size=\"5\"><FONT face=\"Courier\">&nbsp; </FONT><FONT face=\"Arial\">HTTP Status&nbsp;<FONT color=\"#6600cc\">:&nbsp;" + sc + " - " + title + "</FONT></FONT></FONT></STRONG>\r\n");
            buf.append("\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n\t\t</TABLE>\r\n");
            buf.append("\t\t<br>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            if (msg != null) {
                msg = this.replaceScriptStart(msg);
                buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n");
                buf.append("\t\t\t<TR>\r\n\t\t\t\t<TD vAlign=\"top\" align=\"right\" width=\"140\" bgColor=\"#e0e0e0\">\r\n\t\t\t\t\t<P align=\"center\"><FONT face=\"Courier\" color=\"#0a246a\" size=\"4\"><STRONG>Description</STRONG></FONT></P>\r\n\t\t\t\t</TD>\r\n\t\t\t\t<TD bgColor=\"#f0e0e0\">\r\n");
                buf.append("\t\t\t\t\t<DIV align=\"left\"><PRE><FONT face=Courier size=4>" + msg + "</FONT></PRE></DIV>\r\n\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n");
                buf.append("\t\t</TABLE>\r\n");
            }
            buf.append("\t</BODY>\r\n</HTML>");
        } else {
            buf.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n");
            buf.append("<HTML>\r\n\t<HEAD>\r\n\t\t<TITLE>" + title + "</TITLE>\r\n");
            buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
            buf.append("\t</HEAD>\r\n");
            buf.append("\t<BODY>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t\t<H1>" + statusStr + "</H1>\r\n");
            if (showMessage) {
                buf.append("\t\t<br>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
                if (msg != null) {
                    msg = this.replaceScriptStart(msg);
                    buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n");
                    buf.append("\t\t\t<TR>\r\n\t\t\t\t<TD vAlign=\"top\" align=\"right\" width=\"140\" bgColor=\"#e0e0e0\">\r\n\t\t\t\t\t<P align=\"center\"><FONT face=\"Courier\" color=\"#0a246a\" size=\"4\"><STRONG>Description</STRONG></FONT></P>\r\n\t\t\t\t</TD>\r\n\t\t\t\t<TD bgColor=\"#f0e0e0\">\r\n");
                    buf.append("\t\t\t\t\t<DIV align=\"left\"><PRE><FONT face=Courier size=4>" + msg + "</FONT></PRE></DIV>\r\n\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n");
                    buf.append("\t\t</TABLE>\r\n");
                }
            }
            buf.append("\t</BODY>\r\n</HTML>");
        }
        this.sendBodyText(buf.toString());
    }

    protected void printErrorToBrowser(int sc, String msg, Throwable t) throws IOException {
        this.resetBuffer();
        this.setContentType("text/html;charset=" + this.getCharacterEncoding());
        StringBuffer buf = new StringBuffer();
        String statusStr = RequestUtil.getStatusString(sc);
        String title = sc + " " + statusStr;
        boolean attachStacktraceOnError = this.contextGroup.isAttachStacktraceOnError();
        if (!attachStacktraceOnError && this.request.getContext() != null) {
            attachStacktraceOnError = this.request.getContext().isAttachStacktrace();
        }
        if (attachStacktraceOnError) {
            buf.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n");
            buf.append("<HTML>\r\n\t<HEAD>\r\n\t\t<TITLE>" + title + "</TITLE>\r\n");
            buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
            buf.append("\t</HEAD>\r\n");
            buf.append("\t<BODY>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n\t\t\t<TR>\r\n\t\t\t\t<TD bgColor=\"#b2b2b2\">\r\n");
            buf.append("\t\t\t\t\t<STRONG><FONT size=\"5\"><FONT face=\"Courier\">&nbsp; </FONT><FONT face=\"Arial\">HTTP Status&nbsp;<FONT color=\"#6600cc\">:&nbsp;" + sc + " - " + title + "</FONT></FONT></FONT></STRONG>\r\n");
            buf.append("\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n\t\t</TABLE>\r\n");
            buf.append("\t\t<br>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n");
            if (msg != null) {
                msg = this.replaceScriptStart(msg);
                buf.append("\t\t\t<TR>\r\n\t\t\t\t<TD vAlign=\"top\" align=\"right\" width=\"140\" bgColor=\"#e0e0e0\">\r\n\t\t\t\t\t<P align=\"center\"><FONT face=\"Courier\" color=\"#0a246a\" size=\"4\"><STRONG>Description</STRONG></FONT></P>\r\n\t\t\t\t</TD>\r\n\t\t\t\t<TD bgColor=\"#f0e0e0\">\r\n");
                buf.append("\t\t\t\t\t<DIV align=\"left\"><PRE><FONT face=Courier size=4>" + msg + "</FONT></PRE></DIV>\r\n\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n");
            }
            this.sendErrorText(buf.toString(), t);
        } else {
            buf.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n");
            buf.append("<HTML>\r\n\t<HEAD>\r\n\t\t<TITLE>" + title + "</TITLE>\r\n");
            buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
            buf.append("\t</HEAD>\r\n");
            buf.append("\t<BODY>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t\t<H1>" + statusStr + "</H1>\r\n");
            buf.append("\t\t<br>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t</BODY>\r\n</HTML>");
            this.sendBodyText(buf.toString());
        }
    }

    public void sendAuthRequest(int sc, String authenticateHeader, String msg) throws IOException {
        boolean attachStacktraceOnError;
        this.reset();
        this.status = sc;
        StringBuffer buf = new StringBuffer();
        String statusStr = RequestUtil.getStatusString(sc);
        String title = sc + " " + statusStr;
        this.setContentType("text/html");
        if (authenticateHeader != null) {
            this.setHeader("WWW-Authenticate", authenticateHeader);
        }
        if (!(attachStacktraceOnError = this.contextGroup.isAttachStacktraceOnError()) && this.request.getContext() != null) {
            attachStacktraceOnError = this.request.getContext().isAttachStacktrace();
        }
        if (attachStacktraceOnError) {
            buf.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n");
            buf.append("<HTML>\r\n\t<HEAD>\r\n\t\t<TITLE>" + title + "</TITLE>\r\n");
            buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
            buf.append("\t</HEAD>\r\n");
            buf.append("\t<BODY>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n\t\t\t<TR>\r\n\t\t\t\t<TD bgColor=\"#b2b2b2\">\r\n");
            buf.append("\t\t\t\t\t<STRONG><FONT size=\"5\"><FONT face=\"Courier\">&nbsp; </FONT><FONT face=\"Arial\">HTTP Status&nbsp;<FONT color=\"#6600cc\">:&nbsp;" + sc + " - " + title + "</FONT></FONT></FONT></STRONG>\r\n");
            buf.append("\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n\t\t</TABLE>\r\n");
            buf.append("\t\t<br>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            if (msg != null) {
                msg = this.replaceScriptStart(msg);
                buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n");
                buf.append("\t\t\t<TR>\r\n\t\t\t\t<TD vAlign=\"top\" align=\"right\" width=\"140\" bgColor=\"#e0e0e0\">\r\n\t\t\t\t\t<P align=\"center\"><FONT face=\"Courier\" color=\"#0a246a\" size=\"4\"><STRONG>Description</STRONG></FONT></P>\r\n\t\t\t\t</TD>\r\n\t\t\t\t<TD bgColor=\"#f0e0e0\">\r\n");
                buf.append("\t\t\t\t\t<DIV align=\"left\"><PRE><FONT face=Courier size=4>" + msg + "</FONT></PRE></DIV>\r\n\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n");
                buf.append("\t\t</TABLE>\r\n");
            }
            buf.append("\t</BODY>\r\n</HTML>");
        } else {
            buf.append("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n");
            buf.append("<HTML>\r\n\t<HEAD>\r\n\t\t<TITLE>" + title + "</TITLE>\r\n");
            buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
            buf.append("\t</HEAD>\r\n");
            buf.append("\t<BODY>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            buf.append("\t\t<H1>" + statusStr + "</H1>\r\n");
            buf.append("\t\t<br>\r\n\t\t<hr align=\"center\" noShade>\r\n\t\t<br>\r\n");
            if (msg != null) {
                msg = this.replaceScriptStart(msg);
                buf.append("\t\t<TABLE cellSpacing=\"5\" cellPadding=\"5\" width=\"100%\" bgColor=\"#ffffff\" border=\"0\">\r\n");
                buf.append("\t\t\t<TR>\r\n\t\t\t\t<TD vAlign=\"top\" align=\"right\" width=\"140\" bgColor=\"#e0e0e0\">\r\n\t\t\t\t\t<P align=\"center\"><FONT face=\"Courier\" color=\"#0a246a\" size=\"4\"><STRONG>Description</STRONG></FONT></P>\r\n\t\t\t\t</TD>\r\n\t\t\t\t<TD bgColor=\"#f0e0e0\">\r\n");
                buf.append("\t\t\t\t\t<DIV align=\"left\"><PRE><FONT face=Courier size=4>" + msg + "</FONT></PRE></DIV>\r\n\t\t\t\t</TD>\r\n\t\t\t</TR>\r\n");
                buf.append("\t\t</TABLE>\r\n");
            }
            buf.append("\t</BODY>\r\n</HTML>");
        }
        this.sendBodyText(buf.toString());
        this.flushBuffer();
        this.close();
    }

    public void sendRedirect(String location) throws IOException {
        if (this.sendRedirected || this.included != null) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3469));
        }
        this.out.reset();
        this.swriter.clear();
        this.setStatus(302);
        this.setContentType("text/html");
        location = this.makeAbsolute(location);
        this.setHeader("Location", location);
        StringBuffer buf = new StringBuffer();
        buf.append("<head><title>Document moved</title>");
        buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
        buf.append("</head>\r\n");
        buf.append("<body><h1>Document moved</h1>\r\n");
        buf.append("This document has moved <a href=\"");
        buf.append(location);
        buf.append("\">here</a>.<p>\r\n");
        buf.append("</body>\r\n");
        this.sendBodyText(buf.toString());
        this.sendRedirected = true;
        this.flushBuffer();
        this.close();
    }

    protected void sendBodyText(String s) throws IOException {
        byte[] b = null;
        try {
            b = s.getBytes(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace(System.out);
            b = s.getBytes();
        }
        try {
            this.setContentLength(b.length);
            this.out.write(b);
        }
        catch (IllegalStateException ise) {
            ServletOutputStream out = this.getOutputStream();
            out.write(b);
        }
    }

    private void sendErrorText(String s, Throwable t) throws IOException {
        ServletPrintWriter pw = new ServletPrintWriter(this.swriter);
        JeusPrintWriter sw = new JeusPrintWriter(this.swriter);
        JeusPrintWriter tempsw = new JeusPrintWriter(this.swriter);
        try {
            this.swriter.setEncoding(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            this.swriter.setEncoding(null);
        }
        try {
            sw.write(s);
            sw.write("<TR><TD ALIGN=RIGHT VALIGN=TOP BGCOLOR=#F0F0F0><B>error dump</B></TD><TD><PRE>\n");
            t.printStackTrace(tempsw);
            String msg = tempsw.getString();
            msg = this.replaceScriptStart(msg);
            msg = this.replaceScriptEnd(msg);
            sw.write(msg);
            tempsw.clear();
            sw.write("</PRE></TD></TR>\n");
            if (t instanceof ServletException) {
                Throwable cause;
                Throwable root = ((ServletException)t).getRootCause();
                if (root != null) {
                    sw.write("<TR><TD ALIGN=RIGHT VALIGN=TOP BGCOLOR=#F0F0F0><B>root cause</B></TD><TD><PRE>\n");
                    root.printStackTrace(tempsw);
                    msg = tempsw.getString();
                    msg = this.replaceScriptStart(msg);
                    msg = this.replaceScriptEnd(msg);
                    sw.write(msg);
                    tempsw.clear();
                    sw.write("</PRE></TD></TR>\n");
                }
                if (root != null && root instanceof Jsp2EngineException && (cause = ((Jsp2EngineException)((Object)root)).getRootCause()) != null) {
                    sw.write("<TR><TD ALIGN=RIGHT VALIGN=TOP BGCOLOR=#F0F0F0><B>cause</B></TD><TD><PRE>\n");
                    cause.printStackTrace(tempsw);
                    msg = tempsw.getString();
                    msg = this.replaceScriptStart(msg);
                    msg = this.replaceScriptEnd(msg);
                    sw.write(msg);
                    tempsw.clear();
                    sw.write("</PRE></TD></TR>\n");
                }
            }
            sw.write("</TABLE>\n");
            sw.write("</BODY></HTML>\n");
            msg = sw.getString();
            pw.println(msg);
            pw.flush();
        }
        catch (IllegalStateException ise) {
            Throwable root;
            ServletPrintWriter pw2 = new ServletPrintWriter(this.swriter);
            sw.write(s);
            sw.write("<TR><TD ALIGN=RIGHT VALIGN=TOP BGCOLOR=#F0F0F0><B>error dump</B></TD><TD><PRE>\n");
            t.printStackTrace(tempsw);
            String msg = tempsw.getString();
            msg = this.replaceScriptStart(msg);
            msg = this.replaceScriptEnd(msg);
            sw.write(msg);
            tempsw.clear();
            sw.write("</PRE></TD></TR>\n");
            if (t instanceof ServletException && (root = ((ServletException)t).getRootCause()) != null) {
                sw.write("<TR><TD ALIGN=RIGHT VALIGN=TOP BGCOLOR=#F0F0F0><B>root cause</B></TD><TD><PRE>\n");
                root.printStackTrace(tempsw);
                msg = tempsw.getString();
                msg = this.replaceScriptStart(msg);
                msg = this.replaceScriptEnd(msg);
                sw.write(msg);
                tempsw.clear();
                sw.write("</PRE></TD></TR>\n");
            }
            sw.write("</TABLE>\n");
            sw.write("</BODY></HTML>\n");
            msg = sw.getString();
            pw2.println(msg);
            pw2.flush();
        }
    }

    protected void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public final void unclose() {
        if (this.writer != null) {
            this.writer.unclose();
        } else if (this.swriter != null) {
            this.swriter.unclose();
        } else if (this.out != null) {
            this.out.unclose();
        }
    }

    private String replaceScriptStart(String msg) {
        if (msg == null || msg.indexOf("<") < 0) {
            return msg;
        }
        StringTokenizer tok = new StringTokenizer(msg, "<", true);
        StringBuffer buf = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals("<")) {
                buf.append("&lt;");
                continue;
            }
            buf.append(token);
        }
        return buf.toString();
    }

    private String replaceScriptEnd(String msg) {
        if (msg == null || msg.indexOf(">") < 0) {
            return msg;
        }
        StringTokenizer tok = new StringTokenizer(msg, ">", true);
        StringBuffer buf = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals(">")) {
                buf.append("&gt;");
                continue;
            }
            buf.append(token);
        }
        return buf.toString();
    }

    private StringBuffer getStatusLine() {
        StringBuffer statusSB = new StringBuffer();
        String message = this.statusMessage;
        if (message == null) {
            message = RequestUtil.getStatusString(this.status);
        }
        statusSB.append("HTTP/1.1 ").append(this.status);
        if (message != null) {
            statusSB.append(" ").append(message);
        }
        statusSB.append("\r\n");
        return statusSB;
    }

    public ResponseHeaderInfo getResponseHeader() {
        String sessionId = this.request.getCreatedSessionId();
        if (sessionId != null) {
            this.userCookies.addElement(WebSessionConfigImpl.getJeusJSessionIdCookie(this.request, sessionId));
        }
        return new ResponseHeaderInfo(this.getStatus(), this.getStatusLine(), this.headers, this.userCookies, this.contextGroup.getCustomHeader(), this.contextGroup.getCustomHeaderVector(), this.getContentLength(), this.getCharacterEncoding());
    }

    public void clearing() {
        this.headers.clear();
        this.userCookies.removeAllElements();
        this.contentType = null;
        this.characterEncoding = this.forcedResponseEncoding != null ? this.forcedResponseEncoding : this.defaultResponseEncoding;
        this.contentLength = -1;
        this.status = 200;
        this.accessLogStatus = -1;
        this.statusMessage = null;
        this.locale = HttpServletResponseImpl.getDefaultLocale();
        this.writer = null;
        this.usingStream = false;
        this.usingWriter = false;
        this.isErrorPage = false;
        this.sendRedirected = false;
        this.included = null;
        this.contentTypeSetFlag = false;
        this.setCharacterEncodingFlag = false;
        this.flushedBuffer = false;
        this.errorSent = false;
    }

    public void finish() throws IOException {
        try {
            if (this.usingWriter && this.writer != null) {
                this.writer.flush();
            }
            if (this.out != null) {
                this.out.finalFlush();
            }
        }
        catch (SocketException se) {
            return;
        }
        catch (IOException ie) {
            throw ie;
        }
        finally {
            if (this.usingWriter && this.writer != null) {
                this.writer.reset();
            }
            if (this.out != null) {
                if (this.contentLength == -1) {
                    this.contentLength = this.out.getContentCount();
                }
                this.out.finish();
            }
        }
    }

    public String getResponseInfo() {
        ExecutionWrapper wrapper = this.request.getExecutionWrapper();
        String servletName = "unknown";
        if (wrapper != null) {
            servletName = wrapper.getClassName();
        }
        return "response to " + this.request.getRemoteAddr() + ":" + this.request.getRemotePort() + ". servlet = " + servletName + ", contentLength = " + this.contentLength;
    }

    public HashMap getHeaders() {
        return this.headers;
    }

    public boolean isRedirected() {
        return this.sendRedirected;
    }

    public boolean errorSent() {
        return this.errorSent;
    }

    public void setKeepAlive() {
        this.out.setKeepAlive();
    }

    public void unsetKeepAlive() {
        this.out.unsetKeepAlive();
    }

    private WebProperties getContextProperties() {
        Context context = this.request.getContext();
        if (context != null) {
            return context.getContextProperties();
        }
        return this.contextGroup.getContextGroupProperties();
    }

    private boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        if (!this.request.forceURLRewriting() && this.request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        return this.doIsEncodeable(session, location);
    }

    private boolean doIsEncodeable(HttpSession session, String location) {
        Context context = this.request.getContext();
        if (context != null && context.isSessionShared()) {
            return true;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!this.request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!this.request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = this.request.getServerPort();
        int urlPort = url.getPort();
        if (urlPort == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = null;
        if (context != null) {
            contextPath = context.getContextPath();
        }
        if (contextPath != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            if (file.indexOf(";jsessionid=" + session.getId()) >= 0) {
                return false;
            }
        }
        return true;
    }

    protected String makeAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !this.hasScheme(location)) {
            StringBuffer redirectURL = new StringBuffer(128);
            String scheme = this.request.getScheme();
            String hostString = this.request.getHeader("Host");
            String hostName = null;
            int portInt = -1;
            if (hostString == null) {
                hostName = this.request.getServerName();
                portInt = this.request.getServerPort();
            } else {
                int indexOfColon = hostString.indexOf(58);
                if (indexOfColon > 0) {
                    hostName = hostString.substring(0, indexOfColon);
                    portInt = Integer.parseInt(hostString.substring(indexOfColon + 1));
                } else {
                    hostName = hostString.trim();
                    portInt = scheme != null && "https".equals(scheme) ? 443 : 80;
                }
            }
            try {
                redirectURL.append(scheme);
                redirectURL.append("://");
                redirectURL.append(hostName);
                if (scheme.equals("http") && portInt != 80 || scheme.equals("https") && portInt != 443) {
                    redirectURL.append(':');
                    String portS = portInt + "";
                    redirectURL.append(portS);
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getRequestURI();
                    if (relativePath == null) {
                        relativePath = "/";
                    }
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    redirectURL.append(relativePath);
                    redirectURL.append('/');
                }
                redirectURL.append(location);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(location);
            }
            return redirectURL.toString();
        }
        return location;
    }

    private boolean hasScheme(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (RequestUtil.isSchemeChar(c)) continue;
            return false;
        }
        return false;
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(tz);
    }
}

