/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.DispatchedRequest;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.ForwardedRequest;
import jeus.servlet.engine.ForwardedResponse;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletRequestWrapperForward;
import jeus.servlet.engine.HttpServletRequestWrapperInclude;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.IncludedRequest;
import jeus.servlet.engine.IncludedResponse;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.ServletMapper;
import jeus.servlet.filter.FilterChainImpl;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer1;
import jeus.util.message.JeusMessage_WebContainer2;

public class RequestDispatcherImpl
implements RequestDispatcher {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    private Context context = null;
    private String path = null;
    private String queryString = null;
    private String name = null;
    HttpServletResponseImpl orgresp = null;

    RequestDispatcherImpl(Context context) {
        this.context = context;
    }

    void setPath(String urlPath) {
        int i = urlPath.indexOf("?");
        if (i < 0) {
            this.path = RequestUtil.removeDotDot(urlPath);
        } else {
            this.path = RequestUtil.removeDotDot(urlPath.substring(0, i));
            int len = urlPath.length();
            if (i < len) {
                this.queryString = urlPath.substring(i + 1);
            }
        }
    }

    void setName(String name) {
        this.name = name;
    }

    public void forward(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        WebProperties props = PropertyUtil.getContextProperties();
        if (props.PERSISTENT_REQUEST_URL.value) {
            this.forward2(req, resp);
            return;
        }
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)resp;
        }
        catch (ClassCastException e) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3459));
        }
        if (response.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3471));
        }
        response.resetBuffer();
        boolean isGetNamedDispatcher = false;
        ExecutionWrapper wrapper = null;
        ServletMapper mapper = null;
        String servletPath = null;
        String pathInfo = null;
        if (this.name != null) {
            wrapper = this.context.getServletByName(this.name);
            isGetNamedDispatcher = true;
        } else {
            mapper = this.context.getServletByPath(this.path);
            if (mapper != null) {
                servletPath = mapper.getServletPath();
                pathInfo = mapper.getPathInfo();
                wrapper = mapper.getExecutionWrapper();
                isGetNamedDispatcher = false;
            }
        }
        if (wrapper == null) {
            if (this.name != null) {
                throw new FileNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3428, (Object)this.name));
            }
            throw new FileNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3428, (Object)this.path));
        }
        ForwardedRequest dispreq = new ForwardedRequest(request, this.context, isGetNamedDispatcher);
        HttpServletRequest freq = ((DispatchedRequest)dispreq).getRequest(this.context.getContextPath(), this.path, this.queryString, servletPath, pathInfo);
        ForwardedResponse fres = new ForwardedResponse(response, request);
        this.doForward(wrapper, dispreq, freq, fres);
        logger.log(JeusMessage_WebContainer2._3651_LEVEL, JeusMessage_WebContainer2._3651, (Object)this.path);
    }

    private void doForward(ExecutionWrapper wrapper, DispatchedRequest dispatchedReq, HttpServletRequest fwdReq, ForwardedResponse fwdRes) throws IOException, ServletException {
        block14: {
            boolean success = false;
            try {
                this.processCommonRequestDispatcher(wrapper, fwdReq, fwdRes.getResponse());
                success = true;
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                WebProperties props = PropertyUtil.getContextProperties();
                if (props.FORWARD_FILENOTFOUND.value) {
                    fwdRes.getResponse().sendError(404, fwdReq.getRequestURI());
                    break block14;
                }
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2204, (Object)fwdReq.getRequestURI()), (Throwable)fnfe);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
            catch (ServletException se) {
                se.printStackTrace();
                WebProperties props = PropertyUtil.getContextProperties();
                if (props.FORWARD_FILENOTFOUND.value) {
                    if (se.getRootCause() instanceof FileNotFoundException) {
                        fwdRes.getResponse().sendError(404, fwdReq.getRequestURI());
                    } else {
                        throw se;
                    }
                }
                se.printStackTrace();
                throw se;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3429, (Object)this.path), t);
            }
            finally {
                dispatchedReq.restore();
                if (success) {
                    fwdRes.closeResponse();
                }
            }
        }
    }

    public void forward2(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        this.forward2(req, resp, false);
    }

    public void forward2(ServletRequest req, ServletResponse resp, boolean isErrorPage) throws ServletException, IOException {
        ServletMapper mapper;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        ExecutionWrapper wrapper = null;
        if (req instanceof HttpServletRequestWrapperInclude) {
            try {
                response.resetBuffer();
            }
            catch (IllegalStateException e) {}
        } else {
            response.resetBuffer();
        }
        if (this.name != null) {
            wrapper = this.context.getServletByName(this.name);
            if (wrapper == null) {
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)2428, (Object[])new String[]{this.name}));
            }
            boolean success = false;
            try {
                wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
                success = true;
            }
            catch (ServletException se) {
                throw se;
            }
            catch (Throwable t) {
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)2429, (Object[])new String[]{this.name}));
            }
            finally {
                if (success) {
                    this.findOriginalResponse(resp);
                    this.closeResponse(resp, isErrorPage);
                }
            }
            return;
        }
        HttpServletRequestWrapperForward wrequest = new HttpServletRequestWrapperForward(request);
        wrequest.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.FORWARD_INTEGER);
        wrequest.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", this.path);
        wrequest.setLookupPath(this.path);
        String ctxPath = this.context.getContextPath();
        if (ctxPath.equals("/")) {
            wrequest.setRequestURI(this.path);
        } else {
            wrequest.setRequestURI(ctxPath + this.path);
        }
        if (this.queryString != null) {
            wrequest.addQueryString(this.queryString);
        }
        if ((mapper = this.context.getServletByPath(this.path)) != null) {
            wrapper = mapper.getExecutionWrapper();
        }
        if (wrapper == null) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)2428, (Object[])new String[]{this.path}));
        }
        wrequest.setServletPath(mapper.getServletPath());
        wrequest.setPathInfo(mapper.getPathInfo());
        boolean success = false;
        try {
            wrapper.executeServlet((ServletRequest)wrequest, (ServletResponse)response);
            success = true;
        }
        catch (ServletException se) {
            if (se instanceof JspParseException) {
                response.sendError(500, request.getServletPath());
            }
            WebProperties props = PropertyUtil.getContextProperties();
            if (props.FORWARD_FILENOTFOUND.value && se.getRootCause() instanceof FileNotFoundException) {
                response.sendError(404, request.getPathInfo());
                return;
            }
            throw se;
        }
        catch (Throwable t) {
            WebProperties props = PropertyUtil.getContextProperties();
            if (props.FORWARD_FILENOTFOUND.value && t instanceof FileNotFoundException) {
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)2429, (Object[])new String[]{this.path}), t);
            }
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)2429, (Object[])new String[]{this.path}));
        }
        finally {
            if (success) {
                this.findOriginalResponse(resp);
                this.closeResponse(resp, isErrorPage);
            }
        }
    }

    private void findOriginalResponse(ServletResponse resp) {
        if (this.orgresp == null) {
            if (resp instanceof HttpServletResponseImpl) {
                this.orgresp = (HttpServletResponseImpl)resp;
                return;
            }
            ServletResponse temp = null;
            temp = ((ServletResponseWrapper)resp).getResponse();
            while (true) {
                if (temp instanceof HttpServletResponseImpl) {
                    this.orgresp = (HttpServletResponseImpl)temp;
                    break;
                }
                if (!(temp instanceof ServletResponseWrapper)) break;
                temp = ((ServletResponseWrapper)temp).getResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommonRequestDispatcher(ExecutionWrapper wrapper, HttpServletRequest request, HttpServletResponse response) throws ServletException, FileNotFoundException, IOException {
        WebAppContextSwitch.preContextSwitch(this.context.getContextLoader());
        try {
            FilterFactory factory = FilterFactory.getInstance();
            FilterChainImpl filterChain = null;
            try {
                filterChain = factory.createFilterChain((ServletRequest)request, wrapper);
                if (filterChain != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (ServletException se) {
                throw se;
            }
            catch (FileNotFoundException fne) {
                throw fne;
            }
            catch (IOException ie) {
                throw ie;
            }
            finally {
                if (filterChain != null) {
                    filterChain.release();
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResponse(ServletResponse resp, boolean isErrorPage) throws IOException {
        try {
            if (this.orgresp != null) {
                this.orgresp.beginForwardFlush();
            }
            resp.flushBuffer();
        }
        finally {
            if (this.orgresp != null) {
                this.orgresp.endForwardFlush();
            }
        }
        try {
            PrintWriter pw = resp.getWriter();
            pw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ServletOutputStream os = resp.getOutputStream();
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void include(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        if (this.path != null && this.path.indexOf("#") > -1) {
            logger.log(JeusMessage_WebContainer2._3625_LEVEL, JeusMessage_WebContainer2._3625, (Object)this.path);
            return;
        }
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)resp;
        }
        catch (ClassCastException e) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3459));
        }
        boolean isGetNamedDispatcher = false;
        ExecutionWrapper wrapper = null;
        ServletMapper mapper = null;
        String servletPath = null;
        String pathInfo = null;
        if (this.name != null) {
            wrapper = this.context.getServletByName(this.name);
            isGetNamedDispatcher = true;
        } else {
            mapper = this.context.getServletByPath(this.path);
            if (mapper != null) {
                servletPath = mapper.getServletPath();
                pathInfo = mapper.getPathInfo();
                wrapper = mapper.getExecutionWrapper();
                isGetNamedDispatcher = false;
            }
        }
        if (wrapper == null) {
            if (this.name != null) {
                throw new FileNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3430, (Object)this.name));
            }
            throw new FileNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3430, (Object)this.path));
        }
        boolean differentContextFlag = false;
        HttpServletRequestImpl hsri = null;
        if (request instanceof HttpServletRequestImpl && !(hsri = (HttpServletRequestImpl)request).getContextPath().equals(this.context.getContextPath())) {
            hsri.setIncludedContext(this.context);
            differentContextFlag = true;
        }
        IncludedRequest dispreq = new IncludedRequest(request, isGetNamedDispatcher);
        HttpServletRequest ireq = ((DispatchedRequest)dispreq).getRequest(this.context.getContextPath(), this.path, this.queryString, servletPath, pathInfo);
        IncludedResponse ires = new IncludedResponse(response);
        this.doInclude(wrapper, dispreq, ireq, ires);
        if (differentContextFlag) {
            hsri.setIncludedContext(null);
        }
        logger.log(JeusMessage_WebContainer2._3650_LEVEL, JeusMessage_WebContainer2._3650, (Object)this.path);
    }

    private void doInclude(ExecutionWrapper wrapper, DispatchedRequest dispatchedReq, HttpServletRequest incReq, IncludedResponse incRes) throws IOException, ServletException {
        try {
            this.processCommonRequestDispatcher(wrapper, incReq, incRes.getResponse());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
        catch (ServletException se) {
            se.printStackTrace();
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3431, (Object)this.path), t);
        }
        finally {
            dispatchedReq.restore();
            incRes.restore();
        }
    }

    public String getPath() {
        return this.path;
    }
}

