/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspFactory;
import jeus.management.j2ee.Servlet;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.servlet.deployment.descriptor.ServletDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.ServletConfigImpl;
import jeus.servlet.engine.ServletMapper;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.filter.FilterConfigImpl;
import jeus.servlet.filter.FilterDef;
import jeus.servlet.filter.FilterMap;
import jeus.servlet.filter.util.URLPattern;
import jeus.servlet.jsp.JspConfig;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspPropertyMapper;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.jsp.compiler.batch.CompileContext;
import jeus.servlet.jsp.resource.JspResourceListener;
import jeus.servlet.jsp.resource.JspResourceProvider;
import jeus.servlet.jsp2.runtime.JspFactoryImpl;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.JspResourceJspReloader;
import jeus.servlet.servlets.JspServlet;
import jeus.servlet.servlets.ResourceServlet;
import jeus.servlet.servlets.UserJspServlet;
import jeus.servlet.servlets.WebServiceServlet;
import jeus.servlet.servlets.WorkerServlet;
import jeus.servlet.util.SecurityCheckUtil;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.xml.binding.j2ee.JspPropertyGroupType;
import jeus.xml.binding.j2ee.TrueFalseType;
import jeus.xml.binding.j2ee.UrlPatternType;

public class ServletManager
implements JspResourceListener {
    public static final HashMap JSP_EXTENSION = new HashMap();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    private ContextLoader contextLoader;
    private JspEngine jspEngine;
    private JspConfig jspConfig;
    private Context context;
    private String contextPath;
    private int ctxPathLength = 0;
    private Hashtable prefixMappedServlets = new Hashtable();
    private Hashtable extensionMappedServlets = new Hashtable();
    private Hashtable pathMappedServlets = new Hashtable();
    private ExecutionWrapper resourceServlet = null;
    private ExecutionWrapper userDefaultServlet = null;
    public Hashtable preloadServlets = new Hashtable();
    private Hashtable destroyedServletMBeanTable = new Hashtable();
    private Vector includeFiles = new Vector();
    private HashMap filterConfigs = new HashMap();
    private HashMap filterDefs = new HashMap();
    private FilterMap[] filterMaps = new FilterMap[0];

    ServletManager(Context context, ContextLoader contextLoader) {
        this.context = context;
        this.contextPath = context.getContextPath();
        if (this.contextPath != null) {
            this.ctxPathLength = this.contextPath.length();
            if (this.ctxPathLength == 1) {
                this.ctxPathLength = 0;
            }
        }
        this.contextLoader = contextLoader;
    }

    public synchronized void init() {
        String webServiceURL;
        this.resourceServlet = new ResourceServlet();
        try {
            ((ResourceServlet)this.resourceServlet).init(new ServletConfigImpl(this.context));
        }
        catch (ServletException se) {
            se.printStackTrace();
        }
        JspServlet jspServlet = new JspServlet(this.context, this);
        this.addMapping("*.jsp", jspServlet);
        JSP_EXTENSION.put(".jsp", ".jsp");
        this.addUserJspServlet("*.jspx");
        JSP_EXTENSION.put(".jspx", ".jspx");
        if (JspServletWrapper.FILENAME_IGNORECASE) {
            this.addMapping("*.jsP", jspServlet);
            this.addMapping("*.jSp", jspServlet);
            this.addMapping("*.jSP", jspServlet);
            this.addMapping("*.Jsp", jspServlet);
            this.addMapping("*.JsP", jspServlet);
            this.addMapping("*.JSp", jspServlet);
            this.addMapping("*.JSP", jspServlet);
            JSP_EXTENSION.put(".jsP", ".jsP");
            JSP_EXTENSION.put(".jSp", ".jSp");
            JSP_EXTENSION.put(".jSP", ".jSP");
            JSP_EXTENSION.put(".Jsp", ".Jsp");
            JSP_EXTENSION.put(".JsP", ".JsP");
            JSP_EXTENSION.put(".JSp", ".JSp");
            JSP_EXTENSION.put(".JSP", ".JSP");
        }
        if ((webServiceURL = this.context.getWebServiceURL()) != null && webServiceURL.length() > 1) {
            WebServiceServlet webServiceServlet = new WebServiceServlet(this.context);
            this.addMapping(webServiceURL, webServiceServlet);
        }
        this.initJspConfig();
        JspPropertyMapper jpm = this.jspConfig.getJspPropertyMapper();
        if (jpm.getPropertyGroups() != null) {
            List groups = jpm.getPropertyGroups();
            for (int i = 0; i < groups.size(); ++i) {
                JspPropertyGroupType _jspProperty = (JspPropertyGroupType)groups.get(i);
                TrueFalseType v = _jspProperty.getIsXml();
                if (v == null || !v.isValue()) continue;
                List urls = _jspProperty.getUrlPattern();
                for (int j = 0; j < urls.size(); ++j) {
                    UrlPatternType _url = (UrlPatternType)urls.get(j);
                    this.addUserJspServlet(_url.getValue());
                }
            }
        }
    }

    synchronized void initJspConfig() {
        Hashtable jspConf = this.context.getJSPConfig();
        jspConf.put("classpath", this.contextLoader.getClassPath());
        ServletConfigImpl servletConfig = new ServletConfigImpl(this.context);
        servletConfig.setInitParams(jspConf);
        this.jspConfig = new JspConfig(servletConfig, this.context);
        this.jspEngine = new JspEngine(this.context, this.jspConfig);
        this.jspEngine.init();
        JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
    }

    public synchronized void clean() {
        this.terminateServlets();
        this.destroyFilters();
        if (this.jspEngine != null) {
            this.jspEngine.clean();
            this.jspEngine = null;
        }
        if (this.jspConfig != null) {
            this.jspConfig.clean();
            this.jspConfig = null;
        }
        this.contextLoader = null;
        this.context = null;
        if (this.prefixMappedServlets != null && !this.prefixMappedServlets.isEmpty()) {
            this.prefixMappedServlets.clear();
            this.prefixMappedServlets = null;
        }
        if (this.extensionMappedServlets != null && !this.extensionMappedServlets.isEmpty()) {
            this.extensionMappedServlets.clear();
            this.extensionMappedServlets = null;
        }
        if (this.pathMappedServlets != null && !this.pathMappedServlets.isEmpty()) {
            this.pathMappedServlets.clear();
            this.pathMappedServlets = null;
        }
        this.resourceServlet = null;
        this.userDefaultServlet = null;
        if (this.preloadServlets != null) {
            Hashtable preloadServletsTemp = (Hashtable)this.preloadServlets.clone();
            Iterator iter = preloadServletsTemp.keySet().iterator();
            while (iter.hasNext()) {
                Vector vectorTemp = (Vector)this.preloadServlets.remove((Integer)iter.next());
                if (vectorTemp == null) continue;
                vectorTemp.clear();
            }
            this.preloadServlets = null;
            preloadServletsTemp.clear();
        }
    }

    public synchronized void initServlet(ServletDescriptor servletDesc, Hashtable mappings, WebModule webModule) {
        Vector urlPatterns;
        int loadOnStartup;
        ServletWrapper servletWrapper = null;
        String servletName = servletDesc.getServletName();
        String servletClass = servletDesc.getServletClass();
        String jspFile = servletDesc.getJSPFile();
        Hashtable params = servletDesc.getInitParamValues();
        String _runAs = servletDesc.getRunAs();
        if (servletClass != null) {
            servletWrapper = this.addServlet(servletName, servletClass, params, _runAs);
        } else if (jspFile != null) {
            if (!jspFile.startsWith("/")) {
                jspFile = "/" + jspFile;
            }
            try {
                servletWrapper = this.addJsp(servletName, jspFile, params);
            }
            catch (FileNotFoundException fnfe) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3447_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3447_LEVEL, JeusMessage_WebContainer2._3447, (Object)servletName, (Throwable)fnfe);
                }
            }
        } else {
            return;
        }
        if (servletWrapper != null) {
            Servlet servletMBean = (Servlet)this.destroyedServletMBeanTable.get(servletWrapper.getServletName());
            servletMBean.destroyMBean();
            servletWrapper.registerMBean(webModule);
        }
        if ((loadOnStartup = servletDesc.getLoadOnStartUp()) >= 0) {
            Integer key = new Integer(loadOnStartup);
            Vector vec = null;
            vec = this.preloadServlets.containsKey(key) ? (Vector)this.preloadServlets.get(key) : new Vector();
            vec.addElement(servletWrapper);
            this.preloadServlets.put(key, vec);
        }
        if (mappings != null && (urlPatterns = (Vector)mappings.get(servletName)) != null) {
            for (int i = 0; i < urlPatterns.size(); ++i) {
                this.addMapping((String)urlPatterns.elementAt(i), servletWrapper);
            }
        }
    }

    public synchronized void initServlets(Hashtable commonDescs, Hashtable commonMappings, Hashtable myDescs, Hashtable myMappings, WebModule webModule) {
        if (commonDescs == null && myDescs == null) {
            return;
        }
        Hashtable descs = new Hashtable();
        Hashtable mappings = new Hashtable();
        if (commonDescs != null) {
            descs.putAll(commonDescs);
        }
        if (myDescs != null) {
            descs.putAll(myDescs);
        }
        if (commonMappings != null) {
            mappings.putAll(commonMappings);
        }
        if (myMappings != null) {
            mappings.putAll(myMappings);
        }
        Enumeration enum1 = descs.keys();
        while (enum1.hasMoreElements()) {
            Vector urlPatterns;
            String servletName = (String)enum1.nextElement();
            ServletDescriptor servletDesc = (ServletDescriptor)descs.get(servletName);
            ServletWrapper servletWrapper = null;
            Hashtable params = servletDesc.getInitParamValues();
            String servletClass = servletDesc.getServletClass();
            String jspFile = servletDesc.getJSPFile();
            String _runAs = servletDesc.getRunAs();
            if (servletClass != null) {
                if (servletClass.equals("jeus.servlet.engine.WorkerServlet")) {
                    servletDesc.setServletClass("jeus.servlet.servlets.WorkerServlet");
                    servletClass = "jeus.servlet.servlets.WorkerServlet";
                }
                if (servletClass.equals("jeus.servlet.servlets.WorkerServlet")) {
                    this.addWorkerServlet(servletName, servletClass, params, mappings);
                    continue;
                }
                if (servletClass.equals("jeus.servlet.servlets.JspServlet") || servletClass.equals("jeus.servlet.servlets.UserJspServlet")) {
                    Vector urlPatterns2;
                    if (mappings == null || (urlPatterns2 = (Vector)mappings.get(servletName)) == null) continue;
                    for (int i = 0; i < urlPatterns2.size(); ++i) {
                        this.addUserJspServlet((String)urlPatterns2.elementAt(i));
                    }
                    continue;
                }
                servletWrapper = this.addServlet(servletName, servletClass, params, _runAs);
                servletWrapper.registerMBean(webModule);
            } else {
                if (jspFile == null) continue;
                try {
                    servletWrapper = this.addJsp(servletName, jspFile, params);
                    servletWrapper.registerMBean(webModule);
                }
                catch (FileNotFoundException fnfe) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3447_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3447_LEVEL, JeusMessage_WebContainer2._3447, (Object)servletName, (Throwable)fnfe);
                    continue;
                }
            }
            int loadOnStartup = servletDesc.getLoadOnStartUp();
            if (loadOnStartup >= 0) {
                Integer key = new Integer(loadOnStartup);
                Vector vec = null;
                vec = this.preloadServlets.containsKey(key) ? (Vector)this.preloadServlets.get(key) : new Vector();
                vec.addElement(servletWrapper);
                this.preloadServlets.put(key, vec);
            }
            if (mappings == null || (urlPatterns = (Vector)mappings.get(servletName)) == null) continue;
            for (int i = 0; i < urlPatterns.size(); ++i) {
                this.addMapping((String)urlPatterns.elementAt(i), servletWrapper);
            }
        }
    }

    synchronized void preloadServlets() {
        if (!this.preloadServlets.isEmpty()) {
            this.doPreloadServlets();
        }
    }

    private synchronized void doPreloadServlets() {
        Vector<Integer> orderedKeys = new Vector<Integer>();
        Enumeration<Object> e = this.preloadServlets.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            int slot = -1;
            for (int i = 0; i < orderedKeys.size(); ++i) {
                if (key >= (Integer)orderedKeys.elementAt(i)) continue;
                slot = i;
                break;
            }
            if (slot > -1) {
                orderedKeys.insertElementAt(key, slot);
                continue;
            }
            orderedKeys.addElement(key);
        }
        for (int i = 0; i < orderedKeys.size(); ++i) {
            Integer key = (Integer)orderedKeys.elementAt(i);
            e = ((Vector)this.preloadServlets.get(key)).elements();
            while (e.hasMoreElements()) {
                ServletWrapper servlet = (ServletWrapper)e.nextElement();
                try {
                    servlet.loadOnStartup();
                }
                catch (ServletException se) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3705_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3705_LEVEL, JeusMessage_WebContainer2._3705, (Object)(servlet == null ? "null" : servlet.getName()), (Throwable)se);
                }
            }
        }
    }

    public void setWelcomeFiles(Vector files) {
        if (this.resourceServlet instanceof ResourceServlet) {
            ((ResourceServlet)this.resourceServlet).setWelcomeFiles(files);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public JspEngine getJspEngine() {
        return this.jspEngine;
    }

    public ContextLoader getLoader() {
        return this.contextLoader;
    }

    public ServletWrapper getServletByName(String servletName) {
        return this.contextLoader.getServlet(servletName);
    }

    public ServletInfo[] getAllServletInfo() {
        return this.contextLoader.getAllServletInfo();
    }

    public ExecutionWrapper getDefaultServlet() {
        if (this.userDefaultServlet != null) {
            return this.userDefaultServlet;
        }
        return this.resourceServlet;
    }

    public synchronized ServletWrapper addServlet(String servletName, String servletClass, Hashtable params) {
        return this.contextLoader.createServlet(servletName, servletClass, params, this, null);
    }

    public synchronized ServletWrapper addServlet(String servletName, String servletClass, Hashtable params, String _runAs) {
        return this.contextLoader.createServlet(servletName, servletClass, params, this, _runAs);
    }

    public void addWorkerServlet(String servletName, String servletClass, Hashtable params, Hashtable mappings) {
        block4: {
            try {
                Vector urlPatterns;
                WorkerServlet workerServlet = new WorkerServlet();
                ServletConfigImpl config = new ServletConfigImpl(this.context);
                config.setServletName(servletName);
                config.setServletClassName(servletClass);
                config.setInitParams(params);
                workerServlet.init(config);
                if (mappings != null && (urlPatterns = (Vector)mappings.get(servletName)) != null) {
                    for (int i = 0; i < urlPatterns.size(); ++i) {
                        this.addMapping((String)urlPatterns.elementAt(i), workerServlet);
                    }
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3447_LEVEL)) break block4;
                logger.log(JeusMessage_WebContainer2._3447_LEVEL, JeusMessage_WebContainer2._3447, (Object)"WorkerServlet", t);
            }
        }
    }

    public synchronized JspServletWrapper addJsp(String jspName, String jspUri, Hashtable params) throws FileNotFoundException {
        return this.contextLoader.createJsp(jspName, jspUri, params, this, false);
    }

    public synchronized JspServletWrapper addJsp(String jspName, String jspUri, Hashtable params, boolean samename) throws FileNotFoundException {
        return this.contextLoader.createJsp(jspName, jspUri, params, this, samename);
    }

    private void addUserJspServlet(String path) {
        if (path.startsWith("/") && path.endsWith("/*")) {
            this.addMapping(path, new UserJspServlet(this.context, this, true));
        } else {
            this.addMapping(path, new UserJspServlet(this.context, this, false));
        }
    }

    public void addMapping(String path, ExecutionWrapper wrapper) {
        path = path.trim();
        if (wrapper != null && path.length() > 0) {
            if (path.startsWith("/") && path.endsWith("/*")) {
                this.prefixMappedServlets.put(path, wrapper);
            } else if (path.startsWith("*.")) {
                this.extensionMappedServlets.put(path, wrapper);
            } else if (path.equals("/")) {
                this.userDefaultServlet = wrapper;
            } else if (!path.equals("/")) {
                this.pathMappedServlets.put(path, wrapper);
            }
        }
    }

    public ExecutionWrapper lookupServlet(HttpServletRequestImpl request) {
        String requestURI = request.getRequestURI();
        String lookupPath = null;
        String extraParameter = null;
        if (requestURI.length() < this.ctxPathLength) {
            return null;
        }
        lookupPath = requestURI.substring(this.ctxPathLength);
        int index = lookupPath.indexOf(59);
        if (index > -1) {
            extraParameter = lookupPath.substring(index);
            lookupPath = lookupPath.substring(0, index);
        }
        if (SecurityCheckUtil.isUriWithWebInf(lookupPath, true) && !(this.context instanceof CompileContext)) {
            return null;
        }
        ServletMapper servletMapper = new ServletMapper();
        servletMapper.setMapTables(this.pathMappedServlets, this.prefixMappedServlets, this.extensionMappedServlets);
        ExecutionWrapper wrapper = servletMapper.lookupServlet(lookupPath);
        if (wrapper == null) {
            String servletName;
            if (lookupPath.startsWith("/")) {
                servletName = lookupPath;
                wrapper = this.contextLoader.getServlet(servletName);
                if (wrapper == null) {
                    servletName = lookupPath.substring(1);
                    wrapper = this.contextLoader.getServlet(servletName);
                }
            } else {
                servletName = lookupPath;
                wrapper = this.contextLoader.getServlet(servletName);
            }
            if (wrapper == null) {
                if (this.userDefaultServlet != null) {
                    String welcomePath = ((ResourceServlet)this.resourceServlet).checkWelcomeFile(lookupPath);
                    if (welcomePath != null) {
                        wrapper = this.resourceServlet;
                        if (!welcomePath.startsWith("/")) {
                            welcomePath = '/' + welcomePath;
                        }
                        request.setLookupResult(wrapper, this.contextPath, lookupPath, welcomePath, null, extraParameter);
                    } else {
                        wrapper = this.userDefaultServlet;
                        request.setLookupResult(wrapper, this.contextPath, lookupPath, lookupPath, null, extraParameter);
                    }
                } else {
                    wrapper = this.resourceServlet;
                    request.setLookupResult(wrapper, this.contextPath, lookupPath, lookupPath, null, extraParameter);
                }
            } else {
                if (!servletName.startsWith("/")) {
                    servletName = "/" + servletName;
                }
                request.setLookupResult(wrapper, this.contextPath, lookupPath, servletName, null, extraParameter);
            }
            return wrapper;
        }
        request.setLookupResult(wrapper, this.contextPath, lookupPath, servletMapper.getServletPath(), servletMapper.getPathInfo(), extraParameter);
        return wrapper;
    }

    public ExecutionWrapper lookupPathMappedServlet(String lookupPath) {
        return (ExecutionWrapper)this.pathMappedServlets.get(lookupPath);
    }

    public ServletMapper lookupServlet(String lookupPath) {
        String welcomePath;
        ServletMapper servletMapper = new ServletMapper();
        servletMapper.setMapTables(this.pathMappedServlets, this.prefixMappedServlets, this.extensionMappedServlets);
        ExecutionWrapper wrapper = servletMapper.lookupServlet(lookupPath);
        if (wrapper != null) {
            return servletMapper;
        }
        wrapper = this.contextLoader.getServlet(lookupPath);
        if (wrapper == null && lookupPath.startsWith("/")) {
            String servletName = lookupPath.substring(1);
            wrapper = this.contextLoader.getServlet(servletName);
        }
        if (wrapper != null) {
            servletMapper.setDefaultServlet(wrapper, lookupPath, "");
            return servletMapper;
        }
        wrapper = this.userDefaultServlet != null ? ((welcomePath = ((ResourceServlet)this.resourceServlet).checkWelcomeFile(lookupPath)) != null ? this.resourceServlet : this.userDefaultServlet) : this.resourceServlet;
        servletMapper.setDefaultServlet(wrapper, lookupPath, "");
        return servletMapper;
    }

    public void removeServlet(ServletWrapper sw) {
        String key;
        Enumeration enum1;
        if (this.prefixMappedServlets.contains(sw)) {
            enum1 = this.prefixMappedServlets.keys();
            while (enum1.hasMoreElements()) {
                key = (String)enum1.nextElement();
                if (!this.prefixMappedServlets.get(key).equals(sw)) continue;
                this.prefixMappedServlets.remove(key);
            }
        }
        if (this.extensionMappedServlets.contains(sw)) {
            enum1 = this.extensionMappedServlets.keys();
            while (enum1.hasMoreElements()) {
                key = (String)enum1.nextElement();
                if (!this.extensionMappedServlets.get(key).equals(sw)) continue;
                this.extensionMappedServlets.remove(key);
            }
        }
        if (this.pathMappedServlets.contains(sw)) {
            enum1 = this.pathMappedServlets.keys();
            while (enum1.hasMoreElements()) {
                key = (String)enum1.nextElement();
                if (!this.pathMappedServlets.get(key).equals(sw)) continue;
                this.pathMappedServlets.remove(key);
            }
        }
        this.contextLoader.removeServlet(sw.getServletName());
    }

    public synchronized boolean terminateServlet(String servName) {
        ServletWrapper wrapper = this.contextLoader.getServlet(servName);
        if (wrapper == null) {
            return false;
        }
        this.destroyedServletMBeanTable.put(servName, wrapper.getServletMBean());
        this.removeServlet(wrapper);
        wrapper.destroyMBean();
        return true;
    }

    private boolean terminateServlets() {
        Enumeration servs = this.contextLoader.getServlets();
        while (servs.hasMoreElements()) {
            ServletWrapper wrapper = (ServletWrapper)servs.nextElement();
            this.removeServlet(wrapper);
            wrapper.destroyMBean();
        }
        this.destroyedServletMBeanTable.clear();
        return true;
    }

    public void printMappingTables() {
        ServletWrapper wrapper;
        String path;
        Enumeration enum1 = this.pathMappedServlets.keys();
        while (enum1.hasMoreElements()) {
            path = (String)enum1.nextElement();
            wrapper = (ServletWrapper)this.pathMappedServlets.get(path);
            System.out.println("Path : path = " + path + ", servlet = " + wrapper.getServletName());
        }
        enum1 = this.prefixMappedServlets.keys();
        while (enum1.hasMoreElements()) {
            path = (String)enum1.nextElement();
            wrapper = (ServletWrapper)this.prefixMappedServlets.get(path);
            System.out.println("Prefix : path = " + path + ", servlet = " + wrapper.getServletName());
        }
        enum1 = this.extensionMappedServlets.keys();
        while (enum1.hasMoreElements()) {
            path = (String)enum1.nextElement();
            wrapper = (ServletWrapper)this.extensionMappedServlets.get(path);
            System.out.println("Extension : path = " + path + ", servlet = " + wrapper.getServletName());
        }
    }

    public void resourceModified(String resource) {
        block12: {
            ServletWrapper wrapper;
            if (resource != null && !resource.startsWith("/")) {
                resource = "/" + resource;
            }
            if ((wrapper = this.getServletByName(resource)) != null && wrapper.reloader instanceof JspResourceJspReloader) {
                ((JspResourceJspReloader)wrapper.reloader).setDirty(true);
                if (logger.isLoggable(JeusMessage_WebContainer5_4._5689_LEVEL)) {
                    logger.log(JeusMessage_WebContainer5_4._5689_LEVEL, JeusMessage_WebContainer5_4._5689, (Object)resource);
                }
            } else {
                if (this.includeFiles.contains(resource)) {
                    String realPath = this.context.getRealPath(resource);
                    File includeFile = new File(realPath);
                    try {
                        includeFile.getParentFile().mkdirs();
                        JspResourceProvider jspResourceProvider = this.context.getJspResourceProvider();
                        if (jspResourceProvider == null) {
                            throw new IOException("the jsp resource provider must be initialized");
                        }
                        FileUtils.copy((InputStream)jspResourceProvider.getResource(resource), (OutputStream)new FileOutputStream(includeFile));
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5690_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5690_LEVEL, JeusMessage_WebContainer5_4._5690, (Object[])new String[]{resource, realPath});
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5692_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5692_LEVEL, JeusMessage_WebContainer5_4._5692, (Object)resource, (Throwable)e);
                        }
                        break block12;
                    }
                }
                if (!resource.toLowerCase().endsWith(".jsp") || !resource.toLowerCase().endsWith(".jspx")) {
                    ((ResourceServlet)this.resourceServlet).resourceModified(resource);
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5689_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5689_LEVEL, JeusMessage_WebContainer5_4._5689, (Object)resource);
                    }
                }
            }
        }
    }

    public void downloadIncludeFile(String resource) {
        block7: {
            String realPath;
            File includeFile;
            if (resource != null && !resource.startsWith("/")) {
                resource = "/" + resource;
            }
            if (!this.includeFiles.contains(resource)) {
                this.includeFiles.addElement(resource);
            }
            if (!(includeFile = new File(realPath = this.context.getRealPath(resource))).exists()) {
                try {
                    includeFile.getParentFile().mkdirs();
                    JspResourceProvider jspResourceProvider = this.context.getJspResourceProvider();
                    if (jspResourceProvider == null) {
                        throw new IOException("the jsp resource provider must be initialized");
                    }
                    FileUtils.copy((InputStream)jspResourceProvider.getResource(resource), (OutputStream)new FileOutputStream(includeFile));
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5691_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5691_LEVEL, JeusMessage_WebContainer5_4._5691, (Object[])new String[]{resource, realPath});
                    }
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer5_4._5692_LEVEL)) break block7;
                    logger.log(JeusMessage_WebContainer5_4._5692_LEVEL, JeusMessage_WebContainer5_4._5692, (Object)resource, (Throwable)e);
                }
            }
        }
    }

    public void initFilters(HashMap commonFilterDefs, ArrayList commonFilterMaps, HashMap myFilterDefs, ArrayList myFilterMaps, FilterDef loginFilterDef, ArrayList loginFilterMaps) {
        if (commonFilterDefs == null && myFilterDefs == null && loginFilterDef == null) {
            return;
        }
        this.addFilterDef(loginFilterDef);
        this.addFilterDefs(commonFilterDefs);
        this.addFilterDefs(myFilterDefs);
        this.addFilterMaps(loginFilterMaps);
        this.addFilterMaps(commonFilterMaps);
        this.addFilterMaps(myFilterMaps);
    }

    public void destroyFilters() {
        int i = 0;
        FilterMap[] filterMaps = this.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.removeFilterMap(filterMaps[i]);
        }
        FilterDef[] filterDefs = this.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.removeFilterDef(filterDefs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterDefs(HashMap defs) {
        if (defs == null) {
            return;
        }
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.putAll(defs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterDef(FilterDef filterDef) {
        if (filterDef == null) {
            return;
        }
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterDef(FilterDef filterDef) {
        if (filterDef == null) {
            return;
        }
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef findFilterDef(String filterName) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            return (FilterDef)this.filterDefs.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef[] findFilterDefs() {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            FilterDef[] results = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(results);
        }
    }

    public void addFilterMaps(ArrayList filterMaps) {
        if (filterMaps == null) {
            return;
        }
        for (int i = 0; i < filterMaps.size(); ++i) {
            FilterMap filterMap = (FilterMap)filterMaps.get(i);
            this.addFilterMap(filterMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterMap(FilterMap filterMap) {
        if (filterMap == null) {
            return;
        }
        String filterName = filterMap.getFilterName();
        if (this.findFilterDef(filterName) == null) {
            IllegalArgumentException ex = new IllegalArgumentException("failed to add a filter map");
            if (logger.isLoggable(JeusMessage_WebContainer2._3950_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3950_LEVEL, JeusMessage_WebContainer2._3950, (Object)filterName, (Throwable)ex);
            }
            throw ex;
        }
        String servletName = filterMap.getServletName();
        String urlPattern = filterMap.getURLPattern();
        if (servletName == null && urlPattern == null) {
            IllegalArgumentException ex = new IllegalArgumentException("failed to add a filter map");
            if (logger.isLoggable(JeusMessage_WebContainer2._3951_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3951_LEVEL, JeusMessage_WebContainer2._3951, (Throwable)ex);
            }
            throw ex;
        }
        if (servletName != null && urlPattern != null) {
            IllegalArgumentException ex = new IllegalArgumentException("failed to add a filter map");
            if (logger.isLoggable(JeusMessage_WebContainer2._3951_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3951_LEVEL, JeusMessage_WebContainer2._3951, (Throwable)ex);
            }
            throw ex;
        }
        if (urlPattern != null && !URLPattern.isValid(urlPattern)) {
            IllegalArgumentException ex = new IllegalArgumentException("failed to add a filter map");
            if (logger.isLoggable(JeusMessage_WebContainer2._3952_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3952_LEVEL, JeusMessage_WebContainer2._3952, (Object)urlPattern, (Throwable)ex);
            }
            throw ex;
        }
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            FilterMap[] results = new FilterMap[this.filterMaps.length + 1];
            System.arraycopy(this.filterMaps, 0, results, 0, this.filterMaps.length);
            results[this.filterMaps.length] = filterMap;
            this.filterMaps = results;
            // ** MonitorExit[var5_9] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterMap(FilterMap filterMap) {
        if (filterMap == null) {
            return;
        }
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            int n = -1;
            for (int i = 0; i < this.filterMaps.length; ++i) {
                if (this.filterMaps[i] != filterMap) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FilterMap[] results = new FilterMap[this.filterMaps.length - 1];
            System.arraycopy(this.filterMaps, 0, results, 0, n);
            System.arraycopy(this.filterMaps, n + 1, results, n, this.filterMaps.length - 1 - n);
            this.filterMaps = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public FilterMap[] findFilterMaps() {
        return this.filterMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (logger.isLoggable(JeusMessage_WebContainer2._3957_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3957_LEVEL, JeusMessage_WebContainer2._3957);
        }
        boolean ok = true;
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            this.filterConfigs.clear();
            for (String name : this.filterDefs.keySet()) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3953_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3953_LEVEL, JeusMessage_WebContainer2._3953, (Object)name);
                }
                FilterConfigImpl filterConfig = null;
                try {
                    filterConfig = new FilterConfigImpl(this.context, (FilterDef)this.filterDefs.get(name));
                    this.filterConfigs.put(name, filterConfig);
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_WebContainer2._3954_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3954_LEVEL, JeusMessage_WebContainer2._3954, (Object)name, t);
                    }
                    ok = false;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (logger.isLoggable(JeusMessage_WebContainer2._3955_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3955_LEVEL, JeusMessage_WebContainer2._3955);
        }
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            for (String name : this.filterConfigs.keySet()) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3956_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3956_LEVEL, JeusMessage_WebContainer2._3956, (Object)name);
                }
                FilterConfigImpl filterConfig = (FilterConfigImpl)this.filterConfigs.get(name);
                filterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    public FilterConfig findFilterConfig(String name) {
        return (FilterConfig)this.filterConfigs.get(name);
    }

    public synchronized void destroy() {
        this.terminateServlets();
        this.destroyFilters();
        if (this.jspEngine != null) {
            this.jspEngine.clean();
            this.jspEngine = null;
        }
        if (this.jspConfig != null) {
            this.jspConfig.clean();
            this.jspConfig = null;
        }
        this.contextLoader = null;
        this.context = null;
        if (this.prefixMappedServlets != null && !this.prefixMappedServlets.isEmpty()) {
            this.prefixMappedServlets.clear();
            this.prefixMappedServlets = null;
        }
        if (this.extensionMappedServlets != null && !this.extensionMappedServlets.isEmpty()) {
            this.extensionMappedServlets.clear();
            this.extensionMappedServlets = null;
        }
        if (this.pathMappedServlets != null && !this.pathMappedServlets.isEmpty()) {
            this.pathMappedServlets.clear();
            this.pathMappedServlets = null;
        }
        this.resourceServlet = null;
        this.userDefaultServlet = null;
        if (this.preloadServlets != null) {
            Collection values = this.preloadServlets.values();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                ((Vector)iter.next()).clear();
            }
            this.preloadServlets.clear();
            this.preloadServlets = null;
        }
    }

    public void addJspMappings() {
        JspPropertyMapper jpm = this.jspConfig.getJspPropertyMapper();
        if (jpm.getPropertyGroups() != null) {
            List groups = jpm.getPropertyGroups();
            for (int i = 0; i < groups.size(); ++i) {
                JspPropertyGroupType _jspProperty = (JspPropertyGroupType)groups.get(i);
                List urlPatternTypes = _jspProperty.getUrlPattern();
                if (urlPatternTypes == null) continue;
                JspServlet jspServlet = (JspServlet)this.extensionMappedServlets.get("*.jsp");
                for (UrlPatternType urlPattern : urlPatternTypes) {
                    String urlValue = urlPattern.getValue();
                    this.addMapping(urlValue, jspServlet);
                }
            }
        }
    }
}

