/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.net.Socket;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.management.JMXUtility;
import jeus.management.j2ee.servlet.ThreadPoolMo;
import jeus.management.j2ee.servlet.ThreadPoolMoMBean;
import jeus.management.j2ee.servlet.ThreadPoolStatsImpl;
import jeus.management.j2ee.servlet.WebListenerMo;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.common.WebContainerControlException;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ThreadPoolDescriptor;
import jeus.servlet.deployment.descriptor.ThreadStateNotifyDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.util.SimpleTimer;
import jeus.servlet.util.StandardQueue;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;

public abstract class ThreadPoolManager {
    private String listenerId;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    protected String threadPoolId;
    protected Vector threadPool;
    protected Vector blockedThreadPool;
    protected StandardQueue connQueue;
    protected ContextGroup contextGroup;
    protected ConnectionDescriptor connDesc;
    protected ThreadPoolDescriptor tpoolDesc;
    private AtomicInteger threadId = new AtomicInteger(0);
    protected ThreadStateNotifyDescriptor tsnDesc;
    protected boolean enableAdminChannel = false;
    protected ThreadPoolMo threadPoolMo;
    protected boolean isDestroyed = false;
    protected boolean enableAccessControl;
    protected Vector allowedServer;
    private ThreadStateComparator threadStateComparator = new ThreadStateComparator();

    protected ThreadPoolManager(ContextGroup ctxgrp, ConnectionDescriptor desc) {
        this.connDesc = desc;
        this.listenerId = desc.getListenerId();
        this.tpoolDesc = this.connDesc.getThreadPoolDescriptor();
        this.tsnDesc = this.tpoolDesc.getThreadStateNotifyDescriptor();
        this.contextGroup = ctxgrp;
        this.threadPool = new Vector();
        this.blockedThreadPool = new Vector();
        this.enableAdminChannel = desc.getAdminChannel();
        this.enableAccessControl = desc.isAccessControl();
        this.allowedServer = desc.getAllowedServers();
        this.initAllowedServers();
    }

    private void initAllowedServers() {
        if (this.enableAccessControl) {
            this.allowedServer.removeElement("*.*.*.*");
            if (this.allowedServer.isEmpty()) {
                this.enableAccessControl = false;
            }
        }
    }

    public void setMaxThreadNum(String max) {
        this.tpoolDesc.setMaxThreadNum(max);
    }

    public void setMinThreadNum(String min) throws WebContainerControlException {
        try {
            this.tpoolDesc.setMinThreadNum(min);
        }
        catch (Exception e) {
            throw new WebContainerControlException(ErrorMsgManager.getLocalizedString((Throwable)e));
        }
    }

    public void setChangingRate(String rate) {
        this.tpoolDesc.setChangingRate(rate);
    }

    public void setMaxIdleTime(String time) {
        this.tpoolDesc.setMaxIdleTime(time);
    }

    public void setMaxWaitQueue(String size) {
        this.tpoolDesc.setMaxWaitQueue(size);
        int maxWaitQueue = this.tpoolDesc.getMaxWaitQueue();
        if (this.connQueue != null) {
            this.connQueue.setMaxWaitQueueSize(maxWaitQueue);
        }
    }

    public void setMaxQueue(String size) {
        this.tpoolDesc.setMaxQueue(size);
        int maxQueue = this.tpoolDesc.getMaxQueue();
        if (this.connQueue != null) {
            this.connQueue.setMaxQueueSize(maxQueue);
        }
    }

    public ThreadPoolDescriptor getThreadPoolDescriptor() {
        return this.tpoolDesc;
    }

    public ThreadStateNotifyDescriptor getThreadStateNotifyDescriptor() {
        return this.tsnDesc;
    }

    public int getCurrentThreadNum() {
        return this.threadPool.size();
    }

    public int getMaxThreadNum() {
        return this.tpoolDesc.getMaxThreadNum();
    }

    public int getWaitQueueCount() {
        if (this.connQueue != null) {
            return this.connQueue.getWaitQueueCount();
        }
        return this.tpoolDesc.getMaxWaitQueue();
    }

    public StandardQueue getQueue() {
        return this.connQueue;
    }

    public Vector getThreadPool() {
        return this.threadPool;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getThreadPoolId() {
        return this.threadPoolId;
    }

    public int getAndIncrementThreadId() {
        return this.threadId.getAndIncrement();
    }

    public int getThreadId() {
        return this.threadId.get();
    }

    public int getOutputBufferSize() {
        return this.connDesc.getOutputBufferSize();
    }

    public long getReconnectTimeout() {
        return this.connDesc.getReconnectTimeout();
    }

    public int getReadTimeout() {
        return this.connDesc.getReadTimeout();
    }

    public int getPostdataReadTimeout() {
        return this.connDesc.getPostdataReadTimeout();
    }

    public String getScheme() {
        return this.connDesc.getScheme();
    }

    public boolean isEnableAccessControl() {
        return this.enableAccessControl;
    }

    public Vector getAllowedServer() {
        return this.allowedServer;
    }

    public Socket getConnection() throws InterruptedException {
        return this.connQueue.get();
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connDesc;
    }

    public synchronized void destroy() {
        this.isDestroyed = true;
        Enumeration e = this.threadPool.elements();
        while (e.hasMoreElements()) {
            RequestProcessor worker = (RequestProcessor)e.nextElement();
            worker.terminate();
        }
        if (this.connQueue != null) {
            this.connQueue.destroy();
        }
        if (this.threadPoolMo != null) {
            this.threadPoolMo.destroyMBean();
        }
    }

    public boolean isSecuredCommunication() {
        return this.connDesc.isEnableSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitWorkerDestroy(SimpleTimer timer) {
        if (timer == null) {
            return;
        }
        do {
            ThreadPoolManager threadPoolManager = this;
            synchronized (threadPoolManager) {
                RequestProcessor worker;
                Iterator it = this.threadPool.iterator();
                while (it.hasNext()) {
                    worker = (RequestProcessor)it.next();
                    if (worker.isAlive()) continue;
                    it.remove();
                }
                it = this.blockedThreadPool.iterator();
                while (it.hasNext()) {
                    worker = (RequestProcessor)it.next();
                    if (worker.isAlive()) continue;
                    it.remove();
                }
                if (this.threadPool.size() <= 0 && this.blockedThreadPool.size() <= 0) {
                    return;
                }
            }
        } while (!timer.expired(1000L));
    }

    public Vector getThreadState(int mode) {
        Vector allWorkersCopy = new Vector();
        allWorkersCopy.addAll(this.threadPool);
        allWorkersCopy.addAll(this.blockedThreadPool);
        return this.getThreadState(allWorkersCopy, mode);
    }

    protected Vector getThreadState(Vector workers, int mode) {
        Hashtable<String, ThreadStateInfo> infos = new Hashtable<String, ThreadStateInfo>();
        try {
            Iterator iter = workers.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof RequestProcessor) {
                    ThreadStateInfo info = ((RequestProcessor)obj).getThreadState(mode);
                    infos.put(info.getThreadId(), info);
                }
                iter.remove();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        Object[] arrays = infos.values().toArray();
        infos.clear();
        return this.getSortedThreadStateInfos(arrays);
    }

    public abstract void createPool() throws StartingException;

    public abstract int createThreads();

    public abstract void checkThreadPool();

    public abstract void deleteAllThreads();

    public void registerMBean(WebListenerMo webListenerMo) {
        if (webListenerMo == null) {
            return;
        }
        try {
            this.threadPoolMo = (ThreadPoolMo)ThreadPoolMo.createMBean(JMXUtility.toMbeanName(this.threadPoolId), webListenerMo.getObjectName(), this);
            this.threadPoolMo.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ThreadPoolMoMBean getMBean() {
        return this.threadPoolMo;
    }

    public ThreadPoolStatsImpl updateStats(ThreadPoolStatsImpl stats) {
        long _activeThreadCount = 0L;
        int size = this.threadPool.size();
        for (int i = 0; i < size; ++i) {
            RequestProcessor worker = (RequestProcessor)this.threadPool.elementAt(i);
            if (worker == null || !worker.active) continue;
            ++_activeThreadCount;
        }
        ((CountStatisticImpl)stats.getActiveThreadCount()).setValue(_activeThreadCount);
        ((CountStatisticImpl)stats.getBlockThreadCount()).setValue((long)this.blockedThreadPool.size());
        ((CountStatisticImpl)stats.getAllThreadCount()).setValue((long)size);
        ((CountStatisticImpl)stats.getMaxThreadCount()).setValue((long)this.connDesc.getThreadPoolDescriptor().getMaxThreadNum());
        if (this.connQueue == null) {
            ((CountStatisticImpl)stats.getWaitQueueCount()).setValue(-1L);
        } else {
            ((CountStatisticImpl)stats.getWaitQueueCount()).setValue((long)this.connQueue.getWaitQueueCount());
        }
        return stats;
    }

    public void clearStats() {
    }

    public synchronized void removeProcessorInThreadPool(RequestProcessor processor) {
        boolean found = false;
        if (this.isDestroyed) {
            return;
        }
        int size = this.threadPool.size();
        if (size > 0) {
            try {
                for (int i = 0; i < size; ++i) {
                    RequestProcessor worker = (RequestProcessor)this.threadPool.get(i);
                    if (worker != processor) continue;
                    this.threadPool.remove(worker);
                    found = true;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (found) {
            this.checkThreadPool();
        }
    }

    private Vector getSortedThreadStateInfos(Object[] infos) {
        Arrays.sort(infos, this.threadStateComparator);
        Vector<Object> sortedInfos = new Vector<Object>();
        for (int i = 0; i < infos.length; ++i) {
            sortedInfos.addElement(infos[i]);
        }
        return sortedInfos;
    }

    private class ThreadStateComparator
    implements Comparator {
        private ThreadStateComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof ThreadStateInfo) || !(o2 instanceof ThreadStateInfo)) {
                return 0;
            }
            ThreadStateInfo threadStateInfo1 = (ThreadStateInfo)o1;
            ThreadStateInfo threadStateInfo2 = (ThreadStateInfo)o2;
            return threadStateInfo1.getThreadId().compareTo(threadStateInfo2.getThreadId());
        }
    }
}

