/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.ObjectName;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.ContextGroupMo;
import jeus.management.j2ee.servlet.WebModuleDeployInfo;
import jeus.security.base.Policy;
import jeus.security.util.LoginUtil;
import jeus.server.JeusServer;
import jeus.server.enginecontainer.EngineContainer;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.VirtualHostDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.jsp.compiler.batch.CompileContext;
import jeus.servlet.jsp.compiler.batch.CompileManager;
import jeus.servlet.property.VirtualHostProperties;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.WebContextGroupType;

public final class VirtualHost
implements Serializable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    private ContextGroup contextGroup;
    private VirtualHostDescriptor vhDesc;
    private HashMap contexts;
    private Hashtable jspConfig;
    private boolean defaultVirtualHost = false;
    private boolean systemContext;
    private VirtualHostProperties virtualHostProperties;

    public VirtualHost(ContextGroup ctxgrp, VirtualHostDescriptor vhDesc) {
        this.contextGroup = ctxgrp;
        this.vhDesc = vhDesc;
        this.contexts = new HashMap();
        this.defaultVirtualHost = vhDesc.isDefaultVirtualHost();
        boolean bl = this.systemContext = ctxgrp.getContainerManager().isSYSTEM_ENGINE || ctxgrp.getContainerManager() instanceof CompileManager;
        if (ctxgrp.getContextGroupProperties() != null) {
            this.virtualHostProperties = new VirtualHostProperties(ctxgrp.getContextGroupProperties().properties);
            this.virtualHostProperties.init(vhDesc.getProperties());
        }
    }

    public void init(boolean configByXML, boolean initDefaultContext, ContextGroupMo contextGroupMo) throws StartingException {
        this.init(configByXML, initDefaultContext, false, false, contextGroupMo);
    }

    public void destroy() {
        this.contextGroup = null;
        this.vhDesc = null;
        if (this.contexts != null) {
            this.contexts.clear();
            this.contexts = null;
        }
        if (this.jspConfig != null) {
            this.jspConfig.clear();
            this.jspConfig = null;
        }
    }

    public void batchModeInit(boolean configByXML, boolean initDefaultContext, boolean isWebAdmin) throws StartingException {
        this.init(configByXML, initDefaultContext, true, isWebAdmin, null);
    }

    private void init(boolean configByXML, boolean initDefaultContext, boolean batchMode, boolean isWebAdmin, ContextGroupMo contextGroupMo) throws StartingException {
        this.initJSP(isWebAdmin);
        Enumeration ctxDescs = this.vhDesc.getContextDescriptors().elements();
        while (ctxDescs.hasMoreElements()) {
            ContextDescriptor ctxDesc = (ContextDescriptor)ctxDescs.nextElement();
            String contextPath = ctxDesc.getContextPath();
            if (this.defaultVirtualHost && !initDefaultContext && contextPath.equals("/")) continue;
            String contextName = ctxDesc.getContextName();
            try {
                Object dup = this.contextGroup.contextNames.get(contextName);
                if (dup == null) {
                    this.addContext(false, configByXML, contextGroupMo, ctxDesc, ctxDesc.getWebAppDescriptor(), batchMode, isWebAdmin, null, null, null);
                    continue;
                }
                int count = 0;
                Enumeration ctxDescs2 = this.vhDesc.getContextDescriptors().elements();
                while (ctxDescs2.hasMoreElements()) {
                    ContextDescriptor ctxDesc2 = (ContextDescriptor)ctxDescs2.nextElement();
                    String contextPath2 = ctxDesc2.getContextPath();
                    if (this.defaultVirtualHost && !initDefaultContext && contextPath2.equals("/") || !contextName.equals(ctxDesc2.getContextName())) continue;
                    ++count;
                }
                if (count < 2) continue;
                this.addContext(false, configByXML, contextGroupMo, ctxDesc, ctxDesc.getWebAppDescriptor(), batchMode, isWebAdmin, null, null, null);
            }
            catch (StartingException se) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3414_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3414_LEVEL, JeusMessage_WebContainer2._3414, (Object[])new String[]{this.getVirtualHostName(), ctxDesc.getContextName()}, (Throwable)((Object)se));
            }
        }
        this.contextGroup.mapVirtualHost(this.vhDesc.getHostNames(), this);
    }

    Context addContext(boolean configByXML, ContextGroupMo contextGroupMo, ContextDescriptor ctxDesc, Policy appPolicy, ClassLoader classloader, WebModule webModule) throws StartingException {
        return this.addContext(false, configByXML, contextGroupMo, ctxDesc, null, false, false, appPolicy, classloader, webModule);
    }

    Context addContext(ContextGroupMo contextGroupMo, ContextDescriptor ctxDesc, WebAppDescriptor webDesc) throws StartingException {
        return this.addContext(false, true, contextGroupMo, ctxDesc, webDesc, false, false, null, null, null);
    }

    private Context addContext(boolean sysDefaultContext, boolean configByXML, ContextGroupMo contextGroupMo, ContextDescriptor ctxDesc, WebAppDescriptor webDesc, boolean batchMode, boolean isWebAdmin, Policy appPolicy, ClassLoader classloader, WebModule webModule) throws StartingException {
        Context context = null;
        String contextName = null;
        String contextPath = null;
        boolean isCtxNameRegistered = false;
        boolean isCtxNameRegisteredInMornitoring = false;
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            boolean bootTimeDeploy = false;
            if (!this.systemContext && webModule == null) {
                bootTimeDeploy = true;
                ObjectName parentObjName = null;
                if (EngineContainer.serverMBean != null) {
                    parentObjName = EngineContainer.serverMBean.getObjectName();
                } else if (JeusServer.getObjectName() != null) {
                    parentObjName = JeusServer.getObjectName();
                }
                webModule = (WebModule)WebModule.createMBean(ctxDesc.getContextName(), parentObjName, this);
                if (sysDefaultContext) {
                    webModule.setSystemApp(true);
                }
            }
            context = batchMode ? new CompileContext(this, ctxDesc, isWebAdmin) : new Context(this, ctxDesc);
            contextName = ctxDesc.getContextName();
            contextPath = ctxDesc.getContextPath();
            if (webModule != null) {
                ObjectFactory of = new ObjectFactory();
                WebContextGroupType webContextGroupType = of.createWebContextGroupType();
                webContextGroupType.setName(this.contextGroup.getGroupName());
                webModule.setContextGroup(webContextGroupType);
                webModule.setContext(ctxDesc.getContextName());
                webModule.createMBean();
                if (contextGroupMo != null) {
                    contextGroupMo.addWebModule(contextName, webModule.getObjectName());
                    webModule.setContextGroupObjectName(contextGroupMo.getobjectName());
                    contextGroupMo.putDeployTable(contextName, new WebModuleDeployInfo(contextName, ctxDesc.isWarDeploy(), webModule.getObjectName(), context.getContextPath()));
                    isCtxNameRegisteredInMornitoring = true;
                }
            }
            context.init(configByXML, webDesc, appPolicy, classloader, webModule);
            Object dup = this.contexts.get(contextPath);
            if (dup != null) {
                throw new StartingException(JeusMessage_WebContainer0._1343, new String[]{this.vhDesc.getVirtualHostName(), contextPath});
            }
            this.contextGroup.registerContextName(contextName, context);
            this.contexts.put(contextPath, context);
            isCtxNameRegistered = true;
            if (this.systemContext) {
                try {
                    context.execStart();
                    context.execResume();
                }
                catch (Exception e) {
                    throw new StartingException("context start failed - " + context.getContextName(), (Throwable)e);
                }
            }
            if (bootTimeDeploy) {
                LoginUtil.loginCodeSubjectWithRuntimeException();
                try {
                    webModule.start();
                }
                catch (Exception e) {
                    throw new StartingException("context start failed - " + context.getContextName(), (Throwable)e);
                }
                finally {
                    LoginUtil.logoutWithRuntimeException();
                }
            }
            Context context2 = context;
            return context2;
        }
        catch (Exception e) {
            if (isCtxNameRegistered) {
                this.contexts.remove(contextPath);
                this.contextGroup.unregisterContextName(contextName);
            }
            if (isCtxNameRegisteredInMornitoring) {
                contextGroupMo.removeWebModuleDeployInfo(contextName);
                contextGroupMo.removeWebModule(contextName);
            }
            if (webModule != null) {
                try {
                    webModule.destroyMBean(true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (this.systemContext && context != null && context.getContextLoader() != null) {
                context.execSuspend();
                context.execTerminate();
            } else if (context != null && context.getContextLoader() != null) {
                context.execTerminate();
            }
            this.removeContext(contextName);
            if (e instanceof StartingException) {
                throw (StartingException)((Object)e);
            }
            throw new StartingException(e);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public void addContext(ContextDescriptor ctxDesc, Context context) {
        String contextPath = ctxDesc.getContextPath();
        this.contexts.put(contextPath, context);
    }

    private void initJSP(boolean isWebAdmin) throws StartingException {
        this.jspConfig = (Hashtable)this.contextGroup.getJSPConfig().clone();
        String jspwork = (String)this.jspConfig.get("JspWorkDir");
        String outdir = (String)this.jspConfig.get("CompileOutputDir");
        String base = ContextGroup.convertSpecialCharacter(this.vhDesc.getVirtualHostName());
        base = isWebAdmin ? "" : base + File.separator;
        jspwork = jspwork + base;
        outdir = outdir + base;
        this.jspConfig.put("JspWorkDir", jspwork);
        this.jspConfig.put("CompileOutputDir", outdir);
    }

    public Context getContextByPath(String path) {
        Context ctx = null;
        do {
            if ((ctx = (Context)this.contexts.get(path)) != null) continue;
            int i = path.lastIndexOf(47);
            if (i <= -1 || path.length() <= 1) break;
            if ((path = path.substring(0, i)).length() != 0) continue;
            path = "/";
        } while (ctx == null);
        return ctx;
    }

    public Context getContextByPathFromVirtualHost(String path) {
        return this.contextGroup.getContextByPathFromVirtualHost(this, path);
    }

    public boolean isDefaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public Hashtable getJSPConfig() {
        return this.jspConfig;
    }

    public ContextGroup getContextGroup() {
        return this.contextGroup;
    }

    public VirtualHostDescriptor getDescriptor() {
        return this.vhDesc;
    }

    public String getVirtualHostName() {
        return this.vhDesc.getVirtualHostName();
    }

    public Iterator contextElements() {
        return this.contexts.values().iterator();
    }

    public void removeContext(String contextPath) {
        this.contexts.remove(contextPath);
    }

    public String toString() {
        return super.toString() + " VirtualHost(" + this.vhDesc.getVirtualHostName() + ")";
    }

    public VirtualHostProperties getVirtualHostProperties() {
        return this.virtualHostProperties;
    }
}

