/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.net.Socket;
import jeus.servlet.engine.ThreadPoolManager;

public final class WebtobSocketInfo {
    private boolean valid = true;
    private int threadId;
    private Socket socket;
    private String socketInfo;
    private boolean pipeSocket;
    private String nodeId;
    private int svri;
    private int clid;
    private int spri;

    WebtobSocketInfo(int threadId) {
        this.threadId = threadId;
        this.socket = null;
        this.pipeSocket = false;
        this.nodeId = null;
        this.svri = 0;
        this.clid = 0;
        this.spri = 0;
    }

    private WebtobSocketInfo(int threadId, String nodeId, int svri, int clid, int spri) {
        this.threadId = threadId;
        this.socket = null;
        this.pipeSocket = false;
        this.nodeId = nodeId;
        this.svri = svri;
        this.clid = clid;
        this.spri = spri;
    }

    void setSocketInfo(Socket socket, boolean ispipe, String nodeId, int svri, int clid, int spri, String sinfo) {
        this.socket = socket;
        this.pipeSocket = ispipe;
        this.nodeId = nodeId;
        this.svri = svri;
        this.clid = clid;
        this.spri = spri;
        this.socketInfo = sinfo;
    }

    void validate() {
        if (!this.valid) {
            throw new IllegalStateException();
        }
    }

    WebtobSocketInfo clone(ThreadPoolManager manager) {
        this.valid = false;
        return new WebtobSocketInfo(manager.getAndIncrementThreadId(), this.nodeId, this.svri, this.clid, this.spri);
    }

    void setThreadId(int id) {
        this.threadId = id;
    }

    public int getThreadId() {
        return this.threadId;
    }

    Socket getSocket() {
        return this.socket;
    }

    boolean isPipeSocket() {
        return this.pipeSocket;
    }

    String getNodeId() {
        return this.nodeId;
    }

    public int getSvri() {
        return this.svri;
    }

    public int getClid() {
        return this.clid;
    }

    public int getSpri() {
        return this.spri;
    }

    public String toString() {
        return this.socketInfo;
    }

    void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    void destroy() {
        this.valid = false;
        this.close();
    }
}

