/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.server.service.CPUMonitorService;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.connection.WebtobConnector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.WebtobRequestProcessor;
import jeus.servlet.engine.WebtobSocketInfo;
import jeus.servlet.engine.WebtobSuspendMonitor;
import jeus.servlet.engine.io.WebtobHeader;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.CUtility;
import jeus.util.ErrorMsgManager;
import jeus.util.cnet.NetUtil;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.PipeSocket;
import jeus.util.net.WinIPCSocket;

public class WebtobThreadPoolManager
extends ThreadPoolManager
implements WebtobHeader {
    private static final int DFLT_IPC_BASE_PORT = 6666;
    private WebtobConnector connector;
    private int hthId = 0;
    private int hthPort = 9900;
    private String webtobAddress = "127.0.0.1";
    private String registerId;
    private boolean requestQueueing = true;
    private boolean disablePipe = false;
    private String webtobPathDir = null;
    private boolean processingCreatePool = false;
    private ArrayList idleSocketInfos;
    private boolean qsizeAvailable = false;
    private boolean suspendSupported = false;
    private int queueCount = 0;
    private boolean qsizeCheckScheduled = false;
    private AtomicBoolean connectionUnavailable = new AtomicBoolean(false);
    private int webtobIpcbaseport = 6666;
    private boolean useWtbpoolManagement = false;
    private int maxThreadNum = -2;
    private int cpuFatalRate = 80;
    private int cpuWarningRate = 70;
    private int cpuSafeRate = 30;
    private int changingRatio = 70;
    private long checkInterval = 1000L;
    private Thread checkCpuThread = null;
    private Object checkCpuLock = new Object();
    private int orginalMinThreadNum = -1;

    public WebtobThreadPoolManager(ContextGroup ctxgrp, WebtobConnector connector, ConnectionDescriptor desc, int hthId) {
        super(ctxgrp, desc);
        this.connector = connector;
        this.hthId = hthId;
        this.hthPort = desc.getPort() + hthId;
        this.webtobAddress = desc.getWebServerAddress();
        this.registerId = desc.getRegistrationId();
        if (this.registerId == null || this.registerId.equalsIgnoreCase("default")) {
            this.registerId = this.contextGroup.getGroupName();
        }
        this.threadPoolId = desc.getListenerId() + "-hth" + hthId + "(" + this.webtobAddress + ":" + this.hthPort + ")";
        this.requestQueueing = desc.getRequestPrefetch();
        this.disablePipe = desc.getDisablePipe();
        String webtobHome = desc.getWebtobHome();
        this.webtobPathDir = webtobHome != null && webtobHome.length() > 0 ? (webtobHome.endsWith(File.separator) ? webtobHome + "path" + File.separator : webtobHome + File.separator + "path" + File.separator) : null;
        int tmpport = desc.getWebtobIpcbasePort();
        String tmpportStr = CUtility.getenv((String)"WEBTOB_IPCBASEPORT");
        int tmpport2 = -1;
        if (tmpportStr != null) {
            try {
                tmpport2 = Integer.parseInt(tmpportStr);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tmpport > 0) {
            this.webtobIpcbaseport = tmpport;
        } else if (tmpport2 > 0) {
            this.webtobIpcbaseport = tmpport2;
        }
        this.idleSocketInfos = new ArrayList();
        String probeRates = System.getProperty("jeus.wtbpool.proberates");
        String changeRate = System.getProperty("jeus.wtbpool.changerate");
        String checkIntervalString = System.getProperty("jeus.wtbpool.checkinterval");
        if (probeRates != null && changeRate != null && checkIntervalString != null) {
            StringTokenizer st = new StringTokenizer(probeRates.trim(), ",");
            this.cpuSafeRate = Integer.parseInt(st.nextToken());
            this.cpuWarningRate = Integer.parseInt(st.nextToken());
            this.cpuFatalRate = Integer.parseInt(st.nextToken());
            this.changingRatio = Integer.parseInt(changeRate.trim());
            this.checkInterval = Long.parseLong(checkIntervalString.trim());
            this.maxThreadNum = this.tpoolDesc.getMaxThreadNum();
            this.useWtbpoolManagement = true;
        } else {
            this.useWtbpoolManagement = false;
        }
        if (this.useWtbpoolManagement) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Object object = WebtobThreadPoolManager.this.checkCpuLock;
                                synchronized (object) {
                                    WebtobThreadPoolManager.this.checkCpuLock.wait(WebtobThreadPoolManager.this.checkInterval);
                                    WebtobThreadPoolManager.this.checkCpuRate();
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            System.out.println("ForceCpuCheck");
                            continue;
                        }
                        break;
                    }
                }
            };
            Thread checkCpuThread = new Thread(r);
            checkCpuThread.start();
            this.orginalMinThreadNum = this.tpoolDesc.getMinThreadNum();
        }
    }

    public void forceCpuCheck() {
        if (this.useWtbpoolManagement) {
            this.checkCpuThread.interrupt();
        }
    }

    public synchronized void createPool() throws StartingException {
        if (this.isDestroyed) {
            return;
        }
        int minThreadNum = this.tpoolDesc.getMinThreadNum();
        try {
            this.processingCreatePool = true;
            for (int i = 0; i < minThreadNum; ++i) {
                WebtobSocketInfo info = new WebtobSocketInfo(this.getAndIncrementThreadId());
                WebtobRequestProcessor proc = new WebtobRequestProcessor(this, this.contextGroup, info);
                this.threadPool.addElement(proc);
                proc.start();
            }
        }
        catch (Exception ioe) {
            throw new StartingException(2363, new String[]{ioe.getMessage()});
        }
        finally {
            this.processingCreatePool = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createThreads(int qcount) {
        this.queueCount = qcount;
        if (this.tpoolDesc.getMaxWaitQueue() > qcount || !this.qsizeAvailable || this.qsizeCheckScheduled) {
            return;
        }
        try {
            this.qsizeCheckScheduled = true;
            this.createThreads();
        }
        finally {
            this.qsizeCheckScheduled = false;
        }
    }

    public synchronized int createThreads() {
        if (this.isDestroyed) {
            return 0;
        }
        int diff = this.tpoolDesc.getMaxThreadNum() - this.threadPool.size();
        int changingRate = this.tpoolDesc.getChangingRate();
        if (diff > 0) {
            if (diff >= changingRate) {
                diff = changingRate;
            }
            if ((diff = this.tpoolDesc.getMaxThreadNum() - this.threadPool.size()) > 0) {
                if (diff >= changingRate) {
                    diff = changingRate;
                }
                for (int i = 0; i < diff; ++i) {
                    WebtobSocketInfo info = null;
                    int size2 = this.idleSocketInfos.size();
                    info = size2 > 0 ? (WebtobSocketInfo)this.idleSocketInfos.remove(0) : new WebtobSocketInfo(this.getAndIncrementThreadId());
                    WebtobRequestProcessor worker = new WebtobRequestProcessor(this, this.contextGroup, info);
                    this.threadPool.addElement(worker);
                    worker.start();
                }
            }
        }
        return diff;
    }

    public void deleteAllThreads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarmReconnectFail() {
        if (this.connectionUnavailable.get()) {
            return;
        }
        boolean connectionAvailable = false;
        WebtobThreadPoolManager webtobThreadPoolManager = this;
        synchronized (webtobThreadPoolManager) {
            int size = this.threadPool.size();
            WebtobRequestProcessor rp = null;
            for (int i = 0; i < size; ++i) {
                try {
                    rp = (WebtobRequestProcessor)this.threadPool.get(i);
                    if (rp.reconnecting && !rp.running) continue;
                    connectionAvailable = true;
                }
                catch (ArrayIndexOutOfBoundsException e) {}
                break;
            }
        }
        if (!connectionAvailable && this.connectionUnavailable.compareAndSet(false, true)) {
            this.connector.alarmConnectionUnavailable(this.hthId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentCpuRate() {
        int cpuRate = -1;
        String bogusCpuRateString = System.getProperty("eoh.debug.useboguscpurate");
        if ("true".equalsIgnoreCase(bogusCpuRateString)) {
            int bogusCpuRate = -1;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(System.getProperty("jeus.home") + File.separator + "boguscpu"));
                String oneLine = br.readLine();
                bogusCpuRate = Integer.parseInt(oneLine.trim());
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return bogusCpuRate;
        }
        CPUMonitorService cpuMonitorService = CPUMonitorService.getInstance();
        if (cpuMonitorService.isStarted()) {
            double usageRate = cpuMonitorService.getCPUMonitor().getHostCPUUsageRate();
            cpuRate = (int)(usageRate * 100.0);
        }
        return cpuRate;
    }

    public synchronized void checkCpuRate() {
        if (this.isDestroyed) {
            return;
        }
        if (this.processingCreatePool) {
            return;
        }
        if (this.maxThreadNum < -2) {
            return;
        }
        int rate = this.getCurrentCpuRate();
        logger.log(JeusMessage_WebContainer2._3962_LEVEL, JeusMessage_WebContainer2._3962, (Object[])new String[]{"" + this.cpuSafeRate, "" + this.cpuWarningRate, "" + this.cpuFatalRate, "" + rate, "" + this.maxThreadNum});
        int oldMaxThreadNum = this.maxThreadNum;
        if (rate > this.cpuFatalRate) {
            this.maxThreadNum = 0;
            logger.log(JeusMessage_WebContainer2._3963_LEVEL, JeusMessage_WebContainer2._3963, (Object[])new String[]{"Fatal", "rate>cpuFatalRate", "" + oldMaxThreadNum, "" + this.maxThreadNum});
            try {
                this.tpoolDesc.setMinThreadNum("0");
            }
            catch (DescriptorException e) {
                e.printStackTrace();
            }
        } else if (rate > this.cpuWarningRate) {
            this.maxThreadNum = this.maxThreadNum * this.changingRatio / 100;
            logger.log(JeusMessage_WebContainer2._3963_LEVEL, JeusMessage_WebContainer2._3963, (Object[])new String[]{"Warning", "cpuWarningRate<rate", "" + oldMaxThreadNum, "" + this.maxThreadNum});
        } else if (rate < this.cpuSafeRate) {
            if (this.maxThreadNum == 0) {
                this.maxThreadNum = (int)((double)this.tpoolDesc.getMaxThreadNum() * 0.5);
                int neoMin = this.maxThreadNum < this.orginalMinThreadNum ? this.maxThreadNum : this.orginalMinThreadNum;
                try {
                    this.tpoolDesc.setMinThreadNum("" + neoMin);
                }
                catch (DescriptorException e) {
                    e.printStackTrace();
                }
                logger.log(JeusMessage_WebContainer2._3963_LEVEL, JeusMessage_WebContainer2._3963, (Object[])new String[]{"Init", "rate<cpuSafeRate after fatal", "" + oldMaxThreadNum, "" + this.maxThreadNum});
            } else {
                this.maxThreadNum += this.maxThreadNum * this.changingRatio / 100;
                if (this.maxThreadNum > this.tpoolDesc.getMaxThreadNum()) {
                    this.maxThreadNum = this.tpoolDesc.getMaxThreadNum();
                    logger.log(JeusMessage_WebContainer2._3963_LEVEL, JeusMessage_WebContainer2._3963, (Object[])new String[]{"Normal", "rate<cpuSafeRate, set size to maxThreadNum ", "" + oldMaxThreadNum, "" + this.maxThreadNum});
                } else {
                    logger.log(JeusMessage_WebContainer2._3963_LEVEL, JeusMessage_WebContainer2._3963, (Object[])new String[]{"Increase", "rate<cpuSafeRate", "" + oldMaxThreadNum, "" + this.maxThreadNum});
                }
            }
            int diff = this.maxThreadNum - this.threadPool.size();
            for (int i = 0; i < diff; ++i) {
                int size2 = this.idleSocketInfos.size();
                try {
                    WebtobSocketInfo info = null;
                    info = size2 > 0 ? (WebtobSocketInfo)this.idleSocketInfos.remove(0) : new WebtobSocketInfo(this.getAndIncrementThreadId());
                    WebtobRequestProcessor worker = new WebtobRequestProcessor(this, this.contextGroup, info);
                    worker.start();
                    this.threadPool.addElement(worker);
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3379_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3379_LEVEL, JeusMessage_WebContainer2._3379, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId()});
                    continue;
                }
                catch (Throwable ioe) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3380_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3380_LEVEL, JeusMessage_WebContainer2._3380, (Object[])new String[]{String.valueOf(this.hthPort)}, ioe);
                }
            }
        }
    }

    public int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    public boolean isBusy() {
        return this.useWtbpoolManagement && this.threadPool.size() > this.maxThreadNum;
    }

    public synchronized void checkThreadPool() {
        WebtobRequestProcessor worker;
        if (this.isDestroyed) {
            return;
        }
        if (this.processingCreatePool) {
            return;
        }
        int minThreadNum = this.tpoolDesc.getMinThreadNum();
        if (this.maxThreadNum == -2) {
            this.maxThreadNum = this.tpoolDesc.getMaxThreadNum();
        }
        int deleteCount = this.tpoolDesc.getChangingRate();
        long maxIdleTime = this.tpoolDesc.getMaxIdleTime();
        long maxThreadActiveTime = this.tsnDesc == null ? 0L : this.tsnDesc.getMaxThreadActiveTime();
        boolean moreIdleCheck = true;
        int numActiveDeleted = 0;
        int numDead = 0;
        int numCreated = 0;
        int size = this.threadPool.size();
        if (maxIdleTime <= 0L) {
            moreIdleCheck = false;
        }
        if (this.tsnDesc != null) {
            String engineName;
            for (int i = size - 1; i >= 0; --i) {
                long idleTime;
                WebtobRequestProcessor worker2 = (WebtobRequestProcessor)this.threadPool.elementAt(i);
                if (!worker2.isAlive() && !worker2.isDeleted()) {
                    ++numDead;
                    this.threadPool.removeElementAt(i);
                    this.idleSocketInfos.add(worker2.removeSocketInfo());
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3373_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3373_LEVEL, JeusMessage_WebContainer2._3373, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker2.getThreadId(), worker2.getRequestURI()});
                    continue;
                }
                if (worker2.active && !worker2.reconnecting) {
                    long activeTime = worker2.checkIdleTime(maxThreadActiveTime);
                    if (activeTime <= 0L) continue;
                    this.threadPool.removeElementAt(i);
                    worker2.blocked = true;
                    this.blockedThreadPool.insertElementAt(worker2, 0);
                    this.idleSocketInfos.add(worker2.removeSocketInfo());
                    ++numActiveDeleted;
                    if (logger.isLoggable(JeusMessage_WebContainer2._3374_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3374_LEVEL, JeusMessage_WebContainer2._3374, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker2.getThreadId(), String.valueOf(activeTime), worker2.getRequestURI(), String.valueOf(worker2.isAlive())});
                    }
                    worker2.interrupt();
                    continue;
                }
                if (worker2.active || worker2.reconnecting || !moreIdleCheck || this.threadPool.size() <= minThreadNum || (idleTime = worker2.checkIdleTime(maxIdleTime)) <= 0L) continue;
                this.threadPool.removeElementAt(i);
                this.idleSocketInfos.add(worker2.removeSocketInfo());
                worker2.terminate();
                if (--deleteCount == 0) {
                    moreIdleCheck = false;
                }
                if (!logger.isLoggable(JeusMessage_WebContainer2._3383_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3383_LEVEL, JeusMessage_WebContainer2._3383, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker2.getThreadId(), String.valueOf(idleTime)});
            }
            String msg = "";
            int blockedThreads = 0;
            int numBlocked = this.blockedThreadPool.size();
            if (numBlocked > 0) {
                for (int i = numBlocked - 1; i >= 0; --i) {
                    String state;
                    worker = (WebtobRequestProcessor)this.blockedThreadPool.elementAt(i);
                    if (!worker.isDeleted() && !worker.isAlive()) {
                        ++numDead;
                        if (logger.isLoggable(JeusMessage_WebContainer2._3375_LEVEL)) {
                            logger.log(JeusMessage_WebContainer2._3375_LEVEL, JeusMessage_WebContainer2._3375, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), worker.getRequestURI()});
                        }
                        worker.clearing();
                    }
                    if ((state = worker.checkBlockedThreadState()) != null) {
                        msg = msg + state + "\n";
                        ++blockedThreads;
                        if (!logger.isLoggable(JeusMessage_WebContainer2._3376_LEVEL)) continue;
                        logger.log(JeusMessage_WebContainer2._3376_LEVEL, JeusMessage_WebContainer2._3376, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), worker.getRequestURI(), String.valueOf(worker.isAlive())});
                        continue;
                    }
                    worker.blocked = false;
                    this.blockedThreadPool.removeElement(worker);
                }
            }
            if (this.tsnDesc != null && this.tsnDesc.needNotify(blockedThreads, this.maxThreadNum)) {
                WebContainerManager manager = this.contextGroup.getContainerManager();
                engineName = manager.ENGINE_NAME;
                if (logger.isLoggable(JeusMessage_WebContainer2._3319_LEVEL)) {
                    logger.sendEmailNotification(JeusMessage_WebContainer2._3319_LEVEL, this.tsnDesc.getNotifySubject(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3319, (Object[])new String[]{engineName, this.threadPoolId, msg}));
                }
            }
            if (this.tsnDesc != null && this.tsnDesc.needRestart(blockedThreads, this.maxThreadNum)) {
                WebContainerManager manager = this.contextGroup.getContainerManager();
                engineName = manager.ENGINE_NAME;
                String restartMsg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3320, (Object[])new String[]{engineName, this.threadPoolId, msg});
                logger.log(JeusMessage_WebContainer2._3320_LEVEL, restartMsg);
                if (logger.isLoggable(JeusMessage_WebContainer2._3320_LEVEL)) {
                    logger.sendEmailNotification(JeusMessage_WebContainer2._3320_LEVEL, this.tsnDesc.getRestartSubject(), restartMsg);
                }
                manager.restartEngine(this.contextGroup.getGroupName());
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                long idleTime;
                WebtobRequestProcessor worker3 = (WebtobRequestProcessor)this.threadPool.elementAt(i);
                if (!worker3.isAlive() && !worker3.isDeleted()) {
                    ++numDead;
                    this.threadPool.removeElementAt(i);
                    this.idleSocketInfos.add(worker3.removeSocketInfo());
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3373_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3373_LEVEL, JeusMessage_WebContainer2._3373, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker3.getThreadId(), worker3.getRequestURI()});
                    continue;
                }
                if (worker3.active || worker3.reconnecting || !moreIdleCheck || this.threadPool.size() <= minThreadNum || (idleTime = worker3.checkIdleTime(maxIdleTime)) <= 0L) continue;
                this.threadPool.removeElementAt(i);
                this.idleSocketInfos.add(worker3.removeSocketInfo());
                worker3.terminate();
                if (--deleteCount == 0) {
                    moreIdleCheck = false;
                }
                if (!logger.isLoggable(JeusMessage_WebContainer2._3383_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3383_LEVEL, JeusMessage_WebContainer2._3383, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker3.getThreadId(), String.valueOf(idleTime)});
            }
        }
        size = this.threadPool.size();
        if (size < minThreadNum) {
            int diff = minThreadNum - size;
            for (int i = 0; i < diff; ++i) {
                int size2 = this.idleSocketInfos.size();
                try {
                    WebtobSocketInfo info = null;
                    info = size2 > 0 ? (WebtobSocketInfo)this.idleSocketInfos.remove(0) : new WebtobSocketInfo(this.getAndIncrementThreadId());
                    worker = new WebtobRequestProcessor(this, this.contextGroup, info);
                    worker.start();
                    this.threadPool.addElement(worker);
                    ++numCreated;
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3379_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3379_LEVEL, JeusMessage_WebContainer2._3379, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId()});
                    continue;
                }
                catch (Throwable ioe) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3380_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3380_LEVEL, JeusMessage_WebContainer2._3380, (Object[])new String[]{String.valueOf(this.hthPort)}, ioe);
                }
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3381_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3381_LEVEL, JeusMessage_WebContainer2._3381, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), String.valueOf(numActiveDeleted), String.valueOf(numDead), String.valueOf(numCreated)});
        }
    }

    public String getConnectionInfo() {
        return this.getThreadPoolId() + " [port: " + this.hthPort + "] live connections = " + this.threadPool.size();
    }

    public int getWaitQueueCount() {
        if (this.qsizeAvailable) {
            return this.queueCount;
        }
        return -1;
    }

    public synchronized void destroy() {
        this.isDestroyed = true;
        Enumeration e = this.threadPool.elements();
        while (e.hasMoreElements()) {
            WebtobRequestProcessor worker = (WebtobRequestProcessor)e.nextElement();
            worker.terminate();
        }
        this.threadPoolMo.destroyMBean();
    }

    public void suspend() throws IOException {
        WebProperties props = PropertyUtil.getContextProperties();
        this.suspend(props.WEBTOB_SUSPEND_COMMAND_TIMEOUT.value);
    }

    public synchronized void suspend(long timeout) throws IOException {
        if (!this.suspendSupported) {
            return;
        }
        IOException e = null;
        Enumeration enum1 = this.threadPool.elements();
        Vector<WebtobRequestProcessor> suspendedThreads = new Vector<WebtobRequestProcessor>();
        WebtobSuspendMonitor monitor = new WebtobSuspendMonitor();
        while (enum1.hasMoreElements()) {
            WebtobRequestProcessor proc = (WebtobRequestProcessor)enum1.nextElement();
            try {
                if (!proc.suspendWork(monitor)) continue;
                suspendedThreads.add(proc);
            }
            catch (IOException ioe) {
                e = ioe;
            }
        }
        if (e != null) {
            throw e;
        }
        int notSuspended = monitor.waitSuspended(suspendedThreads, timeout);
        if (notSuspended > 0 && logger.isLoggable(JeusMessage_WebContainer2._3706_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3706_LEVEL, JeusMessage_WebContainer2._3706, (Object)String.valueOf(notSuspended));
        }
    }

    public synchronized void resume() throws IOException {
        if (!this.suspendSupported) {
            return;
        }
        IOException e = null;
        Enumeration enum1 = this.threadPool.elements();
        while (enum1.hasMoreElements()) {
            WebtobRequestProcessor proc = (WebtobRequestProcessor)enum1.nextElement();
            try {
                proc.resumeWork();
            }
            catch (IOException ioe) {
                e = ioe;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public void registryConnection(WebtobSocketInfo info) throws IOException {
        info.validate();
        Socket socket = this.connectSocket();
        this.registerWebtob(info, socket, false);
    }

    private Socket connectSocket() throws IOException {
        Socket socket = null;
        socket = JeusNetUtil.getWebtobSocket((String)this.webtobPathDir, (String)this.webtobAddress, (int)this.hthPort, (int)this.hthId, (boolean)this.disablePipe, (int)this.webtobIpcbaseport);
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }

    public void registerWebtob(WebtobSocketInfo info, Socket socket, boolean resumeMode) throws IOException {
        String sinfo;
        boolean isPipeSocket = socket instanceof PipeSocket;
        boolean isWinIPCSocket = socket instanceof WinIPCSocket;
        String nodeId = null;
        boolean isLittleEndian = isPipeSocket && !PipeSocket.BIG_ENDIAN && !resumeMode || isWinIPCSocket && !resumeMode;
        DataInputStream in = new DataInputStream(socket.getInputStream());
        OutputStream out = socket.getOutputStream();
        byte[] engineName = this.makeSessionRoutingEngineInfo();
        int engineNameLen = engineName == null ? 0 : engineName.length;
        byte[] header = new byte[96 + engineNameLen];
        String svrGroupName = null;
        String svrName = null;
        int s1 = this.registerId.indexOf(58);
        if (s1 >= 0) {
            svrGroupName = this.registerId.substring(0, s1);
            svrName = this.registerId.substring(s1 + 1);
        } else {
            svrGroupName = null;
            svrName = this.registerId;
        }
        NetUtil.writeInt((byte[])header, (int)0, (int)9999, (boolean)isLittleEndian);
        NetUtil.writeInt((byte[])header, (int)16, (int)101, (boolean)isLittleEndian);
        NetUtil.writeInt((byte[])header, (int)28, (int)info.getThreadId(), (boolean)isLittleEndian);
        if (isPipeSocket || isWinIPCSocket) {
            NetUtil.writeInt((byte[])header, (int)8, (int)3, (boolean)isLittleEndian);
        }
        int svciflags = 0;
        if (this.requestQueueing) {
            svciflags |= 2;
        }
        svciflags |= 4;
        svciflags |= 0x40000;
        svciflags |= 0x20000;
        NetUtil.writeInt((byte[])header, (int)88, (int)(svciflags |= 0x200000), (boolean)isLittleEndian);
        NetUtil.writeInt((byte[])header, (int)20, (int)info.getSvri(), (boolean)isLittleEndian);
        NetUtil.writeInt((byte[])header, (int)24, (int)info.getClid(), (boolean)isLittleEndian);
        NetUtil.writeInt((byte[])header, (int)92, (int)info.getSpri(), (boolean)isLittleEndian);
        if (svrGroupName != null) {
            byte[] svrGroupNameBytes = svrGroupName.getBytes();
            System.arraycopy(svrGroupNameBytes, 0, header, 52, svrGroupNameBytes.length);
            header[52 + svrGroupNameBytes.length] = 0;
        }
        byte[] svrNameBytes = svrName.getBytes();
        System.arraycopy(svrNameBytes, 0, header, 68, svrNameBytes.length);
        header[68 + svrNameBytes.length] = 0;
        if (engineNameLen > 0) {
            System.arraycopy(engineName, 0, header, 96, engineNameLen);
            NetUtil.writeInt((byte[])header, (int)84, (int)engineNameLen, (boolean)isLittleEndian);
        }
        out.write(header, 0, 96 + engineNameLen);
        out.flush();
        if (resumeMode) {
            return;
        }
        try {
            socket.setSoTimeout(30000);
            in.readFully(header, 0, 96);
        }
        catch (Exception e) {
            socket.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3368));
        }
        int magic = NetUtil.readInt((byte[])header, (int)0);
        int type = NetUtil.readInt((byte[])header, (int)16);
        int msize = NetUtil.readInt((byte[])header, (int)84);
        int svri = NetUtil.readInt((byte[])header, (int)20);
        int clid = NetUtil.readInt((byte[])header, (int)24);
        int spri = NetUtil.readInt((byte[])header, (int)92);
        int rflag = NetUtil.readInt((byte[])header, (int)88);
        if (msize > 0) {
            byte[] data = new byte[msize + 1];
            try {
                in.readFully(data, 0, msize);
            }
            catch (Exception e) {
                throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3368));
            }
        }
        int readTimeout = this.getReadTimeout();
        try {
            if (readTimeout > 0) {
                socket.setSoTimeout(readTimeout);
            } else {
                socket.setSoTimeout(0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (magic != 9999) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3369, (Object)String.valueOf(magic)));
        }
        if (type != 1101) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3370, (Object)String.valueOf(type)));
        }
        if ((rflag & 0x20000) != 131072) {
            nodeId = null;
        } else {
            int nodeNo = clid >> 21;
            int hthNo = (clid & 0x1FC000) >> 14;
            DecimalFormat fmt1 = new DecimalFormat("0000");
            DecimalFormat fmt2 = new DecimalFormat("000");
            nodeId = fmt1.format(nodeNo) + fmt2.format(hthNo);
        }
        this.qsizeAvailable = (rflag & 4) == 4;
        this.suspendSupported = (rflag & 0x200000) == 0x200000;
        String string = sinfo = isPipeSocket ? socket.toString() : "Socket[" + this.webtobAddress + ":" + this.hthPort + "]";
        if (logger.isLoggable(JeusMessage_WebContainer2._3384_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3384_LEVEL, JeusMessage_WebContainer2._3384, (Object)sinfo);
        }
        info.setSocketInfo(socket, isPipeSocket, nodeId, svri, clid, spri, sinfo);
    }

    private byte[] makeSessionRoutingEngineInfo() {
        String id = "JENGINEID\t" + this.contextGroup.getSessionRoutingEngineName();
        byte[] idbyte = id.getBytes();
        String result = "0000E" + id + "0000";
        int len = idbyte.length;
        byte[] lenstr = String.valueOf(len).getBytes();
        byte[] resultByte = result.getBytes();
        System.arraycopy(lenstr, 0, resultByte, 4 - lenstr.length, lenstr.length);
        return resultByte;
    }
}

