/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.io.Ajp13Constants;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.servlet.engine.io.ResponseHeaderInfo;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer2;

public class Ajp13OutputAdaptor
extends ProtocolOutputAdaptor
implements Ajp13Constants {
    public static final int SC_RESP_CONTENT_TYPE = 40961;
    public static final int SC_RESP_CONTENT_LANGUAGE = 40962;
    public static final int SC_RESP_CONTENT_LENGTH = 40963;
    public static final int SC_RESP_DATE = 40964;
    public static final int SC_RESP_LAST_MODIFIED = 40965;
    public static final int SC_RESP_LOCATION = 40966;
    public static final int SC_RESP_SET_COOKIE = 40967;
    public static final int SC_RESP_SET_COOKIE2 = 40968;
    public static final int SC_RESP_SERVLET_ENGINE = 40969;
    public static final int SC_RESP_STATUS = 40970;
    public static final int SC_RESP_WWW_AUTHENTICATE = 40971;
    public static final byte[] END_RESPONSE_ARRAY = new byte[]{65, 66, 0, 2, 5, 1};

    public Ajp13OutputAdaptor(OutputStream out, WebServerOutputStream webServer, byte[] header, byte[] body) {
        super(out, webServer, header, body);
    }

    protected int prepareBuffer(int min, int max) throws IOException {
        int freeSpace = this.bufferSize - this.bufferCount - 1;
        if (freeSpace < min) {
            this.flush(true, false);
        }
        if ((freeSpace = this.bufferSize - this.bufferCount - 1) < min) {
            throw new IOException("buffer full. min = " + min);
        }
        return freeSpace;
    }

    void setMaxContentLength(int value) {
        this.maxContentLength = value;
    }

    protected void writeHeader() throws IOException {
        if (this.headerCount > this.webServerHeaderSize) {
            return;
        }
        this.headerCount = 0;
        this.appendHeaderShort(16706);
        this.appendHeaderShort(0);
        this.httpHeader[this.headerCount++] = 4;
        ResponseHeaderInfo header = this.webServer.getResponseHeader();
        String encoding = header.encoding;
        this.appendHeaderShort(header.status);
        this.appendHeaderString(RequestUtil.getStatusString(header.status), encoding);
        ArrayList resh = header.processResponseHeader2();
        int num_hdr = resh.size() / 2;
        this.appendHeaderShort(num_hdr);
        Iterator it = resh.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = (String)it.next();
            int sc = this.headerNameToSc(name);
            if (sc != -1) {
                this.appendHeaderShort(sc);
            } else {
                this.appendHeaderString(name, encoding);
            }
            this.appendHeaderString(value, encoding);
        }
        this.setShort(this.httpHeader, 2, this.headerCount - 4);
        this.out.write(this.httpHeader, 0, this.headerCount);
        if (logger.isLoggable(JeusMessage_WebContainer2._3270_LEVEL)) {
            StringBuffer buf = new StringBuffer();
            buf.append("\tstatus : " + RequestUtil.getStatusString(header.status) + StringUtil.lineSeparator);
            buf.append("\theader : " + resh.toString() + StringUtil.lineSeparator);
            logger.log(JeusMessage_WebContainer2._3270_LEVEL, JeusMessage_WebContainer2._3270, (Object)buf.toString());
        }
    }

    private int headerNameToSc(String name) {
        switch (name.charAt(0)) {
            case 'C': 
            case 'c': {
                if (name.equalsIgnoreCase("Content-Type")) {
                    return 40961;
                }
                if (name.equalsIgnoreCase("Content-Language")) {
                    return 40962;
                }
                if (!name.equalsIgnoreCase("Content-Length")) break;
                return 40963;
            }
            case 'D': 
            case 'd': {
                if (!name.equalsIgnoreCase("Date")) break;
                return 40964;
            }
            case 'L': 
            case 'l': {
                if (name.equalsIgnoreCase("Last-Modified")) {
                    return 40965;
                }
                if (!name.equalsIgnoreCase("Location")) break;
                return 40966;
            }
            case 'S': 
            case 's': {
                if (name.equalsIgnoreCase("Set-Cookie")) {
                    return 40967;
                }
                if (!name.equalsIgnoreCase("Set-Cookie2")) break;
                return 40968;
            }
            case 'W': 
            case 'w': {
                if (!name.equalsIgnoreCase("WWW-Authenticate")) break;
                return 40971;
            }
        }
        return -1;
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        boolean flushed = false;
        try {
            int contLen = this.bufferCount - this.webServerHeaderSize;
            if (!forced && !last && contLen <= 0) {
                return false;
            }
            if (!this.committed) {
                this.writeHeader();
                this.committed = true;
                flushed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
            }
            if (contLen > 0) {
                this.httpBody[this.bufferCount++] = 0;
                this.setShort(this.httpBody, 0, 16706);
                this.setShort(this.httpBody, 2, this.bufferCount - 4);
                this.httpBody[4] = 3;
                this.setShort(this.httpBody, 5, this.bufferCount - this.webServerHeaderSize - 1);
                this.out.write(this.httpBody, 0, this.bufferCount);
                this.out.flush();
                flushed = true;
            }
            if (last) {
                this.out.flush();
                this.out.write(END_RESPONSE_ARRAY);
                flushed = true;
            }
            this.out.flush();
            this.bufferCount = this.webServerHeaderSize;
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        return flushed;
    }

    protected void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize;
        this.headerCount = this.webServerHeaderSize;
        this.contentCount = 0;
    }

    protected void resetContent() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize;
        this.contentCount = 0;
    }

    private int setShort(byte[] buff, int bPos, int val) {
        buff[bPos] = (byte)(val >>> 8 & 0xFF);
        buff[bPos + 1] = (byte)(val & 0xFF);
        return 2;
    }

    private void appendHeaderShort(int val) {
        this.httpHeader[this.headerCount++] = (byte)(val >>> 8 & 0xFF);
        this.httpHeader[this.headerCount++] = (byte)(val & 0xFF);
    }

    private void appendHeaderString(String str, String encoding) throws IOException {
        if (str == null) {
            this.checkHeaderBufferSize(3);
            this.appendHeaderShort(0);
            this.httpHeader[this.headerCount++] = 0;
            return;
        }
        byte[] bytes = null;
        try {
            bytes = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            bytes = str.getBytes();
        }
        int toWrite = 2 + bytes.length + 1;
        this.checkHeaderBufferSize(toWrite);
        this.appendHeaderShort(bytes.length);
        System.arraycopy(bytes, 0, this.httpHeader, this.headerCount, bytes.length);
        this.headerCount += bytes.length;
        this.httpHeader[this.headerCount++] = 0;
    }

    private void checkHeaderBufferSize(int toWrite) {
        if (this.headerCount + toWrite > this.httpHeader.length) {
            int newsize;
            byte[] org = this.httpHeader;
            for (newsize = this.httpHeader.length; this.headerCount + toWrite > newsize; newsize += 1024) {
            }
            this.httpHeader = this.webServer.resizeHttpHeader(newsize);
            System.arraycopy(org, 0, this.httpHeader, 0, this.headerCount);
        }
    }
}

