/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.servlet.engine.io.ResponseHeaderInfo;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class BufferedOutputAdaptor
extends ProtocolOutputAdaptor {
    protected BufferedOutputAdaptor(OutputStream out, WebServerOutputStream webServer, byte[] header, byte[] body) {
        super(out, webServer, header, body);
    }

    protected int prepareBuffer(int min, int max) throws IOException {
        int freeSpace = this.bufferSize - this.bufferCount;
        if (freeSpace < min) {
            this.flush(true, false);
        }
        if ((freeSpace = this.bufferSize - this.bufferCount) < min) {
            throw new IOException("buffer full. min = " + min);
        }
        return freeSpace;
    }

    protected void writeHeader() {
        if (this.headerCount > this.webServerHeaderSize) {
            return;
        }
        ResponseHeaderInfo header = this.webServer.getResponseHeader();
        this.headerCount = this.webServerHeaderSize;
        if (header.contentLength >= 0) {
            header.responseHeader.append("Content-Length: " + String.valueOf(header.contentLength) + "\r\n");
        }
        header.responseHeader.append("\r\n");
        byte[] content = null;
        byte[] statusLine = new byte[]{};
        WebProperties props = PropertyUtil.getContextProperties();
        String encoding = props.RESPONSE_HEADER_ENCODING.value;
        if (header.statusLine != null) {
            if (encoding == null) {
                statusLine = header.statusLine.toString().getBytes();
            } else {
                try {
                    statusLine = header.statusLine.toString().getBytes(encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    statusLine = header.statusLine.toString().getBytes();
                }
            }
        }
        if (encoding == null) {
            content = header.responseHeader.toString().getBytes();
        } else {
            try {
                content = header.responseHeader.toString().getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                content = header.responseHeader.toString().getBytes();
            }
        }
        if (statusLine.length + content.length > this.httpHeader.length - this.headerCount) {
            this.httpHeader = this.webServer.resizeHttpHeader(statusLine.length + content.length + this.webServerHeaderSize);
        }
        if (statusLine.length > 0) {
            System.arraycopy(statusLine, 0, this.httpHeader, this.headerCount, statusLine.length);
            this.headerCount += statusLine.length;
        }
        System.arraycopy(content, 0, this.httpHeader, this.headerCount, content.length);
        this.headerCount += content.length;
        if (logger.isLoggable(JeusMessage_WebContainer2._3271_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3271_LEVEL, JeusMessage_WebContainer2._3271, (Object)new String(this.httpHeader, this.webServerHeaderSize, this.headerCount - this.webServerHeaderSize));
        }
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        boolean flushed = false;
        try {
            int contLen = this.bufferCount - this.webServerHeaderSize;
            if (!forced && !last && contLen <= 0) {
                return false;
            }
            if (!this.committed) {
                this.writeHeader();
                this.webServer.setWebServerHeader(last, contLen + this.headerCount, 0, this.httpHeader);
                this.out.write(this.httpHeader, 0, this.headerCount);
                if (contLen > 0) {
                    this.out.write(this.httpBody, this.webServerHeaderSize, contLen);
                }
                this.out.flush();
                this.committed = true;
                flushed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
            } else if (last || contLen > 0) {
                this.webServer.setWebServerHeader(last, this.bufferCount, 0, this.httpBody);
                this.out.write(this.httpBody, 0, this.bufferCount);
                this.out.flush();
                flushed = true;
            }
            if (flushed) {
                this.bufferCount = this.webServerHeaderSize;
            }
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        return flushed;
    }

    protected void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize;
        this.headerCount = this.webServerHeaderSize;
        this.contentCount = 0;
    }

    protected void resetContent() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize;
        this.contentCount = 0;
    }
}

