/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.StreamHandlerImpl14;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;

public abstract class ProtocolOutputAdaptor {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    protected OutputStream out;
    protected byte[] httpHeader;
    protected byte[] httpBody;
    private byte[] initHttpBody;
    protected int bufferSize;
    protected int webServerHeaderSize;
    protected int headerCount;
    protected int bufferCount;
    protected WebServerOutputStream webServer = null;
    protected boolean committed = false;
    protected boolean bufferClosed = false;
    protected int maxContentLength;
    protected int contentCount;
    protected StreamHandlerImpl14 streamHandler;

    protected ProtocolOutputAdaptor(OutputStream out, WebServerOutputStream webServer, byte[] header, byte[] body) {
        this.out = out;
        this.webServer = webServer;
        this.httpHeader = header;
        this.httpBody = body;
        this.initHttpBody = body;
        this.headerCount = this.webServerHeaderSize = webServer.getWebServerHeaderSize();
        this.bufferCount = this.webServerHeaderSize;
        this.bufferSize = this.httpBody.length;
        this.committed = false;
        this.bufferClosed = false;
        this.maxContentLength = -1;
    }

    void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setStreamHandlerImpl(StreamHandlerImpl streamHandler) {
        this.streamHandler = (StreamHandlerImpl14)streamHandler;
    }

    public void setBodyBuffer(byte[] body) {
        this.httpBody = body;
        this.bufferSize = body.length;
        this.headerCount = this.webServerHeaderSize;
        this.bufferCount = this.webServerHeaderSize;
        this.webServer.sendUrgentMessage();
    }

    boolean isEmpty() {
        return !this.committed && this.bufferCount <= this.webServerHeaderSize && this.headerCount <= this.webServerHeaderSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getHttpHeaderSize() {
        return this.headerCount - this.webServerHeaderSize;
    }

    void setMaxContentLength(int value) {
        this.maxContentLength = value;
    }

    void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    protected int getContentCount() {
        return this.contentCount;
    }

    protected final int beforeWrite(int len) throws IOException {
        if (this.bufferClosed) {
            return 0;
        }
        if (this.maxContentLength >= 0) {
            int diff = this.maxContentLength - this.contentCount;
            int n = len = len > diff ? diff : len;
        }
        if (this.httpBody == null) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3468));
        }
        return len;
    }

    protected final void afterWrite(int count) throws IOException {
        this.contentCount += count;
        if (this.maxContentLength >= 0 && this.maxContentLength == this.contentCount) {
            if (!this.committed) {
                this.flush(true, false);
            }
            this.bufferClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(int i) throws IOException {
        try {
            int max = this.beforeWrite(1);
            if (max == 0) {
                return;
            }
            this.prepareBuffer(1, 1);
            this.httpBody[this.bufferCount++] = (byte)i;
        }
        finally {
            this.afterWrite(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3450));
        }
        int writtenBytes = 0;
        try {
            int max = this.beforeWrite(len);
            while (len > 0 && max > 0) {
                int currentMax = this.prepareBuffer(1, max);
                int currentLen = len > currentMax ? currentMax : len;
                System.arraycopy(b, off, this.httpBody, this.bufferCount, currentLen);
                len -= currentLen;
                off += currentLen;
                if ((max -= currentLen) < 0) {
                    this.bufferCount += currentLen + max;
                    writtenBytes += currentLen + max;
                    break;
                }
                this.bufferCount += currentLen;
                writtenBytes += currentLen;
            }
        }
        finally {
            this.afterWrite(writtenBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(char[] cbuf, int off, int len, CharsetEncoder ctb) throws IOException {
        int maxBytesPerChar = (int)ctb.maxBytesPerChar();
        int temp = maxBytesPerChar * len;
        int ci = off;
        int end = off + len;
        int writtenBytesCount = 0;
        try {
            int max = this.beforeWrite(temp);
            if (max == 0) {
                return;
            }
            if (WebProperties.J2EE_COMPATIBLE.value) {
                for (int i = off; i < len; ++i) {
                    if (cbuf[i] < '\ufeff') continue;
                    cbuf[i] = 32;
                }
            }
            int n = 0;
            while (len > 0 && max > 0) {
                ByteBuffer hbuf;
                int currentMax = this.prepareBuffer(maxBytesPerChar, max);
                CharBuffer cbuff = CharBuffer.wrap(cbuf, ci, len);
                CoderResult coderResult = ctb.encode(cbuff, hbuf = ByteBuffer.wrap(this.httpBody, this.bufferCount, currentMax), false);
                if (coderResult.isOverflow()) {
                    int nci = cbuff.position();
                    if (nci == ci) {
                        throw new CharConversionException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3734));
                    }
                    ci = nci;
                    n = hbuf.position() - this.bufferCount;
                } else {
                    n = hbuf.position() - this.bufferCount;
                    ci = end;
                }
                if ((max -= n) < 0) {
                    this.bufferCount += n + max;
                    writtenBytesCount += n + max;
                    break;
                }
                writtenBytesCount += n;
                this.bufferCount += n;
                len = end - ci;
            }
        }
        finally {
            this.afterWrite(writtenBytesCount);
        }
    }

    public boolean flush(boolean forced, boolean last) throws IOException {
        if (!this.committed) {
            this.webServer.sendUrgentMessage();
        }
        return this.internalFlush(forced, last);
    }

    boolean isCommitted() {
        return this.committed;
    }

    void closeBuffer() {
        this.bufferClosed = true;
    }

    void uncloseBuffer() {
        this.bufferClosed = false;
    }

    protected void finish() {
        this.committed = false;
        this.bufferClosed = false;
        this.contentCount = 0;
        this.maxContentLength = -1;
        this.setBodyBuffer(this.initHttpBody);
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    protected abstract void writeHeader() throws IOException;

    protected abstract int prepareBuffer(int var1, int var2) throws IOException;

    public abstract boolean internalFlush(boolean var1, boolean var2) throws IOException;

    protected abstract void reset() throws IllegalStateException;

    protected abstract void resetContent() throws IllegalStateException;
}

