/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import jeus.servlet.engine.io.ServletStreamWriter;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;
import sun.security.action.GetPropertyAction;

public final class ServletOutputStreamWriter
extends ServletStreamWriter {
    private char[] cb;
    private int nChars;
    private int nextChar;
    private CharsetEncoder ctb;
    private WebServerOutputStream out;
    private String encoding;
    private boolean closed;

    public ServletOutputStreamWriter(WebServerOutputStream out) {
        super((Object)out);
        if (out == null) {
            throw new NullPointerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3735));
        }
        this.encoding = null;
        this.out = out;
        this.cb = new char[8192];
        this.nextChar = 0;
        this.nChars = 8192;
        this.closed = false;
    }

    public void jspInit(int size) {
        if (size < 8192) {
            size = 8192;
        }
        if (this.cb.length >= size) {
            return;
        }
        char[] tmp = new char[size];
        if (this.nextChar > 0) {
            System.arraycopy(this.cb, 0, tmp, 0, this.nextChar);
        }
        this.cb = tmp;
        this.nChars = size;
    }

    void reset() {
        this.nextChar = 0;
        this.flushed = false;
        this.closed = false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) throws UnsupportedEncodingException {
        if (this.flushed) {
            return;
        }
        if (this.ctb != null) {
            if (enc == null && this.encoding == null) {
                return;
            }
            if (enc.equals(this.encoding)) {
                return;
            }
        }
        if (enc == null) {
            try {
                GetPropertyAction pa = new GetPropertyAction("file.encoding");
                String csn = AccessController.doPrivileged(pa);
                this.ctb = Charset.forName(csn).newEncoder();
            }
            catch (UnsupportedCharsetException e) {
                this.ctb = Charset.forName("UTF-8").newEncoder();
            }
        } else {
            this.ctb = Charset.forName(enc).newEncoder();
        }
        this.ctb.onMalformedInput(CodingErrorAction.REPLACE);
        this.ctb.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.encoding = enc;
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3512));
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3736));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.nextChar == 0) {
                return;
            }
            this.out.write(this.cb, 0, this.nextChar, this.ctb);
            this.nextChar = 0;
            this.flushed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.nextChar >= this.nChars) {
                if (autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.nChars) {
                if (autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
                this.out.write(cbuf, off, len, this.ctb);
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                System.arraycopy(cbuf, b, this.cb, this.nextChar, d);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                if (autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                s.getChars(b, b + d, this.cb, this.nextChar);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                if (autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.flushBuffer();
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.flushBuffer();
            this.out.close();
            this.closed = true;
        }
    }

    public void unclose() {
        this.closed = false;
        this.out.unclose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            try {
                this.out.resetContent();
            }
            catch (IllegalStateException ise) {
                throw new IOException(ise.getMessage());
            }
            this.nextChar = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            try {
                this.out.resetContent();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.nextChar = 0;
        }
    }

    public int getUsed() {
        return this.nextChar;
    }
}

