/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.Writer;
import jeus.servlet.engine.io.ServletStreamWriter;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public final class WrappedServletStreamWriter
extends ServletStreamWriter {
    private char[] cb;
    private int nChars;
    private int nextChar;
    private Writer out;

    public WrappedServletStreamWriter(Writer out, int bufsize) {
        super(out);
        if (out == null) {
            throw new NullPointerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3735));
        }
        this.out = out;
        if (bufsize < 8192) {
            bufsize = 8192;
        }
        this.cb = new char[bufsize];
        this.nChars = bufsize;
        this.flushed = false;
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3512));
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3736));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            if (this.nextChar == 0) {
                return;
            }
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
            this.flushed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            if (this.nextChar >= this.nChars) {
                if (autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.nChars) {
                if (autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
                this.out.write(cbuf, off, len);
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                System.arraycopy(cbuf, b, this.cb, this.nextChar, d);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                if (autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                s.getChars(b, b + d, this.cb, this.nextChar);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                if (autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.flushBuffer();
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flushBuffer();
            this.out.close();
            this.out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.flushed) {
                throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3511));
            }
            if (this.out == null) {
                return;
            }
            this.nextChar = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.nextChar = 0;
        }
    }

    public int getUsed() {
        return this.nextChar;
    }
}

