/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.filter;

import javax.servlet.ServletRequest;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.filter.FilterChainImpl;
import jeus.servlet.filter.FilterConfigImpl;
import jeus.servlet.filter.FilterMap;

public class FilterFactory {
    public static final int ERROR = 1;
    public static final Integer ERROR_INTEGER = new Integer(1);
    public static final int FORWARD = 2;
    public static final Integer FORWARD_INTEGER = new Integer(2);
    public static final int INCLUDE = 4;
    public static final Integer INCLUDE_INTEGER = new Integer(4);
    public static final int REQUEST = 8;
    public static final Integer REQUEST_INTEGER = new Integer(8);
    public static final String DISPATCHER_TYPE_ATTR = "jeus.web.DISPATCHER_TYPE";
    public static final String DISPATCHER_REQUEST_PATH_ATTR = "jeus.web.DISPATCHER_REQUEST_PATH";
    private static FilterFactory factory = null;

    private FilterFactory() {
    }

    public static FilterFactory getInstance() {
        if (factory == null) {
            factory = new FilterFactory();
        }
        return factory;
    }

    public FilterChainImpl createFilterChain(ServletRequest request, ExecutionWrapper wrapper) {
        FilterConfigImpl filterConfig;
        int i;
        int dispatcher = -1;
        Integer dispatcherInt = (Integer)request.getAttribute(DISPATCHER_TYPE_ATTR);
        if (dispatcherInt != null) {
            dispatcher = dispatcherInt;
        }
        String requestPath = null;
        Object attribute = request.getAttribute(DISPATCHER_REQUEST_PATH_ATTR);
        if (attribute != null) {
            requestPath = attribute.toString();
        }
        FilterChainImpl filterChain = null;
        ServletManager servletManager = wrapper.getServletManager();
        if (servletManager == null) {
            return null;
        }
        FilterMap[] filterMaps = servletManager.findFilterMaps();
        if (filterMaps == null || filterMaps.length == 0) {
            return null;
        }
        String servletName = wrapper.getName();
        for (i = 0; i < filterMaps.length; ++i) {
            if (!this.matchDispatcher(filterMaps[i], dispatcher) || !this.matchFiltersURL(filterMaps[i], requestPath) || (filterConfig = (FilterConfigImpl)servletManager.findFilterConfig(filterMaps[i].getFilterName())) == null) continue;
            if (filterChain == null) {
                filterChain = this.internalCreateFilterChain(request, wrapper);
            }
            filterChain.addFilter(filterConfig);
        }
        for (i = 0; i < filterMaps.length; ++i) {
            if (!this.matchDispatcher(filterMaps[i], dispatcher) || !this.matchFiltersServlet(filterMaps[i], servletName) || (filterConfig = (FilterConfigImpl)servletManager.findFilterConfig(filterMaps[i].getFilterName())) == null) continue;
            if (filterChain == null) {
                filterChain = this.internalCreateFilterChain(request, wrapper);
            }
            filterChain.addFilter(filterConfig);
        }
        return filterChain;
    }

    private boolean matchFiltersURL(FilterMap filterMap, String requestPath) {
        if (requestPath == null) {
            return false;
        }
        String testPath = filterMap.getURLPattern();
        if (testPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            if (testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
                if (requestPath.length() == testPath.length() - 2) {
                    return true;
                }
                if ('/' == requestPath.charAt(testPath.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                return testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return requestPath.endsWith("/j_security_check");
    }

    private boolean matchFiltersServlet(FilterMap filterMap, String servletName) {
        if (servletName == null) {
            return false;
        }
        return servletName.equals(filterMap.getServletName()) || "*".equals(filterMap.getServletName());
    }

    private boolean matchDispatcher(FilterMap filterMap, int dispatcher) {
        switch (dispatcher) {
            case 2: {
                if (filterMap.getDispatcherMapping() != 2 && filterMap.getDispatcherMapping() != 3 && filterMap.getDispatcherMapping() != 7 && filterMap.getDispatcherMapping() != 6 && filterMap.getDispatcherMapping() != 13 && filterMap.getDispatcherMapping() != 10 && filterMap.getDispatcherMapping() != 11 && filterMap.getDispatcherMapping() != 15) break;
                return true;
            }
            case 4: {
                if (filterMap.getDispatcherMapping() != 4 && filterMap.getDispatcherMapping() != 5 && filterMap.getDispatcherMapping() != 7 && filterMap.getDispatcherMapping() != 6 && filterMap.getDispatcherMapping() != 14 && filterMap.getDispatcherMapping() != 12 && filterMap.getDispatcherMapping() != 11 && filterMap.getDispatcherMapping() != 15) break;
                return true;
            }
            case 1: {
                if (filterMap.getDispatcherMapping() != 1 && filterMap.getDispatcherMapping() != 3 && filterMap.getDispatcherMapping() != 5 && filterMap.getDispatcherMapping() != 6 && filterMap.getDispatcherMapping() != 9 && filterMap.getDispatcherMapping() != 10 && filterMap.getDispatcherMapping() != 11 && filterMap.getDispatcherMapping() != 12) break;
                return true;
            }
            default: {
                if (filterMap.getDispatcherMapping() != 8 && filterMap.getDispatcherMapping() != 9 && filterMap.getDispatcherMapping() != 14 && filterMap.getDispatcherMapping() != 12 && filterMap.getDispatcherMapping() != 13 && filterMap.getDispatcherMapping() != 10 && filterMap.getDispatcherMapping() != 15 && filterMap.getDispatcherMapping() != 11) break;
                return true;
            }
        }
        return false;
    }

    private FilterChainImpl internalCreateFilterChain(ServletRequest request, ExecutionWrapper wrapper) {
        FilterChainImpl filterChain = null;
        if (System.getSecurityManager() == null && request instanceof HttpServletRequestImpl) {
            HttpServletRequestImpl req = (HttpServletRequestImpl)request;
            filterChain = (FilterChainImpl)req.getFilterChain();
            if (filterChain == null) {
                filterChain = new FilterChainImpl();
                req.setFilterChain(filterChain);
            }
        } else {
            filterChain = new FilterChainImpl();
        }
        filterChain.setExecutionWrapper(wrapper);
        return filterChain;
    }
}

