/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import jeus.servlet.jsp.JspWriterImpl;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;

public class BodyContentImpl
extends BodyContent {
    private char[] cb;
    protected int bufferSize = 8192;
    private int nextChar;
    static String lineSeparator = System.getProperty("line.separator");
    private JspWriter jspWriter;
    private Writer writer;

    public BodyContentImpl(JspWriter writer) {
        super(writer);
        this.jspWriter = writer;
        this.cb = new char[this.bufferSize];
        this.nextChar = 0;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.nextChar >= this.bufferSize) {
                this.reAllocBuff(0);
            }
            this.cb[this.nextChar++] = (char)c;
        }
    }

    private void reAllocBuff(int len) {
        char[] tmp = new char[this.bufferSize];
        System.arraycopy(this.cb, 0, tmp, 0, this.cb.length);
        if (len <= 8192) {
            this.cb = new char[this.bufferSize + 8192];
            this.bufferSize += 8192;
        } else {
            this.cb = new char[this.bufferSize + len];
            this.bufferSize += len;
        }
        System.arraycopy(tmp, 0, this.cb, 0, tmp.length);
        tmp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(len);
            }
            System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
            this.nextChar += len;
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) throws IOException {
        if (this.writer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (len >= this.bufferSize - this.nextChar) {
                    this.reAllocBuff(len);
                }
                s.getChars(off, off + len, this.cb, this.nextChar);
                this.nextChar += len;
            }
        } else {
            this.writer.write(s, off, len);
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.write(lineSeparator);
        }
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            WebProperties props = PropertyUtil.getContextProperties();
            s = props.JSP_JSPWRITER_DEFAULT_NULL_STRING.value;
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        if (obj == null) {
            WebProperties props = PropertyUtil.getContextProperties();
            this.write(props.JSP_JSPWRITER_DEFAULT_NULL_STRING.value);
        } else {
            this.write(String.valueOf(obj));
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.cb = new char[8192];
            this.bufferSize = 8192;
            this.nextChar = 0;
        }
    }

    public void clearBuffer() throws IOException {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.cb = null;
        }
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    public Reader getReader() {
        return new CharArrayReader(this.cb, 0, this.nextChar);
    }

    public String getString() {
        return new String(this.cb, 0, this.nextChar);
    }

    public void writeOut(Writer out) throws IOException {
        out.write(this.cb, 0, this.nextChar);
    }

    public static void main(String[] args) throws Exception {
        char[] buff = new char[]{'f', 'o', 'o', 'b', 'a', 'r', 'b', 'a', 'z', 'y'};
        BodyContentImpl bodyContent = new BodyContentImpl(new JspWriterImpl(null, 100, false));
        bodyContent.println(buff);
        System.out.println(bodyContent.getString());
        bodyContent.writeOut(new PrintWriter(System.out));
    }
}

