/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import jeus.servlet.engine.Context;
import jeus.servlet.jsp.JspPropertyMapper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.util.properties.JeusAppProperties;
import jeus.xml.binding.BindingHelper;
import jeus.xml.binding.j2ee.JspConfigType;
import jeus.xml.binding.j2ee.TaglibType;
import jeus.xml.binding.j2ee.WebAppType;

public final class JspConfig {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    public boolean checkIncludedJspFile = false;
    public boolean keepGenerated = true;
    public String compileEncoding = null;
    public String forcedPageEncoding = null;
    public String defaultPageEncoding = null;
    public String javaCompiler = null;
    public String compileOutputDir = null;
    public URL[] compileOutputURLs = null;
    public String classpath = null;
    public String compileOption = null;
    public File jspWorkDir;
    public ServletConfig config;
    private ServletContext context;
    public String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private JspPropertyMapper jspPropertyMapper;
    private HashMap taglibs;
    private HashMap tagLocationToUri;

    public JspConfig() {
    }

    public JspConfig(ServletConfig config, ServletContext context) {
        String classpath;
        String ieClassId;
        this.config = config;
        this.context = context;
        String sep = System.getProperty("file.separator");
        String keepgen = config.getInitParameter("KeepGenerated");
        if (keepgen != null) {
            this.keepGenerated = keepgen.equalsIgnoreCase("true");
        }
        this.checkIncludedJspFile = Boolean.valueOf(config.getInitParameter("CheckIncludedJspFile"));
        this.compileEncoding = config.getInitParameter("CompileEncoding");
        this.forcedPageEncoding = config.getInitParameter("ForcedPageEncoding");
        this.defaultPageEncoding = config.getInitParameter("DefaultPageEncoding");
        this.javaCompiler = config.getInitParameter("JavaCompiler");
        String outDir = config.getInitParameter("CompileOutputDir");
        try {
            File outDirF = new File(outDir);
            this.compileOutputDir = outDirF.getCanonicalPath();
            this.compileOutputURLs = new URL[]{outDirF.toURL()};
        }
        catch (Exception e) {
            // empty catch block
        }
        this.compileOption = config.getInitParameter("CompileOption");
        if (this.compileOption == null) {
            this.compileOption = JeusAppProperties.APP_COMPILER_OPTION;
        }
        String dir = config.getInitParameter("JspWorkDir");
        this.jspWorkDir = new File(dir);
        try {
            if (!this.jspWorkDir.exists()) {
                this.jspWorkDir.mkdirs();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!(this.jspWorkDir.exists() && this.jspWorkDir.canRead() && this.jspWorkDir.canWrite() && this.jspWorkDir.isDirectory())) {
            String dir2 = System.getProperty("java.io.tmpdir");
            this.jspWorkDir = new File(dir2);
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5620_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5620_LEVEL, JeusMessage_WebContainer5_4._5620, new Object[]{((Context)context).getContextName(), dir, dir2});
            }
            dir = dir2;
        }
        File outputDir = new File(this.compileOutputDir);
        try {
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!(outputDir.exists() && outputDir.isAbsolute() && outputDir.isDirectory() && outputDir.canWrite())) {
            this.compileOutputDir = dir;
        }
        if (this.compileOutputDir.endsWith(sep)) {
            this.compileOutputDir = this.compileOutputDir.substring(0, this.compileOutputDir.length() - 1);
        }
        if ((ieClassId = config.getInitParameter("ieClassId")) != null) {
            this.ieClassId = ieClassId;
        }
        this.classpath = (classpath = config.getInitParameter("classpath")) != null ? classpath : context.getRealPath("/") + "WEB-INF" + sep + "classes";
        WebAppType webApp = ((Context)context).getWebAppDesc().getWebApp();
        this.jspPropertyMapper = new JspPropertyMapper(webApp);
        this.initTaglib(webApp);
    }

    public void clean() {
        if (this.jspPropertyMapper != null) {
            this.jspPropertyMapper.clean();
            this.jspPropertyMapper = null;
        }
        if (this.compileOutputURLs != null) {
            this.compileOutputURLs = null;
        }
        if (this.context != null) {
            this.context = null;
        }
        if (this.config != null) {
            this.config = null;
        }
        if (this.tagLocationToUri != null) {
            this.tagLocationToUri.clear();
            this.tagLocationToUri = null;
        }
        if (this.taglibs != null) {
            this.taglibs.clear();
            this.taglibs = null;
        }
    }

    private void initTaglib(WebAppType _webApp) {
        if (_webApp == null) {
            return;
        }
        List list = _webApp.getDescriptionAndDisplayNameAndIcon();
        Object _obj = BindingHelper.getSubFirstElement(list, JspConfigType.class);
        if (_obj == null) {
            return;
        }
        JspConfigType _jspConfig = (JspConfigType)_obj;
        List _groups = _jspConfig.getTaglib();
        if (_groups == null) {
            return;
        }
        HashMap<String, String> _taglibs = this.taglibs = new HashMap<String, String>();
        this.tagLocationToUri = new HashMap();
        for (int i = 0; i < _groups.size(); ++i) {
            TaglibType taglibType = (TaglibType)_groups.get(i);
            String _uri = taglibType.getTaglibUri().getValue();
            String _location = taglibType.getTaglibLocation().getValue();
            _taglibs.put(_uri, _location);
            this.tagLocationToUri.put(_location, _uri);
        }
    }

    public String getLocation(String _uri) {
        if (this.taglibs == null) {
            return null;
        }
        return (String)this.taglibs.get(_uri);
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public boolean checkIncludedJspFile() {
        return this.checkIncludedJspFile;
    }

    public boolean keepGenerated() {
        return this.keepGenerated;
    }

    public String getCompileEncoding() {
        return this.compileEncoding;
    }

    public String getJavaCompiler() {
        return this.javaCompiler;
    }

    public String getCompileOutputDir() {
        return this.compileOutputDir;
    }

    public URL[] getCompileOutputURLs() {
        return this.compileOutputURLs;
    }

    public String getCompileOption() {
        return this.compileOption;
    }

    public String getForcedPageEncoding() {
        return this.forcedPageEncoding;
    }

    public String getDefaultPageEncoding() {
        return this.defaultPageEncoding;
    }

    public String ieClassId() {
        return this.ieClassId;
    }

    public File getJspWorkDir() {
        return this.jspWorkDir;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public JspPropertyMapper getJspPropertyMapper() {
        return this.jspPropertyMapper;
    }

    public HashMap getTaglibs() {
        return this.taglibs;
    }

    public HashMap getTagLocationToUri() {
        return this.tagLocationToUri;
    }
}

