/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.jsp.DummyOutputStream;
import jeus.servlet.jsp.JspConfig;
import jeus.servlet.jsp.JspEngineContext;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.JspProperty;
import jeus.servlet.jsp.TLDManager;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JavaCompiler;
import jeus.servlet.jsp.compiler.JavacJavaCompiler;
import jeus.servlet.jsp.compiler.JspCodeGenerator;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.SunJavaCompiler;
import jeus.servlet.jsp.compiler.SunJavaCompiler2;
import jeus.servlet.jsp.compiler.TagFileClassHandler;
import jeus.servlet.jsp.compiler.TagFileCodeGenerator;
import jeus.servlet.jsp.compiler.TagFileInfoImpl;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.JspCompilationContext;
import jeus.servlet.loader.JspReloader;
import jeus.servlet.property.ContextProperties;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class JspEngine {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    private Context context;
    private JspConfig jspConfig;
    private String defaultJavaCompiler;
    private String contextClassPath;
    private TLDManager tldManager;
    private boolean earDeploy;
    private static String ps = System.getProperty("path.separator");
    private static String fs = System.getProperty("file.separator");
    private static final String JAVAC_CLASS1 = "sun.tools.javac.Main";
    private static final String JAVAC_CLASS2 = "com.sun.tools.javac.Main";
    private static final String JAVAC = "javac";

    public JspEngine(Context context, JspConfig jspConfig) {
        try {
            this.earDeploy = context.isEarDeploy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.context = context;
        this.jspConfig = jspConfig;
        this.contextClassPath = jspConfig.getClassPath();
    }

    public void init() {
        this.tldManager = new TLDManager(this);
        ContextProperties props = this.context.getContextProperties();
        if (!props.JASPER.value) {
            this.initJavaCompiler(WebContainerManager.STANDALONE_MODE);
        }
    }

    public void clean() {
        if (this.tldManager != null) {
            this.tldManager.clean();
            this.tldManager = null;
        }
        this.jspConfig = null;
        this.context = null;
    }

    private void initJavaCompiler(boolean standaloneMode) {
        String userDefault = this.jspConfig.getJavaCompiler();
        Class<?> sunJavac = null;
        this.defaultJavaCompiler = null;
        if (userDefault != null) {
            if (userDefault.startsWith(JAVAC)) {
                this.defaultJavaCompiler = JAVAC;
            } else if (userDefault.startsWith("sun.tools.javac")) {
                try {
                    sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS1) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS1);
                    this.defaultJavaCompiler = JAVAC_CLASS1;
                }
                catch (ClassNotFoundException fnfe) {
                    this.defaultJavaCompiler = null;
                }
            } else if (userDefault.startsWith("com.sun.tools.javac")) {
                try {
                    sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS2) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS2);
                    this.defaultJavaCompiler = JAVAC_CLASS2;
                    if (SunJavaCompiler2.method141 == null && SunJavaCompiler2.method13 == null) {
                        this.defaultJavaCompiler = null;
                    }
                }
                catch (ClassNotFoundException fnfe) {
                    this.defaultJavaCompiler = null;
                }
            }
        }
        if (this.defaultJavaCompiler == null) {
            try {
                sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS2) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS2);
                this.defaultJavaCompiler = JAVAC_CLASS2;
            }
            catch (ClassNotFoundException fnfe) {
                try {
                    sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS1) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS1);
                    this.defaultJavaCompiler = JAVAC_CLASS1;
                }
                catch (ClassNotFoundException fnfe2) {
                    this.defaultJavaCompiler = JAVAC;
                }
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer5_4._5499_LEVEL)) {
            logger.log(JeusMessage_WebContainer5_4._5499_LEVEL, JeusMessage_WebContainer5_4._5499, (Object)this.defaultJavaCompiler);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public TLDManager getTLDManager() {
        return this.tldManager;
    }

    public String parseAndCompileClassic(JspReloader reloader) throws JspEngineException, FileNotFoundException, IOException {
        JspEngineContext ctxt = new JspEngineContext(this.contextClassPath, this.context, this.tldManager, reloader, this.jspConfig);
        String fname = reloader.getJavaFileName();
        new File(fname).getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(fname);
        JspProperty jspProperty = reloader.getJspProperty();
        String pageEncoding = jspProperty == null ? null : jspProperty.getPageEncoding();
        CodeGenerator codeGen = this.parseJsp(ctxt, fos, pageEncoding);
        this.compile(ctxt, codeGen.getCompileEncoding());
        return ctxt.getFullClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseAndCompile(JspReloader reloader) throws JspEngineException, FileNotFoundException, IOException, Jsp2EngineException {
        WebProperties props = PropertyUtil.getContextProperties();
        if (!props.JASPER.value) {
            JspEngineContext ctxt = new JspEngineContext(this.contextClassPath, this.context, this.tldManager, reloader, this.jspConfig);
            String fname = reloader.getJavaFileName();
            new File(fname).getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(fname);
            JspProperty jspProperty = reloader.getJspProperty();
            String pageEncoding = jspProperty == null ? null : jspProperty.getPageEncoding();
            CodeGenerator codeGen = this.parseJsp(ctxt, fos, pageEncoding);
            this.compile(ctxt, codeGen.getCompileEncoding());
            return ctxt.getFullClassName();
        }
        JspEngineContext ctxt = new JspEngineContext(this.contextClassPath, this.context, this.tldManager, reloader, this.jspConfig);
        String fname = reloader.getJavaFileName();
        new File(fname).getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(fname);
        JspProperty jspProperty = reloader.getJspProperty();
        String pageEncoding = jspProperty == null ? null : jspProperty.getPageEncoding();
        boolean firstTime = true;
        JspCompilationContext compileCtxt = reloader.getJspServlerWrapper().getJspEngineContext();
        compileCtxt.setServletClassName(reloader.getClassOnlyName());
        compileCtxt.setServletJavaFileName(fname);
        compileCtxt.setServletPackageName(reloader.getPackageName());
        compileCtxt.disableDerivedPackageName();
        JspEngine jspEngine = this;
        synchronized (jspEngine) {
            if (firstTime) {
                firstTime = false;
            }
            compileCtxt.setJspConfig(this.jspConfig);
            compileCtxt.compile();
        }
        return ctxt.getFullClassName();
    }

    private void compile(JspEngineContext ctxt, String encoding) throws JspCompileException {
        JspReloader reloader = ctxt.getReloader();
        String javaFileName = reloader.getJavaFileName();
        String classpath = this.getCompileClassPath(ctxt.getClassPath());
        String compileOutputDir = ctxt.getCompileOutputDir();
        String compileOption = ctxt.getCompileOption();
        int index = -1;
        if (compileOption != null && (index = compileOption.indexOf("-classpath ")) > -1) {
            String temp = compileOption.substring(index + "-classpath ".length()).trim();
            if ((index = temp.indexOf(32)) > 0) {
                temp = temp.substring(0, index);
            }
            classpath = temp + ps + classpath;
        }
        JavaCompiler compiler = this.getCompiler(classpath, encoding, compileOutputDir, compileOption, javaFileName);
        try {
            compiler.compile();
        }
        catch (Throwable t) {
            reloader.renameCorruptedClassFile();
            if (t instanceof JspCompileException) {
                throw (JspCompileException)((Object)t);
            }
            throw new JspCompileException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object)javaFileName), t);
        }
        if (!ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
    }

    private String getCompileClassPath(String classpath) {
        String systemClassPath = null;
        try {
            systemClassPath = JeusRootClassLoader.getRootClassPaths(this.context.getContextLoader().getParentClassLoader());
        }
        catch (Exception e) {
            systemClassPath = JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "javaee.jar";
            systemClassPath = systemClassPath + File.pathSeparator + JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "jeus.jar";
        }
        return systemClassPath + ps + classpath;
    }

    private JavaCompiler getCompiler(String classpath, String encoding, String outdir, String opt, String src) {
        JavaCompiler compiler = null;
        compiler = this.defaultJavaCompiler.equals(JAVAC) ? (fs.startsWith("/") ? new JavacJavaCompiler(classpath, encoding, outdir, opt, src) : new JavacJavaCompiler("\"" + classpath + "\"", encoding, outdir, opt, src)) : (this.defaultJavaCompiler.equals(JAVAC_CLASS1) ? new SunJavaCompiler(classpath, encoding, outdir, opt, src) : (this.defaultJavaCompiler.equals(JAVAC_CLASS2) ? new SunJavaCompiler2(classpath, encoding, outdir, opt, src) : (fs.startsWith("/") ? new JavacJavaCompiler(classpath, encoding, outdir, opt, src) : new JavacJavaCompiler("\"" + classpath + "\"", encoding, outdir, opt, src))));
        return compiler;
    }

    private CodeGenerator parseJsp(JspEngineContext ctxt, OutputStream os, String pageEncoding) throws JspEngineException, FileNotFoundException, IOException {
        JspReader reader = new JspReader(ctxt.getServletContext(), this, pageEncoding);
        ctxt.setReader(reader);
        JspCodeGenerator codeGen = new JspCodeGenerator(this, ctxt, pageEncoding);
        JspParser parser = new JspParser(reader, codeGen, false);
        if (this.context.isWebApp_2_3()) {
            parser.setWebApp_2_3(true);
            codeGen.isELIgnored = "true";
        } else {
            JspProperty jspProperty = parser.getJspProperty();
            if (jspProperty != null && jspProperty.isElIgnored()) {
                codeGen.isELIgnored = "true";
            }
        }
        reader.startsWith(parser, ctxt.getJspFile(), pageEncoding);
        ServletWriter writer = new ServletWriter(new PrintWriter(new OutputStreamWriter(os, codeGen.getJavaEncoding())));
        ctxt.setWriter(writer);
        codeGen.setWriter(writer);
        ((CodeGenerator)codeGen).beginPageProcessing();
        parser.parse();
        ((CodeGenerator)codeGen).endPageProcessing();
        writer.close();
        return codeGen;
    }

    private String[] resolveEncoding(JspEngineContext ctxt, String _pageEncoding, CodeGenerator codeGen) throws JspEngineException, FileNotFoundException, IOException {
        String compileEncoding = ctxt.getCompileEncoding();
        if (compileEncoding == null || compileEncoding.equals("")) {
            compileEncoding = "UsePageEncoding";
        }
        String pageEncoding = null;
        String responseEncoding = null;
        String forcedPageEncoding = ctxt.getForcedPageEncoding();
        String defaultPageEncoding = ctxt.getDefaultPageEncoding();
        if (forcedPageEncoding != null) {
            pageEncoding = forcedPageEncoding;
            responseEncoding = forcedPageEncoding;
        } else {
            String[] result = new String[2];
            pageEncoding = result[0];
            responseEncoding = result[1];
            if (pageEncoding != null && _pageEncoding != null && !pageEncoding.equalsIgnoreCase(_pageEncoding)) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5351, (Object[])new Object[]{_pageEncoding, pageEncoding}));
            }
        }
        if (responseEncoding == null) {
            responseEncoding = "ISO-8859-1";
        }
        String javaEncoding = null;
        if (compileEncoding.equalsIgnoreCase("UTF8") || compileEncoding.equalsIgnoreCase("UTF-8")) {
            compileEncoding = "UTF-8";
            javaEncoding = "UTF-8";
            if (pageEncoding == null) {
                pageEncoding = defaultPageEncoding;
            }
        } else if (compileEncoding.equalsIgnoreCase("UsePageEncoding")) {
            if (pageEncoding == null) {
                javaEncoding = defaultPageEncoding;
                pageEncoding = defaultPageEncoding;
                compileEncoding = defaultPageEncoding;
            } else {
                compileEncoding = responseEncoding;
                javaEncoding = responseEncoding;
            }
        } else if (pageEncoding == null) {
            javaEncoding = compileEncoding;
            pageEncoding = defaultPageEncoding;
        } else {
            javaEncoding = compileEncoding;
        }
        String[] result = new String[]{pageEncoding, javaEncoding, compileEncoding};
        if (logger.isLoggable(JeusMessage_WebContainer5._5320_LEVEL)) {
            logger.log(JeusMessage_WebContainer5._5320_LEVEL, JeusMessage_WebContainer5._5320, (Object[])new String[]{ctxt.getJspFile(), pageEncoding, javaEncoding, compileEncoding});
        }
        return result;
    }

    public void parseTagFile(TagFileClassHandler handler, String _pageEncoding, String _contentType) throws JspEngineException {
        try {
            if (_pageEncoding == null) {
                _pageEncoding = this.getTagFilePageEncoding(this.context, handler, _contentType);
            }
            String fname = handler.getHandlerJavaFileName();
            new File(fname).getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(fname);
            JspReader reader = new JspReader(this.context, this, _pageEncoding);
            ServletWriter writer = new ServletWriter(new PrintWriter(new OutputStreamWriter((OutputStream)fos, _pageEncoding)));
            TagFileCodeGenerator codeGen = new TagFileCodeGenerator(this, reader, writer, handler);
            codeGen.setContentType(_contentType);
            JspParser parser = new JspParser(reader, codeGen, false, true);
            TagFileInfoImpl tfi = handler.getTagFileInfo();
            reader.startsWith(parser, tfi);
            codeGen.beginPageProcessing();
            parser.parseTagFile();
            codeGen.endPageProcessing();
            writer.close();
        }
        catch (IOException ioe) {
            throw new JspEngineException(ioe.getMessage(), ioe);
        }
    }

    private String getTagFilePageEncoding(Context ctxt, TagFileClassHandler handler, String _contentType) throws JspEngineException, IOException {
        TagFileInfoImpl tfi = handler.getTagFileInfo();
        String path = tfi.getPath();
        boolean tagx = path != null && path.endsWith(".tagx");
        InputStream in = tfi.getInputStream();
        String initialEncoding = null;
        try {
            String name = JspUtil.trimTrailingSpace(path);
            File file = new File(RequestUtil.removeDotDot(name));
            FileReader fr = new FileReader(ctxt.getDocBase() + file);
            BufferedReader br = new BufferedReader(fr);
            char[] seq = new char[4];
            br.read(seq, 0, 4);
            initialEncoding = seq[0] == '<' && seq[1] == '?' && seq[2] == 'x' && seq[3] == 'm' ? "8859_1" : (seq[0] == 'L' && seq[1] == 'o' && seq[2] == '\u00a7' && seq[3] == '\u0094' ? "EBCDIC" : (seq[0] == '\u0000' && seq[1] == '\u0000' && seq[2] == '\u0000' && seq[3] == '<' ? "UCS-4" : (seq[0] == '<' && seq[1] == '\u0000' && seq[2] == '\u0000' && seq[3] == '\u0000' ? "UCS-4" : (seq[0] == '\u0000' && seq[1] == '\u0000' && seq[2] == '<' && seq[3] == '\u0000' ? "UCS-4" : (seq[0] == '\u0000' && seq[1] == '<' && seq[2] == '\u0000' && seq[3] == '\u0000' ? "UCS-4" : (seq[0] == '\u00fe' && seq[1] == '\u00ff' ? "UTF-16" : (seq[0] == '\u00ff' && seq[1] == '\u00fe' ? "UTF-16" : (seq[0] == '\u0000' && seq[1] == '<' && seq[2] == '\u0000' && seq[3] == '?' ? "UTF-16" : (seq[0] == '<' && seq[1] == '\u0000' && seq[2] == '?' && seq[3] == '\u0000' ? "UTF-16" : "8859_1")))))))));
        }
        catch (Exception e) {
            e.printStackTrace();
            initialEncoding = "8859_1";
        }
        String _pageEncoding = initialEncoding;
        JspReader reader = new JspReader(this.context, this, _pageEncoding, true);
        DummyOutputStream os = new DummyOutputStream();
        ServletWriter writer = new ServletWriter(new PrintWriter(new OutputStreamWriter(os)));
        TagFileCodeGenerator codeGen = new TagFileCodeGenerator(this, reader, writer, handler);
        codeGen.setContentType(_contentType);
        JspParser parser = new JspParser(reader, codeGen, false, true);
        try {
            reader.startsWith(parser, tfi);
            codeGen.beginPageProcessing();
            parser.parseTagFile();
            codeGen.endPageProcessing();
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new JspEngineException(ioe.getMessage(), ioe);
        }
        String jspContentType = codeGen.getContentType();
        String jspPageEncoding = codeGen.getPageEncoding();
        String result = null;
        if (!tagx) {
            result = jspPageEncoding;
            if (result == null) {
                result = "8859_1";
            }
        } else {
            result = codeGen.pageEncodingInXml;
            if (result == null) {
                result = _pageEncoding;
            }
            if (jspPageEncoding != null && codeGen.pageEncodingInXml != null && !jspPageEncoding.equals(codeGen.pageEncodingInXml)) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object[])new Object[]{jspPageEncoding, codeGen.pageEncodingInXml}));
            }
        }
        return result;
    }

    public void parseAndCompileTagFile(TagFileClassHandler handler, String _contentType) throws JspEngineException {
        String _pageEncoding = null;
        try {
            _pageEncoding = this.getTagFilePageEncoding(this.context, handler, _contentType);
        }
        catch (IOException ioe) {
            throw new JspEngineException(ioe.getMessage(), ioe);
        }
        this.parseTagFile(handler, _pageEncoding, _contentType);
        String fname = handler.getHandlerJavaFileName();
        Object _jspProperty = null;
        String classpath = this.getCompileClassPath(this.context.getContextLoader().getClassPath());
        String compileOutputDir = this.tldManager.getTagCompileOutDir();
        String compileOption = this.jspConfig.getCompileOption();
        JavaCompiler compiler = this.getCompiler(classpath, _pageEncoding, compileOutputDir, compileOption, fname);
        try {
            compiler.compile();
        }
        catch (Throwable t) {
            if (t instanceof JspCompileException) {
                throw (JspCompileException)((Object)t);
            }
            throw new JspCompileException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object)fname), t);
        }
    }
}

