/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import javax.servlet.ServletContext;
import jeus.servlet.jsp.JspConfig;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.TLDInfo;
import jeus.servlet.jsp.TLDManager;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.loader.JspReloader;

public class JspEngineContext {
    private JspReloader reloader;
    private JspReader reader;
    private ServletWriter writer;
    private ServletContext context;
    private String classpath;
    private boolean isErrPage;
    private String contentType;
    private JspConfig jspConfig;
    private TLDManager tldManager;

    public JspEngineContext(String classpath, ServletContext context, TLDManager tldManager, JspReloader reloader, JspConfig jspConfig) {
        this.classpath = classpath;
        this.context = context;
        this.tldManager = tldManager;
        this.reloader = reloader;
        this.jspConfig = jspConfig;
        this.isErrPage = false;
    }

    public TLDInfo getTLDInfo(String uri) throws JspEngineException {
        return this.tldManager.getTLDInfo(uri, this.reloader.getJspURI());
    }

    public String getClassPath() {
        return this.reloader.getParent().getClassPath();
    }

    public JspReader getReader() {
        return this.reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public String getOutputDir() {
        return this.jspConfig.getJspWorkDir().toString();
    }

    public String getCompileOutputDir() {
        return this.jspConfig.getCompileOutputDir();
    }

    public String getCompileOption() {
        return this.jspConfig.getCompileOption();
    }

    public JspReloader getReloader() {
        return this.reloader;
    }

    public String getJspFile() {
        return this.reloader.getJspURI();
    }

    public String getServletClassName() {
        return this.reloader.getClassOnlyName();
    }

    public String getServletPackageName() {
        return this.reloader.getPackageName();
    }

    public final String getFullClassName() {
        return this.reloader.getClassName();
    }

    public boolean keepGenerated() {
        return this.jspConfig.keepGenerated();
    }

    public String getCompileEncoding() {
        return this.jspConfig.getCompileEncoding();
    }

    public String getJavaCompiler() {
        return this.jspConfig.getJavaCompiler();
    }

    public String getDefaultPageEncoding() {
        return this.jspConfig.getDefaultPageEncoding();
    }

    public String getForcedPageEncoding() {
        return this.jspConfig.getForcedPageEncoding();
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }
}

