/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import jeus.servlet.engine.Context;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.TLDInfo;
import jeus.servlet.jsp.compiler.TagFileInfoImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public final class TLDManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    public static final String TLD = "META-INF/taglib.tld";
    private JspEngine engine;
    private Context context;
    private Hashtable tldInfos = new Hashtable();
    private Hashtable taglibMappingFromJarFile = new Hashtable();
    private Hashtable remoteTLDCache = new Hashtable();
    private int uniqueNumber;
    private File tempDir;
    private Object uniqueNumberSync = new Object();
    private String tagCompileOutDir;
    private HashMap tagDirs = new HashMap();
    private HashMap tagUriLocation = new HashMap();
    private boolean webDotXmlInitialized = false;

    TLDManager(JspEngine engine) {
        this.engine = engine;
        this.context = engine.getContext();
        this.uniqueNumber = 0;
        this.initClassPath();
        this.initTempDir();
        this.initTaglibMappingFromJarFile();
        this.initTagFiles();
        this.initTldUrls();
    }

    public void clean() {
        this.clearTLDInfoTable(this.tldInfos);
        this.clearTLDInfoTable(this.taglibMappingFromJarFile);
        this.clearTLDInfoTable(this.remoteTLDCache);
        if (this.tagDirs != null) {
            HashMap tagDirsTemp = (HashMap)this.tagDirs.clone();
            Iterator iter = tagDirsTemp.keySet().iterator();
            while (iter.hasNext()) {
                TLDInfo tldTemp = (TLDInfo)this.tagDirs.remove((String)iter.next());
                if (tldTemp == null) continue;
                tldTemp.clean();
            }
            this.tagDirs = null;
            tagDirsTemp.clear();
        }
        if (this.tagUriLocation != null) {
            this.tagUriLocation.clear();
            this.tagUriLocation = null;
        }
        this.context = null;
        this.engine = null;
    }

    private void clearTLDInfoTable(Hashtable table) {
        if (table == null) {
            return;
        }
        Hashtable tableTemp = (Hashtable)table.clone();
        Iterator iter = tableTemp.keySet().iterator();
        while (iter.hasNext()) {
            TLDInfo tldTemp = (TLDInfo)table.remove((String)iter.next());
            if (tldTemp == null) continue;
            tldTemp.clean();
        }
        table = null;
        tableTemp.clear();
    }

    private void initClassPath() {
        String compileoutdir = this.engine.getJspConfig().getCompileOutputDir();
        if (compileoutdir.endsWith("/") || compileoutdir.endsWith("\\")) {
            compileoutdir = compileoutdir.substring(0, compileoutdir.length() - 1);
        }
        this.tagCompileOutDir = compileoutdir + File.separator + "jeus_tagwork" + File.separator;
        File tmp = new File(this.tagCompileOutDir);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        try {
            String path = this.tagCompileOutDir;
            if (!path.startsWith(File.separator)) {
                path = "/" + path;
            }
            URL libURL = new URL("file://" + path);
            this.context.getContextLoader().addClassPath(libURL);
        }
        catch (MalformedURLException mue) {
            if (logger.isLoggable(JeusMessage_WebContainer5._5358_LEVEL)) {
                logger.log(JeusMessage_WebContainer5._5358_LEVEL, JeusMessage_WebContainer5._5358, (Object)this.tagCompileOutDir, (Throwable)mue);
            }
            return;
        }
    }

    private void initTldUrls() {
        Set dirlist = this.context.getResourcePathsAll("/WEB-INF");
        if (dirlist == null) {
            return;
        }
        for (String fname : dirlist) {
            if (!fname.endsWith(".tld")) continue;
            InputStream in = this.context.getResourceAsStream(fname);
            try {
                int howMuchRead;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] tmpBuf = new byte[1024];
                while ((howMuchRead = in.read(tmpBuf, 0, 1024)) > 0) {
                    baos.write(tmpBuf, 0, howMuchRead);
                }
                baos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                try {
                    TLDInfo tli = new TLDInfo(this.context, bais, null, true, fname);
                    String _uri = tli.getURI();
                    if (_uri != null) {
                        this.tagUriLocation.put(_uri, fname);
                    } else {
                        HashMap tagLocationToUri = this.engine.getJspConfig().getTagLocationToUri();
                        if (tagLocationToUri != null && (_uri = (String)tagLocationToUri.get(fname)) != null) {
                            this.tagUriLocation.put(_uri, fname);
                        }
                    }
                    if (_uri == null) continue;
                    this.tldInfos.put(_uri, tli);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void initWebDotXml() throws JspEngineException {
        Hashtable taglibMap = this.context.getTaglibConfigs();
        if (taglibMap == null) {
            return;
        }
        Enumeration keys = taglibMap.keys();
        while (keys.hasMoreElements()) {
            String uri = (String)keys.nextElement();
            String location = (String)taglibMap.get(uri);
            TLDInfo info = this.getTLDInfoWithURI(location, "/WEB-INF/");
            this.tldInfos.put(uri, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUniqueNumber() {
        Object object = this.uniqueNumberSync;
        synchronized (object) {
            int r = ++this.uniqueNumber;
            if (this.uniqueNumber == Integer.MAX_VALUE) {
                this.uniqueNumber = 0;
            }
            return r;
        }
    }

    private void initTempDir() {
        this.tempDir = new File(this.context.getAttribute("javax.servlet.context.tempdir") + File.separator + "_taglib_");
        this.tempDir.mkdirs();
        File[] garbages = this.tempDir.listFiles();
        if (garbages != null && garbages.length > 0) {
            for (int i = 0; i < garbages.length; ++i) {
                garbages[i].delete();
            }
        }
    }

    private void initTagFiles() {
        Set dirlist = this.context.getResourcePathsAll("/WEB-INF/tags");
        if (dirlist == null) {
            return;
        }
        for (String fname : dirlist) {
            if (!fname.endsWith(".tag") && !fname.endsWith(".tagx")) continue;
            int _lastIndex = fname.lastIndexOf(".tag");
            int _lastIndexSeparator = fname.lastIndexOf(47);
            String _dirName = fname.substring(0, _lastIndexSeparator);
            String onlyFileName = fname.substring(_lastIndexSeparator + 1, _lastIndex);
            TagFileInfoImpl _tagFile = null;
            try {
                _tagFile = new TagFileInfoImpl(onlyFileName, fname, null, this.context, null);
            }
            catch (JspEngineException jee) {
                if (!logger.isLoggable(JeusMessage_WebContainer5._5340_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer5._5340_LEVEL, JeusMessage_WebContainer5._5340, (Object)fname, (Throwable)((Object)jee));
                continue;
            }
            TLDInfo _tagfiles = (TLDInfo)this.tagDirs.get(_dirName);
            try {
                if (_tagfiles == null) {
                    _tagfiles = new TLDInfo(this.context, _dirName);
                    this.tagDirs.put(_dirName, _tagfiles);
                }
                _tagfiles.addTagFileInfo(_tagFile);
            }
            catch (JspEngineException jee) {}
        }
    }

    public TLDInfo getTagFiles(String _tagdir) {
        return this.tagDirs == null ? null : (TLDInfo)this.tagDirs.get(_tagdir);
    }

    public String getTagCompileOutDir() {
        return this.tagCompileOutDir;
    }

    private void initTaglibMappingFromJarFile() {
        TreeSet dirlist = this.context.getResourcePathsAll("/WEB-INF/lib");
        if (dirlist == null) {
            dirlist = new TreeSet();
        }
        for (String fname : dirlist) {
            if (!fname.endsWith(".jar")) continue;
            try {
                ZipEntry entry;
                InputStream in = null;
                if (fname.startsWith("/WEB-INF/lib")) {
                    in = this.context.getResourceAsStream(fname);
                } else if (fname.startsWith(JeusBootstrapProperties.JEUS_HOME)) {
                    in = new FileInputStream(new File(fname));
                }
                if (in == null) continue;
                ZipInputStream zin = null;
                try {
                    zin = new ZipInputStream(in);
                }
                catch (Exception ne) {
                    if (!logger.isLoggable(JeusMessage_WebContainer5._5341_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer5._5341_LEVEL, JeusMessage_WebContainer5._5340, (Object)fname, (Throwable)ne);
                    continue;
                }
                boolean tldFound = false;
                while ((entry = zin.getNextEntry()) != null) {
                    int b;
                    if (!entry.getName().endsWith(".tld")) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while (zin.available() != 0 && (b = zin.read()) != -1) {
                        baos.write(b);
                    }
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    try {
                        TLDInfo tli = new TLDInfo(this.context, bais, null, true, fname);
                        this.taglibMappingFromJarFile.put(tli.getURI(), tli);
                    }
                    catch (Exception e) {}
                }
                zin.closeEntry();
                zin.close();
                in.close();
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(JeusMessage_WebContainer5_4._5497_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer5_4._5497_LEVEL, JeusMessage_WebContainer5_4._5497, (Object)fname, (Throwable)ioe);
            }
        }
    }

    public TLDInfo getTLDInfo(String uri, String jspURI) throws JspEngineException {
        String location;
        TLDInfo info;
        if (!this.webDotXmlInitialized) {
            this.initWebDotXml();
            this.webDotXmlInitialized = true;
        }
        if ((info = (TLDInfo)this.tldInfos.get(uri)) != null) {
            return info;
        }
        info = (TLDInfo)this.taglibMappingFromJarFile.get(uri);
        if (info != null) {
            return info;
        }
        Hashtable taglibMap = this.context.getTaglibConfigs();
        String string = location = taglibMap == null ? null : (String)taglibMap.get(uri);
        if (location == null) {
            location = (String)this.tagUriLocation.get(uri);
        }
        if (location == null) {
            return this.getTLDInfoWithURI(uri, jspURI);
        }
        return this.getTLDInfoWithLocation(location, uri, jspURI);
    }

    private TLDInfo getTLDInfoWithLocation(String location, String uri, String jspURI) throws JspEngineException {
        TLDInfo info = this.getTLDInfoWithURI(location, "/WEB-INF/");
        this.tldInfos.put(uri, info);
        return info;
    }

    private TLDInfo getTLDInfoWithURI(String uri, String jspURI) throws JspEngineException {
        Object info = null;
        if (uri.startsWith("/")) {
            String absPath = this.context.getDocBase() + File.separator + uri;
            File file = new File(absPath);
            if (!file.exists() && !uri.startsWith("/WEB-INF")) {
                absPath = this.context.getDocBase() + "/WEB-INF" + uri;
                file = new File(absPath);
            }
            return this.getLocalTLD(file);
        }
        if (uri.indexOf("://") < 0) {
            String absPath = null;
            absPath = (jspURI = jspURI.substring(0, jspURI.lastIndexOf("/"))).equals("/") ? this.context.getDocBase() + File.separator + uri : this.context.getDocBase() + jspURI + File.separator + uri;
            File file = new File(absPath);
            if (!file.exists() && !uri.startsWith("WEB-INF")) {
                absPath = jspURI.equals("/") ? this.context.getDocBase() + "/WEB-INF" + File.separator + uri : this.context.getDocBase() + "/WEB-INF" + jspURI + File.separator + uri;
                file = new File(absPath);
            }
            return this.getLocalTLD(file);
        }
        return this.getRemoteTLD(uri);
    }

    private TLDInfo getLocalTLD(File file) throws JspEngineException {
        TLDInfo info = null;
        boolean isZip = false;
        try {
            ZipFile zfile = new ZipFile(file);
            isZip = true;
        }
        catch (IOException e) {
            isZip = false;
        }
        if (isZip) {
            try {
                ZipEntry entry;
                ZipInputStream zin = new ZipInputStream(new FileInputStream(file));
                while ((entry = zin.getNextEntry()) != null) {
                    if (entry.getName().equals(TLD)) {
                        int b;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while (zin.available() != 0 && (b = zin.read()) != -1) {
                            baos.write(b);
                        }
                        baos.close();
                        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                        info = new TLDInfo(this.context, bais, file.toString(), true);
                        zin.closeEntry();
                        break;
                    }
                    zin.closeEntry();
                }
                zin.close();
            }
            catch (IOException e) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5498, (Object)file.toString()), e);
            }
            if (info == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5498, (Object)file.toString()));
            }
        } else {
            try {
                FileInputStream in = new FileInputStream(file);
                info = new TLDInfo(this.context, in, file.toString(), false);
            }
            catch (IOException e) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5498, (Object)file.toString()), e);
            }
        }
        return info;
    }

    private TLDInfo getRemoteTLD(String full_path) throws JspEngineException {
        TLDInfo info = (TLDInfo)this.remoteTLDCache.get(full_path);
        if (info != null) {
            return info;
        }
        int unique = this.getUniqueNumber();
        String localFileName = "_taglib_" + unique;
        File localFile = new File(this.tempDir, localFileName);
        try {
            localFile.createNewFile();
        }
        catch (IOException ioe) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5496, (Object)localFile.toString()), ioe);
        }
        localFile.deleteOnExit();
        try {
            URL url = new URL(full_path);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            this.copy(in, localFile);
        }
        catch (MalformedURLException mue) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5495, (Object)full_path), mue);
        }
        catch (FileNotFoundException fnfe) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5494, (Object)full_path), new IOException(fnfe.getMessage()));
        }
        catch (IOException e) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5493, (Object)full_path), e);
        }
        info = this.getLocalTLD(localFile);
        this.remoteTLDCache.put(full_path, info);
        if (info.isFromZipFile()) {
            this.context.getContextLoader().addClassPath(info.getRealLocation());
        }
        return info;
    }

    private void copy(InputStream in, File file) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(file);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, nRead);
        }
    }
}

