/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.BeanCache;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspAttribute;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ParamParser;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class BeanParser
extends Parser {
    private static final String OPEN_BEAN = "<jsp:useBean";
    private static final String CLOSE_BEAN = "/>";
    private static final String CLOSE_BEAN_2 = "</jsp:useBean";
    private static final String CLOSE_BEAN_3 = ">";
    private static final String[] validAttributes = new String[]{"id", "scope", "class", "type", "beanName"};
    public static final Vector DISABLE_PARAM = new Vector();

    BeanParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (reader.matches(OPEN_BEAN)) {
            Mark start = reader.mark();
            reader.advance(OPEN_BEAN.length());
            Hashtable attrs = reader.parseTagAttributesBean();
            JspParser.checkAttributes("useBean", attrs.keys(), validAttributes);
            reader.skipSpaces();
            if (!reader.matches(CLOSE_BEAN)) {
                if (!reader.matches(CLOSE_BEAN_3)) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5519));
                }
                reader.advance(CLOSE_BEAN_3.length());
                Mark stop = reader.mark();
                UseBeanJspAttributeInfo rtmap = new UseBeanJspAttributeInfo();
                Hashtable attrs2 = (Hashtable)attrs.clone();
                attrs.clear();
                Enumeration enum1 = attrs2.keys();
                while (enum1.hasMoreElements()) {
                    String name = (String)enum1.nextElement();
                    String value = (String)attrs2.get(name);
                    StringAttribute attr = new StringAttribute(name, value, null, false, false, rtmap.isRTExprAttribute(name));
                    attrs.put(name, attr);
                }
                Attribute jspAttribute = null;
                while ((jspAttribute = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap)) != null) {
                    attrs.put(jspAttribute.attributeName, jspAttribute);
                }
                BeanCache beanInfo = codeGen.getBeanCache();
                boolean genSessionVariable = codeGen.getGenSessionVariable();
                parser.flushCharData();
                BeanGenerator gen = new BeanGenerator(attrs, beanInfo, genSessionVariable, start, stop, isJspDocument, codeGen);
                codeGen.addGenerator(gen, "ClassDeclarationPhase");
                codeGen.addGenerator(gen, "ServiceMethodPhase");
                gen.setClassName(codeGen.checkBeanImport(gen.getClassName()));
                int oldSize = reader.size;
                parser.parse(this, CLOSE_BEAN_2, null, DISABLE_PARAM, true);
                if (oldSize != reader.size) {
                    throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5520));
                }
                if (!reader.matches(CLOSE_BEAN_2)) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5519));
                }
                reader.advance(CLOSE_BEAN_2.length());
                reader.skipSpaces();
                if (!reader.matches(CLOSE_BEAN_3)) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5519));
                }
                reader.advance(CLOSE_BEAN_3.length());
                parser.flushCharData();
                Mark stop2 = reader.mark();
                if (!isJspDocument) {
                    xmlViewer.addBean(reader, start, stop2);
                }
                BeanEndGenerator gen2 = new BeanEndGenerator(start, stop);
                codeGen.addGenerator(gen2, "ServiceMethodPhase");
                return true;
            }
            reader.advance(CLOSE_BEAN.length());
            Mark stop = reader.mark();
            BeanCache beanInfo = codeGen.getBeanCache();
            boolean genSessionVariable = codeGen.getGenSessionVariable();
            parser.flushCharData();
            BeanGenerator gen = new BeanGenerator(attrs, beanInfo, genSessionVariable, start, stop, isJspDocument, codeGen);
            codeGen.addGenerator(gen, "ClassDeclarationPhase");
            codeGen.addGenerator(gen, "ServiceMethodPhase");
            gen.setClassName(codeGen.checkBeanImport(gen.getClassName()));
            parser.flushCharData();
            if (!isJspDocument) {
                xmlViewer.addBean(reader, start, stop);
            }
            BeanEndGenerator gen2 = new BeanEndGenerator(start, stop);
            codeGen.addGenerator(gen2, "ServiceMethodPhase");
            return true;
        }
        return false;
    }

    static {
        DISABLE_PARAM.add(new ParamParser(true));
    }

    class BeanEndGenerator
    extends Generator {
        public BeanEndGenerator(Mark start, Mark stop) {
            this.start = start;
            this.stop = stop;
        }

        public boolean generate(ServletWriter writer, String phase) {
            writer.println("}");
            return true;
        }
    }

    class BeanGenerator
    extends Generator {
        private Hashtable attrs;
        private BeanCache beanInfo;
        private boolean genSession;
        private boolean isJspDocument;
        private CodeGenerator codeGen;

        public BeanGenerator(Hashtable attrs, BeanCache beanInfo, boolean genSession, Mark start, Mark stop, boolean isJspDocument, CodeGenerator codeGen) {
            this.start = start;
            this.stop = stop;
            this.attrs = attrs;
            this.beanInfo = beanInfo;
            this.genSession = genSession;
            this.isJspDocument = isJspDocument;
            this.codeGen = codeGen;
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            if ("ClassDeclarationPhase".equals(phase)) {
                this.checkSyntax(writer);
            } else if ("ServiceMethodPhase".equals(phase)) {
                this.generateMethod(writer);
            }
            return true;
        }

        public void setClassName(String name) {
            if (name != null) {
                this.attrs.put("class", name);
            }
        }

        public String getClassName() throws JspEngineException {
            return this.getStringAttribute("class");
        }

        public void checkSyntax(ServletWriter writer) throws JspEngineException {
            String name = this.getStringAttribute("id");
            String scope = this.getStringAttribute("scope");
            String clsname = this.getStringAttribute("class");
            String type = this.getStringAttribute("type");
            Object beanName = this.getAttribute("beanName");
            if (name == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5521));
            }
            if (clsname == null && type == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5522, (Object)name));
            }
            if (this.beanInfo.checkVariable(name) && WebProperties.J2EE_COMPATIBLE.value) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5523, (Object[])new String[]{name}));
            }
            if (scope != null && scope.equalsIgnoreCase("session") && !this.genSession) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5524, (Object[])new String[]{name}));
            }
            if (clsname != null && beanName != null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5525, (Object[])new String[]{name}));
            }
            if (clsname == null) {
                clsname = type;
            }
            if (scope == null || scope.equals("page")) {
                this.beanInfo.addBean(name, clsname, "page");
            } else if (scope.equals("request")) {
                this.beanInfo.addBean(name, clsname, "request");
            } else if (scope.equals("session")) {
                this.beanInfo.addBean(name, clsname, "session");
            } else if (scope.equals("application")) {
                this.beanInfo.addBean(name, clsname, "application");
            } else {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5526, (Object[])new String[]{name, scope}));
            }
        }

        public void generateMethod(ServletWriter writer) throws JspEngineException {
            String name;
            String varname = name = this.getStringAttribute("id");
            String scope = this.getStringAttribute("scope");
            String clsname = this.getStringAttribute("class");
            String type = this.getStringAttribute("type");
            Object beanName = this.getAttribute("beanName");
            if (type == null) {
                type = clsname;
            }
            String objectName = null;
            String scopeName = null;
            if (scope == null || scope.equals("page")) {
                objectName = "pageContext";
                scopeName = "PageContext.PAGE_SCOPE";
            } else if (scope.equals("request")) {
                objectName = "request";
                scopeName = "PageContext.REQUEST_SCOPE";
            } else if (scope.equals("session")) {
                objectName = "session";
                scopeName = "PageContext.SESSION_SCOPE";
            } else if (scope.equals("application")) {
                objectName = "application";
                scopeName = "PageContext.APPLICATION_SCOPE";
            }
            this.declareBean(writer, type, varname);
            this.lock(writer, objectName);
            this.locateBean(writer, type, varname, name, scopeName);
            this.createBean(writer, varname, clsname, beanName, name, type, scopeName);
            this.unlock(writer);
            this.generateInit(writer, varname);
        }

        private void declareBean(ServletWriter writer, String type, String varname) {
            writer.println(type + " " + varname + " = null;");
            writer.println("boolean _" + varname + "_bean_just_created = false;");
        }

        private void lock(ServletWriter writer, String scope) {
            writer.println("synchronized (" + scope + ") {");
            writer.pushIndent();
        }

        private void locateBean(ServletWriter writer, String type, String varname, String name, String scope) {
            writer.println(varname + "= (" + type + ")");
            writer.println("pageContext.getAttribute(" + ServletWriter.quoteString(name) + "," + scope + ");");
        }

        private void createBean(ServletWriter writer, String varname, String clsname, Object beanName, String name, String type, String scope) throws JspEngineException {
            if (clsname != null || beanName != null) {
                writer.println("if ( " + varname + " == null ) {");
                writer.pushIndent();
                writer.println("_" + name + "_bean_just_created = true;");
                this.generateBeanCreate(writer, varname, clsname, beanName, type);
                writer.println("pageContext.setAttribute(" + ServletWriter.quoteString(name) + ", " + varname + ", " + scope + ");");
                writer.popIndent();
                writer.println("}");
            } else {
                writer.println("if (" + varname + "  == null) ");
                writer.println(" throw new java.lang.InstantiationException (\"bean " + varname + "  not found within scope \"); ");
            }
        }

        protected void generateBeanCreate(ServletWriter writer, String varname, String clsname, Object beanName0, String type) throws JspEngineException {
            String convert;
            String beanName = null;
            boolean beanNameIsExpr = false;
            if (beanName0 != null) {
                if (beanName0 instanceof String) {
                    beanName = (String)beanName0;
                } else if (beanName0 instanceof StringAttribute) {
                    beanName = ((StringAttribute)beanName0).getAttributeValue();
                } else {
                    JspAttribute attr = (JspAttribute)beanName0;
                    attr.generate(writer, this.codeGen, CodeGenerator.getPageContextName(this.parent), null);
                    beanName = attr.variableName;
                }
            }
            if (beanName != null && JspUtil.isExpression(beanName, this.isJspDocument)) {
                beanName = JspUtil.getExpr(beanName, this.isJspDocument);
                beanNameIsExpr = true;
            }
            String string = convert = clsname == null ? type : clsname;
            if (beanName != null) {
                clsname = beanName;
            }
            writer.println("try {");
            writer.pushIndent();
            if (beanNameIsExpr) {
                writer.println(varname + " = (" + convert + ") java.beans.Beans.instantiate(this.getClass().getClassLoader(), " + clsname + ");");
            } else {
                writer.println(varname + " = (" + convert + ") java.beans.Beans.instantiate(this.getClass().getClassLoader(), " + ServletWriter.quoteString(clsname) + ");");
            }
            writer.popIndent();
            writer.println("} catch (ClassNotFoundException _ex) {");
            writer.pushIndent();
            if (beanNameIsExpr) {
                writer.println(" throw new java.lang.InstantiationException (_ex.getMessage());");
            } else {
                writer.println(" throw new java.lang.InstantiationException (_ex.getMessage());");
            }
            writer.popIndent();
            writer.println("} catch (Exception _ex) {");
            writer.pushIndent();
            if (beanNameIsExpr) {
                writer.println(" throw new ServletException (\"Cannot create bean of class \" + " + clsname + ", _ex);");
            } else {
                writer.println(" throw new ServletException (\"Cannot create bean of class \" + \"" + clsname + "\", _ex);");
            }
            writer.popIndent();
            writer.println("}");
        }

        private void unlock(ServletWriter writer) {
            writer.popIndent();
            writer.println("} ");
        }

        private void generateInit(ServletWriter writer, String name) {
            writer.println("if(_" + name + "_bean_just_created) {");
        }

        public String getStringAttribute(String attrName) throws JspEngineException {
            Object obj = this.getAttribute(attrName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof StringAttribute) {
                return ((StringAttribute)obj).getAttributeValue();
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5677, (Object)attrName));
        }

        public Object getAttribute(String name) {
            if (this.attrs == null) {
                return null;
            }
            Object obj = this.attrs.get(name);
            return obj;
        }
    }

    private class UseBeanJspAttributeInfo
    implements JspattributeParser.JspAttributeInfo {
        private UseBeanJspAttributeInfo() {
        }

        public boolean isRTExprAttribute(String attrname) {
            return attrname.equals("beanName");
        }

        public boolean isEnableScript(String attrname) {
            return true;
        }

        public boolean isJspFragment(String attrname) {
            return false;
        }
    }
}

